/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _mbinit.c,v 1.4 1996/10/27 08:52:51 jack Exp $ */

#include <locale.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mbctype.h>
#include <mbprvt.h>

static void
fail_allocation (void)
{
  fflush (stdout);
  fflush (stderr);
  fprintf (stderr,"__mbinit(): cannot allocte for mapping table\n");
  abort ();
}

static void *
safe_malloc (size_t size)
{
  void *p;

  p = malloc (size);
  if (p == NULL)
    fail_allocation ();

  return p;
}

static unsigned short
make_sjis (int i, int j)
{
  unsigned short sjis;

  if (i >= 0x3e)
    {
      sjis = 0xe040;
      i -= 0x3e;
    }
  else
    sjis = 0x8140;

  if (i & 1)
    {
      sjis += 0x005f;
      i >>= 1;
      sjis += (i << 8);
      sjis += j;
    }
  else
    {
      i >>= 1;
      sjis += (i << 8);
      sjis += j;
      if (j >= (0x7f - 0x40))
	sjis++;
    }

  return sjis;
}

void
__mbmake_sjis_mapping_table (void)
{
  int i, j;
  unsigned short sjis, unicode;

  /* allocate memory */
  __sjis_to_unicode_mapping = safe_malloc (65536 * sizeof (unsigned short));
  __unicode_to_sjis_mapping = safe_malloc (65536 * sizeof (unsigned short));

  /* fill tabel with error code */
  for (i = 0; i < 65536; i++)
    {
      __sjis_to_unicode_mapping[i] = _MBC_ERROR_UNICODE;
      __unicode_to_sjis_mapping[i] = _MBC_ERROR_SJIS;
    }

  /* for SBCS */
  for (i = 0; i < 256; i++)
    {
      sjis = i;
      unicode = __jis0201_to_unicode_mapping[sjis];
      if (unicode != _MBC_ERROR_UNICODE)
	{
	  __sjis_to_unicode_mapping[sjis] = unicode;
	  if (__unicode_to_sjis_mapping[unicode] == _MBC_ERROR_SJIS)
	    __unicode_to_sjis_mapping[unicode] = sjis;
	}
    }
  /* for DBCS */
  for (i = 0; i < 94; i++)
    for (j = 0; j < 94; j++)
      {
	sjis = make_sjis (i, j);
	unicode = __jis0208_to_unicode_mapping[(i * 94) + j];
	if (unicode != _MBC_ERROR_UNICODE)
	  {
	    __sjis_to_unicode_mapping[sjis] = unicode;
	    if (__unicode_to_sjis_mapping[unicode] == _MBC_ERROR_SJIS)
	      __unicode_to_sjis_mapping[unicode] = sjis;
	  }
      }
}

void
__mbinit (int category, const char *locale)
{
  if (locale == NULL || *locale == '\0')
    return;

  if (strcmp (locale, "C") == 0)
    {
      if (category == LC_CTYPE || category == LC_ALL)
	{
	  __string_single_to_wchar = __string_single_to_wchar_c;
	  __string_double_to_wchar = __string_double_to_wchar_c;
	  __wchar_to_mbc = __wchar_to_mbc_c;
	  __mbctype = &__c_mbctype[1];
#ifdef __DJGPP__
	  __dj_mb_cur_max = 1;
#endif
	}
    }
  else if (strcmp (locale, "ja_JP.SJIS") == 0)
    {
      if (category == LC_CTYPE || category == LC_ALL)
	{
	  if (__sjis_to_unicode_mapping == NULL)
	    __mbmake_sjis_mapping_table ();
	  __string_single_to_wchar = __string_single_to_wchar_ja_jp_sjis;
	  __string_double_to_wchar = __string_double_to_wchar_ja_jp_sjis;
	  __wchar_to_mbc = __wchar_to_mbc_ja_jp_sjis;
	  __mbctype = &__sjis_mbctype[1];
#ifdef __DJGPP__
	  __dj_mb_cur_max = __mb_cur_max_ja_jp_sjis;
#endif
	}
    }

  if (category == LC_CTYPE || category == LC_ALL)
    {
      /* initialize shift states */
      (void) mblen (NULL, 0);
      (void) mbtowc ((wchar_t *) 0, NULL, 0);
      (void) wctomb (NULL, (wchar_t) 0);
    }
}
