/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: mbctombb.c,v 1.1 1996/06/23 11:46:35 jack Exp $ */

#include <mbstring.h>
#include <mbprvt.h>

#define NUL '\0'

static unsigned char alnmap[] =
{
  /* 824f-825e */
  '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', NUL, NUL, NUL, NUL, NUL, NUL,

  /* 825f-827e */
  NUL, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', NUL, NUL, NUL, NUL, NUL,

  /* 827f */
  NUL,

  /* 8280-829a */
  NUL, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
  'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
};

static unsigned char punctmap[] =
{
  /* 8140 */
  ' ',

  /* 8141-81ac */
  0xa4, 0xa1, ',',  '.',  0xa5, ':',  ';',  '?', /* 8141-8150 */
  '!',  0xde, 0xdf, NUL,  NUL,  NUL,  '^',  NUL,
  '_',  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  NUL, /* 8151-8160 */
  NUL,  NUL,  NUL,  NUL,  NUL,  '/',  NUL,  '~',
  NUL,  '|',  NUL,  NUL,  '`',  '\'', NUL,  '"', /* 8161-8170 */
  '(',  ')',  NUL,  NUL,  '[',  ']',  '{',  '}',
  NUL,  NUL,  NUL,  NUL,  0xa2, 0xa3, NUL,  NUL, /* 8171-8180 */
  NUL,  NUL,  '+',  '-',  NUL,  NUL,  NUL,  NUL,
  '=',  NUL,  '<',  '>',  NUL,  NUL,  NUL,  NUL, /* 8181-8190 */
  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  '\\', '$',
  NUL,  NUL,  '%',  '#',  '&',  '*',  '@',  NUL, /* 8191-81a0 */
  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,
  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  NUL,  NUL, /* 81a1-81ac */
  NUL,  NUL,  NUL,  NUL,
};

static unsigned char hiramap[] =
{
  /* 829f-82f1 */
  0xa7, 0xb1, 0xa8, 0xb2, 0xa9, 0xb3, 0xaa, 0xb4, /* 829f-82ae */
  0xab, 0xb5, 0xb6, NUL,  0xb7, NUL,  0xb8, NUL,
  0xb9, NUL,  0xba, NUL,  0xbb, NUL,  0xbc, NUL,  /* 82af-82be */
  0xbd, NUL,  0xbe, NUL,  0xbf, NUL,  0xc0, NUL,
  0xc1, NUL,  0xaf, 0xc2, NUL,  0xc3, NUL,  0xc4, /* 82bf-82ce */
  NUL,  0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, NUL,
  NUL,  0xcb, NUL,  NUL,  0xcc, NUL,  NUL,  0xcd, /* 82cf-82de */
  NUL,  NUL,  0xce, NUL,  NUL,  0xcf, 0xd0, 0xd1,
  0xd2, 0xd3, 0xac, 0xd4, 0xad, 0xd5, 0xae, 0xd6, /* 82df-82ee */
  0xd7, 0xd8, 0xd9, 0xda, 0xdb, NUL,  0xdc, NUL,
  NUL,  0xa6, 0xdd,                               /* 82ef-82f1 */
};

static unsigned char katamap[] =
{
  /* 8340-8396 */
  0xa7, 0xb1, 0xa8, 0xb2, 0xa9, 0xb3, 0xaa, 0xb4, /* 8340-834f */
  0xab, 0xb5, 0xb6, NUL,  0xb7, NUL,  0xb8, NUL,
  0xb9, NUL,  0xba, NUL,  0xbb, NUL,  0xbc, NUL,  /* 8350-835f */
  0xbd, NUL,  0xbe, NUL,  0xbf, NUL,  0xc0, NUL,
  0xc1, NUL,  0xaf, 0xc2, NUL,  0xc3, NUL,  0xc4, /* 8360-836f */
  NUL,  0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, NUL,
  NUL,  0xcb, NUL,  NUL,  0xcc, NUL,  NUL,  0xcd, /* 8370-837e */
  NUL,  NUL,  0xce, NUL,  NUL,  0xcf, 0xd0,

  /* 837f */
  NUL,

  0xd1, 0xd2, 0xd3, 0xac, 0xd4, 0xad, 0xd5, 0xae, /* 8380-838f */
  0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, NUL,  0xdc,
  NUL,  NUL,  0xa6, 0xdd, NUL,  NUL,  NUL,        /* 8390-8396 */
};

int
_mbctombb (int c)
{
  int value;

  /* alphabet, digit */
  if (c >= _MBC_DIGIT_BEGIN && c <= _MBC_LOWER_END)
    {
      value = (int) alnmap[c - _MBC_DIGIT_BEGIN];
      if (value != NUL)
	return value;
    }
  /* punctuation, etc */
  else if (c >= _MBC_SPACE && c <= _MBC_PUNCT_END)
    {
      value = (int) punctmap[c - _MBC_SPACE];
      if (value != NUL)
	return value;
    }
  /* hirakana */
  else if (c >= _MBC_HIRA_BEGIN && c <= _MBC_HIRA_END)
    {
      value = (int) hiramap[c - _MBC_HIRA_BEGIN];
      if (value != NUL)
	return value;
    }
  /* katakana */
  else if (c >= _MBC_KATA_BEGIN && c <= _MBC_KATA_END)
    {
      value = (int) katamap[c - _MBC_KATA_BEGIN];
      if (value != NUL)
	return value;
    }

  /* no conversion (nothing) */
  return c;
}
