/*
 * Copyright (C) 1996, jack
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static char rcsid[]= "$Id: sk2dk.c,v 1.2 1996/10/25 14:06:06 jack Exp $";

#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <mbctype.h>
#include <mbstring.h>

/* my name */
char *progname = NULL;



/* safety functions */

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void fatal (char *format, ...);
void *xmalloc (size_t size);
void *xrealloc (void *p, size_t size);
FILE *xfopen (char *fname, char *mode);
char *fgets_line (FILE *fp);

void
fatal (char *format, ...)
{
  va_list ap;

  va_start (ap, format);
  fprintf (stderr, "%s: ", progname);
  vfprintf (stderr, format, ap);
  va_end (ap);
  fprintf (stderr, "\n");
  exit (EXIT_FAILURE);
}

void *
xmalloc (size_t size)
{
  void *p;

  p = malloc (size);
  if (p == NULL)
    fatal ("Memory allocate error");

  return p;
}

void *
xrealloc (void *p, size_t size)
{
  p = realloc (p, size);
  if (p == NULL)
    fatal ("Memory allocate error");

  return p;
}

FILE *
xfopen (char *fname, char *mode)
{
  FILE *fp;

  fp = fopen (fname, mode);
  if (fp == NULL)
    fatal ("Cannot open %s", fname);

  return fp;
}

#define TMPBUF_SIZE 256

char *
fgets_line (FILE *fp)
{
  char *dst, *p;
  int len, n;

  dst = p = xmalloc (TMPBUF_SIZE);
  dst[0] = '\0';
  len = 0;

  while (fgets (p, TMPBUF_SIZE, fp) != NULL)
    {
      n = strlen (p);
      len += n;
      if (n + 1 < TMPBUF_SIZE || dst[len - 1] == '\n')
	return xrealloc (dst, len + 1);
      else
	dst = xrealloc (dst, len + TMPBUF_SIZE);
      p = dst + len;
    }

  if (feof (fp) && len != 0)
    {
      dst = xrealloc (dst, len + 2);
      dst[len] = '\n';
      dst[len + 1] = '\0';
      return dst;
    }

  free (dst);
  return NULL;
}


void
open_filter_files (char *in_name, char *out_name, FILE **in_fp, FILE **out_fp)
{
  if (strcmp (in_name, "-") == 0)
    *in_fp = stdin;
  else
    *in_fp = xfopen (in_name, "rt");

  if (strcmp (out_name, "-") == 0)
    *out_fp = stdout;
  else
    *out_fp = xfopen (out_name, "wt");
}

void
close_filter_files (FILE **in_fp, FILE **out_fp)
{
  fflush (*in_fp);
  fflush (*out_fp);
  if (ferror (*in_fp) && *in_fp != stdin)
    fatal ("Read error");
  if (ferror (*out_fp) && *out_fp != stdout)
    fatal ("Write error");
  if (*in_fp != stdin)
    fclose (*in_fp);
  if (*out_fp != stdout)
    fclose (*out_fp);
  *in_fp = *out_fp = NULL;
}

int
fputmbc (int mbc, FILE *fp)
{
  int rc;

  if ((mbc & 0xff00U) != 0)
    {
      rc = fputc ((mbc >> 8) & 0xffU, fp);
      if (rc == EOF || (mbc & 0xffU) == 0)
	return rc;
      rc = fputc (mbc & 0xffU, fp);
    }
  else
    rc = fputc (mbc & 0xffU, fp);

  return rc;
}

int
sk2dk (char *in_name, char *out_name)
{
  FILE *in_fp, *out_fp;
  char *lp;

  open_filter_files (in_name, out_name, &in_fp, &out_fp);

  while ((lp = fgets_line (in_fp)) != NULL)
    {
      unsigned char *up = (unsigned char *) lp;
      int c, mbc;

      for (c = *up++; c != '\0'; c = *up++)
	{
	  if (_ismbblead (c))
	    {
	      mbc = (c << 8) + *up++;
	      fputmbc (mbc, out_fp);
	      if ((mbc & 0xffU) == '\0')
		break;
	      continue;
	    }

	  if (_ismbbkana (c) && ! _ismbbkpunct (c))
	    {
	      mbc = _mbbtombc (c);
	      fputmbc (mbc, out_fp);
	    }
	  else
	    fputc (c, out_fp);
	}
      free (lp);
    }

  close_filter_files (&in_fp, &out_fp);

  return 0;
}

int
main (int argc, char *argv[])
{
  char *in_name = "-", *out_name = "-";
  int rc;

  setlocale (LC_CTYPE, "");

  progname = argv[0];
  if (argc >= 2)
    in_name = argv[1];
  if (argc >= 3)
    out_name = argv[2];

  rc = sk2dk (in_name, out_name);
  return rc;
}
