/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcsstr.c,v 1.2 1996/08/01 08:16:35 jack Exp $ */

#include <wchar.h>

wchar_t *
wcsstr (const wchar_t *ws1, const wchar_t *ws2)
{
  const wchar_t *wp;
  wchar_t wc;
  size_t len;

  wp = ws1;
  wc = *ws2;
  len = wcslen (ws2);

  while ((wp = wcschr (wp, wc)) != NULL)
    {
      if (wcsncmp (wp, ws2, len) == 0)
	return (wchar_t *) wp;
      wp++;
    }

  return NULL;
}
