/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wcstok.c,v 1.2 1996/07/16 15:32:27 jack Exp $ */

#include <wchar.h>

wchar_t *
wcstok (wchar_t *ws, const wchar_t *dlm)
{
  static wchar_t *next = NULL;
  wchar_t *endp;

  /* continue ? */
  if (ws == NULL)
    {
      if (next == NULL)
	return NULL;
      ws = next;
    }

  /* skip delimiter */
  ws += wcsspn (ws, dlm);
  if (*ws == 0)
    {
      next = NULL;
      return NULL;
    }

  /* search delimiter */
  endp = wcspbrk (ws, dlm);
  if (endp == NULL)
    next = NULL;
  else
    {
      /* cut off token */
      *endp++ = 0;

      /* save pointer */
      next = endp;
    }

  return ws;
}
