/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: wprintf.c,v 1.2 1996/07/16 15:32:27 jack Exp $ */

#include <stdarg.h>
#include <wchar.h>
#include <wcprvt.h>

struct __swprintf_stream
{
  size_t pos;
  wchar_t *s;
};

static wint_t
__swprintf_fputwc (wint_t wc, FILE *stream)
{
  struct __swprintf_stream *ssbufp;

  ssbufp = (struct __swprintf_stream *) stream;
  ssbufp->s[ssbufp->pos++] = wc;

  return wc;
}

int
fwprintf (FILE *stream, const wchar_t *format, ...)
{
  va_list ap;
  int rc;
  __WCHAR_BINARYMODE_VARIABLES;

  va_start (ap, format);
  __WCHAR_BINARYMODE_PROLOGUE (stream);
  rc = _dowprnt (format, ap, stream, __fputwc);
  __WCHAR_BINARYMODE_EPILOGUE (stream);
  va_end (ap);

  return rc;
}

int
wprintf (const wchar_t *format, ...)
{
  va_list ap;
  int rc;
  __WCHAR_BINARYMODE_VARIABLES;

  va_start (ap, format);
  __WCHAR_BINARYMODE_PROLOGUE (stdout);
  rc = _dowprnt (format, ap, stdout, __fputwc);
  __WCHAR_BINARYMODE_EPILOGUE (stdout);
  va_end (ap);

  return rc;
}

int
swprintf (wchar_t *s, const wchar_t *format, ...)
{
  va_list ap;
  int rc;
  struct __swprintf_stream ssbuf;

  ssbuf.pos = 0;
  ssbuf.s = s;

  va_start (ap, format);
  rc = _dowprnt (format, ap, (FILE *) &ssbuf, __swprintf_fputwc);
  va_end (ap);

  ssbuf.s[ssbuf.pos] = 0;

  return rc;
}

int
vfwprintf (FILE *stream, const wchar_t *format, va_list ap)
{
  int rc;
  __WCHAR_BINARYMODE_VARIABLES;

  __WCHAR_BINARYMODE_PROLOGUE (stream);
  rc = _dowprnt (format, ap, stream, __fputwc);
  __WCHAR_BINARYMODE_EPILOGUE (stream);

  return rc;
}

int
vwprintf (const wchar_t *format, va_list ap)
{
  int rc;
  __WCHAR_BINARYMODE_VARIABLES;

  __WCHAR_BINARYMODE_PROLOGUE (stdout);
  rc = _dowprnt (format, ap, stdout, __fputwc);
  __WCHAR_BINARYMODE_EPILOGUE (stdout);

  return rc;
}

int
vswprintf (wchar_t *s, const wchar_t *format, va_list ap)
{
  int rc;
  struct __swprintf_stream ssbuf;

  ssbuf.pos = 0;
  ssbuf.s = s;

  rc = _dowprnt (format, ap, (FILE *) &ssbuf, __swprintf_fputwc);

  ssbuf.s[ssbuf.pos] = 0;

  return rc;
}
