/*
 * Copyright (C) 1996, jack
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: _wcprop.c,v 1.2 1996/10/27 13:23:46 jack Exp $ */

#include <wctype.h>
#include <wcprvt.h>

#define WC(x) ((wchar_t) (x))
#define WCNODIFF (WC (0U))
#define WCRANGE (0)
#define WCCLASSEND { -1, (wchar_t *) 0 }
#define DIFFOF(a,b) (WC ((int)(a) - (int)(b)))
#define NUMOF(x) (sizeof ((x)) / sizeof (*(x)))

/* classifications (C locale) */
static wchar_t __wcrange_c_cntrl[] = { WC (0x0000U), WC (0x001fU), WCNODIFF, };
static wchar_t __wcrange_c_digit[] = { WC ('0'), WC ('9'), WCNODIFF, };
static wchar_t __wcrange_c_upper[] = { WC ('A'), WC ('Z'), DIFFOF ('a', 'A'), };
static wchar_t __wcrange_c_lower[] = { WC ('a'), WC ('z'), DIFFOF ('A', 'a'), };
static wchar_t __wcrange_c_hexupr[] = { WC ('A'), WC ('F'), DIFFOF ('a', 'A'), };
static wchar_t __wcrange_c_hexlwr[] = { WC ('a'), WC ('f'), DIFFOF ('A', 'a'), };
static wchar_t __wcenum_c_space[] =
{
  WC ('\t'), WC ('\n'), WC('\v'), WC ('\f'), WC ('\r'), WC (' '),
};
static wchar_t __wcenum_c_punct[] =
{
  WC ('!'), WC ('"'), WC ('#'), WC ('$'), WC ('%'), WC ('&'), WC ('\''),
  WC ('('), WC (')'), WC ('*'), WC ('+'), WC (','), WC ('-'), WC ('.'),
  WC ('/'), WC (':'), WC (';'), WC ('<'), WC ('='), WC ('>'), WC ('?'),
  WC ('@'), WC ('['), WC ('\\'), WC (']'), WC ('^'), WC ('_'), WC ('`'),
  WC ('{'), WC ('|'), WC ('}'), WC ('~'),
};

static struct __wcclass __wcclass_c_alnum[] =
{
  { WCRANGE, &__wcrange_c_digit[0] },
  { WCRANGE, &__wcrange_c_upper[0] },
  { WCRANGE, &__wcrange_c_lower[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_alpha[] =
{
  { WCRANGE, &__wcrange_c_upper[0] },
  { WCRANGE, &__wcrange_c_lower[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_cntrl[] =
{
  { WCRANGE, &__wcrange_c_cntrl[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_digit[] =
{
  { WCRANGE, &__wcrange_c_digit[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_graph[] =
{
  { WCRANGE, &__wcrange_c_digit[0] },
  { WCRANGE, &__wcrange_c_upper[0] },
  { WCRANGE, &__wcrange_c_lower[0] },
  { NUMOF (__wcenum_c_punct), &__wcenum_c_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_lower[] =
{
  { WCRANGE, &__wcrange_c_lower[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_print[] =
{
  { WCRANGE, &__wcrange_c_digit[0] },
  { WCRANGE, &__wcrange_c_upper[0] },
  { WCRANGE, &__wcrange_c_lower[0] },
  { NUMOF (__wcenum_c_space), &__wcenum_c_space[0] },
  { NUMOF (__wcenum_c_punct), &__wcenum_c_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_punct[] =
{
  { NUMOF (__wcenum_c_punct), &__wcenum_c_punct[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_space[] =
{
  { NUMOF (__wcenum_c_space), &__wcenum_c_space[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_upper[] =
{
  { WCRANGE, &__wcrange_c_upper[0] },
  WCCLASSEND,
};

static struct __wcclass __wcclass_c_xdigit[] =
{
  { WCRANGE, &__wcrange_c_digit[0] },
  { WCRANGE, &__wcrange_c_hexupr[0] },
  { WCRANGE, &__wcrange_c_hexlwr[0] },
  WCCLASSEND,
};

/* properties (C locale) */
static struct __wcprop __wcprop_c_alnum =
{
  "alnum",
  &__wcclass_c_alnum[0],
};

static struct __wcprop __wcprop_c_alpha =
{
  "alpha",
  &__wcclass_c_alpha[0],
};

static struct __wcprop __wcprop_c_cntrl =
{
  "cntrl",
  &__wcclass_c_cntrl[0],
};

static struct __wcprop __wcprop_c_digit =
{
  "digit",
  &__wcclass_c_digit[0],
};

static struct __wcprop __wcprop_c_graph =
{
  "graph",
  &__wcclass_c_graph[0],
};

static struct __wcprop __wcprop_c_lower =
{
  "lower",
  &__wcclass_c_lower[0],
};

static struct __wcprop __wcprop_c_print =
{
  "print",
  &__wcclass_c_print[0],
};

static struct __wcprop __wcprop_c_punct =
{
  "punct",
  &__wcclass_c_punct[0],
};

static struct __wcprop __wcprop_c_space =
{
  "space",
  &__wcclass_c_space[0],
};

static struct __wcprop __wcprop_c_upper =
{
  "upper",
  &__wcclass_c_upper[0],
};

static struct __wcprop __wcprop_c_xdigit =
{
  "xdigit",
  &__wcclass_c_xdigit[0],
};

static struct __wcprop __wcprop_c_tolower =
{
  "tolower",
  &__wcclass_c_upper[0],
};
static struct __wcprop __wcprop_c_toupper =
{
  "toupper",
  &__wcclass_c_lower[0],
};

/* array of property pointers sorted by name (C locale) */
struct __wcprop *__wcprops_c[] =
{
  &__wcprop_c_alnum,
  &__wcprop_c_alpha,
  &__wcprop_c_cntrl,
  &__wcprop_c_digit,
  &__wcprop_c_graph,
  &__wcprop_c_lower,
  &__wcprop_c_print,
  &__wcprop_c_punct,
  &__wcprop_c_space,
  &__wcprop_c_upper,
  &__wcprop_c_xdigit,
};

struct __wcprop *__wcprops_trans_c[] =
{
  &__wcprop_c_tolower,
  &__wcprop_c_toupper,
};

/* maximum number of index (C locale) */
int __wcprops_c_num = NUMOF (__wcprops_c);
int __wcprops_trans_c_num = NUMOF (__wcprops_trans_c);


/* current array of property pointers */
struct __wcprop **__wcprops = &__wcprops_c[0];
struct __wcprop **__wcprops_trans = &__wcprops_trans_c[0];

/* current maximum number of index */
int __wcprops_num = NUMOF (__wcprops_c);
int __wcprops_trans_num = NUMOF (__wcprops_trans_c);

/* for solving undefine symbol */
static void (*__wcinit_dummy) (int, const char *) = __wcinit;
