/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
				Copyright (c)1995,1996 Malcolm Taylor

 -> ACCEL.H
 -> Accelerator class for ALT key accelerators.
*/

#ifndef _accel_h
#define _accel_h

#include <types.h>
#include <memory.h>

class Window;
extern BYTE XLateALT[];

class Accelerator {
	public:
		Accelerator(int c,Window *wnd)
			:next(NULL)
			,window(wnd)
		{
			if(c==0x20)
			{
				key=0x20;
				scan=XLateALT[c];
			}
			else
			{
				key=0x00;
				scan=XLateALT[c];
			}
		}
		Accelerator(BYTE k,BYTE s,Window *wnd)
			:next(NULL)
			,window(wnd) 
			,key(k)
			,scan(s)
			{}

		void SetNext(Accelerator *acc) {next=acc;}
		Accelerator *GetNext() {return next;}
		Window *GetWindow() {return window;}
		BOOL Check(BYTE k,BYTE s);

	private:
		BYTE key,scan;
		Window *window;
		Accelerator *next;
};

#endif

