/*************************************************************
 ***************    ===The Window System===    ***************
 *************************************************************
            Copyright (c)1995,1996 Malcolm Taylor

 -> CHECKBOX.H
 -> A check box control.
*/

#ifndef _checkbox_h
#define _checkbox_h

#include <types.h>
#include <tws/window.h>

#define E_BOXUNCHECKED(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==2000) \
   { \
      function(); \
      return TRUE; \
   }

#define E_BOXCHECKED(ID,function) \
   if(ev->Type==W_NOTIFY && ev->p1==ID && ev->p2==2001) \
   { \
      function(); \
      return TRUE; \
   }

class CheckBox:public Window {
   public:
      CheckBox(Window *parent,ControlID ID,char *text,int x,int y,int l,int isChecked=FALSE);
      ~CheckBox();

      void Check();
      void UnCheck();

      inline int isChecked() 
         { return checked; }

   protected:
      void PaintWindow(int,int,int,int);
      void LButtonDown(int,int,int);
      void Focus();
      void UnFocus();
      void Select();
      void KeySelect(int);

      DECLARE_RESPONSE_TABLE;

      int checked,isfocused;
      ControlID checkID;
      char *text;
};


#endif
