/*************************************************************
 ******************    ===Sound Test===    *******************
 *************************************************************
		Copyright (c)1996 Grafik Software by Malcolm Taylor

 -> SOUNDTST.CC
 -> Main program source file for the picture viewer.
*/

#include "soundtst.h"
#include "wavewin.h"
#include <tws/message.h>
#include <tws/filedlg.h>
#include <tws/help.h>

HelpDataBase *help_data;

DEFINE_RESPONSE_TABLE(MainMenu,AutoMenu)
	E_COMMAND(ID_FILE_OPEN,CmFileOpen)
	E_COMMAND(ID_SHELL_TO_DOS,CmFileShellToDos)
	E_COMMAND(ID_FILE_EXIT,CmFileExit)
	E_COMMAND(ID_HELP_CONTENTS,CmHelpContents)
END_RESPONSE_TABLE

void
MainMenu::CmFileOpen()
{
	char *filename;
	WaveWindow *ww;

	filename=FileDlg("Open File").Run();
	if(filename)
	{
		WaveWindow(filename).Run();
		delete filename;
	}
}

void
MainMenu::CmFileShellToDos()
{
	ws.ShellToDos();
}

void
MainMenu::CmFileExit()
{
	ws.StopRunningEvents();
}

void
MainMenu::CmHelpContents()
{
	HelpWindow *temp=new HelpWindow(NULL,help_data,"contents",ws.GetDeskWidth()/2+10,100,ws.GetDeskWidth()*9/10+30,ws.GetDeskHeight()*4/5+50);
	temp->Setup();
}

int main(int argc,char *argv[])
{
	char *temp;

	help_data=new HelpDataBase("soundtst.hlp");

	ws.Init("soundtst.cfg");

	MainMenuWindow Main;

	ws.RefreshDesktop();

	ws.RunEvents();

	return 0;
}

