/************************************************************************
// File lwpstdlib.h - Patch header fir stdlib.h
// Copyright (C) 1997 Paolo De Marino
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version,
//  with the only exception that all the people in the THANKS file
//  must receive credit.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; see the file COPYING.LIB.
//  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
//  Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
************************************************************************/
#ifndef __LWP_STDLIB_H
#define __LWP_STDLIB_H 1

#include <stdlib.h>
__inline__ static void* _lwp_malloc(size_t arg)
{
  void* result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = malloc(arg);
  _lwp_enable = tmp;
  return result;
}
#define malloc(size) _lwp_malloc(size)

__inline__ static void _lwp_free(void* ptr)
{
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  free(ptr);
  _lwp_enable = tmp;
}
#define free(ptr) _lwp_free(ptr)

__inline__ static void* _lwp_realloc(void *ptr,size_t size)
{
  void* result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = realloc(ptr,size);
  _lwp_enable = tmp;
  return result;
}
#define realloc(size) _lwp_realloc(ptr,size)

__inline__ static void* _lwp_calloc(size_t num,size_t size)
{
  void* result;
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  result = calloc(num,size);
  _lwp_enable = tmp;
  return result;
}
#define calloc(num,size) _lwp_calloc(num,size)

__inline__ static void _lwp_cfree(void* ptr)
{
  volatile int tmp;
  tmp = _lwp_enable;
  _lwp_enable = 1;
  cfree(ptr);
  _lwp_enable = tmp;
}
#define cfree(ptr) _lwp_cfree(ptr)


#define xfree    #error
#define xmalloc  #error
#define xrealloc #error

#endif
