//  readwrit.cc - C++ Interface to LWP demo - demonstrates read/write locks
//  Copyright (C) 1997 Paolo De Marino
//
//  This program is free software; you can redistribute it and/or modify it
//  freely; basically you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
#include "lwp.h"
#include "threads.h"

ReadWriteSemaphore sema;

volatile int first=0,   // Will be incremented together, with a .5"
             second=0;  // interval within.

class readThread : public Thread
{
public:
       readThread(unsigned stacksize) : Thread(stacksize) { };

       void prepare(void)
       {
       }
       void execute(void)
       {
        for(int i = 0; i < 100; i++)
        {
         ReadLock lock(sema);
         printf("PID %i, %s\n",getPid(),first == second ? "OK" : "Error!");
         lwp_yield();
        }
       }
       void cleanup(void)
       {
       }
};
class writeThread : public Thread
{
public:
       writeThread(unsigned stacksize) : Thread(stacksize) { };

       void prepare(void)
       {
       }
       void execute(void)
       {
        for(int i = 0; i < 100; i++)
        {
         lwp_yield();
         WriteLock lock(sema);
         first++;           // Have to be updated concurrently!
         lwp_sleep(0,50);   // Wait 1/20th of a second!
         second++;
         printf("PID %i modified values!\n",getPid());
        };
       }
       void cleanup(void)
       {
       }
};
int main(int, char *[])
{
    InitLwp(RTC128);
    printf("Starting...\n");

    writeThread wThread1(8192),wThread2(8192);
    readThread rThread1(8192),rThread2(8192),
               rThread3(8192),rThread4(8192);

    do
    {
     CritSect a;
     rThread1.start();
     rThread2.start();
     rThread3.start();
     rThread4.start();
     wThread1.start();
     wThread2.start();
    } while(0);

    wThread1.waitCompletion();
    wThread2.waitCompletion();
    rThread1.waitCompletion();
    rThread2.waitCompletion();
    rThread3.waitCompletion();
    rThread4.waitCompletion();

    printf("Done!\n");

    DoneLwp();
    return 0;
}
