//  example6.cc - C++ Interface to LWP demo - Demonstates the
//  use of gates for synchronization purposes.
//  Copyright (C) 1997 Paolo De Marino
//
//  This program is free software; you can redistribute it and/or modify
//  it freely; basically, you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     pdemarin@mbx.idn.it
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
#include <stdio.h>
#include <conio.h>
#include "lwp.h"
#include <dos.h>
#include <stdlib.h>
#include "threads.h"

#undef cprintf
void interr(int )   // During the execution of this function, multithreading
{                   // will surely be disabled!
 lwp_thread_disable();
 cprintf("Inside my debug handler!\n");
 lwp_thread_enable();
}

MutexSemaphore memoryAllocation;

char *newChar()
{
 MutexSemaphoreLock lock(memoryAllocation);
 return new char;
}
void deleteChar(char *ptr)
{
 MutexSemaphoreLock lock(memoryAllocation);
 delete ptr;
}

Gate theGate;

class printThread : public Thread
{
public:
       printThread(unsigned stacksize) : Thread(stacksize) { };

       void prepare(void)
       {
       }
       void execute(void)
       {
        printf("PID %i Started!\n",getPid());
        theGate.Wait();
        printf("PID %i Freed!\n",getPid());
       }
       void cleanup(void)
       {
       }
};
Thread *Thread1,*Thread2,*Thread3,*Thread4;
int main(int, char *[])
{
    signal(SIGINT,interr);

    InitLwp(RTC128);
    printf("Starting...\n");
    printf("Current Thread=%p\n",&Thread::currentThread());

    printThread myThread1(8192),myThread2(8192),
                myThread3(8192),myThread4(8192);

    Thread1 = &myThread1;
    Thread2 = &myThread2;
    Thread3 = &myThread3;
    Thread4 = &myThread4;

    myThread1.start();
    myThread2.start();

    printf("Waiting to open gate!\n");
    while(!kbhit()) lwp_yield();

    printf("Opened!\n");

    theGate.Open();

    myThread1.waitCompletion();
    myThread2.waitCompletion();

    printf("First two threads finished!\n");
    while(!kbhit()) lwp_yield();
    getch();

    myThread3.start();

    printf("Waiting to close gate!\n");
    while(!kbhit()) lwp_yield();
    getch();

    theGate.Close();
    printf("Closed!");

    myThread4.start();

    printf("Waiting to open gate!\n");
    while(!kbhit()) lwp_yield();
    getch();

    theGate.Open();

    myThread3.waitCompletion();
    myThread4.waitCompletion();

    DoneLwp();
    return 0;
}
