//------------------------------------------------------------------------
//  queue.h - templated Queue class (used as base of the MessageQueue class)
//  Copyright (C) 1997 Paolo De Marino
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version,
//  with the only exception that the people in the THANKS file must
//  receive credit.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; see the file COPYING.LIB.
//  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
//  Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//     paolodemarino@usa.net
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
//
// History : see history.txt
//------------------------------------------------------------------------


#ifndef __QUEUE_H
#define __QUEUE_H

#include <assert.h>

template <class T>
class Queue
{
protected:
       class QueueElement
       {
       public:
        T               object;
        QueueElement   *next;
        QueueElement(const T& what) : object(what),next(0) { };
       } *head,*tail;

       int elements;
public:
       Queue() { head = tail = 0; elements = 0; };
      ~Queue()
       {
        while( tail != 0 )
        {
         QueueElement *temp = tail;
         tail = tail->next;
         delete temp;
        }
       }

       void push(const T& what)
       {
        if(elements == 0)
        {
                head = tail = new QueueElement(what);
        } else      // Already something!
        {
                QueueElement *nuovo = new QueueElement(what);
                head->next = nuovo;
                head = head->next;
        }
        elements++;
       }

       T pop()
       {
        assert(elements > 0);
// Should throw an exception, but I don't know if exceptions can safely be
// handled under LWP, so I rather assert() there is something to pop.
        T retval = tail->object;
        QueueElement *last = tail;

        tail = tail->next;
        delete last;

        if(tail == 0) head = 0; // No more elements!

        elements--;
        return retval;
       }

       int numElems() const
       {
        return elements;
       }
       int isEmpty() const
       {
         return elements == 0;
       };
};

#endif
