/* ASM code for the lwp package.  This is where the nitty gritty shtuff is */
/****************************************************************************
*  Copyright (C) 1997 Paolo De Marino
*
*  Original code by Sengan Short (sengan.short@durham.ac.uk) and Josh Turpen
*  (snarfy@goodnet.com).
*
*  This library is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version,
*  with the only exception that all the people in the THANKS file must
*  receive credit.
*
*  This library is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; see the file COPYING.LIB.
*  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
*  Cambridge, MA 02139, USA.
*
*  For contacting the author send electronic mail to
*     paolodemarino@usa.net
*
*  Or paper mail to
*
*     Paolo De Marino
*     Via Donizetti 1/E
*     80127 Naples
*     Italy
*
*  History: see history.txt
****************************************************************************/
.globl __lwp_pm_irq8_timer_hook
.globl __lwp_pm_irq0_timer_hook
.globl __lwpasm_start
.globl __lwpasm_end
.globl _lwp_yield
.globl __lwp_scheduler
.globl _lwp_thread_enable
.globl _lwp_thread_disable
.globl __init_fpu
.globl __lwp_pcount
tmp1: .long 0
tmp2: .long 0
tmp3: .long 0
.globl tmp1
.globl tmp2
.globl tmp3

.align 4
.text
__lwpasm_start:
__lwp_pm_irq8_timer_hook:
        pushl %eax
        pushl %ds
        .byte 0x2E   /* CS: */
        movw ___djgpp_ds_alias, %ds
        cmp $0, __lwp_interrupt_pending
        jne L2
        movl $1, __lwp_interrupt_pending
        cmp $0, __lwp_enable
        jne  L1
        movb $0x99,%al
        call ___djgpp_hw_exception
        jmp L2

L1:     movl $0, __lwp_interrupt_pending
L2:     movb $0x0C, %al
        outb %al, $0x70
        inb  $0x71, %al  /* ACK int in RTC */
        movb $0x20, %al
        outb %al, $0xa0 /* ACK int in slave int controller */
        outb %al, $0x20 /* ACK int in master int controller */
        popl %ds
        popl %eax
        sti
        iret



__lwp_pm_irq0_timer_hook:
        pushl %eax
        pushl %ds
        .byte 0x2E  /* CS: */
        movw ___djgpp_ds_alias, %ds
        cmp $0, __lwp_interrupt_pending
        jne L4
        movl $1, __lwp_interrupt_pending
        cmp $0, __lwp_enable
        jne  L3
        movb $0x99,%al
        call ___djgpp_hw_exception
        jmp L4
L3:     movl $0, __lwp_interrupt_pending
L4:     movl $0x20, %eax
        outb %eax, $0x20
        popl %ds
        popl %eax
        sti
        iret

.align 4
__lwp_scheduler:
        movl  ___djgpp_exception_state_ptr, %edi
        cmpl $0, %edi
        je raised               /* SIGILL was raise()'d, not by interrupt */
        /* get reg values from __djgpp_exception_state */
        movl 0(%edi), %eax
        pushl %eax
        movl 4(%edi), %ebx
        movl 8(%edi), %ecx
        movl 12(%edi), %edx
        movl 16(%edi), %esi
        movl 24(%edi), %ebp
        movl 28(%edi), %eax
        movl %eax, tmp1       /* esp */
        movl 32(%edi), %eax
        movl %eax, tmp2       /* eip */
        movl 36(%edi), %eax
        movl %eax, tmp3       /* eflags */
        popl %eax
        movl 20(%edi), %edi
        movl tmp1, %esp       /* stack switched to exception state stack */
        pushl tmp2            /* push exeception state ret address */
        /* now it's setup to look just like a yield happened in the code  */

        pushal
        pushl tmp3   /* eflags */

        decl __lwp_pcount       /* Decrement priority counter   */
        cmp $0,__lwp_pcount     /* If > 0                       */
        ja P1                   /* Skip this section            */

        subl $108, %esp
        fwait
        fnsave (%esp)   /* FPU pushal ;) */
        fwait

        movl __lwp_cur, %esi
        movl %esp, 12(%esi)

   call _lwp_findnext

   movl __lwp_cur, %esi

        movl 12(%esi), %esp

        cli
        fwait
        frstor (%esp)   /* FPU popal ;) */
        fwait
        addl $108, %esp

        popl %eax
        andb $0xfe, %ah   /* mask off debug flag */
        pushl %eax

P1:     popfl
        sti
        popal
raised: movl $0, __lwp_interrupt_pending
        ret

/*
 * _lwp_yield is imperative! It doesn't care about priorities: if a threads
 * asks for it, it must be IMMEDIATELY performed.
*/
.align 4
_lwp_yield:
        movl $1, __lwp_interrupt_pending
        pushal
        pushfl

        subl $108, %esp
        fwait
        fnsave (%esp)   /* FPU pushal ;) */
        fwait

        movl __lwp_cur, %esi
        movl %esp, 12(%esi)

   call _lwp_findnext
   movl __lwp_cur, %esi

        movl 12(%esi), %esp

        cli
        fwait
        frstor (%esp)   /* FPU popal ;) */
        fwait
        addl $108, %esp

        popl %eax
        andb $0xfe, %ah   /* mask off debug flag before poping */
        pushl %eax        /* the flags */
        popfl

        sti

        popal
        movl $0, __lwp_interrupt_pending
        ret

__init_fpu:
        pushl %eax
        movl $__fpu_init_state, %eax
        finit
        fwait
        fnsave (%eax)
        fwait
        popl %eax
        ret

_lwp_thread_enable:     movl $0, __lwp_enable
                        ret
_lwp_thread_disable:    movl $1, __lwp_enable
                        ret
__lwpasm_end:
