// -----------------------------------------------------------------------
//  threads.cc - C++ Interface to modified LWP package
//  Copyright (C) 1997 Paolo De Marino
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version,
//  with the only exception that the people in the THANKS file must
//  receive credit.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; see the file COPYING.LIB.
//  If not, write to the Free Software Foundation, Inc., 675 Mass Ave,
//  Cambridge, MA 02139, USA.
//
//  For contacting the author send electronic mail to
//		 paolodemarino@usa.net
//
//  Or paper mail to
//
//     Paolo De Marino
//     Via Donizetti 1/E
//     80127 Naples
//     Italy
//
// History: see history.txt
// -----------------------------------------------------------------------

#ifdef DEBUG
        #define ZFORTIFY
        #include "../../fortify/zfortify.hpp"
#endif

#include "threads.h"
#include "lwpstdio.h"

unsigned int CritSect::numLocks = 0;

Thread::Thread(unsigned stack,unsigned priority,int startImmediately)
     : messagesQueue()
{
    MutexSemaphoreLock r(res);  // Lock access to other constructors
    run = startImmediately ?    // Most important, allows sinc with spawned process
          1 : 0;
    dead = 0;                   // Obviously, the thread isn't dead!
    curThread = this;           // Gives identity to static member function
    readyToRun = 0;             // Set by spawned member function to
                                // ackowledge us

    pid = lwp_spawn(spawnedProcess, stack,priority);
    lwp_wait_true(&readyToRun); // Wait until thread has acknowledged
}

void Thread::spawnedProcess(void)
{
    Thread *myobj = curThread;
    if (myobj->pid != lwp_getpid())
    {
        printf("Error - no ACK possible between thread and creator\n");
        exit(-1);
    }
    myobj->readyToRun = 1;      // Unlock constructor, we've linked up!

    lwp_setuserptr((void *) myobj);     // Prepare currentThread()

    myobj->prepare();

    lwp_wait_true(&(myobj->run));       // Now, wait until master signals to start...

    myobj->execute();
// Clean up, if necessary!
    myobj->cleanup();
    myobj->dead = 1;
}
void Thread::prepare(void)
{
//    printf("Preparing...\n");
}
void Thread::execute(void)
{
//    printf("Executing...\n");
}
void Thread::cleanup(void)
{
//    printf("Cleaning up...\n");
}

Thread *Thread::curThread = 0;
MutexSemaphore Thread::res;

// ---------------------------------------------------------------------
class MainThread : public Thread
{
public:
    MainThread();               // Contructor HAS to be called from main

    void kill(void) { };        // Can't kill main()

    void waitCompletion(void) { };
};

MainThread::MainThread(void) : Thread()
{
    pid = LWP_MAIN;
    if (pid != getPid())
    {
          printf("Wrong initialization - "
                 "MainThread started from a non-main() task!");
          abort();
    }
    lwp_setuserptr((void *) this);      // Prepare currentThread()
    run = 1;
    dead = 0;
}
MainThread *theMainThread = 0;

void InitLwp(int speed)
{
    lwp_init(8, speed);
    theMainThread = new MainThread;
}
void DoneLwp(void)
{
    lwp_thread_disable();       // Lock multitasking engine for last time
    delete theMainThread;
}

// Here we redefine a more hardened operator new and delete.
#ifndef ZFORTIFY

void * operator new(size_t size)
{
 return malloc(size);
}

void operator delete(void *what)
{
 free(what);
}
#endif
