//  Tests mulithreading engine. Stability test. Written by
//  Paolo De Marino (paolodemarino@usa.net)
//  This demo file is FREEWARE - you can do whatever you want with it.
//
//  This demo is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this demo; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "lwp.h"
#include "lwpstdio.h"
#include "lwpconio.h"
#include "lwppc.h"

#include <pc.h>
#include <go32.h>
#include <sys/timeb.h>


#ifdef DEBUG
#define FORTIFY
#include "../../fortify/fortify.h"
#endif

#define MAX_PROC 50
#define PROCS_STEP 10

void
proc1 (void)
{
  char ch = 0;
  char attr = ScreenAttrib;
  static volatile int offset = 0;
  unsigned int off = offset++;

  while (1)
    {
      ScreenPutChar (ch, attr, off, 1);
      ch++;
    }
}

void
proc2 (void)
{
  static volatile int offset = 0;
  int pid = lwp_getpid ();

  offset++;

  printf ("Thread %i starts!\n", pid);

  lwp_sleep (0, 500);

  printf ("Thread %i suicides!\n",pid);

  if (offset & 1)               /* Odd threads "suicide" via lwp_kill */
    {
      lwp_kill (pid);
      printf ("Hey!!! Shouldn't get here!!!! (PID %i)\n\r", pid);
    }
  return;                       /* Even threads suicide via return */
}
void printRing(void)
{
        lwp *curs = _lwp_cur;
        lwp_thread_disable();

        do
          {
                printf("Thread %i       Status %i\n",curs->lwpid,curs->status);
                curs = curs->next;
        } while(curs != _lwp_cur);
        lwp_thread_enable();
}
#if 0
void
find_granularity (void)
{
  struct timeb a, b;
  long long diff;

  fprintf(stderr,"Granularity...\n");
  printf ("Tring to find ftime granularity...\n\r"
          "This shouldn\'t take more than 2/10 of a second...\n\r");

  ftime (&a);
  do
    {
      ftime (&b);
      diff = (b.time - a.time) * 1000 + (b.millitm - a.millitm);
    }
  while (diff == 0);
  printf ("ftime granularity is %llu ms\n", diff);
  fprintf(stderr,"ftime granularity is %llu ms\n",diff);
  while (!kbhit ());
   while (kbhit ())
    getch ();
}

void
test_lwp_sleep (void)
{
  struct timeb a, b;
  unsigned long long diff;
  int times[] = {500, 500, 1000, 2000, 2500, 3000, 0, 0};
  int i;

  fprintf(stderr,"Sleep test...\n");
  printf ("Testing lwp_sleep.\n\r"
          "Requested sleep time(ms)      Time effectively slept(ms)\n\r");
  fprintf (stderr,"Testing lwp_sleep.\n\r"
          "Requested sleep time(ms)      Time effectively slept(ms)\n\r");

  for (i = 0; i < sizeof (times) / sizeof (times[0]); i++)
    {
      ftime (&a);
      lwp_sleep (times[i] / 1000, times[i] % 1000);
      ftime (&b);
      diff = (b.time - a.time) * 1000 + (b.millitm - a.millitm);
      fprintf (stderr,"%10u                     %10llu\n", times[i], diff);
                printf ("%10u                     %10llu\n", times[i], diff);
    }
  printf("Press a key\n");
  while (!kbhit ());
  while (kbhit ())
    getch ();
}
#endif
void
test_spawn_kill (void)
{
  int ids[MAX_PROC], i = 0;

  printf ("\n\n\n\r"
          "We will spawn threads up to a maximum of 80, and kill them\n\r"
          "Press a key to start.");
  fprintf(stderr,"Testing lwp_spawn and lwp_kill\n");
  do
    {
      int j;
      for (j = 0; j < PROCS_STEP; j++, i++)
        ids[i] = lwp_spawn (proc1, 4096, 1);

      lwp_sleep (1, 0);
      fprintf(stderr,"%i Threads active\n",lwp_getactive());
    }
  while ((i < MAX_PROC) && !kbhit ());

  while (kbhit ())
    getch ();

  fprintf(stderr,"Killing threads...\n");

  for (; i >= 0; i--)
    lwp_kill (ids[i]);

  fprintf(stderr,"Threads killed, yielding.\n");

  lwp_sleep(1,0);

  while (kbhit ())
    getch ();

  fprintf(stderr,"%i Threads active\n",lwp_getactive());
  printRing();
}
void
test_suicide_and_death (void)
{
  int i = 0,threads;

  printf ("\nPress a key to start.\n"
                         "How many threads do you want to spawn?\n"
                         "They will be started and then killed. The main thread will wait\n"
                         "5 seconds after the end.\n");

  scanf("%d",&threads);
  printf("\nEcho: %i\n",threads);
  fprintf(stderr,"Testing suicide...\n");
  for (i = 0; i < threads; i++)
    lwp_spawn (proc2, 4096, 1);

  printRing();
  printf("%i Threads active + MAIN + TCP\n",lwp_getactive()-2);

  printf ("Sleeping...\n\r");
  lwp_sleep (5, 0);     // Calls lwp_yield...

  while (kbhit ())	// Clear keyboard buffer
    getch ();

  fprintf(stderr,"Should have all died...\n");
  fprintf(stderr,"%i Threads active\n",lwp_getactive());
}
int
main ()
{
     setvbuf(stderr,0, _IONBF,0);
#if 0
  find_granularity ();
#endif
#ifdef DEBUG
  Fortify_EnterScope ();
  Fortify_CheckAllMemory ();
#endif
  ScreenClear ();

  if (!lwp_init (8, RTC512))
    {
      fprintf (stderr, "Unable to initialize multithreading.\n\r");
      return -1;
    }
  else
    {
      printf ("Multithreading correctly initialized.\n\r");
    }

#if 0
  test_lwp_sleep ();

  ScreenClear ();

  test_spawn_kill ();
#endif
  ScreenClear ();

  test_suicide_and_death ();

  lwp_deinit ();

  ScreenClear ();

  printf ("Looking for memory leaks...\n");
#ifdef DEBUG
  Fortify_CheckAllMemory ();

  Fortify_LeaveScope ();
#endif
  return 0;
}
