//  Demonstrates use of printf with multithreading. Written by
//  Josh Turpen (snarfy@goodnet.com) and
//  Sengan Short(sengan.short@durham.ac.uk)
//  Modified by Paolo De Marino (paolodemarino@usa.net)
//  This demo file is FREEWARE - you can do whatever you want with it.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING. If not, write to the
//  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "lwp.h"
#include "lwpconio.h"
#include "lwpstdio.h"

#ifdef DEBUG
 #define FORTIFY
 #include "../../fortify/fortify.h"
#endif

#define MAX_PROC 4
void proc1(void)
{
   while(1)
     {
        printf("PROC 1\n");  /* printf disables tasking, and this loop */
        lwp_yield();         /* is too tight not to yield.  If printf  */
                             /* was re-entrant, then it would pre-empt */
                             /* much easier.                           */
     }
}

void proc2(void)
{
   while(1)
     {
        printf("PROC 2\n");
        lwp_yield();
     }
}

void proc3(void)
{
   while(1)
     {
        printf("PROC 3\n");
        lwp_yield();
     }
}

void proc4(void)
{
   while(1)
     {
        printf("PROC 4\n");
        lwp_yield();
     }
}

int main()
{
 int ids[MAX_PROC];

 if(lwp_init(8, RTC128)) /* doesn't really matter since each task yields */
 {
 ids[0] = lwp_spawn(proc1, 4096,1);
 ids[1] = lwp_spawn(proc2, 4096,1);
 ids[2] = lwp_spawn(proc3, 4096,1);
 ids[3] = lwp_spawn(proc4, 4096,1);
 while(!kbhit())
    {
    printf("MAIN\n");
    lwp_yield();
    }
 getch();
 lwp_kill(ids[0]);
 lwp_kill(ids[1]);
 lwp_kill(ids[2]);
 lwp_kill(ids[3]);
 }
 return 0;
}