// Associated include file : Graphics/Button.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// ----- Object TButton

DEFINE(TButton);

DEFINE_EVENTS_TABLE(TButton,TZone)
  COMMAND(cmSelect,  doChangeSelect)
  COMMAND(cmUnSelect,doChangeSelect)
  COMMAND(cmButtonReAction,doButtonReAction)
  MOUSELDOWN()
  MOUSELUP()
  KEYDOWN()
END_EVENTS_TABLE;

short RegTButton;
char *IdentTButton = "TButton";

// Delais en 1/100 de secondes

#define DelayTime    30
#define RepetTime    4
#define DownTime     10

// Contructors

TButton::TButton()
{ Defaults();
}

TButton::TButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options)
{ Defaults();
  Init(X,Y,L,H,_Command,_ScanCode,_Options);
}

TButton::TButton(TRect R, long _Command, int _ScanCode, int _Options)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Command,_ScanCode,_Options);
}

void TButton::Defaults(void)
{ // Object identification
  Register=RegTButton;
  Ident=IdentTButton;
  // Other default values
  Command=0;
  ScanCode=0;
  SetOptions(opSelectable | opGetAllEvents);
}

void TButton::Init(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options)
{ // Herited creations
  TZone::Init(X,Y,L,H);
  // New creations
  Command=_Command;
  ScanCode=_ScanCode;
  if (_Options & boDisabled)
  { SetStatus(sfDisabled);
    _Options&=~boDisabled;
  }
  ButtonOptions=_Options;
  RectChanging=Where-Where.P1();
}

// Events

boolean TButton::MouseLUp(TPoint , int )
{ if (GetStatus(sfDown))
  { ClearStatus(sfDown);
    Invalidate(RectChanging);
    if (GetStatus(sfMouseIn))
      if (!(ButtonOptions & boImmediate)) Action();
    return TRUE;
  }
  return FALSE;
}

boolean TButton::MouseLDown(TPoint , int )
{ if (!GetStatus(sfDisabled))
    if (GetStatus(sfMouseIn))
    { SetStatus(sfDown);
      Invalidate(RectChanging);
      if (ButtonOptions & boImmediate) Action();
      if (ButtonOptions & boRepetition) SetAlarm(cmButtonReAction,DelayTime,this);
      return TRUE;
    }
  return FALSE;
}

boolean TButton::doChangeSelect(void)
{ if (Focus()) Invalidate();
  return FALSE;
}

boolean TButton::doButtonReAction(void)
{ if (CurrentEvent.InfoPtr==this)
  { if (GetStatus(sfDown) && GetStatus(sfMouseIn))
    { Action();
      SetAlarm(cmButtonReAction,RepetTime,this);
    }
    return TRUE;
  }
  return FALSE;
}

boolean TButton::KeyDown(int SC, int Toggle)
{ if (TZone::KeyDown(SC,Toggle)) return TRUE;
  if (!GetStatus(sfDisabled))
  { int C=SC;
    if (ButtonOptions & boNoCase) ScanCodeUpr(C);
    if (GetStatus(sfSelected))
      if (C==(int)' ')
      { KeyboardAction();
        return TRUE;
      }
    if (ButtonOptions & boShiftedScanCode)
    { // Touche = ScanCode+Shift
      if (GetToggleStatus() & tgShift)
        if (C==ScanCode)
        { KeyboardAction();
          return TRUE;
        }
    }
    else
    { // Touche = ScanCode
      if (C==ScanCode)
      { KeyboardAction();
        return TRUE;
      }
    }
  }
  return FALSE;
}

// Graphics

void TButton::DrawSelect(int Depl)
{ SetSysColor(DarkGray);
  Rectangle(4+Depl,4+Depl,Where.Width()-5+Depl,Where.Height()-5+Depl);
}

void TButton::DrawInside(int )
{ }

int TButton::DrawFrame()
{ return Frame3D(GetStatus(sfDown));
}

void TButton::Draw(TRect )
{ int D;
  SetSysColor(FaceGray);
  Bar(0,0,Where.Width()-1,Where.Height()-1);
  D=DrawFrame();
  if (GetStatus(sfDisabled)) FontSystem->Grayed(TRUE);
  else SetSysColor(Black);
  SetSysColor(Black);
  DrawInside(D);
  FontSystem->Grayed(FALSE);
  if (Focus()) DrawSelect(D);
}

// Action

void TButton::Action(void)
{ SetCommand(Command,this);
}

void TButton::KeyboardAction(void)
{ SetStatus(sfDown);
  Invalidate(RectChanging);
  ShowDrawingNow();
  Delay(DownTime);
  ClearStatus(sfDown);
  Invalidate(RectChanging);
  ShowDrawingNow();
  Action();
}

// Objects streams

void TButton::Read(TDisk* file)
{ TZone::Read(file);
  file->Read(&Command,sizeof(long));
  ReadInt(file,&ScanCode);
  ReadInt(file,&ButtonOptions);
}

void TButton::Write(TDisk* file)
{ TZone::Write(file);
  file->Write(&Command,sizeof(long));
  WriteInt(file,ScanCode);
  WriteInt(file,ButtonOptions);
}

// ----- TStdButton

DEFINE(TStdButton);

short RegTStdButton;
char *IdentTStdButton = "TStdButton";

TStdButton::TStdButton()
{ Defaults();
}

TStdButton::TStdButton(int X, int Y, int L, int H, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp)
{ Defaults();
  Init(X,Y,L,H,_Command,_ScanCode,_Options,_Text,_Mapp);
}

TStdButton::TStdButton(TRect R, long _Command, int _ScanCode, int _Options, char* _Text, TMapping* _Mapp)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Command,_ScanCode,_Options,_Text,_Mapp);
}

void TStdButton::Defaults(void)
{ // Object identification
  Register=RegTStdButton;
  Ident=IdentTStdButton;
  // Other defaults values
  ParamText=NULL;
  Text=NULL;
}

void TStdButton::Init(int X, int Y, int L, int H, long _Command, int _ScanCode,
                      int _Options, char* _Text, TMapping* _Mapp)
{ int LCur=L-8;
  // Herited constructions
  TButton::Init(X,Y,L,H,_Command,_ScanCode,_Options);
  // New constructions
  Mapp=_Mapp;
  if (_Text!=NULL) ParamText=strdup(_Text);
  // :: If there is a mapping, compute its position and kepp its space
  if (Mapp!=NULL)
  { if (ParamText==NULL)
    { // No text -> Bitmap is centered
      dXM=(Where.Width()-3-Mapp->Width())/2+1;
    }
    else
    { // A txt -> Bitmap is right-aligned
      dXM=Where.Width()-5-Mapp->Width();
    }
    dYM=(Where.Height()-3-Mapp->Height())/2+1;
    LCur-=Mapp->Width()+4;
  }
  // :: If there is a text, truncate it to L, and compute its position
  if (ParamText!=NULL)
  { Text=strdup(ParamText);
    FontSystem->TruncSysStr(LCur,ParamText,Text);
    dXT=4+(LCur-FontSystem->WidthSysStr(Text))/2;
    dYT=(Where.Height()-FontSystem->HeightStr(Text))/2;
    // Search for a HotKey in the system text
    char *P=strchr(Text,'&');
    if (P!=NULL) ScanCode=(short)(*(P+1));
  }
}

void TStdButton::Done(void)
{ // Herited destructions
  TButton::Done();
  // New destructions
  if (Text!=NULL)      free(Text);
  if (ParamText!=NULL) free(ParamText);
  if (Mapp!=NULL)      delete Mapp;
}

void TStdButton::DrawInside(int Depl)
{ if (Text!=NULL) PutSysStr(dXT+Depl,dYT+Depl,Text,FontSystem);
  if (Mapp!=NULL) Mapp->Draw(dXM+Corner.X()+Depl,dYM+Corner.Y()+Depl);
}

// Objects streams

void TStdButton::Read(TDisk* file)
{// char Tmp;
  TButton::Read(file);
/*  if (ParamText!=NULL) free(ParamText);
  ReadString(file,&ParamText);
  file->Read(&Tmp,sizeof(char));
  if (Tmp)
  { // If there is no mapping, generate one in order to be able to read the new
    if (Mapp==NULL) Mapp=new TSysIcone(7,7,ICO_OK);
    // Read the new mapping
    Mapp->Read(file);
  }
  else
  { if (Mapp!=NULL) delete Mapp;
    Mapp=NULL;
  }
  Init2();*/
}

void TStdButton::Write(TDisk* file)
{ char Tmp;
  TButton::Write(file);
  WriteString(file,ParamText);
  Tmp=(Mapp!=NULL);
  file->Write(&Tmp,sizeof(char));
  if (Tmp) Mapp->Write(file);
}

// ----- Standard Buttons

TOKButton::TOKButton(int X, int Y) :
  TStdButton(X,Y,80,23,cmOK,ScanReturn,0,"OK",new TSysIcone(16,11,ICO_OK))
{ }

TCancelButton::TCancelButton(int X, int Y) :
  TStdButton(X,Y,80,23,cmCancel,ScanEscape,0,"Cancel",new TSysIcone(13,12,ICO_Cancel))
{ }

TYesButton::TYesButton(int X, int Y) :
  TStdButton(X,Y,80,23,cmYes,ScanAltY,0,"&Yes",NULL)
{ }

TNoButton::TNoButton(int X, int Y) :
  TStdButton(X,Y,80,23,cmNo,ScanAltN,0,"&No",NULL)
{ }
