// Associated include file : Graphics/Shell.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

// Variables globales

long          ScreenSaverDelay;
TScreenSaver *ScreenSaver;
long          DelayDblClick;
long          LastClickTime;

// Variables locales

long    AlarmTime;
long    AlarmComm;
long    AlarmDelay;
void   *AlarmPtr;
long    ScreenSaverTime;
boolean MouseDrag;

// --- TShell

DEFINE(TShell);

short         RegTShell;
char         *IdentTShell = "TShell";
TShell       *Application;

DEFINE_EVENTS_TABLE(TShell,TObject)
  COMMAND(cmUpdateMouse,doUpdateMouse)
END_EVENTS_TABLE

// Constructeur, Destructeur

TShell::TShell(void)
{ Defaults();
  Init();
}

void TShell::Defaults(void)
{ // Object Identification
  Register=RegTShell;
  Ident=IdentTShell;
  // Other defaults values
  NbEventStock=0;
  Time.Second=70;
  Time.Minute=70;
  Time.Hour=25;
  AlarmComm=0;
  MouseActiveZone=NULL;
  MouseDrag=FALSE;
  // Temporisation souris
  DelayDblClick=20;
  LastClickTime=-10000;
  ScreenSaver=NULL;
}

void TShell::Init(void)
{ // Herited Creations
  TObject::Init();
  // New Creations
  // :: Build the default Screen Saver
  ScreenSaver=ScreenSaverCreation();
}

// Mouse events

void TShell::GetKeyMouseEvent(TEvent *Event)
{ long Time;
  // Capte tous les vnements
  GrMouseEvent evt;
  GrMouseGetEvent(GR_M_EVENT | GR_M_POLL | GR_M_NOPAINT,&evt);
  if (evt.flags & GR_M_KEYPRESS)   { Event->What=evKeyDown;    goto fin; }
  if (evt.flags & GR_M_LEFT_DOWN)
  { Time=GetTime();
    if (Time-LastClickTime<=DelayDblClick)
    { Event->What=evMouseDblClk;
      LastClickTime=-10000;
    }
    else
    { Event->What=evMouseLDown;
		LastClickTime=Time;
    }
    goto fin;
  }
  if (evt.flags & GR_M_RIGHT_DOWN) { Event->What=evMouseRDown; goto fin; }
  if (evt.flags & GR_M_LEFT_UP)    { Event->What=evMouseLUp;   goto fin; }
  if (evt.flags & GR_M_RIGHT_UP)   { Event->What=evMouseRUp;   goto fin; }
  if (evt.flags & GR_M_MOTION)     { Event->What=evMouseMove;  goto fin; }
  return;
fin:
  Event->Where.X()=evt.x;
  Event->Where.Y()=evt.y;
  Event->Buttons=evt.buttons;
  Event->KbStat=evt.kbstat;
  if (evt.key & 0xFF00) Event->ScanCode=(evt.key & 0xFF) << 8;
                   else Event->ScanCode=(evt.key & 0xFF);
}

// Time event and Alarms

void SetAlarm(long Comm, long Delay, void *Ptr)
{ AlarmTime=GetTime();
  AlarmComm=Comm;
  AlarmDelay=Delay;
  AlarmPtr=Ptr;
}

void TShell::GetTimeEvent(TEvent* Event)
{ long      SysTime=GetTime();
  TTimeDate NewTime;
  // Vrifie l'ventuelle alarme
  if (AlarmComm)
    if (SysTime-AlarmTime>AlarmDelay)
    { Event->What=evCommand;
      Event->Command=AlarmComm;
      Event->InfoPtr=AlarmPtr;
      AlarmComm=0;
      return;
    }
  // Met  jour les compteurs et envoie les Events
  if ((NewTime.Second!=Time.Second) ||
      (NewTime.Minute!=Time.Minute) ||
      (NewTime.Hour  !=Time.Hour))
  { Time.Second=NewTime.Second;
    Time.Hour=NewTime.Hour;
    Time.Minute=NewTime.Minute;
    Event->What=evTime;
    return;
  }
/*
  if ((bdate.da_year!=Time.Year) ||
      (bdate.da_mon!=Time.Month) ||
      (bdate.da_day!=Time.Day))
  { Time.Year=bdate.da_year;
    Time.Month=bdate.da_mon;
    Time.Day=bdate.da_day;
    Event->What=evDate;
    return;
  }*/
}

//

void TShell::GetEvent(TEvent* Event)
{ // Par dfaut, aucun vnement
  Event->What=evNothing;
  // Regarde d'abord le stock
  if (NbEventStock)
  { NbEventStock--;
    *Event=EventStock[NbEventStock];
  }
  else
  { // Puis les divers priphriques d'entre
    GetKeyMouseEvent(Event);
    // Traitements spciaux sur ces vnements
    // :: Handling of Mouse Cursor Aspect when the mouse fly over screen objects
    if ((Event->What==evMouseMove)&&(!MouseDrag))
    { TZone *OldMouseActive = MouseActiveZone;
      MouseActiveZone=NULL;
      Event->What=evMouseTest;
      ModalObject->HandleEvent(Event);
      Event->What=evMouseMove;
      if (OldMouseActive!=MouseActiveZone)
      { if (OldMouseActive!=NULL) OldMouseActive->LeaveActiveZone();
        OldMouseActive=MouseActiveZone;
        if (MouseActiveZone!=NULL) MouseActiveZone->BecomeActiveZone();
                              else ChangeMouseAspect(MouseCursorArrow);
      }
    }
    // :: Handling the Insert status
    if ((Event->What==evKeyDown)&&(Event->ScanCode==ScanInsert))
    { Event->What=evCommand;
      Event->Command=cmDrawCursor;
      ModalObject->HandleEvent(Event);
      CursorIns=!CursorIns;
      Event->What=evCommand;
      Event->Command=cmDrawCursor;
      ModalObject->HandleEvent(Event);
      Event->What=evNothing;
    }
    //
    if (Event->What!=evNothing)
    { // Un vnement utilisateur a eu lieu -> Il faut remettre  zro
      // Le dlai d'conomiseur d'cran
      ScreenSaverTime=GetTime()/100;
    }
    else
      if (GetTime()/100-ScreenSaverTime>ScreenSaverDelay)
      { // Le dlai d'inactivit est dpass -> Dclencher le ScreenSaver
        // 1. Excute l'conomiseur jusqu' une action utilisateur
        ScreenSaver->Execute();
        // 2. Demande la Restauration de l'cran
        Desktop->Invalidate();
        // 3. Reset du timing
        ScreenSaverTime=GetTime()/100;
        return;
      }
    if (Event->What==evNothing) GetTimeEvent(Event);
    // Si aucun, envoie l'vnement automatique
    if (Event->What==evNothing) Event->What=evAuto;
  }
}

void TShell::SetEvent(TEvent *Event)
{ if (NbEventStock==MaxEventStock)
  { /*ErrorMsg("Erreur programmeur",
             "Trop d'vnements stocks par SetEvent");*/
  }
  else
  { EventStock[NbEventStock]=*Event;
    NbEventStock++;
  }
}

boolean TShell::Focus(void)
{ return TRUE;
}

long TShell::EventsLoop(TObject *O)
{ TObject *OldModalObject=ModalObject;
  ModalObject=O;
  TEvent Event;
  O->ExitCode=0L;
  do
  { GetEvent(&Event);
    if (Event.What & evNotModal) HandleEvent(&Event);
                            else O->HandleEvent(&Event);
  } while(!(O->ExitCode));
  ModalObject=OldModalObject;
  return(O->ExitCode);
}

boolean TShell::doUpdateMouse(void)
{ TEvent     Event;
  GrCursor *Cursor=GrMouseGetCursor();
  Event.What=evMouseMove;
  Event.Where.X()=Cursor->xcord;
  Event.Where.Y()=Cursor->ycord;
  SetEvent(&Event);
  return TRUE;
}

void TShell::ScreenSaverReset(int Delay)
{ ScreenSaverTime=GetTime()/100;
  ScreenSaverDelay=Delay;
}

TScreenSaver *TShell::ScreenSaverCreation()
{ return new TScreenSaver(this);
}

// ----- Screen Saver

TScreenSaver::TScreenSaver(TShell *Shell)
{ TheShell=Shell;
}

boolean TScreenSaver::NoUserAction(void)
{ TEvent Event;
  Event.What=evNothing;
  TheShell->GetKeyMouseEvent(&Event);
  return Event.What==evNothing;
}

void TScreenSaver::Execute(void)
{ NoStep=0;
  Init();
  do
  { Step();
    NoStep++;
  } while(NoUserAction());
  Done();
}

void TScreenSaver::Init(void)
{ // Blank Screen
  GrSetClipBox(0,0,GrMaxX(),GrMaxY());
  GrFilledBox(0,0,GrMaxX(),GrMaxY(),NoSysColor[0]);
  // Change le curseur souris
  ChangeMouseAspect(MouseCursorInactivity);
  MouseChangeTime=GetTime()/100;
}

void TScreenSaver::Step(void)
{ // Change in a random way the mouse cursor position, every seconds
  if (GetTime()/100-MouseChangeTime>=1)
  { GrMouseWarp(20+Random(GrMaxX()-40),20+Random(GrMaxY()-40));
    MouseChangeTime=GetTime()/100;
  }
}

void TScreenSaver::Done(void)
{ // Restaure le curseur souris
  RestoreMouseAspect();
}

// --- Usefull functions

void BeginDrag()
{ MouseDrag=TRUE;
}

void EndDrag()
{ MouseDrag=FALSE;
}
