// Associated include file : Graphics/Window.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"

// ----- TWindow

DEFINE(TWindow);

short RegTWindow;
char *IdentTWindow = "TWindow";

// Constructors

TWindow::TWindow()
{ Defaults();
}

TWindow::TWindow(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

TWindow::TWindow(TRect R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

void TWindow::Defaults(void)
{ // Object identification
  Register=RegTWindow;
  Ident=IdentTWindow;
  // Other defaults values
  SetOptions(opSelectable | opCSHiX | opCSHiY);
  ColorGroup=0;
  MinimalSize=TPoint(50,70);
}

void TWindow::Init(int X, int Y, int L, int H)
{ // Herited creations
  TZone::Init(X,Y,L,H);
}

// Events

// DO NOT use DECLARE_EVENTS_TABLE... macros in this object because
// it has a very special events treatments. The MouseLDown must be
// treated FIRST in order to allow focus change between overlapping
// windows

boolean TWindow::MouseLDown(TPoint , int )
{ if (GetStatus(sfMouseIn))
  { if (!GetStatus(sfSelected)) ComeToForeground();
    return TRUE;
  }
  return FALSE;
}

void TWindow::HandleEvent(TEvent *Event)
{ boolean PurgeEvent=FALSE;
  if (Event->What == evMouseLDown)
    PurgeEvent=MouseLDown(Event->Where,Event->Buttons);
  DealEvent(Event);
  if (PurgeEvent) ClearEvent(Event);
             else TreatEvent(Event);
}

boolean TWindow::CanClose(void)
{ return TRUE;
}

// Objects streams

void TWindow::Read(TDisk *file)
{ TZone::Read(file);
  file->Read(&ColorGroup,sizeof(char));
}

void TWindow::Write(TDisk *file)
{ TZone::Write(file);
  file->Write(&ColorGroup,sizeof(char));
}

// Clipping

void TWindow::ComeToForeground(void)
{ // Change Linked list order
  // :: Remove from the list without doing anything else
  TObject::UnLink();
  // :: Replace in the top of the list
  Desktop->Insert(this);
}

void TWindow::CalculateClip(void)
{ TWindow *W;
  TRect    R;
  //
  TZone::CalculateClip();
  // Clip avec toutes les fentres qui sont devant
  W=Next();
  while(W!=NULL)
  { // Clip avec cette fenetre
    W->GetClipRect(R);
    ClipWithRect(Clipping,R-Where.P1());
    ClipWithRect(ClipSons,R-Where.P1());
    // Zone suivante
    W=W->Next();
  }
}

void TWindow::GetClipRect(TRect& R)
{ R=Where;
  R.X1()+=2;
  R.Y1()+=2;
  R.X2()-=2;
  R.Y2()-=2;
}

// Liste chainee

void TWindow::UnLink(void)
{ // D-slectionne cette fentre
  UnSelect();
  // Enleve la fenetre du bureau
  TZone::UnLink();
  // Slectionne la nouvelle fenetre de 1er plan
  TWindow *W=(TWindow*)Desktop->Son();
  if (W!=NULL)
  { W=W->Last();
    W->Select();
    W->Invalidate();
  }
}

void TWindow::Draw(TRect Clip)
{ SetSysColor(FaceGray);
  Bar(Clip);
}