// Associated include file : Mecanism/ClipBrd.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/clipbrd.h"

#define cpTextLine  1

// --- Local vars

TClipBoard *TheClipBoard;

// --- Object TClipBoard

TClipBoard::TClipBoard(void)
{ Type=0;
}

// --- Object TClipBoard_TextLine

TClipBoard_TextLine::TClipBoard_TextLine(char *_Line)
{ Line=strdup(_Line);
  Type=cpTextLine;
}

TClipBoard_TextLine::~TClipBoard_TextLine(void)
{ free(Line);
}

// --- Access Functions

void SetClipBoard(TClipBoard *Clip)
{ if (TheClipBoard!=NULL) delete TheClipBoard;
  TheClipBoard=Clip;
}

TClipBoard *GetClipBoard(void)
{ return TheClipBoard;
}

boolean ClipBoardEmpty(void)
{ return TheClipBoard==NULL;
}

int ClipBoardType(void)
{ if (TheClipBoard==NULL) return 0;
  return TheClipBoard->GetType();
}

// --- Init/Done

void InitClipBoard(void)
{ TheClipBoard=NULL;
}

void DoneClipBoard(void)
{ if (TheClipBoard!=NULL) delete TheClipBoard;
}