/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Little usefull graphical objects
	File      : Include/Gadgets/Menus.H
	Author    : Eric NICOLAS
	Overview  : TMenu, TMenuChoice objects : Menu Bar
	UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_MENUS_H_
#define _GADGETS_MENUS_H_

class TMenu;
class TMenuChoice;

// ===== Globals Vars =======================================================

extern TMenu *MainMenu;

// ===== TMenu Object =======================================================

extern short RegTMenu;
extern char *IdentTMenu;

class TMenu : public TStdWindow
{ DECLARE(TMenu);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    int    wText, wHotText;
    TMenu *FatherMenu;
  public:
  // Public constructors
          TMenu(void);
          TMenu(char *Text, int _Options=0);
  // Construction / Destruction
          void         Defaults(void);
          void         Init(char *Text, int _Options);
  // Interaction
          boolean      MouseLDown(TPoint Where, int Buttons);
          boolean      KeyDown(int ScanCode, int Toggle);
          void         CloseMenu(void);
  // Size computation
          void         InitChoices(void);
          int          CompHeight(void);
          int          CompWidth(void);
  // Linked lists
          TMenuChoice *FirstChoice(void);
          TMenuChoice *LastChoice(void);
          TMenuChoice *ActiveChoice(void);
};

// ===== TMenuChoice Object =================================================

extern short RegTMenuChoice;
extern char *IdentTMenuChoice;

class TMenuChoice : public TZone
{ DECLARE(TMenuChoice);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  public:
    // Datas set by user
    char  *Text;
    char  *HotText;
    int    GlobalScanCode;
    int    Command;                  // =0 si choix de sous-menu
    TMenu *SubMenu;                  // =NULL si choix d'action
    // Data computed
    int    LocalScanCode;
    int    wText, wHotText;
  // --- Functions
  public:
  // Public constructors
          TMenuChoice(void);
          TMenuChoice(char *_Text, int _GlobalScanCode,
                      int _Command, int _Status=0, int _Options=0);
          TMenuChoice(char *_Text, TMenu *_SubMenu, int _Status=0);
  // Construction / Destruction
          void         Defaults(void);
          void         Init(char *_Text, int _GlobalScanCode, int _Command,
                            TMenu *_SubMenu, int _Status, int _Options);
          void         Done(void);
  // Graphic aspect
          void         Draw(TRect Rect);
  virtual void         BecomeActiveZone(void);
  virtual void         LeaveActiveZone(void);
  // User action
          boolean      MouseLDown(TPoint Where, int Buttons);
          void         Down(void);
          void         Up(void);
          void         Activate(void);
  // Linked lists
          TMenu*       Father(void);
          TMenuChoice* NextChoice(void);
          TMenuChoice* PrevChoice(void);
};

// ===== Inline functions ===================================================

inline TMenu* TMenuChoice::Father(void)
{ return (TMenu*)TZone::Father();
}

#endif // _GADGETS_MENUS_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**                 Bug corrected in the clipping region system
**   01/03/96 :EN: Moving from struct to class. Adding Defaults() method
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
** ------------------------------------------------------------------------*/
