/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Screen graphics management
	File      : Include/Graphics/FontSys.H
	Author    : Olivier PAYEN, Eric NICOLAS
	Overview  : Font managing
	UpDate    : Mar 03, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_FONTSYS_H_
#define _GRAPHICS_FONTSYS_H_

#define FFace_NORMAL   0
#define FFace_BOLD     1
#define FFace_ITALIC   2

class TFont
{ // --- Datas
  protected:
    GrFont      *Fonts[4];
    GrTextOption Options;
    int          UnderLineOption;
    boolean      IsGrayed;
  // --- Functions
  public:
  // Constructor / Destructor
           TFont(char *Name);
  virtual ~TFont();
  // Choosing the font's attributes
          void     ChooseFace(int Face);
			 void     UnderLine(boolean UL);
          void     BackColor(int Color);
          void     BackSysColor(int SysColor);
          void     Grayed(boolean _IsGrayed);
  // Choosing the font's alignment
          void     XAlignLeft(void)    { Options.txo_xalign=GR_ALIGN_LEFT;   }
          void     XAlignCenter(void)  { Options.txo_xalign=GR_ALIGN_CENTER; }
          void     XAlignRight(void)   { Options.txo_xalign=GR_ALIGN_RIGHT;  }
          void     XAlignDefault(void) { Options.txo_xalign=GR_ALIGN_LEFT;   }
          void     YAlignUp(void)      { Options.txo_yalign=GR_ALIGN_TOP;    }
          void     YAlignCenter(void)  { Options.txo_yalign=GR_ALIGN_CENTER; }
          void     YAlignDown(void)    { Options.txo_yalign=GR_ALIGN_BOTTOM; }
          void     YAlignDefault(void) { Options.txo_yalign=GR_ALIGN_TOP;    }
          void     AlignDefault(void)  { XAlignDefault(); YAlignDefault();   }
  // Using the font
          int      WidthStr(char *Text);
          int      WidthChar(char Ch);
          int      HeightStr(char *Text=NULL);
          void     TruncStr(int Width, char *Text, char *Result);
          void     PutStr(int X, int Y, char *Text, int Color);
  // Using the font with system text
          int      WidthSysStr(char *Text);
			 void     TruncSysStr(int Width, char *Text, char *Result);
          void     PutChar(int X, int Y, char Ch, int Color);
          void     PutSysStr(int X, int Y, char *Text, int Color);
  private:
          void     DoPutStr(int X, int Y, char *Text, int Color);
};

extern TFont *FontSystem;
extern TFont *FontListing;

void InitFont();
void DoneFont();

#endif // _GRAPHICS_FONTSYS_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Moving from struct to class
**   03/03/96 :EN: Adding 'Grayed' functionality
** ------------------------------------------------------------------------*/
