/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*          This module was originally written by Vince Perriello           */
/*                                                                          */
/*                                                                          */
/*                      BinkleyTerm Terminal Overlay                        */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

void ansi_map (unsigned ScanVal)
{
   unsigned KeyCode;
  
   int i;
   int Len = 0;
   char *Ptr = AnsiTbl;

   if (AnsiHdr->ElemCnt == 0)
      return;

   for (i = 0; i < AnsiHdr->ElemCnt; i++)
      {
      KeyCode = *((unsigned int *)Ptr);
      Ptr += sizeof (unsigned int);
      Len = (int) *Ptr++;

      if (ScanVal == KeyCode)
         break;

      Ptr += Len;
      }

   if (i == AnsiHdr->ElemCnt)
      return;

   SENDCHARS (Ptr, Len, 0);  /* Send the mapped string   */
}

int term_overlay (int k)
{
   int c;
   long t1;

         switch ((unsigned)k)
            {
            case F_TERM_SETBAUD:
               ++baud;
               if (!btypes[baud].rate_value)
                  baud = 0;
               program_baud ();
               cur_baud = btypes[baud];
               scr_printf (MSG_TXT(M_BINK_NOW_AT));
               (void) sprintf (junk, "%u baud.\r\n", btypes[baud].rate_value);
               scr_printf (junk);
               break;

            case F_TERM_COMMCONFIG:
               scr_printf ("\r\n7 or 8 data bits? ");
               (void) fgets (junk, 100, stdin);
               comm_bits = (atoi (junk) == 7) ? BITS_7 : BITS_8;
               if (comm_bits == BITS_8)
                  {
                  parity = NO_PARITY;
                  }
               else
                  {
                  scr_printf ("(E)ven, (O)dd, or (N)o parity? ");
                  (void) fgets (junk, 100, stdin);
                  (void) strupr (junk);
                  parity = (junk[0] == 'E') ? EVEN_PARITY :
                     ((junk[0] == 'O') ? ODD_PARITY : NO_PARITY);
                  }
               scr_printf ("1 or 2 stop bits? ");
               (void) fgets (junk, 100, stdin);
               stop_bits = (atoi (junk) == 1) ? STOP_1 : STOP_2;

               program_baud ();
               break;

            case F_TERM_DIALOUT:
               scr_printf (MSG_TXT(M_PHONE_OR_NODE));
               if (!get_number (junk))
                  break;
               if (strchr (junk, '/') != NULL)
                  {
                  if (nodeproc (junk))
                     {
                     (void) strcpy (junk, (char *) (newnodedes.PhoneNumber));
                     do_dial_strings ();
                     }
                  else break;
                  }
               try_2_connect (junk);             /* try to connect         */
               gong ();
               break;

            case F_TERM_CLEARSCREEN:
               screen_clear ();
               break;

            case F_TERM_HANGUP:
               t1 = timerset (300);
               while (CARRIER)
                  if (timeup (t1))
                     {
                     scr_printf (MSG_TXT(M_NO_DROP_DTR));
                     break;
                     }
                  else
                     {
                     LOWER_DTR ();
                     }
               status_line (MSG_TXT(M_END_OF_CONNECT));
               RAISE_DTR ();
               break;

            case F_TERM_REINITMODEM:
               mdm_init (term_init);
               break;

            case F_TERM_SHELL:
               scr_printf ("\r\n");
               scr_printf (&(MSG_TXT(M_SHELLING)[1]));
               scr_printf (MSG_TXT(M_TYPE_EXIT));
               MDM_DISABLE ();
               change_prompt ();
               b_spawn (NULL);
               /* Re-enable ourselves */
               if (Cominit (port_ptr, buftmo) != 0x1954)
                  {
                  (void) printf ("\r\n%s\r\n", MSG_TXT(M_FOSSIL_GONE));
                  exit (1);
                  }
               scr_printf (MSG_TXT(M_WELCOME_BACK));
               RAISE_DTR ();
               program_baud ();
               break;

            case F_TERM_CHANGEPORT:
               c = port_ptr;
               if (++port_ptr == MAXport)
                  port_ptr = 0;
               MDM_DISABLE ();
               if (Cominit (port_ptr, buftmo) != 0x1954)
                  {
                  port_ptr = c;
                  (void) Cominit(port_ptr, buftmo);
                  }
               program_baud ();
               RAISE_DTR ();
               scr_printf (MSG_TXT(M_BINK_NOW_USING));
               WRITE_ANSI ((char)(port_ptr + '1'));
               scr_printf (":\r\n");
               XON_ENABLE ();
               break;

            case F_TERM_DOBREAK:
               if (old_fossil)
                  {
                  scr_printf (MSG_TXT(M_NO_BREAK));
                  }
               else
                  {
                  scr_printf (MSG_TXT(M_SENDING_BREAK));
                  send_break (100);
                  scr_printf (MSG_TXT(M_DONE));
                  }
               break;

            case F_TERM_VERSION:
               scr_printf (MSG_TXT(M_YOU_ARE_USING));
               scr_printf (ANNOUNCE);
               scr_printf ("\r\n");
               scr_printf (ver_stuff);
               break;

            case F_TERM_MACRO1:
            case F_TERM_MACRO2:
            case F_TERM_MACRO3:
            case F_TERM_MACRO4:
            case F_TERM_MACRO5:
            case F_TERM_MACRO6:
            case F_TERM_MACRO7:
            case F_TERM_MACRO8:
            case F_TERM_MACRO9:
               c = (int)((unsigned) k - (unsigned)F_TERM_MACRO1);
               if (keys[c] != NULL)
                  {
                  SENDCHARS (keys[c], strlen (keys[c]), 0);
                  }
               break;

            default:
               return (1);
            }

   return (0);
}

