/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*                    BinkleyTerm "SendWaZOO" Processor                     */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*  This module is based largely on a similar module in OPUS-CBCS V1.03b.   */
/*  The original work is (C) Copyright 1987, Wynn Wagner III. The original  */
/*  author has graciously allowed us to use his code in this work.          */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#define rb_plus "r+b"

int get_ZedZap (char *, FILE *);
int send_ZedZap (char *, char *, int, int);
int get_ZedZip (char *, FILE *);
int send_ZedZip (char *, char *, int, int);


int WaZOO_callback (char *);
int WaZOO_time (long);

static int fsent;

#define NUM_FLAGS 4


/*--------------------------------------------------------------------------*/
/* SEND WaZOO (send another WaZOO-capable Opus its mail)                    */
/*   returns TRUE (1) for good xfer, FALSE (0) for bad                      */
/*   use instead of n_bundle and n_attach for WaZOO Opera                   */
/*--------------------------------------------------------------------------*/
int send_WaZOO ()
{
   char fname[80];
   char s[80];
   char *HoldName;
   int c;
   int check_again;
   struct stat buf;

   fsent = 0;

   HoldName = HoldAreaNameMunge(&called_addr);
   check_again = 0;

just_make_sure:
   /*--------------------------------------------------------------------*/
   /* Send all waiting ?UT files (mail packets)                          */
   /*--------------------------------------------------------------------*/
   *ext_flags = 'O';
   for (c = 0; c < NUM_FLAGS; c++)
      {
#ifndef JACK_DECKER
      if (caller && (ext_flags[c] == 'H'))
         continue;
#endif

      (void) sprintf (fname,
               "%s%s.%cUT",
               HoldName, Hex_Addr_Str (&called_addr), ext_flags[c]);

      if (!stat (fname, &buf))
         {

         /*--- Build a dummy PKT file name */
         invent_pkt_name (s);

         /*--- Tell ZModem to handle this as a SEND AS then DELETE */
         status_line (MSG_TXT(M_PACKET_MSG));

         if (!Send_Zmodem (fname, s, fsent++, DO_WAZOO))
            {
            net_problems = 1;
            return FALSE;
            }
          CLEAR_IOERR ();
          (void) unlink (fname);
         }
      }                                          /* for */

   /*--------------------------------------------------------------------*/
   /* Send files listed in ?LO files (attached files)                    */
   /*--------------------------------------------------------------------*/
   *ext_flags = 'F';
   if (!do_FLOfile (ext_flags, WaZOO_callback))
      {
      return FALSE;
      }

   if (fsent && !check_again)
      {
      check_again = 1;
      goto just_make_sure;
      }

   /*--------------------------------------------------------------------*/
   /* Send our File requests to other system                             */
   /*--------------------------------------------------------------------*/
   if (requests_ok)
      {
      (void) sprintf (fname, request_template, HoldName, Hex_Addr_Str (&called_addr));
      if (!stat (fname, &buf))
         {
         if (!(((unsigned) remote_capabilities) & WZ_FREQ))
            status_line (MSG_TXT(M_FREQ_DECLINED));
         else
            {
            status_line (MSG_TXT(M_OUT_REQUESTS));
            ++made_request;
            if (Send_Zmodem (fname, NULL, fsent++, DO_WAZOO))
               (void) unlink (fname);
            }
         }
      }

   fsent = respond_to_file_requests (fsent, WaZOO_callback, WaZOO_time);

   if (!fsent)
      status_line (MSG_TXT(M_NOTHING_TO_SEND), Full_Addr_Str (&called_addr));


   (void) Send_Zmodem (NULL, NULL, ((fsent) ? END_BATCH : NOTHING_TO_DO), DO_WAZOO);

   sent_mail = 1;

   return TRUE;

}                                                /* WaZOO */

/*
 * WaZOO_callback () -- send requested file using WaZOO method.
 *
 *
 */
int WaZOO_callback (char *reqs)
{
   return (Send_Zmodem (reqs, NULL, fsent++, DO_WAZOO));
}

int WaZOO_time (long filesize)
{
   int i;
   i = (int) (filesize * 10 / cur_baud.rate_value * 100 / 95);
   return (i);
}

