/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*              Routines for updating the screen within BinkleyTerm         */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*                                                                          */
/*   This module is derived from code developed by Augie Hansen in his      */
/*   book "Proficient C" published by Microsoft Press.  Mr. Hansen was      */
/*   kind enough to give us verbal permission to use his routines, and      */
/*   Bob, Vince and Alan (and all our full screen users) are grateful.      */
/*   If you decide to use this code in some package you are doing, give     */
/*   some thought to going out and buying the book. He deserves that.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

extern BUFFER Sbuf;
extern CELLP Scrnbuf;
extern int cursor_col;
extern int cursor_row;

#ifdef MILQ
static BlankedWnd = NULLHWND;
#endif

void sb_show ()
{
   register unsigned int r;
   unsigned int src_os;
   char far *q;

   if (screen_blank && do_screen_blank)
      {
#ifdef MILQ
      if ( !BlankedWnd ) {
        BlankedWnd = GetFocus();
        }
      WinSetAttr( _HwndDesktop, 0, 0 );
      CloseWindow( MilqueMailerWnd );
      SetFocus( MilqueMailerWnd );
      SetWindowPos( MilqueMailerWnd,
                    NULLHWND,
                    random( GetSystemMetrics(SM_CXSCREEN) - 15 ),
                    random( GetSystemMetrics(SM_CYSCREEN) - 4 ),
                    0, 0,
                    SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW );
      WinDrawAllWindows();
#else
      for (r = 0; r < SB_ROWS; r++)
         {
         q = blanks;
         (void) VioWrtCellStr ((PCH) q, (USHORT) (SB_COLS * 2), (USHORT) r, (USHORT) 0, (HVIO) 0L);
         }
#endif
      sb_dirty ();
      return;
      }

#ifdef MILQ
   if ( IsIconic( MilqueMailerWnd ) ) {
     OpenIcon( MilqueMailerWnd );
     BringWindowToTop( MilqueMailerMnu );
     BringWindowToTop( callwin->hWnd );
     BringWindowToTop( filewin->hWnd );
     BringWindowToTop( historywin->hWnd );
     BringWindowToTop( holdwin->hWnd );
     BringWindowToTop( settingswin->hWnd );
     if ( BlankedWnd ) {
       SetFocus( BlankedWnd );
       BlankedWnd = NULLHWND;
       }
     CallDlgPrc( callwin->hWnd, WM_PAINT, 0, 0L );
     }
#endif
   /* Anything to do? */
   if (!(Sbuf.flags & SB_DELTA))
      {
      return;
      }

   src_os = 0;
   for (r = 0; r < SB_ROWS; r++)
      {
      /* Copy only changed portions of lines */
      if (((unsigned)Sbuf.lcol[r] < SB_COLS) && (Sbuf.rcol[r] > 0))
         {
#ifndef MILQ
         q = (char far *) (Scrnbuf + src_os + Sbuf.lcol[r]);
         (void) VioWrtCellStr ((PCH) q, (USHORT) ((Sbuf.rcol[r] - Sbuf.lcol[r] + 1) * 2), (USHORT) r, (USHORT) Sbuf.lcol[r], (HVIO) 0L);
#endif   
         Sbuf.lcol[r] = SB_COLS;
         Sbuf.rcol[r] = 0;
         }
      src_os += (unsigned) SB_COLS;
      }

   /* the display now matches the buffer -- clear flag bit */
   Sbuf.flags &= ~SB_DELTA;

   /* Put sanity check on cursor_row and cursor_col here */
   if (cursor_row < 0 || cursor_row > (int)(SB_ROWS - 1))
      cursor_row = SB_ROWS - 1;
   if (cursor_col < 0 || cursor_col > (int)(SB_COLS - 1))
      cursor_col = SB_COLS - 1;

#ifndef MILQ
   gotoxy (cursor_col, cursor_row);
#endif
   return;
}

/*
 * Just cleans up the structure to say it is reality - I can use this when
 * I write directly to the screen for single char writes.
 */

void sb_clean ()
{
   int r;

   for (r = 0; r < (int) SB_ROWS; r++)
      {
      Sbuf.lcol[r] = SB_COLS;
      Sbuf.rcol[r] = 0;
      }

   Sbuf.flags &= ~SB_DELTA;
}

/*
 * Make the entire buffer "dirty" so it will be updated.
 */

void sb_dirty ()
{
   int r;

   for (r = 0; r < (int) SB_ROWS; r++)
      {
      Sbuf.lcol[r] = 0;
      Sbuf.rcol[r] = SB_COLS_M_1;
      }

   Sbuf.flags |= SB_DELTA;
}

