; Source for ASKYN.COM
;
; To build: ml askyn.asm
;
; DLX Bulletin Board System V7.0
;
; FREEWARE NOTICE
;
; DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
; Anyone who wishes to may run the program, copy it, or modify it for
; any purpose, including commercial gain.
;

.model tiny

cseg	segment public 'code'
	assume	cs:cseg,ds:cseg,es:cseg
	org	100h
start	proc	far
	jmp	short main	; goto actual beginning
start	endp
;
; data area
;
query	db	'Enter y for yes or n for no: $'
crlf	db	13,10,'$'
buffer	db	10
buflen	db	0
bufdat	db	10 dup(' ')
;
; main program
;
main	proc	near

; ask on stdout
	mov	ah,9		; display string
	lea	dx,query	; the big question
	int	21h		; dos 1 function

; buffered input from stdin
	mov	ah,0ah		; buffered keyboard input
	lea	dx,buffer	; where the input goes
	int	21h		; dos 1 function
	mov	ah,9		; display string
	lea	dx,crlf		; end of line
	int	21h		; dos 1 function
	cmp	buflen,0	; any response?
	je	main		; try again if not

; no?
	cmp	bufdat,'n'	; n/N ignore case
	je	nope
	cmp	bufdat,'N'
	je	nope

; yes?
	cmp	bufdat,'y'	; y/Y ignore case
	je	yup
	cmp	bufdat,'Y'
	jne	main		; try again

; return, setting errorlevel
yup:	mov	al,0		; errorlevel 0 = yes
	jmp	short fini
nope:	mov	al,1		; errorlevel 1 = no
fini:	mov	ah,4ch		; terminate process
	int	21h		; dos 2 function

main	endp
cseg	ends
	end	start		; transfer address
