@ECHO OFF
REM CLEANUP.BAT file is a batch file that uses the parameter passed from The 
REM Total Packer and branches off to the appropriate section.  You can use
REM this file to delete backup's as the following example does, you can have
REM it re-flag the data files as sharable if you are running a network and you
REM can do countless other things with it.  You might also want to distribute
REM a more complex batch file for other sysops to use if you do some nice 
REM things. The format is simple as shown below, if you modify the first 
REM section, make SURE the paramater checking is in upper case as a batch 
REM file check is case sensitive. Also, you may wish to temporarily comment
REM out the @ECHO OFF for debugging purposes.

if "%1" == "USERLIST" goto userclean
if "%1" == "MAIL" goto mailclean
if "%1" == "MSG" goto msgclean
if "%1" == "LANGUAGE" goto langclean
if "%1" == "MENU" goto menuclean
if "%1" == "DESCRIPTION" goto descclean
if "%1" == "XFERCONF" goto xfrclean
if "%1" == "MSGCONF" goto cnfclean

goto end
: userclean
  REM Clean up userlist files
  CD \CELERITY
  DEL USERS.OLD
  goto end
: mailclean
  REM Clean up mail data files
  CD \CELERITY\EMAIL
  DEL *.BK?
  goto end
: msgclean
  REM Clean up message data files
  CD \CELERITY\MSG
  DEL *.BK?
  goto end
: langclean
  REM Clean up language files
  CD \CELERITY\LANGUAGE
  DEL *.BK?
  goto end
: menuclean
  REM Clean up menu files
  CD \CELERITY\MENU
  DEL *.BK?
  goto end
: descclean
  REM Clean up description files
  CD \CELERITY\DATA
  DEL *.BK?
  goto end
: xfrclean
  REM Clean up .XFR files (Only the .BK1 files will be present)
  CD \CELERITY\CONF
  DEL *.BK1
  goto end
: cnfclean
  REM Clean up .CNF files (Only the .BK1 files will be present)
  CD \CELERITY\CONF
  DEL *.BK1
  goto end
: end
