{$R-,S-,I-,D-,F+,V-,B-,N-,L+,O+}

Unit records;


interface



uses dos;


{**************************************************************************}
{                                                                          }
{  USERREC Record                                                          }
{                                                                          }
{  The USERREC record is the format for the USERS file found in the        }
{  Celerity main BBS directory.  It contains the bulk of the information   }
{  about the user's personal details, user configuration, BBS statistics,  }
{  and so forth.  The USERS file is a typed file of USERREC records.       }
{                                                                          }
{  Note: Record #0 of the USERS file should ALWAYS be blank except for the }
{        REALNAME field, which contains the version number of the user     }
{        list in the form "2.00" or "1.42".                                }
{                                                                          }
{**************************************************************************}
type UserRec=record                   {Version 2.00}
     UserID:longint;                  {User identification number}
     Handle:string[30];               {User's handle}
     Realname:string[30];             {User's real first/last name}
     InterNetName:string[15];         {name for internet mail}
     Signature:string[80];            {User's signature}
     Address:array[1..2] of string[30]; {Street Address}
     Macro:array[1..3] of string[30]; {Macros}
		 Note:string[30];                 {User note:  'Sysop of XXX' etc.}
     PrivNote:string[80];             {Sysop note}
		 Password:string[15];             {Password}
		 Phonenum:string[12];             {Phone #.  If blank, user will be prompted}
     DataPhone:string[12];            {Data phone # }
     FaxPhone:string[12];             {Fax phone #}
		 Laston:longint;                  {Last time on in PackTime format}
     NumCalls,                        {Number of calls to system}
		 Udlevel,		       			          {Xfer section access level}
		 Level:integer;                   {Main BBS access level  -5 through 100}
		 HelpLevel:integer;               {Novice / Expert Mode}
		 udpoints:longint;                {Current file points}

     AccessFlags:Longint;             {Access flags #1-32}

     XferConfAccess:longint;          {unused with 2.0}


     AutoChatCall:boolean;            {Call chat upon login}
		 infoforms:array[1..5] of integer;{Location values for Infoforms.  Set to -1}

     InfoScrOffset:array[1..10] of Longint; {unused with 2.0}
     InfoScrSize:Array[1..10] of longint;   {unused with 2.0}

     Color: array[1..8] of byte;  {User's color values.  Setting to 0 will}
		                              {cause system to remap them to the current}
		                              {defaults, as set in setup.}
		 displaylen:byte;        {User's display length.  10-70 lines.}
		 lastmessages,           {Used for determining "how many new posts"}
		 lastups:integer;        {Used to determine the number of new uploads}
     SingleKey:boolean;      {use single key input}
		 defproto:char;          {Default xfer protocol.  Character.}
		 hack:byte;              {Hack attempts since last call.  If >5, ask for phone #}
     AccountCreated:longint; {Date account was created}

     Dummy1:array[1..20] of longint; {unused with 2.0}

     Dummy2:byte;       {unused with 2.0}
     TimeDoor:byte;          {For Byteman's TimeDoor}

     LangSelect,             {Language file preference.  If 0, will ask}
     MenuSelect:byte;        {Menu file preference.  If 0, will ask}

     SpareLongs:array[1..17] of longint;  {unused with 2.0}

		 lastcps,                {Average cps rate for downloading}
		 cpstimes:word;          {Times counted for average}
     CurList:byte;           {Which file list config currently in use?}
		 commpoints,             {Points gained via commission since last call}
		 valpoints:integer;      {Points gained from validation since last call}
		 ScanNet:boolean;        {unused with 2.0}

		 userpcr,                {Individual post/call ratio.  0=use default}
		 userudr,                {Individual upload/download ratio.  0=default}
		 usergenr,               {General ratio}
		 age:byte;               {User's age.  6-89.  If less than 0, user will
          									  be prompted for both age and sex}
     usersex:boolean;        {True=female.  Approved by Deanna Elizalda, Feminist}
		 Expiration,             {Date of account expiration}
		 birthdate:longint;      {date of birth}
		 voteyes,                {Number of votes cast for validation in NUV}
		 voteno:byte;            {Number against user in NUV}
		 timeperday:byte;        {Individual user's time per day.  0=default by lvl}
		 Posts_Month,            {Posts user had at BEGINNING of the month..}
		 Posts_all,              {Total posts user has made}
		 Uploads_Month,          {Uploads user had at the beginning of the month}
		 Uploads_All,            {Total number of uploads}
		 Dnloads_Month,          {Total downloads at beginning of month}
		 Dnloads_all:integer;    {total downloads user has ever made}
		 UpBytes_Month,          {Total bytes uploaded at beginning of month}
		 UpBytes_All,            {Total number of uploaded bytes}
		 DnBytes_Month,          {Bytes downloaded at beginning of month}
		 DnBytes_All:longint;    {Bytes downloaded altogether}
		 PBytes_All,             {Total bytes POSTED by user}
		 PBytes_Month:longint;   {Bytes posted at beginning of this month}
		 KperDay,                {Download k limit per day}
		 KToday:Word;            {K downloaded so far today}
		 NoNet:boolean;          {Deny net access}
		 Exempt:array[1..5] of boolean;
                             {Exemptions: 1-pcr, 2=udr, 3=genr, 4=, 5=xfer}
		 SpecialAccess:boolean;  {unused with 2.0}
     Naplps:boolean;         {Display NAPLPS screens}
     RIP:boolean;            {Use RIP graphics}
     QwkPacker:char;         {code for QWK packer}
     UseYesNo,               {Use YesNo prompts}
     UseFloatPrompt,         {Use floating prompts}
     UseColor:boolean;       {Use color}
     UseSignature:boolean;   {Display signature}
     UseFSE:boolean;         {Use full screen editor}
     PermitPaging:boolean;   {Allow multinode paging & messages}
     SkipTopTen:boolean;     {Do not display top ten}
     SavedTermEmul:byte;     {0=none, 1=vt52, 2=vt52 Atari, 3=vt100, 4=ANSI,
                              5=Avatar level 0}
     SysopFlags:longint;     {sysop flags #1 to 32}

     AreaAccess:longint;     {Unused in 2.0}

     VoteData:array[1..8] of byte;     {vote data - nybbles}
     RemainingTimeCredit:longint;      {Time credit remaining today}
     TermCharacter:longint;  {bitfield:  1=use linefeeds, 2=post prompts,
                                         3=more prompts, 4=8-bit ascii}
     FileList:array[1..3] of longint;  {File listing configuration}
                     {bitfield  1=name, 2=extension,
                                3=size, 4=points, 5=Uploader  6=date u/l
                                7=times d/l, 8=description, 9=skip line}
     TotalTimeOnline:longint;   {Total time user has spent online in minutes}
	  end;


{**************************************************************************}
{                                                                          }
{  BBSREC Record                                                           }
{                                                                          }
{  The BBSREC record is used to hold data for the BBS list feature of      }
{  Celerity.  BBS Lists are held in *.LST files found in the conference    }
{  directory.  The main BBS list is BBSLIST.LST, others may be created     }
{  within the conference structure.  It is a typed file.  If the file is   }
{  deleted, it will be re-created with the official Celerity support       }
{  boards listed.                                                          }
{                                                                          }
{**************************************************************************}
type  BBSrec=record           {*.LST for version 2.0}
			name:string[24];        {Name of BBS}
			Descript:string[60];    {Description of BBS}
			Number:string[20];      {BBS Phone Number}
			DeviceType:byte;        {0=BBS, 1=VMB, 2=NUA}
			software:string[8];     {Software Type}
			megs:word;              {Megabytes of storage}
			maxbaud:string[5];      {Maximum BPS rate in ASCII form}
      lines:byte;             {# of incoming phone lines}

      mnp:boolean;            {Supports MNP error correction}
      ZYX:boolean;            {Proprietary Zyxel format}
      PEP:boolean;            {Telebit protocol}
			HST:boolean;            {Supports USRobotics HST standard}
			V32:boolean;            {Supports ITU-T v.32 standard}
			V42:boolean;            {Supports ITU-T v.42 error correction}
			V42bis:boolean;         {Supports ITU-T v.42bis compression}
			V32bis:boolean;         {Supports ITU-T v.32bis standard}
      V32ter:boolean;         {Supports V.32Ter interrim standard}
      VFC:boolean;            {Supports V.FC interrim standard}
      V34:boolean;            {Supports ITU-T V.34 (v.fast) standard}

      ISDN:boolean;           {ISDN Connection}

      Allow56k,
      Allow64k:boolean;       {ISDN connections}
      Allow128k,
      Allow144k:boolean;      {ISDN Multiplexing}

      Allow1,
      Allow2,
      Allow3,
      Allow4,
      Allow5,
      Allow6,
      Allow7,
      Allow8:boolean;         {Future use}


      Allow28800:boolean;     {Supports a 28,800bps connect rate (V.FC, V.34}
      Allow26600:boolean;     {Supports a 26,600bps connect rate (V.FC)}
      Allow24000:boolean;     {Supports a 24,000bps connect rate (V.FC)}
      Allow21600:boolean;     {Supports a 21,600bps connect rate (Telebit, ASL}
      Allow19200:boolean;     {Supports a 19,200bps connect rate (PEP, v.32ter, v.FC, Zyxel)}
      Allow16800:boolean;     {Supports a 16,800bps connect rate (HST, Zyxel)}
			Allow14400:boolean;     {Supports a 14,400bps connect rate (HST, v.32bis)}
			Allow9600:boolean;      {Supports a 9600bps connect rate (HST, v.32, PEP, DSI)}
			Allow2400:boolean;      {Supports a 2400bps connect rate (v.22)}
			Allow1200:boolean;      {Supports a 1200bps connect rate (Bell 212, Bell 202)}
			leftby:string[30];      {Handle of whoever made this entry}
			when:longint;           {Date entry created in DOS PACKTIME format}
			end;


{**************************************************************************}
{                                                                          }
{  TOPTENREC Record                                                        }
{                                                                          }
{  The TOPTENREC record contains the data for Celerity's Top Ten Users     }
{  feature.  The Top Ten data is held in the TOPTEN.DAT file in the DATA   }
{  directory.  It is a typed file, but has a unique structure.  Record #0  }
{  is unused, and can be used for third party development if desired.      }
{  Records #1 through #10 are used to store the top ten all time posters.  }
{  Records #11 through #20 are used for the top ten monthly posters.       }
{  Records #21 through #30 are for the top kbyte uploaders of all time.    }
{  Records #31 through #40 are for the top monthly kbyte uploaders.        }
{  Records #41 through #50 are for the top kbyte downloaders of all time.  }
{  Records #51 through #60 are for the top monthly kbyte downloaders.      }
{                                                                          }
{  Records above #60 are currently unused by Celerity, but are defined for }
{  third-party utility use and future expansion.  They are:                }
{                                                                          }
{  Records #61 through #70 are for the top downloaded files of all time.   }
{  Records #71 through #80 are for the top downloaded files this month.    }
{  Records #81 through #90 are for the top ten callers of all time.        }
{  Records #91 through #100 are for the top ten callers of the month.      }
{                                                                          }
{  The top ten file works through usage, and will eventually recreate      }
{  itself if it becomes damaged or deleted.  When a user logs onto the     }
{  board, enters the transfer section, or enters the message bases, the    }
{  top ten will be scanned for the user and updated.                       }
{                                                                          }
{**************************************************************************}
type  TopTenRec=record   {TOPTEN.DAT for version 2.0}
			name:string[30];   {Name of user / file}
			kup,kdn:longint;   {Used for kbytes uploaded, kbytes downloaded}
			numup,numdn:word;  {Used for number of uploads/downloads}
			posts:word;        {Used for the number of posts}
			code:byte;         {Used to determine which class it belongs to -}
      end;               {1 is for top posters, 2 is for top monthly
                          posters, and so forth}


{**************************************************************************}
{                                                                          }
{  NEWUSERVOTEREC Record                                                   }
{                                                                          }
{  The NewUserVoteRec contains information about users currently in the    }
{  new user voting process.  It is a typed file, and position in the file  }
{  does not matter.  When a new entry is added, the file is scanned for an }
{  entry with a blank "handle" field.  When an entry is deleted, the handle}
{  field is erased.  The new user data is stored in USERVOTE.DAT in the    }
{  DATA directory.                                                         }
{                                                                          }
{**************************************************************************}
type NuvSet=array[1..100] of longint;  {Used by NewUserVoteRec}
     {This is used to store the UserID of users who have voted for or against
      a new user.. Nuvset[1] may equal 113 for UserID #113, etc.}

type NewUserVoteRec=record   {USERVOTE.DAT for version 2.0}
		 handle:string[30];      {Handle of user being voted on}
		 UserID:Longint;         {UserID of user}
		 voteyes,voteno:nuvset;  {Sets of YES votes and NO votes}
		 Comment:array[1..20] of string[84]; {Comments about the user}
	  end;


{**************************************************************************}
{                                                                          }
{  USERSPECSREC Record                                                     }
{                                                                          }
{  The UserSpecsRec contains template information for the old user editor  }
{  and for the Zap User process.  Basically, it allows the sysop to define }
{  ranges to list/delete users by.  The file USERSPEC is in the DATA dir.  }
{                                                                          }
{  Please note that this section is due for an overhaul, and will probably }
{  be changed considerably in 2.10                                         }
{                                                                          }
{**************************************************************************}
type userspecsrec=record   {USERSPEC for version 2.0}
 		 name:string[30];
		 minlevel,maxlevel,minlaston,maxlaston:integer;
		 minpcr,maxpcr:real
		end;

(*
{**************************************************************************}
{                                                                          }
{  MSGREC Record                                                           }
{                                                                          }
{  The MSGREC record is no longer used externally by Celerity.  It remains }
{  here because it is used for the Full Screen / Line Editors for Celerity }
{  and for the quoting system.  Additionally, it is used for CelerityNet   }
{  for version 1.42.                                                       }
{                                                                          }
{**************************************************************************}
type  MsgRec=record    {only used internally in version 2.0}
      text:array [1..maxmessagesize] of string[80];
      leftto:string[30];
      title:string[80];
      anon:boolean;
      numlines:integer
      end;
*)

{**************************************************************************}
{                                                                          }
{  MSGDATAHEADER Record                                                    }
{                                                                          }
{  The MsgDataHeader is a very important record, but is never used in of   }
{  itself.  For all CelerityText data entries (messages, file descriptions,}
{  menus, language file entries, email, etc), there is an index file and   }
{  a data file.  The index file is always a typed file (see other sections }
{  for details on these record formats), but the data file is dynamic.     }
{  This is where the MsgDataHeader comes in.  At the very beginning of a   }
{  data segment in a CelerityText data file is a special 9-byte header.    }
{  This header is the MsgDataHeader, which contains some important details }
{  about the data that follows.  The IndexOffset refers back to the index  }
{  file and contains the index number of the record which is associated    }
{  with the data segment.  The size tells Celerity how many bytes are in   }
{  the data segment, and CompType refers to the "compression format",      }
{  which is currently unused.                                              }
{                                                                          }
{**************************************************************************}
type	MsgDataHeader = Record
		  IndexOffset	: longint;	{Location of index entry}
		  Size				: longint;	{Size of message}
		  CompType		: byte;			{Compression type - unused in 2.0}
		  end;


{**************************************************************************}
{                                                                          }
{  MSGINDEXREC Record                                                      }
{                                                                          }
{  The MsgIndexRecord is vital to the Celerity v2.00+ messaging system.    }
{  The *.IDX index files in the message bases and MAIL.IDX file are typed  }
{  files based on this record.  It contains all pertinent information      }
{  regarding messages on a Celerity system.                                }
{                                                                          }
{**************************************************************************}
type MsgIndexRec = record     {*.IDX format for Celerity v2.00}
		 Title		:	string[71];	  {Title of the message}
		 Author		:	string[35];   {Handle of message author}
		 AuthorAddr:string[127];	{This is the address of the author}
     AuthorNote: string[30];  {Authors User Note}
		 LeftTo		: string[35];   {Handle of addressee}
		 LeftAddr	:	string[127];	{Address of the recipient}
		 ForwardBy	: string[35]; {Handle of the user who forwarded the message}
		 ForwardAddr:string[127];	{This is the address of the fowarder}
		 When			: longint;		  {When message was written in PACKTIME}

		 TimesRead	: word;				{Message read how many times??}
		 Return		: boolean;		  {Return Receipt requested}
		 Anon			: boolean;		  {Anonymous message}
		 FileName	: string[12];   {Name of attached file}

		 Offset		: longint;		  {position of data in data file}
		 Size			: longint;		  {size of message in bytes}

		 {flags....}
		 Deleted	: boolean;		  {message is deleted}
     Validated: boolean;      {message validatation state}
     Personal : boolean;      {}

		 {Thread Info}
		 Origin,             		  {Original post of thread}
		 Parent,									{Parent of this message}
     PrevSibling,             {Prev reply to the original message. (Sibling)}
		 NextSibling,						  {Next reply to the original message (sibling)}
		 Child			: longint;		{First reply to THIS post.. eldest "child"}

     MsgRefId  : longint;     {Reference to this post}
     FidoToss,
     Toss2,
     Toss3,                   {Flags for third-party utilities}
     ExtTossed : boolean;     {External utility tossed}

     NetStatus : byte;
     AreaName  : string[20];  {internal name of network}
     NetIdent  : string[30];  {Name for network}
     AssortedCrap:array[1..60] of char;
		 end;


{**************************************************************************}
{                                                                          }
{  MSGBASEREC Record                                                       }
{                                                                          }
{  The MsgBaseRec record contains the format for Celerity's message base   }
{  configuration files (*.BSE in the conference directory).  It contains   }
{  all needed information about the actual message base, its configuration,}
{  restrictions, and so forth.                                             }
{                                                                          }
{**************************************************************************}
type MsgBaseRec=record {*.BSE format for Celerity v2.00}
     Name       : string[30];  {Name of sub-board}
     QwkName    : string[15];             {Name used in QWK readers}
     AccessCode : string[15];          {Command to get to sub board}
     AttachedPath,             {Path to attached files}
     DataPath,                 {File name of the Sub Data}
     IndexPath,                {File name of the Sub Index}
     QscanPath  : pathstr;     {File name of quickscan data}
     OriginLine : string[80];  {This sub's origin line}
     BoardMsgLimit:integer;    {Maximum number of messages on sub  }
     CurrentMsgCount:integer;  {every time post made, inc. this}
     NetType    : byte;        {0=local, 1=celnet, 2=fido, 3=mercnet, 4=qwk}
     NetAddress : string[15];  {network address use}
     AreaName   : string[20];  {network address use}
                               {Fido EchoMail Conference Name}
     BaseNews   : string[80];  {path to message base news/intro file}
     RealNames,                {Use real names on sub}
     AllowAnsi,                {Allow ANSI}
     AllowNaplps,              {Allow NAPLPS}
     AllowAnony,               {Allow Anonymous posts}
     AllowFileAttach,          {Allow attached files}
     AllowPrivateMsg,          {Allow receiver-only messages}
     AllowUpload,              {Allow post uploads}
     AllowDnload,              {Allow post downloads}
     RequireValidate,          {Require Post Validation}
     TimeStopped,              {Time doesn't count when in sub}
     option1,
     option2,
     option3,
     option4,
     option5    :boolean;

     CurMsgRefID: longint;     {Last message id on this sub}
     Index      : longint;     {Pointer to the records loc in data file}
                               {This needs to be updated when subs change}
     QwkConfNum : Word; 
     Compression:byte;         {0=uncompressed - default}
     PostSizeLimit:integer;    {0=no limit.  A byte was too small.}
     FileCredit:integer;       {bytes per credit point.      }
                               {If negative, points per post.}
     fidoLocalAttribute,       {Allways Set "ON" for now}
                               {I See no use for this, but left there}
                               {for Compatibility}
     fidoDelSentMsg,           {Del .MSG's after sending? Default: ON}
     fidoDelTossedMsg,         {Del .MSG's after import?  Default: ON}
     fidoSetCrash,             {Set Crash Attribute?      Default: OFF}
     fidoSetPrivate,           {Set Private for ALL Msgs? Default: OFF}
     fidoSetHold,              {Set Hold for pickup Flag? Default: ON}
     FidoAtt7,                 {Reserved}
     FidoAtt8   :  Boolean;    {Reserved} {Fido attributes}
                               {NOTE: Crash & Hold CAN NOT Both be set!}
     NetIdent   :  string[30]; {name of Network (ie: SoundBlaster Net)}
     CTNetNumber:integer;      {Relative Net Number used by CelToScn}
     Space      : String[113]; {Spare work space}
     end;


{**************************************************************************}
{                                                                          }
{  QSCANREC Record                                                         }
{                                                                          }
{  The QscanRec record is used for retaining newscan information about     }
{  Celerity 2.00+ message and file areas.  When a user enters a .BSE or    }
{  .XFR area from a newscan, this associated file is accessed and scanned. }
{  If the user's UserID does not exist in the file, an entry will be made  }
{  for the user and he or she will be asked if he would like to always     }
{  scan this base, be asked every time, or skip the base altogether.       }
{  Additional entries will probably be made to include QWK generation.     }
{  The RefID is used by the message bases to hold the reference number of  }
{  the last message read, and used by the Xfer section to store the date   }
{  the section was last scanned (PACKTIME format).  Updated is another     }
{  field which contains a date in PACKTIME, and will contain the date/time }
{  that this record was last updated.  Eventually a utility will be needed }
{  to weed out records which have not been accessed in 90 days or some     }
{  arbitrary time (users who are no longer active on the board).           }
{                                                                          }
{**************************************************************************}
type QscanRec = Record   {*.QSN / *.QSX format for Celerity v2.00}
     UserId     : longint; {Unique Number User}
     RefId      : longint; {MsgRefId of last message the user read}
     ScanMe     : byte;    {0=Don't scan.  1 = Scan. 2=Ask. 3=?? As yet undefined}
     Updated    : longint; {Last time this record was used.}
     Space1,
     Space2     : longint; {Room to grow.}
     end;


{**************************************************************************}
{                                                                          }
{  CONFERENCEREC Record                                                    }
{                                                                          }
{  One of Celerity v2.00's central features is its high powered conference }
{  system.  Configuration of the conference system is saved via a series   }
{  of conference data files in the conference directory with an extension  }
{  of .CNF.  There are four basic .CNF files defined by Celerity, all      }
{  others are created by sysops as they set up their systems.  The pre-    }
{  defined conferences are MAIN.CNF, XFER.CNF, PRIVATE.CNF, and GFILE.CNF. }
{  A conference item can be one of a number of types, indicated in the     }
{  DataType field.  The currently defined types are as follows:            }
{  #  Ext   Description                                                    }
{  0        Deleted conference item                                        }
{  1 .BSE   Message Base                                                   }
{  2 .XFR   Transfer Section                                               }
{  3 .CNF   Conference Item                                                }
{  4 .DOR   Doors section                                                  }
{  5 .BUL   Bulletin / news section                                        }
{  6 .ART   Art Gallery                                                    }
{  7 .LST   BBS List                                                       }
{  8 .VOT   Voting Booth                                                   }
{                                                                          }
{**************************************************************************}
type ConferenceRec=record     {*.CNF format v2.00}
     Name       :string[60];  {Name of conference item}
     AccessCode :string[10];  {Access name to select conference item}
     ReadAccess :string[80];  {Access string required to access}
		 PostAccess :string[80];  {Access string to post on this sub  }
		 AdminAccess:string[80];  {Access string to modify/sysop sub  }
		 Password   :string[10];  {Password required to enter sub     }
     DataFile   :string[80];  {Data item menu entry points to}
     ConfMenu   :string[80];  {Name of menufile for this item}
     DataType   :byte;        {Type of conference item}
     Index      :word;        {Position in data file of this record}
     end;

{**************************************************************************}
{                                                                          }
{  XFERLISTREC Record                                                      }
{                                                                          }
{  The XferListRec record is used by the XFERLIST.UPL and XFERLIST.DNL     }
{  files residing in the DATA directory.  These files contain logs of      }
{  the last 500 files uploaded and downloaded from the BBS.  The most      }
{  recent upload or download resides at the end of the file, and the oldest}
{  file is on the beginning.  When the file is full (500 entries), the     }
{  oldest 10 entries will be erased and the other entries moved down.      }
{                                                                          }
{**************************************************************************}
type XferListRec=record     {Updated 8/22/93}
		 Username:string[30];   {Name of user who downloaded the file}
     UploadedBy:string[30]; {File uploaded by}
		 Filename:string[30];   {Name of file downloaded}
		 Size:longint;          {Size of file downloaded in bytes}
		 When:longint;          {PACKTIME of when the file was downloaded}
		 cps:word;              {CPS Rate of the transfer}
		 end;


{**************************************************************************}
{                                                                          }
{  FILEREC Record                                                          }
{                                                                          }
{  The FileRec record (UdRec in 1.42 and previously) is the record used for}
{  all file listings in Celerity v2.00+ transfer sections.  All Celerity   }
{  *.DIR files are made up of this record, and have a corresponding .DES   }
{  data file (CelerityText with MsgDataHeader - see above) for description }
{  data.  The DescOffset and DescSize refer to this .DES file.             }
{                                                                          }
{**************************************************************************}
type FileRec=record                 { *.DIR for version 2.00+ 7/14/93}
       sentby:string[30];           { Who uploaded the file}
       when,                        { When was it uploaded - PACKTIME}
       whenrated:longint;           { Show up on newscans since.. PACKTIME}
       filename,                    { DOS filename}
       dlpw:string[15];             { Password to download it}
       path:string[50];             { Full pathname pointing to location}
       points:integer;              { Cost to download}
       filesize:longint;            { Size (in bytes)}
       SystemNote:string[44];       { Contains system messages re:viruses etc}
       DescOffset,                  { Offset of description data}
       DescSize,                    { Size of description}
       ExtDescOffset,               { Offset of extended description}
       ExtDescSize:longint;         { Size of extended description}
       DescLength:byte;             { Length (# of lines) of description}
       DateMoved:longint;           { Date the file was last moved}
       Unused:string[14];           { unused with 2.0}
       downloaded:integer;          { Number of times file downloaded}
       newfile,                     { Unvalidated file}
       FreeFile:boolean;            { File is a free download}
       progname:string[20];         { This is the full/program name of the program}
       ofwhat1,ofwhat2:byte;        { These are for "disk x of y"}
       ptsgiven:integer;            { How many validation points awarded}
       private:string[30];          { Who is a private file for}
     end;


{**************************************************************************}
{                                                                          }
{  AREAREC Record                                                          }
{                                                                          }
{  The AreaRec record format defines the structure of all *.XFR conference }
{  items (transfer areas).  It is a typed file containing a list of all    }
{  file areas in the transfer conference.                                  }
{                                                                          }
{**************************************************************************}
type arearec=record               {*.XFR Transfer Area record for v2.00 }
     name,                        { Name of xfer volume}
     xmodemdir:string[80];        { Pathname to files in section}
     AccessCode:string[50];       { Access string }
     unu1,
     unu2,
     unu3,
     unu4,
     unu5:byte;                   { Currently unused }
     AskAboutDiz,                 { Allow user to override File_id.DIZ }
     ImportDiz,                   { Import file_id.diz/desc.sdi if it exists }
     ScanAllAreas,                { Scan other areas when uploading }
     ScanThisArea,                { Scan this area in upload scan }
     FreeArea,                    { Free download area }
     NoRatio,                     { Ignore ratio }
     slowdrive:boolean;           { If "Slow drive", like a WORM, the system
                                    wont check for existance of file when
                                    listing files.  Additionally, files will
                                    be copied to the temporary directory
                                    before a download is made }
     unused:integer;              { }
     upload,                      { Allow uploads to section}
     download:boolean;            { Allow downloads from section}
     dataname:string[80];         { Path to the .DIR/.DES data files}
   end;


{**************************************************************************}
{                                                                          }
{  DOORRECORD Record                                                       }
{                                                                          }
{  The DoorRecord record is used for maintaining lists of Celerity's online}
{  programs for users, most commonly called Doors.  All files in the       }
{  conference directory with an extension of .DOR are made up of these     }
{  records.  The main doors section refers to MAINDOOR.DOR in the          }
{  conference directory, all others are created by sysops in the conference}
{  setup.                                                                  }
{                                                                          }
{**************************************************************************}
type DoorRecord=record      {*.DOR for Celerity v2.00+ 7/14/93}
		 name:string[30];       {Name of door}
     Access:string[80];     {Access code needed to access the door}
		 numused:word;          {Number of times used}
		 Commandline:string[80];{Commandline to execute the door}
		 doortype:byte;	        {0=Celerity, 1=Door.sys, 2=dorinfo.def, 3=chain.txt}
		 BatchDoor:boolean;     {Door is a batch file in the door directory}
		 end;


{**************************************************************************}
{                                                                          }
{  ONELINERREC Record                                                      }
{                                                                          }
{  The OneLinerRec record is the structure for ONELINER.DAT in the DATA    }
{  directory.                                                              }
{                                                                          }
{**************************************************************************}
type OneLinerRec=record       {ONELINER.DAT for Celerity v2.00+}
		author:string[30];        {Handle of the person who wrote the oneliner}
		origin:string[30];        {Origin line of where the oneliner originated}
		when  :longint;           {When the oneliner was written}
		Line  :string[80];        {The actual oneliner data}
		end;


{**************************************************************************}
{                                                                          }
{  ARTRECORD Record                                                        }
{                                                                          }
{  The ArtRecord record is the structure for all *.ART files - the data    }
{  for Art Galleries which reside in the conference directory.  The main   }
{  art gallery is named GALLERY.ART, all others are sysop-created.  Note   }
{  that the ArtType variable is defined as follows:                        }
{                                                                          }
{  1: ANSI art                                                             }
{  2: NAPLPS art                                                           }
{  3: RIP art                                                              }
{                                                                          }
{**************************************************************************}
type ArtRecord=record     {*.ART definition for 2.00+  7/14/93}
    author:string[30];    {Who uploaded the art}
    origin:string[30];    {Origin of the art}
    when:longint;         {When uploaded - PACKTIME}
    filename:string[12];  {Name of ART file - file resides in the ART dir}
    TimesViewed:Byte;     {Times the art has been viewed}
    ArtType:byte;         {Type of art (see above)}
    Unused:byte;          {unused}
    Descript:string[80];  {Description of art}
    end;


{**************************************************************************}
{                                                                          }
{  NEWSRECORD Record                                                       }
{                                                                          }
{  The NewsRecord record is used to make up the *.BUL bulletin/news files  }
{  in Celerity, which reside in the CONFERENCE directory.  NEWS.BUL is     }
{  the default news file which is accessible from the main menu and will   }
{  be scanned for new entries when a user logs on.  All other .BUL files   }
{  will act as "bulletin sections" and will not be automatically scanned   }
{  when a user logs on.                                                    }
{                                                                          }
{**************************************************************************}
type NewsRecord=record    {*.BUL definition for 2.00+  7/14/93}
     author:string[30];   {Who wrote the news}
     origin:string[30];   {Origin of the news}
     when:longint;        {When was the news written}
     filename:string[12]; {Filename of news on the disk}
     Unused:array[1..3] of byte;
     Descript:string[80]; {Description of the news/bulletin}
     Access:string[80];   {Access string required to read news/bulletin}
     AlwaysShow:boolean;  {Always Show news/bulletin when scanned}
     end;


{**************************************************************************}
{                                                                          }
{  LOGREC Record                                                           }
{                                                                          }
{  The LogRec record contains the format for the system logs, which reside }
{  in the DATA directory and are named SYSLOG.x (x being the node number   }
{  of the log).  The log entries are referenced with a two-dimensional     }
{  numbering system - Menu and Subcommand.  These values are listed below. }
{                                                                          }
{**************************************************************************}
type logrec=record                 {SYSLOG.x format for 2.00+}
       menu,subcommand:integer;    {Identifier - see below}
       param:string[41];           {Parameter passed}
       when:longint                {PACKTIME format of entry time}
     end;
{      Menu / Subcommand information.  Not all entries are used.  } {
Menu 0:
        0  Incoming call at [Param] bps
        1  User: [Param] Logged on
        2  Invalid password for [Param]
        3  Caller Disconnected
        4  System error: [Param]
        5  Attempted to extract invalid file [Param]
        6  User [Param] in login shell
        7  Calling from area code [Param]
        8  Celerity corrupted.  HALT.
        9  BETA Test Time left: [Param]
        10  Security violation extraction: [Param]
        11  [Param]
Menu 1:
        1  Password changed
        2  Tried to chat
        3  Requested chat: [Param]
        4  ** TRANSFERED TO USER [Param] **
        5  Wrong password transfering to [Param]
        6  Changed handle to [Param]
Menu 2:
        2  Deleted the error log
        3  Edited user [Param]
        4  Changed the system time/date
        5  Created a new guided tour
        6  Viewed the system log
        7  Deleted the System Log
        8  Created user [Param]
Menu 3:
        5  Configured Global Newscan
        6  Configured file listings
        7  Changed Colors
        8  Configured newscans
        9  Changed terminal emulation
        10  Entered Gfile Xfer Section
Menu 4:
        1  Created/uploaded news or bulletin [Param]
        2  Listed bulletins in [Param]
        3  Deleted news/bulletin [Param]
        4  Viewed news/bulletin [Param]
Menu 6:
        1  Added Oneliner [Param]
        2  Deleted Oneliner [Param]
        3  Listed Oneliners
        4  Purged Onliners
Menu 7:
        1  Added BBS [Param]
        2  Added VMB [Param]
        3  Added NUA [Param]
        4  Listed BBS''
        5  Listed VMB''s
        6  Listed NUA''s
        7  Deleted entry [Param]
Menu 8:
        1  Entered chat with [Param]
        2  Exited chat
Menu 9:
        1  Opened door [Param]
        2  Changed door [Param]
        3  Deleted door [Param]
        4  Created door [Param]
Menu 10:
        1  Voted on ballot [Param]
        2  Edited ballot [Param]
        3  Deleted ballot [Param]
        4  Created ballot [Param]
        5  Added option to [Param]
Menu 11:
        1  Listed Art files
        2  Deleted art: [Param]
        3  Uploaded art: [Param]
Menu 12:
        1  Read email from [Param]
        2  Sent email to [Param]
        3  Replied to mail from [Param]
        4  Forwarded email to [Param]
        5  Bulk mail to user #[Param]
        6  Sent feedback to [Param]
        7  U/L file mail: [Param]
        8  D/L file mail: [Param]
        9  Packed mail file: [Param]
Menu 15:
        1  Downloaded [Param]
        2  Uploaded [Param]
        3  Entered sysop options for [Param]
        4  Download Efficiency: [Param]
        5  Batch Downloaded [Param]
        6  Xfer Aborted: [Param]
        7  Xfer Aborted just before EOF: [Param]
        8  Master list for Conference [Param]
        9  Extracted a file from: [Param]
        11  Deleted own upload of [Param]
        12  Changed description of [Param]
        13  Edited own upload of [Param]
        14  DSZ String [Param]
Menu 16
        1  Searched for unvalidated files
        2  Killed area
        3  Modified area attributes for [Param]
        4  Modified file attributes for [Param]
        5  Moved file [Param]
        6  Sorted area
        7  Deleted file [Param]
        8  Added resident file [Param]
        9  Re-ordered areas
        10  Disk directory [Param]
        11  Batch moved file [Param]
        12  Created new area: [Param]
        13  Set upload directory to [Param]
        14  Attempted Security Breach.  File: [Param]
        15  Downloaded offline file: [Param]
        16  Bad offline download: [Param]
Menu 18:
        1  Set wanted flag to [Param]
        6  Changed user''s name to [Param]
        7  File transfer points: [Param]
        8  Changed user''s password
        9  Deleted user
        10  Granted sysop status: [Param]
        11  Denied sysop status: [Param]
        12  Time left for today: [Param]
        13  Viewed user''s status
        14  File transfer level: [Param]
        15  Set user''s access level: [Param]
        16  Changed phone number: [Param]
        17  Part-sysop security violation
Menu 19:
        1  Created QWK Offline packet
        2  Uploaded REP Offline packet
        3  Posted via QWK: [Param]
Menu 20:
        1  Entered Multinode Chat
        2  Exited Multinode Chat
        3  Paged node #[Param]
Menu 22:
        1  Voted yes on [Param]
        2  Voted no on [Param]
        3  NUV: Auto-Validated [Param]
        4  NUV: Auto-Deleted [Param]
        5  Removed [Param] from voting
        6  Vetoed vote on [Param]
        7  Abstained on [Param]
Menu 23:
        0  ULP: Good Upload: [Param]
        1  ULP: Upload Altered: [Param]
        2  ULP: New Description: [Param]
        3..5  ULP: <reserved> [Param]
        6  ULP: Validity failed, [Param] deleted.
        7  ULP: Validity failed, [Param] waiting.
        8  UPL: Virus found, [Param] deleted.
        9  UPL: Virus found, [Param] waiting.
        10  UPL: Virus found in [Param], removed.
Menu 24:
        0  Upload Validity failed, [Param] deleted.
        1  Upload found virus, [Param] deleted.
        2  ULP: New Description: [Param]
        3..5  ULP: <reserved> [Param]
        6  ULP: Validity failed, [Param] deleted.
        7  ULP: Validity failed, [Param] waiting.
        8  UPL: Virus found, [Param] deleted.
        9  UPL: Virus found, [Param] waiting.
        10  UPL: Virus found in [Param], removed.
}


{**************************************************************************}
{                                                                          }
{  PROTOREC Record                                                         }
{                                                                          }
{  The ProtoRec record is the structure for PROTOCOL.DAT in the DATA       }
{  directory.  It contains information about transfer protocols available  }
{  on a Celerity BBS.  There are five classes of protocols (a class of 0   }
{  is ignored).                                                            }
{                                                                          }
{  1:  Batch Uploads                                                       }
{  2:  Batch Downloads                                                     }
{  3:  Single File Upload                                                  }
{  4:  Single File Download                                                }
{  5:  Bidirectional Transfer                                              }
{                                                                          }
{**************************************************************************}
type Protorec=record                   { PROTOCOL.DAT for Version 2.00+}
		 letter:char;                      { Letter to select }
		 desc:string[30];                  { Description }
		 progname:string[12];              { Name of protocol .exe / .com }
		 Param:string[60];                 { Command-line parameters }
     Class:byte;   {0=none  1=batch up, 2=batch down, 3=up, 4=down, 5=bi}
  	 end;


{**************************************************************************}
{                                                                          }
{  SYSTEMHISTORYREC Record                                                 }
{                                                                          }
{  SystemHistoryRec defines the structure for the HISTORY.DAT file which   }
{  resides in the DATA directory.  This maintains the system history for   }
{  a number of days (including the current one) and keeps track of the     }
{  number of calls, posts, feedback, email, new user applications, uploads,}
{  downloads, etc.                                                         }
{                                                                          }
{**************************************************************************}
type SystemHistoryRec=record   {HISTORY.DAT structure for v2.00+}
		 calls,                    {# of calls made this day}
     posts,                    {# of posts}
     feedback,                 {# of feedback sent}
     email,                    {# of mail sent}
     newusers,                 {How many new users applied}
     uploads,                  {How many uploads received}
     downloads,                {How many downloads made}
     daynumber:integer;        {Days the system has been up}
		 netmaid:boolean;          {unused with 2.0}
		 date:string[15];          {Date in ASCII format}
		 temp1,temp2,temp3,temp4,temp5:integer;  {unused}
		 end;


{**************************************************************************}
{                                                                          }
{  NODEIDREC Record                                                        }
{                                                                          }
{  The NodeIDRec is important for multi-node systems, and is virtually     }
{  unused for single line systems.  It passes information between nodes    }
{  via the NODELIST.NOD file in the MULTINODE directory.  There are a      }
{  number of different activity codes, which are as follows:               }
{                                                                          }
{  0: Unknown                                                              }
{  1: Node Down                                                            }
{  2: Node Waiting For Call                                                }
{  3: User Logging In                                                      }
{  4: User At Main Menu                                                    }
{  5: User In Sub-Boards                                                   }
{  6: User In Transfer Section                                             }
{  7: User Transfering Files                                               }
{  8: User In MultiNode Chat                                               }
{  9: User Chatting With Sysop                                             }
{ 10: New User Applying                                                    }
{ 11: User In QWK Processor                                                }
{ 12: User In A Door                                                       }
{ 13: User Entering System                                                 }
{ 14: User In Direct (Multinode) Chat                                      }
{ 15: User Linking Another System                                          }
{ 16: Network Call                                                         }
{                                                                          }
{**************************************************************************}
type NodeIDRec=record          {NODELIST.NOD for v2.00}
		 Username:string[15];      {Name of user}
     NodeDescript:string[15];  {Description of the node}
		 ChatAvail:boolean;        {Available for paging}
		 ChatRequest:byte;         {Node being paged}
		 Activity:byte;            {Node Activity (see above)}
     DirectPipe:byte;          {Chat room user is in}
		 Update:longint;           {Last date/time node updated NODELIST.NOD}
		 end;


{**************************************************************************}
{                                                                          }
{  CALLERLOGREC Record                                                     }
{                                                                          }
{  The CallerLogRec record defines CALLER.LOG in the DATA directory.  This }
{  file contains records for the previous 250 callers to the system with   }
{  the most recent caller at the beginning of the file.                    }
{                                                                          }
{**************************************************************************}
type CallerLogRec=record    { CALLER.LOG format for v2.00+}
     UserName:string[30];   { name of user }
     Location:string[30];   { currently unused }
     CallNumber:longint;    { Call number }
     TimeofCall:longint;    { time/date of call in PackTime }
     Speed:LongInt;         { Connect speed   0=local }
     ConnectMode:byte;      { unused}
     NodeNumber:Byte;       { Node # logged onto }
     end;


{**************************************************************************}
{                                                                          }
{  SYSTEMCALLSREC Record                                                   }
{                                                                          }
{  This record defines the format of STATUS.DAT in the MAIN BBS Directory. }
{  This file is a typed file, with record #0 containing data for the BBS   }
{  as a whole, and successive records being specific to particular nodes   }
{  (ie: record #1 is for node #1, record #5 for node #5, etc.).            }
{                                                                          }
{**************************************************************************}
type SystemCallsRec=record
     TotalCalls:longint;    { total number of system calls / this node }
     CallsToday,            { calls received today }
     CallsYesterday:word;   { Calls taken yesterday }
     CallsLocal,            { total local calls }
     Calls300,              { total 300bps calls }
     Calls1200,
     Calls2400,
     Calls4800,
     Calls7200,
     Calls9600,
     Calls12000,
     Calls14400,
     Calls16800,
     Calls19200,
     Calls21600,
     Calls24000,
     Calls26400,
     Calls28800,
     Calls38400,
     Calls57600,
     Calls115k:longint;       { total direct-connect 115,200 calls }
     CallsFiler,              { unused }
     CallsNetwork:longint;    { CElerityNet calls }
     CallsLink:longint;       { Link (second/third system) calls }
     DateFirstOnline:longint; { Packtime that this node first came online }
     TotalDaysUp:word;        { number of days node has been up }
     TotalNewUsers:word;      { new users applied on this node }
     TotalUps,                { total uploads on node }
     TotalDns,                { total downloads on node }
     TotalUpK,                { uploaded k   }
     TotalDnK:longint;        { downloaded k }
     TodaysDateTime:longint;  { packtime of last day written to this file }
     MinutesIdle,
     MinutesUsed,
     MinutesXfer:longint;
     TotalSystemIDs:longint;
     SysopAvailable:char;     {Sysop is available}
     ScreenOutput:boolean;    {Screen output is on}
     TotalMessages:word;
     end;

{**************************************************************************}
{                                                                          }
{  NODECOMMANDREC Record                                                   }
{                                                                          }
{  This record will be used for sysops to pass commands to other BBS nodes.}
{  It will contain information to toggle different options on the node or  }
{  to perform actions.  If an entry is blank, it is ignored.  The file     }
{  this record is used for is NODECMD.<node number> in the SHARED dir.     }
{                                                                          }
{**************************************************************************}
type NodeCommandRec=record
     Snoop:boolean;
     Print:boolean;
     Trap:boolean;
     HangUp:boolean;
     TempSysop:boolean;
     TimeAdjust:integer;
     PointsAdjust:integer;
     end;



{**************************************************************************}
{                                                                          }
{  TEXTINDEXREC Record                                                     }
{                                                                          }
{  This record will is used by CelerityText files to point to the actual   }
{  location in the .LNG/.DSP file of a particular entry.  It contains both }
{  the offset (location) and size (length) of the entry.                   }
{                                                                          }
{**************************************************************************}
type TextIndexRec=record    { Record to point to text location }
     Size,                  { Size / length of entry }
     Offset:Longint;        { Offset / location of entry in data file }
     end;


{**************************************************************************}
{                                                                          }
{  LANGREC Record                                                          }
{                                                                          }
{  This record defines the format of the LANGFILE.DAT file which resides in}
{  the LANGUAGE directory.  It is used to define the language files which  }
{  are available on a BBS.                                                 }
{                                                                          }
{**************************************************************************}
type LangRec=record
     Intro    : string[80]; { Description of CelerityText file shown to user }
     LangPath : string[80]; { Path to Language File for this entry }
     MenuPath : string[80]; { Path to Menu file for this entry }
     Archives : array[1..5] of string[80];  { Unused with 2.0 }
     ArchDesc : array[1..5] of string[60];  { Unused with 2.0 }
     AccessCode : string[80]; { Access code required to use this CelerityText object }
     DisplayLines,          { Recommended display lines for object }
     DisplayCols: Byte;     { Recommended display columns for object }
     Ascii7,                { Does it support 7-bit ASCII? }
     Ascii8,                { Does it support 8-bit ASCII? }
     ANSI,                  { Does it require ANSI? }
     Avatar,                { Does it require Avatar? }
     Vt52,                  { Does it require VT52? }
     Vt52Atari,             { Does it require VT52 Atari? }
     Vt100,                 { Does it require VT100? }
     Iemsi,                 { Is it an IEMSI interactive session? }
     Naplps,                { Does it require NAPLPS? }
     Rip:boolean;           { Does it require RIP? }
     dummy1,                { Unused with 2.0 }
     dummy2,
     dummy3,
     dummy4,
     dummy5:boolean;
     end;


{**************************************************************************}
{                                                                          }
{  UPLOADSPOOLREC Record                                                   }
{                                                                          }
{  This record defines the format of the SPOOL.UP file residing in the     }
{  COMMON directory.  It is used to spool uploads to an offline upload     }
{  processor.            .                                                 }
{                                                                          }
{**************************************************************************}
type UploadSpoolRec=record
     Ud:FileRec;            {File record of the file being processed}
     DestDir:string;        {Directory the file will be moved to}
     DestArea:string;       {Path to Celerity .DIR / .DES files}
     UploaderId:longint;    {UserID of the user who uploaded the file}
     end;


{**************************************************************************}
{                                                                          }
{  BALLOTREC Record                                                        }
{                                                                          }
{  This record defines the format of the *.VOT files residing in the DATA  }
{  directory.  It is used for taking polls of the users.  Actual vote data }
{  is currently stored in the user record with individual users.  This will}
{  be changed in version 2.10.                                             }
{                                                                          }
{**************************************************************************}
type BallotRec=record
     Title:string[80];            {Title of voting topic}
     ReqBal:byte;                 {Required ballot voted on}
     ReqChoice:byte;              {Required previous ballot choice}
     AllowAdd:boolean;            {Allow user additions}
     VotesCast:word;              {Total votes cast}
     Choices:array[1..15] of string[30]; {Voting choices on ballot}
     end;


{****************************************************************************}
{ NetConfig record -   FileName: CELTOSCN.CFG                                }
{                      Location: Celerity's Network Directory Preferred, but }
{                                Not Required (To be blunt, they *Could* put }
{                                It anywhere, the path is passed via cmdline }
{****************************************************************************}
type NetConfig=record          { ***** Pascal Data Format ***** }
  NetNumber,                   { Relative Network Number }
                               { Fido Type Address: ZONE:NETWORK/NODE.POINT }
  AddrZone,                    { Zone That this Network uses }
  AddrNet,                     { Network Portion of Address }
  AddrNode,                    { Node Portion of Address }
  AddrPoint:integer;           { Point Portion of Address (Or Zero) }
  AllowNetMail,                { Will we process NetMail in this Net? }
  UseExtNL:boolean;            { Create an Extended NL for this Net? }
  NetName:string[40];          { Descriptive Name of Network }
  CelCfgPath:string[120];      { Fully Qualified Path to CONFIG.DAT }
  FDIMMainDir:string[120];     { Full Path to FD or IM Main Dir }
  NLPath:string[120];          { Fully Qualified Path To REAL Nodelist }
  NLName:string[12];           { NodeList FileName (*.??? = Newest ###) }
  NMailTossDir:string[120];    { Full Path To Toss NetMail To/From }
  Space:array[1..474] of char; { Room To Expand }
end;


{ ************************************************************************** }
{ NLIdx record -       FileName: CELNLIDX.### - ### = Relative Net Number    }
{                      Location: Celerity's Network Directory Preferred, but }
{                                Not Required (WILL be in same directory as  }
{                                NetConfig Record)                           }
{ ************************************************************************** }
type NLIdx=record              { ***** Universal Data Format ***** }
  Zone,                        { Beggining of Zone/Network         }
  Net:integer;                 { Combonation                       }
  NLOffset:longint;            { Physical Offset in CT NLData      }
end;


{ ************************************************************************** }
{ NLData record -      FileName: CELNL.### - ### = Relative Net Number       }
{                      Location: Celerity's Network Directory Preferred, but }
{                                Not Required (WILL be in same directory as  }
{                                NetConfig Record)                           }
{                     This Record serves 2 purposes:                         }
{                     -To Validate a Net address                             }
{                     -Record offset to extended Node List                   }
{ ************************************************************************** }
type NLData=record             { ***** Universal Data Format ***** }
  Zone,                        { ZONE:NET/NODE Fido   }
  Net,                         { Style Address        }
  Node:integer;                {                      }
  ExtRecNo:word;               { Extended NL Rec Num  }
end;


{ ************************************************************************** }
{ NLExtended record -  FileName: CELNLEXT.### - ### = Relative Net Number    }
{                      Location: Celerity's Network Directory Preferred, but }
{                                Not Required (WILL be in same directory as  }
{                                NetConfig Record)                           }
{ ************************************************************************** }
type NLExtended=record         { ***** Pascal Data Format ***** }
  Status:integer;              { Status: 0=Node, 1=ZC, 2=RC, 3=NC, 4=Hub,  }
                               {         5=Pvt, 6=Hold, 7=Down             }
  Name:string[25];             { The "Name" of this Node                   }
  Location:string[15];         { Location (City and state)                 }
  SysOp:string[15];            { System Operators name                     }
  Phone:string[16];            { Telephone Number or -Unpublished-         }
  BaudRate:longint;            { Max Baud Rate of This Node                }
  Flags:string[20];            { Node Flags (ie. HST, V32, XA, XX, MO, CM) }
end;



(*    This is the record contained in the SETUP.DAT file    *)
{**************************************************************************}
{                                                                          }
{  SETUPTYPE Record                                                        }
{                                                                          }
{  The SetupType record is a very large record which is used to maintain   }
{  the configuration for Celerity BBS.  It is created, edited, and written }
{  by the CELSETUP.EXE program, and is read by CELERITY.EXE.  The data     }
{  defined by this record gets written to SETUP.DAT, a seperate copy in    }
{  each NODE directory.                                                    }
{                                                                          }
{**************************************************************************}
type setuptype=record
    {tracking info}
    Version: word;         {version code: format = 138}

    CheckSum: longint;
    filter:byte;
    SerialNum: string[5];

		{System Info}
		sysop_name,             {sysop's handle * UNUSED AS OF 1.40 * }
                           {Used again in 2.0}
    longname,              {full BBS name}
    shortname: string[80]; {short BBS name}
    acronym: string[3];    {3-letter acronym}
    bbscity,               {city of BBS}
    BbsState,              {state / province / country}
    telenumber,            {Phone #}
    sys2name,              {Name for System 2}
    sys3name: string[30];  {Name for System 3}

		{System Options}

		{ systemtoggles : Word; Checkbox}
			allowdoors,         {Allow Doors on the system}
			allowfat,           {Allow FAT file move}
			StrictPhone,        {Strict Phone Checking}
			SyslogProtect,      {Protect System Log (no remote delete)}
			ExternalChatCall,           {Use Voice Synthesis chat}
      HangUpOnExit:boolean;  {hang up user on BBS exit}
			autologin: boolean; {Sysop Auto-Login on F10}


		SupportedRates : Word; {Supported BPS rates}

		systemtype : Word;  {System Type}
		{ Celerity  = 0
			CAE       = 1
			CAE/TAC   = 2
			Alacrity  = 3}
		systemspeed : Word;  {CPU Type}
		{ Pentium=0
      80486 =1
			80386 =2
			80286 =3
			 8086 =4}


		bbsnode : integer;    {Node # of BBS}
		mintimeout : integer; {Minutes of activity until timeout}

		{==Look and Feel==}
		UserTopTenDisable,    {Allow users to disable top ten}
		UseTopTen,            {Use the Top Ten lists}
		UseRumor,             {Use OneLiners}
		KeyFlash,             {Use Key Flash Monitor}
		FreeDownloads: boolean;{Make all downloads free}

		WaitText: string[80]; {"Please Wait" string}

    LocalCodes:string[80];            {Local area codes in format: 213;714;909}

		AnonymousStr: string[30]; {Anonymous user name}
    DotChar: string[1];       {"hidden" input character}
		DefHelpLevel: integer;    {Default help level for new users}

		{Serial Port }
		uart16550: boolean; {Enable FIFO buffering}
		PortDelay,          {unused with 2.0}
    ComPortSelect,      {Radio Button com port select...}
		UseCom,							{Com Port}
		ComInt,							{Com Interrupt}
		IRQ,                {COM IRQ}
		InBuffer,           {Input Buffer}
		OutBuffer: Integer; {Output buffer}
		BaseAddr: string[10]; {Base address of port}
    LockedDTERate: word;  {Locked DTE rate of port}

		{Modem Setup}
		LockDTERate,                {Lock the DTE rate}
		OffHookSysop: boolean;			{pick up line when sysop goes local}
		ModemSetupStr,							{Setup string for modem}
		ModemHangupStr,				 			{Hangup string for modem}
		ModemDialPrefix,						{Dial prefix for modem}
		ModemDialSuffix :String[80];{Dial suffix for modem}
		{modemlist : TListboxRec;  Listbox}
		ModemType,					        {Type of modem}
		NumRings,										{Answer on Ring Number}
		ConnectDelay : integer;   	{Delay Before connecting}

		{Video Options}
		Monochrome,          		{Monochrome system}
		UseEGA,									{25 or 43/50 line}
		CelerityAnsi,						{Use internal ansi filter}
		ScreenSaver: boolean;		{Use the WFC screen saver}

		{Xfer Options}
		UploadFactor,           {Grant how many times the pointval for upload}
		PointVal,               {How many k needed per file point}
		Maxloan,                {Maximum loan which can be granted}
		Commission,             {Commission rate given to users}
		ULpercent: Integer;     {Time compensation for uploading}

    DownLoadRates: word;    {bit map of what baud rates allow dl.}

		UserDLcost,							{can users decide dl cost?}
		UseFPS,                 {Use the file point system?}
		AutoValidate,						{Should new files be autovalidated}
		Process,								{Should comment.bat run to process zips?}
		UseBackupDir,						{Should there be backup dirs in xfer?}
		AllowRequest,						{Allow user requests for Offline files?}
		Files_Password,  				{Can users attach file passwords to u/ls?}

		PickyDesc,							{Use picky file descriptions?}
		Files_Progname,				{Use program name in file listing? Gone in 2.0}
		Files_OfWhat,					{Use disk numbers in files listing? Gone in 2.0}
		Files_Descript: boolean;{Use file descriptions??}

    {Conferences}
    UseConf: boolean;		{unused with 2.0}
    ConfNames: array[1..5] of string[30];  {unused with 2.0}
    XferConfNames: array[1..5] of string[30]; {unused with 2.0}


		{Passwords}
		sysoppass, 											{Sysop Password}
		pagepass: String[10]; 					{Emergency Chat Password}
		systempassword, 								{Login p/w for system1}
		system2password,								{Login p/w for system2}
		system3password,								{Login p/w for system3}
		newuserpass, 										{Application p/w for new users}
		lockoutpass : String[30]; 			{Restricted Baud Lockout p/w}

		{Chat Options}
		AvailStr,                 {String saying "sysop available"}
		NotAvailStr,              {String saying "sysop not available"}
		Appear,                   {String saying "sysop is here"}
		DisAppear: String[80];    {String saying "sysop is gone"}
		ObnoxChat: boolean;				{Use the Obnoxious Chat??}

  	{Login Shell}
    LoginString: String[80];	{Text to be displayed if not Connent at xxx}
    UseTermDetect: boolean;		{Use Ansi/Avatar/VT100 terminal detection}
    ShellType:word;						{1=No Shell, 2= Menu, 4=Dos Emulator,}
    													{8=Unix Emulator, 16=Lightbar, 32=External}


		{Pathnames}
		Main_Dir,				{path to main bbs files}
		Temp_Dir,				{path to temp xfer area}
		Node_Dir,				{path to node specific files}
		Multi_Dir,		  {common internode directory}
		Conf_Dir,				{path to conference files}
		Data_Dir,				{path to mail data, xfer section files, etc}
    Display_Dir,    {path to display text files}
		CelNet_Dir,			{path for celeritynet files}
		Door_Dir,				{path for Door batch files}
		Audio_Dir,			{path for SoundBlaster files}
		NUU_Dir: String[127];		{path for new user uploads }

    Virus_Path,                {path to virus scanner}
    Virus_Command:string[80];  {commandline for virus scanner}

    {Network Options}
		{netToggles : Word; Checkbox}
    UseNet,						{Use Celerity Net}
    NetHost,					{Is the system the Celerity Net HOST?}
    NetHub:boolean;		{Is the system the Celerity Net HUB?}

		netnode : String[6]; 	{Network Node Code}
		netpass : String[80]; 	{Network Password}
		hubnum : longint; 			{Hub ID code}
		netbegin : String[8]; 	{*** Change to packtime? Net call start time}
		netend : String[8]; 		{*** Change to packtime? Net call end time}
		hostphone : String[30]; {Network HOST/HUB phone number}
		extender : String[80];  {Dialing Extender, Calling card, etc..}
		originline : String[80];{Network origin line}

		{netfeatures : Word; Checkbox}
		FeatureA,
		FeatureB,
		FeatureC,
		FeatureD,
		FeatureE,
		FeatureF,
		FeatureG,
		FeatureH,
		FeatureI,
    FeatureJ: boolean;  {network features for CelerityNet}


		{Timed Events}
		{*** These types may (will) change.  Perhaps packtime...}
    {*** They used to be strings.  }
		TimeRestStart, 						{Time for restricted hours to begin}
		TimeRestEnd, 							{Time for restricted hours to end}
		AvailTime, 								{What time is the sysop available for chat}
		UnavailTime, 							{What time will the sysop not be available}
		EventTime,           			{time to run even batch file}
		EventBatch,              	{name of event batch file to run}
		BackTime: String[8]; 			{time to run backup.bat}

    {Login Commands}
    ShellCom: array[1..9] of string[10]; {Various Shell Commands}

    {Infoforms}
    Infoname:array[1..5] of String[30]; {Names of infoforms 1-5}
    ForceForm:Array[1..5] of boolean;		{Force user to fillin form x?}
    InfoLvl:array[1..5] of integer;			{Min user level to access form}
    InfoMax:array[1..5] of Integer;			{Max user level to access form}

    {New User Options}
    private,							{Refuse all new users?}
    HangNewUsers,					{Hang up after a new user applies?}
    RequireUpload,				{Require new user ul a program with application?}
		CopyNewUserUpload,    {Save actual new user upload?}
		RequireFeedback,      {Make new users leave feedback??}
		UseAddress: Boolean;  {Will prompt user for address.}

    NewUserLvl,						{Level for new users}
    DefUDLevel,						{File Xfer level for new users}
    DefUDPoint:integer;		{File Xfer points for new users}

    NewUserNote: string[30]; {User note for new users.}

    {New User Voting}
    NewUserVoting,				{Enable new user voting system}
    AutoNUV: boolean;			{Auto Validate/Delete new user base on vote?}

    YesVote,							{Number of Yes vote to validate}
    NoVote,								{Number of NO votes to delete user}
    NuvLvl,								{Level required to access NUV system.}
    Forcevote: integer;		{Users above this level will be forced to do NUV}


    {Local Users}
    LocalLockout: boolean;{Use the Local user lockout?}
    LocalPercent: Integer;{What percent of local uses will be allowed?}
    LocalMSG: string[80]; {LUL rejection message.}

    {QuickValidate}
    QvalLvl,							{Level to assign quick validated user}
    QvalXfer,							{Xfer Level to assign quick validated user}
    QvalXP: integer;			{Xfer Points to assign quick validated user}

    QvalNote: string[30];	{User Note to assign quick validated user}

		QvalMsgCon,
		QvalXferCon,
		BasicMsgCon,
		BasicXferCon: array[1..5] of boolean; {unused with 2.0}


    {Access Levels}
    LogonLvl: integer;        {Level required to enter BBS}

    UserTime: array[1..10] of integer; {User time/day/level}

    SysopLevel,						{Level required for cosysop activities}
    AnonymousLevel,				{Level to post anonymous}
    PostLevel,						{Level to post a bulletin}
    AutoMsgLvl,						{Level to leave automessage}
    TimeRestLvl,					{Level required to log on during restrict hours}
    ReadAnonLvl,					{Level need to see name of anon poster}
    ListUserLvl,					{Level to get a userlist}
    ListLastLvl,					{Level to see list of recent callers}
    ListXferLvl,					{Level to see list of xfer activity}
    SyStatLvl,						{Level to see system status}
    SysHistLvl,						{Level to see system history}
    TopTenExempt,					{Level for exclusion from Top Ten}
    LoanLev:integer;			{Level needed to make a file point loan}

    {User Ratios}
    XferPcr,					{Default pcr needed for xfer}
    PCRExempt,				{Level to exempt from PCR}
    UDRatio,					{Default UD ration needed to download}
    UDExempt,					{Level to exempt from UD ratio}
    GenRatio,					{Required average of UDR and PCR}
    GenExempt:integer;{Level to exempt for General Ratio}

    {Colors}
    Color1,
    Color2,
    Color3,
    Color4,
    Color5,
    Color6,
    Color7,
		Color8,								{Attribute type....  Various color settings}
		SysopToolColor,				{Color for sysop tools}
		StatLineColor,     		{Color of status Line}	{End of 1.38 record}

		SysopToolHigh,

		WFC_Back,							{Wait for call colors}
		WFC_Text1,
		WFC_Text2,
		WFC_Panel1,
		WFC_Panel2,
		WFC_Border,

		PopupColor,
		LightBarColor: byte;

		{pathnames}
		Art_Dir,               	{Ansi Art Gallery directory}
		Language_Dir:	String[127];	{Directory for language files}

		{Network Options}
		netbegin2,					 	{2nd Net call start time}
		netend2 : String[8]; 	{2nd Net call end time}

		{Look and Feel}
		AlacrityMenus, 				{Use Alacrity-style menus}
		AllowMasterFile,				{Allow creation of a master file creation}
		SoundEffects: boolean;  {Use sound effects.  }

		{Misc}
		BozoFilter: byte;  {unused}

		{New Path item}
		Mail_Dir	: String[127];	{path for Email uploads}

		{FidoNet Data}

		fidoLocalAttribute,
		fidoDelSentMsg,
	 	fidoDelTossedMsg,
		fidoSetCrash,
		fidoSetPrivate,
		fidoSetHold,
		fidoSetLocal,
		fidoFlag8	:	boolean;

		fidoAddress	:	string[15];	{Zone:Net/Node/Point Address}
		fidoOrigin	: string[80];	{Fidonet origin line}

		{Addition Modem Connect Stings}
		connectStr : array[1..13] of string[15];

		{More Look and Feel}
		UserNoteEdit,        {Allow users to edit user notes}
		AllowHandles,        {Allow handles on the BBS}
		UseNuaVmb	: boolean; {Use enhanced VMB/NUA entries in the BBS List}

		{New Login Shell Command Prompt}
		ShellPrompt	: string[80];  {Command prompt used in the shell}

		{Standard DSZ Protocol}
		DSZexe: string[12];       {unused with 2.0}

		{Shell Upload Pass}
		ShellUploadPass: string[10]; {unused with 2.0}

		Sequence: array[1..20] of Record
			order: byte;              {Order in login sequence}
			name: string[12];         {Name of extended entry}
			options: byte;            {Options in system}
			end;

    {More access levels}
    ArtGalleryLvl,          { Level to upload Art to Art Gallery }
    QwkAccessLvl,           { Level needed to enter QWK section }
		SLevExpired,      			{ SLevel to change an expired account to}
		XLevExpired: integer;   { XLevel to change an expired account to}

    {More look and feel}
    HeaderFormat,           { Radio buttons for header format }
    UnusedLF,               { free for future expansion }
		UnusedLF2:Word;         {unused with 2.0}
		PauseString: String[80];{unused with 2.0}


		{New Password Entry}
		LowSpeedNewUserPass : string[10]; {password for low speed user login}
    filepw:boolean;                   {Use file passwords}

    ScanDrives:string[10];            {Drives to scan for WFC}
    AdjustDisplay:boolean;            {Adjust display for 25/50 line users}
    NodeName:string[15];  {description of node}

    PKZip_Path,           {path to pkzip}
    PKunzip_path,         {path to pkunzip}
    Arj_Path,             {path to ARJ.exe}
    Lha_Path,             {path to LHA.exe}
    Zoo_Path,             {path to ZOO.EXE}
    DDD_Path,             {path to DDD.EXE}
    Pak_Path,             {path to PAK.EXE}
    Arc_Path,             {Path to arc.exe}
    Unarc_Path,           {path to unarc.exe}
    Swap_Dir,             {Swap file directory}

    Buffer_Dir,           {to copy slow files to}
    Archive_Dir,           {for archive processing use}

    GifView:string[127];  {Path to graphic viewer}

    VerifyUpload,          {Verify uploads}
    ConvertUpload,         {Convert uploads}
    VirusScan,             {Virus scan uploads}
    CommentUpload,         {Comment uploads}
    CleanUpload,           {Clean uploads}

    Files_Private,         {Allow private files in xfers}
    Files_ExtDesc,         {Allow extended descriptions}
    AllowMultipleLogins:boolean;  {Allow user to be on multiple times}

    ExitOnRecycle, {Board drops to batch file when user hangs up}
    AllowMailFiles: boolean; {Allow File Attachments in mail}
    {New 2.0 Stuff}

    {Serial Type}
    SerialType: word;       {Serial, Digi-Board, Fossil}

    {Xfer}
    FreeSpaceToUpload : word; {free space required to upload}

    PrintUserLog : word;  {hardcopy logging option.  Unused with 2.00}
    SecureConsole: boolean;  {Secure local console.  Unused with 2.0}

    {New User}
    SendNUFeedBackTo: String[30];  {User to send new user feedback to}


    end; {Setup Record}

                                                                            (*

  These are the basic pascal record types used for Celerity v2.00.  Most data
  files are random-access files consisting of equal records, and described
  below.  If you are writing in another language, you can read these files
  but will need to know some of the details:

  A "string" is an array of characters as large as the definition (string[20]
  would mean 20 characters) preceded by a length byte.  This byte tells how
  many of those characters are in use.  A length byte of value $04 would mean
  that the first four characters hold valid data, and the rest of the array
  is to be ignored.

  An "integer" is a signed 16-bit integer number (-32768 to 32767).

  A "longint" is a signed 32-bit integer

  A "word" is an unsigned 16-bit integer (0 to 65535).
*)





(*************************************************************************)
(* Sicko's mods                                                               *)
(*************************************************************************)



Type

   userfiletype=file of userrec;

   type ScreenType = array [0..3999] of Byte;


type anystr=string[128];
     lstr=string[80];
     mstr=string[30];
     sstr=string[15];
     cstr=string[45];
     sickostr=string[70];

var

    UserFile: userfiletype;
    ScreenAddr : ScreenType absolute $B800:$0000;



const
     SESC  = 50;
     Spgdn = 26;
     Spgup = 27;


const
	{Constants for File Locking}
                        {The +2 allows opening for Read/Write}
	RW		=	0+2;	    {Fully Open}
	Locked		=       16+2;	    {Read/Write Denied to other programs}
	ReadOnly	=	32+2;	    {Write Access Denied}
	WriteOnly	=	48+2;	    {Read Access Denied}
        Denied          =       5;       {File Locked Error}



implementation

begin
end.



