{

  Copyright 1994 by Salvatore Besso, mc8505@mclink.it

  This software is freeware.

  You are free to modify the source code for your personal use and to
  redistribute this software only if you leave the copyright notices
  unmodified everywhere in the code, also in the comments.

  In case of problems contact me via e-mail at address:

  mc8505@mclink.it

}

program TablesDescription; { Prints Paradox 4 tables structure }

{
  Errorlevels returned:

  1  = File error (not found or other DOS error)
  2  = Paradox Engine error
  3  = Printer error
  99 = Command line parameter wrong or missing
}

uses
  Dos,Printer,
  Drivers,Objects,
  PXEngine,OOPxEng;

const
  Version = '1.02';

  Engine  : PEngine   = NIL;
  DataBase: PDataBase = NIL;

  OnPrinter: Boolean = True;
  Path     : PathStr = '';

var
  I,J : Integer;
  S   : String;

procedure ReleaseEngine;

begin
  if Database <> NIL then Dispose (Database,Done);
  if Engine <> NIL then Dispose (Engine,Done)
end;

procedure ShutDown (Code: RetCode);

begin
  PrintStr (#7#13#10'Paradox Engine Database Framework error:'#13#10);
  PrintStr (Engine^.GetErrorMessage (Code) + #13#10);
  ReleaseEngine;
  Halt (2)
end;

procedure OpenEngine;

begin
  Engine := New (PEngine,defInit (pxLocal));
  if Engine^.LastError <> PXSuccess then
    ShutDown (Engine^.LastError);
  DataBase := New (PDataBase,Init (Engine));
  if DataBase^.LastError <> PXSuccess then
    ShutDown (DataBase^.LastError)
end;

procedure PrinterError;

begin
  PrintStr (#7#13#10'Printer error'#13#10);
  ReleaseEngine;
  Halt (3)
end;

procedure PrintStructure;

var
  DirInfo        : SearchRec;
  D              : DirStr;
  N              : NameStr;
  E              : ExtStr;
  Header         : array[1..5] of String;
  I              : Integer;
  Line,Spaces    : String;
  TableDescriptor: PTableDesc;

procedure PrintInfo (P: PFieldDesc); far;

var
  S,T     : String;
  Len,Size: Integer;

begin
  Str (P^.FldNum:0,T);
  S := Copy (T + Spaces,1,3) + ': ' + Copy (P^.FldName + Spaces,1,26);
  case P^.FldType of
    fldChar  : T := 'Alpha';
    fldShort : T := 'Short';
    fldDate  : T := 'Date';
    fldDouble: T := 'Number';
    fldBlob  : T := 'Blob'
  end;
  S := S + Copy (T + Spaces,1,10);
  case P^.FldSubType of
    fldStNone   : T := 'None';
    fldStMoney  : T := 'Currency';
    fldStMemo   : T := 'Memo';
    fldStBinary : T := 'Binary';
    fldStFmtMemo: T := 'Fmt Memo';
    fldStOleObj : T := 'OLE';
    fldStGraphic: T := 'Graphic'
  end;
  S := S + Copy (T + Spaces,1,10);
  case P^.FldType of
    fldChar  : Len := P^.FldLen;
    fldShort : Len := 2;
    fldDate  : Len := 4;
    fldDouble: Len := 8;
    fldBlob  : Len := P^.FldLen
  end;
  Str (Len:0,T);
  S := S + Copy (T + Spaces,1,7);
  Size := Len;
  if P^.FldType = fldBlob then Inc (Size,10);
  Str (Size:0,T);
  S := S + T;
  {$I-}
  if OnPrinter then
    WriteLn (Lst,S)
  else WriteLn (S);
  {$I+}
  if IOResult > 0 then PrinterError
end;

begin { PrintStructure }
  FillChar (Line[1],79,'-');
  Line[0] := #79;
  FillChar (Spaces[1],79,' ');
  Spaces[0] := #79;
  FSplit (FExpand (Path),D,N,E);
  if N = '' then N := '*';
  Path := D + N + '.DB';
  FindFirst (Path,Archive,DirInfo);
  if DosError > 0 then
  begin
    PrintStr (#7#13#10'File not found or file error'#13#10);
    ReleaseEngine;
    Halt (1)
  end;
  while DosError = 0 do
  begin
    N := Copy (DirInfo.Name,1,Pos ('.',DirInfo.Name) - 1);
    if IOResult > 0 then PrinterError;
    TableDescriptor := DataBase^.GetDescVector (D + N);
    if DataBase^.LastError <> PXSuccess then
      ShutDown (DataBase^.LastError);
    Header[1] := '';
    Header[2] := Copy (Spaces,1,(80 - Byte (N[0])) div 2) + N;
    Header[3] := Line;
    Header[4] := '#    Description               Type      Sub       Len' +
      '    Size';
    Header[5] := Line;
    for I := 1 to 5 do
    begin
      {$I-}
      if OnPrinter then
        WriteLn (Lst,Header[I])
      else WriteLn (Header[I]);
      {$I+}
      if IOResult > 0 then PrinterError
    end;
    TableDescriptor^.ForEach (@PrintInfo);
    Dispose (TableDescriptor,Done);
    {$I-}
    if OnPrinter then
      Write (Lst,#12#13)
    else WriteLn;
    {$I+}
    if IOResult > 0 then PrinterError;
    FindNext (DirInfo)
  end
end;

procedure Usage;

begin
  PrintStr (#13#10'Usage: TablDesc [/NOPRINTER] [d:\path\]tablename[.DB]' +
    #13#10'                [>] [>>] [output device or file]' +
    #13#10'                (wildcards are OK)'#13#10#10);
  PrintStr ('Use /NOPRINTER to view the structures without printing.'#13#10);
  PrintStr ('Use /NOPRINTER together with "> file/device" or ">> file" to ' +
    'redirect output'#13#10'to a file or device without printing.'#13#10);
  Halt (99)
end;

begin { Main }
  PrintStr ('TablDesc ' + Version + ' - Prints Paradox 4 tables structure' +
    #13#10'by Salvatore Besso, mc8505@mclink.it'#13#10);
  if ParamCount = 0 then Usage;
  for I := 1 to ParamCount do
  begin
    S := ParamStr (I);
    for J := 1 to Length (S) do S[J] := Upcase (S[J]);
    if S[1] = '/' then
    begin
      if (Path <> '') or (S <> '/NOPRINTER') then
        Usage
      else OnPrinter := False
    end
    else if Path = '' then
      Path := ParamStr (I)
    else Usage
  end;
  if Path = '' then Usage;
  OpenEngine;
  PrintStructure;
  ReleaseEngine
end.
