/* P821 V2.4 Installation */
'@Echo Off'
Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX
Call SysCls
Say 'Installing P821 Version 2.4 ...'
Say ''

Result = SysFileTree( 'P821.EXE', 'Files', 'F' )
If Files.0 = 0 Then Do
  Say 'ERROR: P821.EXE not found! Installation cancelled.'
  Signal DONE
End

Result = SysFileTree( 'P821_OS2.ICO', 'Files', 'F' )
If Files.0 = 0 Then Do
  Say 'ERROR: P821_OS2.ICO not found! Installation cancelled.'
  Signal DONE
End

Say ''
Say 'Creating program object...'
Say ''

Path = Directory()
If Right(Path,1) <> '\' Then Do
  Path = Path||'\'
End

Type = 'WPProgram'
Title = 'P821 V2.4'
Folder = '<WP_DESKTOP>'
Parms = 'EXENAME='Path'P821.EXE;PARAMETERS=[format options:] %*;OBJECTID=<P821>;ICONFILE='Path'P821_OS2.ICO;NOPRINT=YES;'
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )
If Result <> 1 Then Do
    Say 'ERROR: Unable to create object. Installation cancelled.'
    Signal DONE
End

Say 'Installation completed!'
Signal DONE

FAILURE:
Say 'Installation error.'
Signal DONE
HALT:
Say 'Installation error.'
Signal DONE
SYNTAX:
Say 'Syntax error.'
Signal DONE
DONE:
Exit
