'                               ANALYZE
'Edited using QuickBasic 4.5  (use /AH for Huge Arrays)
'A program to Analyze the output from scanners used with machine-graded tests.
'Copyright Dec., 1993 by Christopher King
DECLARE SUB HappyFace (N%)
DECLARE SUB GetResults ()
DECLARE SUB ItemAnalysis (Info() AS STRING)
DECLARE SUB PrintOut ()
DECLARE SUB ResponsePrint (start%, endcount%)
DECLARE SUB ResponseControl ()
DECLARE SUB Initial (Info() AS STRING)
DECLARE SUB GetFormat (FirstRecord$, SecondRecord$, AForm AS ANY)
DECLARE SUB FKeys (N%)
DECLARE SUB F6 ()
DECLARE SUB F7 ()
DECLARE SUB F8 ()
DECLARE SUB Details ()
DECLARE SUB PersonalPrint ()
DECLARE FUNCTION DiscrimMaxFactor! ()
DECLARE FUNCTION DiscrimError! ()
DECLARE SUB PageHeader ()
DECLARE SUB Comline (NumArgs%, MaxArgs%)
DECLARE SUB QuickSort2 (Low%, High%)
DECLARE FUNCTION RandInt% (lower%, Upper%)
DECLARE SUB QuickSort1 (Low%, High%)
DECLARE SUB Analysis ()
' $DYNAMIC
DEFINT A-Z
CLEAR , , 2000              'This increases the stack space
arraysize = 400             'Arraysize limits number of score sheets to 400.
TYPE Format                 'Used to define input file formats
    length1 AS INTEGER
    NameStart AS INTEGER
    NameLength AS INTEGER
    ResponseStart AS INTEGER
    ResponseLength AS INTEGER
    Pad AS INTEGER
    length2 AS INTEGER
    Response2Start AS INTEGER
    Response2Length AS INTEGER
END TYPE
OPTION BASE 1
DIM SHARED NameOnKey AS STRING * 21, Answers(200) AS STRING * 2
DIM SHARED NumStudents, NumProblems, MaxProblem, ActualProblems
DIM SHARED InFileName AS STRING, OutFileName AS STRING, KeyFileName AS STRING
DIM SHARED Names(arraysize) AS STRING * 21, StudentTotals(arraysize)
DIM SHARED Response(arraysize, 200) AS STRING * 2, Average AS SINGLE
DIM SHARED A(200), B(200), C(200), D(200), E(200), Blank(200), ItemTotals(200)
DIM SHARED Ones, Twos, Threes, Fours, Fives, BlanksInKey, PrintWidth
DIM SHARED AlphaIndex(arraysize), NumIndex(arraysize), StandardDev AS SINGLE
DIM SHARED LineNum, DiscrimSize, Discrimination(200, 5)  AS SINGLE
DIM SHARED reliability AS SINGLE, Exist, BadResponses, SumX AS LONG, Dash
DIM SHARED DiscrimFactor AS SINGLE, OneOverStandardDev AS SINGLE, EditKey
DIM SHARED WhereAt AS STRING, InitFile AS STRING, LinesPerPage
DIM SHARED ScoreFirstSheet, PrintWide, T90(30) AS SINGLE, NormalWidthGraphics
DIM SHARED LinesPerNormalPage, LinesPerWidePage, ColumnsPerWidePage
DIM SHARED RunKermit, FKeys1To4(4), DataFormat(4) AS Format
DIM SHARED Command(2) AS STRING
DIM Info(5) AS STRING
CONST false = 0, true = NOT false
'************** 90% confidence interval Students T values *******************
DATA 6.3138,2.92,2.3534,2.1318,2.0150,1.9432,1.8946,1.8595,1.8331,1.8125
DATA 1.7959,1.7823,1.7709,1.7613,1.7530,1.7459,1.7396,1.7341,1.7291,1.7247
DATA 1.7207,1.7171,1.7139,1.7109,1.7081,1.7056,1.7033,1.7011,1.6991,1.6873
'****************************************************************************
FOR N = 1 TO 30
     READ T90(N)
NEXT N
FOR N = 1 TO arraysize              'Initialize sorting indices
    AlphaIndex(N) = N
    NumIndex(N) = N
NEXT N
ON ERROR GOTO ErrorHandler
CALL Comline(N, 4)
CALL Initial(Info())
CALL GetResults
OPEN OutFileName FOR OUTPUT AS #3
WhereAt = ""
IF NOT FKeys1To4(4) = 1 THEN              'if not just description...
    CALL QuickSort1(1, NumStudents)     'Sort scores numerically
    CALL QuickSort2(1, NumStudents)     'Sort scores alphabetically by name
    CALL Analysis
    IF FKeys1To4(1) = 1 THEN            'if just item analysis...
        LineNum = LinesPerPage + 1
        CALL ItemAnalysis(Info())
    ELSE
        IF NOT (FKeys1To4(2) = 1 OR FKeys1To4(3) = 1) THEN
        'if not just (responses or personal)...
            CALL PrintOut
            IF FKeys1To4(1) THEN CALL ItemAnalysis(Info())  'if item ...
        ELSE
            LineNum = LinesPerPage + 1
            'Forces page header for first page of score tabs or Student Responses
        END IF
        IF FKeys1To4(2) AND NOT FKeys1To4(3) = 1 THEN ResponseControl
        'if responses and not just personal...
        IF FKeys1To4(3) AND NOT FKeys1To4(2) = 1 THEN PersonalPrint
        'if personal and not just responses...
    END IF
ELSE
    LineNum = 2 * LinesPerPage  'So PageHeader won't start a new page.
END IF
IF FKeys1To4(4) AND NOT (FKeys1To4(1) = 1 OR FKeys1To4(2) = 1 OR FKeys1To4(3) = 1) THEN
    'if description and not just (item or responses or personal)...
    CALL Details
END IF
CLOSE #3
PRINT SPC(31); "Analysis Complete"
COLOR 15
IF NOT (PrintWide AND RunKermit) THEN
    PRINT SPC(24); "Print output file on LPT1 [No]?  ";
    COLOR 7
    DO
        ch$ = INKEY$
    LOOP WHILE ch$ = ""
    PRINT
    PALETTE
    IF UCASE$(ch$) = "Y" THEN
        doit$ = "PRINT.EXE " + OutFileName
        SHELL doit$
    END IF
ELSE
    ERASE Answers, Names, StudentTotals, Response, A, B, C, D, E, Blank, DataFormat
    ERASE AlphaIndex, NumIndex, ItemTotals, Discrimination, T90, FKeys1To4, Info
    IF NOT (Command(1) = "" OR Command(2) = "") THEN
        PRINT SPC(22); "Execute the following commands [No]?"
    END IF
    PALETTE
    COLOR 7
    length1 = LEN(Command(1))
    length2 = LEN(Command(2))
    IF length1 > length2 THEN length2 = length1
    spot = (80 - length2 - 12) / 2
    row = CSRLIN
    PRINT SPC(spot); Command(1)
    PRINT SPC(spot); Command(2);
    DO
        ch$ = INKEY$
    LOOP WHILE ch$ = ""
    IF UCASE$(ch$) = "Y" THEN
        FOR N = 1 TO 2
            LOCATE row + N - 1, length2 + 3 + spot
            PRINT "Executing"   '9 spaces
            SHELL Command(N)
        NEXT N
        'Not possible to start kermit with "RUN Kermit" because Kermit
        'sees ANALYZE's command line options.
    ELSE
        PRINT
    END IF
END IF
END

' error handling routine handles only "Bad File Name" and "Path Not Found";
' aborts on most other errors
'
CONST FileNotFound = 53
CONST BadPath = 76
CONST BadFileName = 52
ErrorHandler:
    'Error handler for input and answer key file names.
    Number = ERR
    IF Number = FileNotFound OR Number = BadFileName THEN
        'bad file name
        COLOR 7
        LOCATE 15, 1
        PRINT SPACE$(80);
        LOCATE 15, 25
        IF WhereAt = "GetResults--Input File" THEN
            PRINT "File "; UCASE$(InFileName); " not found."
            LOCATE 7, 19
            PRINT SPACE$(80 - 19);
            LOCATE 7, 19
            COLOR 15
            INPUT ; "", InFileName
        ELSEIF WhereAt = "GetResults--Answer Key" THEN
            PRINT "File "; UCASE$(KeyFileName); " not found."
            LOCATE 9, 19
            PRINT SPACE$(80 - 19);
            LOCATE 9, 19
            COLOR 15
            INPUT ; "", KeyFileName
        ELSE
            ' some other error, so print message and abort
            COLOR 7
            PRINT "Unrecoverable error--"; ERR
            ON ERROR GOTO 0
        END IF
        RESUME
    ELSEIF Number = BadPath THEN
        'bad path name
        LOCATE 15, 1
        PRINT SPACE$(80);
        LOCATE 15, 1
        IF WhereAt = "GetResults--Input File" THEN
            PRINT "Path in "; UCASE$(InFileName); " not found."
            LOCATE 7, 19
            PRINT SPACE$(80 - 19);
            LOCATE 7, 19
            INPUT ; "", InFileName
        ELSEIF WhereAt = "GetResults--Answer Key" THEN
            PRINT "Path in "; UCASE$(KeyFileName); " not found."
            LOCATE 9, 19
            PRINT SPACE$(80 - 19);
            LOCATE 9, 19
            INPUT ; "", KeyFileName
        END IF
        RESUME
    ELSE
        ' some other error, so print message and abort
        COLOR 7
        PRINT "Unrecoverable error--"; ERR
        ON ERROR GOTO 0
    END IF

CatchError:
    'Error handler for output file name.
    IF ERR = FileNotFound THEN
        'File does not exist
        Exist = false
        RESUME NEXT
    ELSEIF ERR = BadFileName OR ERR = 64 THEN
        'bad file name
        IF UCASE$(OutFileName) <> "" THEN
            LOCATE 15, 1
            PRINT SPACE$(80);
            LOCATE 15, 10
            PRINT UCASE$(OutFileName); " is a bad file name."
        END IF
        LOCATE 8, 19
        PRINT SPACE$(80 - 19);
        LOCATE 8, 19
        INPUT ; "", OutFileName
        RESUME
    ELSEIF ERR = BadPath THEN
        'bad path name
        LOCATE 15, 1
        PRINT SPACE$(80);
        LOCATE 15, 10
        PRINT "Path in "; UCASE$(OutFileName); " not found."
        LOCATE 8, 19
        PRINT SPACE$(80 - 19);
        LOCATE 8, 19
        INPUT ; "", OutFileName
        RESUME
    ELSE
        ' some other error, so print message and abort
        COLOR 7
        PRINT "Unrecoverable error--"; ERR
        ON ERROR GOTO 0
    END IF

REM $STATIC
SUB Analysis
DIM Jstring(5) AS STRING * 2
Jstring(1) = "1 ": Jstring(2) = "2 ": Jstring(3) = "3 "
Jstring(4) = "4 ": Jstring(5) = "5 "

'*********************** Analyze responses to each question ****************
'     The scanner output uses A = 1, B = 2, C = 3, D = 4, E = 5, and
' Blank = " ".  Response(M,N) is blank if student left blank and is a
' two-character null string if item is beyond a student's last response.
' ItemTotals(N) is number correct for each item.  Number of responses
' that are A, B, etc. are in A(N), B(N), C(N), D(N), E(N), and Blank(N).

NullString$ = CHR$(0) + CHR$(0)       'Generate a two-character null string.
FOR N = 1 TO NumProblems
    CorrectTotal = 0
    Answer$ = Answers(N)
    FOR M = 1 TO NumStudents
        IF Response(M, N) = "- " THEN
            CorrectTotal = CorrectTotal + 1
            char$ = Answer$
        ELSE
            char$ = Response(M, N)
        END IF
        SELECT CASE char$       'Distribution of responses on tests.
            CASE "1 "
                A(N) = A(N) + 1
            CASE "2 "
                B(N) = B(N) + 1
            CASE "3 "
                C(N) = C(N) + 1
            CASE "4 "
                D(N) = D(N) + 1
            CASE "5 "
                E(N) = E(N) + 1
            CASE "  ", NullString$
                Blank(N) = Blank(N) + 1
            CASE "* "
                BadResponses = BadResponses + 1
                Response(M, N) = "? "
                PRINT SPC(12); Names(M); " has multiple responses to item"; N
            CASE ELSE
                PRINT "Unrecognized student answer; program bombs."
                PRINT Names(M); ", answer number"; N; "is "; CHR$(34); Response(M, N); CHR$(34);
                PRINT ".  Responses follow:"
                FOR P = 1 TO MaxProblem
                    PRINT Response(M, P);
                NEXT P
                END
        END SELECT
    NEXT M
    IF Answer$ = "# " THEN
        ItemTotals(N) = NumStudents
        Answers(N) = "* "
        'change Answers back to "* " for the printouts.
    ELSE
        ItemTotals(N) = CorrectTotal
    END IF
NEXT N

'************* Key Distribution, Discrimination, & Reliability **************
' Distribution of responses in the key goes into Ones(N), Twos(N), Threes(N),
' Fours(N), Fives(N), and BlanksInKey(N).
' Discrimination for each item goes into Discrimination(N, J).
' Reliability is calculated.
   
    'Discrimination is calculated using point biserial correlation
    'coefficients, r(pb) between test scores and item response.  The formula
    'is:              (Y1bar - Y0bar)squareroot(p*q)
    '         r(pb) = ------------------------------
    '                              s
    ' Y1bar = mean score on test of people who correctly answered a problem.
    ' Y0bar = "     "     "   "  "   "      "  incorrectly "      "   "
    ' p = proportion of people who answered the question correctly.
    ' q = 1 - p
    ' s = standard deviation of test score totals
    'This is from "Statistics in Education and Psychology", (1965), by Tate.
    'I choose to use the square of this, because the square of a correlation
    'coefficient is proportional to "strength" of a relation.  The sign before
    'squaring is retained.
DiscrimFactor = DiscrimMaxFactor!
FOR N = 1 TO NumProblems
    Answer$ = Answers(N)
    FOR J = 1 TO 5
        NumRight = 0
        CorrectTotal = 0
        InCorrectTotal = 0
        Jstr$ = Jstring(J)
        IF Answer$ = Jstr$ THEN Jstr$ = "- "
        FOR M = 1 TO NumStudents
            IF Response(M, N) = Jstr$ THEN
                NumRight = NumRight + 1
                CorrectTotal = CorrectTotal + StudentTotals(M)
            END IF
        NEXT M
        IF NumRight = 0 THEN
            CorrectMean! = 0
        ELSE
            CorrectMean! = CorrectTotal / NumRight
        END IF
        NumWrong = NumStudents - NumRight
        IF NumWrong = 0 THEN
            InCorrectMean! = 0
        ELSE
            InCorrectMean! = (SumX - CorrectTotal) / NumWrong
        END IF
        P! = NumRight / NumStudents
        q! = 1 - P!
        intermediate! = (CorrectMean! - InCorrectMean!) * SQR(P! * q!)
        correlation! = intermediate! * OneOverStandardDev * DiscrimFactor
        'if just one student, then OneOverStandardDev is zero.
        Discrimination(N, J) = correlation! * correlation!
        IF intermediate! < 0 THEN Discrimination(N, J) = -Discrimination(N, J)
    NEXT J
       
    'Reliability is from "Statistical Methods in Education", D.G. Lewis(1972).
    'The Kuder-Richardson coefficient of reliability, r(KR), is given by
    '                  n    [(sigma)squared - summation(p*q)]
    '       r(KR) = -----------------------------------------
    '                (n - 1)        [(sigma)squared]
    'n = number of items in the test
    'sigma = standard deviation of test score totals
    'p = proportion passing each item
    'q = 1 - p
    IF Answers(N) <> "  " THEN  'This is in case of a blank in the answer key.
        FractionCorrect! = ItemTotals(N) / NumStudents
        FractionWrong! = 1 - FractionCorrect!
        SUMpq! = FractionCorrect! * FractionWrong! + SUMpq!
    END IF
NEXT N
reliability = ActualProblems * (StandardDev * StandardDev - SUMpq!) / ((ActualProblems - 1) * StandardDev * StandardDev)
END SUB

SUB Comline (NumArgs, MaxArgs) STATIC

   NumArgs = 0: in = false
   ' Get the command line using the COMMAND$ function.
   cl$ = COMMAND$
   L = LEN(cl$)
   ' Insure that a blank preceeds any "/" except the first character.
   J = INSTR(2, cl$, "/")
   ' Go through the command line a character at a time.
   FOR I = 1 TO L
      C$ = MID$(cl$, I, 1)
      'Test for character being a blank or a tab.
      IF (C$ <> " " AND C$ <> CHR$(9)) THEN
                            ' Neither blank nor tab.
          IF C$ = "/" THEN in = false
                            ' Test to see if you're already
                            ' inside an argument.
             IF NOT in THEN
                            ' You've found the start of a new argument.
                            ' Test for too many arguments.
                IF NumArgs = MaxArgs THEN EXIT FOR
                NumArgs = NumArgs + 1
                in = true
             END IF
                            ' Add the character to the current argument.
             Args$(NumArgs) = Args$(NumArgs) + C$
      ELSE
                            ' Found a blank or a tab.
                            ' Set "Not in an argument" flag to FALSE.
             in = false
      END IF
   NEXT I

IF Args$(1) = "?" OR Args$(1) = "HELP" OR Args$(1) = "/?" THEN
    CLS
    PRINT "ANALYZE 1.00 is a program to analyze the output from optical scanners that"
    PRINT "score machine-graded tests.  The output includes scores sorted both by name"
    PRINT "and by score; item analysis (distribution of responses, discrimination,"
    PRINT "reliability); student responses; and individual score reports.  Four input"
    PRINT "file formats can be defined in the analyze.ini file.  The default values are"
    PRINT "for NCS model 7001 and OptiScan 5 scanners.  Up to 400 score sheets can be"
    PRINT "analyzed."
    PRINT "                                         --Christopher King"
    PRINT
    PRINT "ANALYZE     The program prompts for filenames."
    PRINT "     or"
    PRINT "ANALYZE InputFile OutputFile KeyFileName Filename.ini /?"
    PRINT "                 /?       Displays this screen"
    PRINT "     OutputFileName       If given, must follow InputFileName"
    PRINT "        KeyFileName       If used, must follow InputFileName and OutputFile"
    PRINT "       Filename.ini       An initialization file and path may be given"
    PRINT
    PRINT "The first sheet in the input file is used as the answer key, unless a key"
    PRINT "filename is given.  Then the first sheet in KeyFileName is the answer key,"
    PRINT "and the user can choose whether or not to iqnore the input file's first "
    PRINT "sheet (in case it, too, is an answer key).  An item marked with a "; CHR$(34); "*"; CHR$(34); " on the"
    PRINT "answer key will have all responses scored as correct."
    END
END IF

FoundInFile = false
FoundOutFile = false
FoundKeyFile = false
IF NumArgs > 0 THEN
    FOR N = 1 TO NumArgs
        IF MID$(Args$(N), 1, 1) = "/" THEN
            PRINT "Unrecognized switch on command line."
            END
            KeyFileName = Args$(N)
        ELSEIF INSTR(Args$(N), ".INI") THEN
            InitFile = Args$(N)
        ELSEIF NOT FoundInFile THEN
            InFileName = Args$(N)
            FoundInFile = true
        ELSEIF NOT FoundOutFile THEN
            OutFileName = Args$(N)
            FoundOutFile = true
        ELSEIF NOT FoundKeyFile THEN
            KeyFileName = Args$(N)
            FoundKeyFile = true
        ELSE
            PRINT "WARNING:  Too Many Parameters on command line."
            END
        END IF
    NEXT N
END IF

END SUB

SUB Details
'This subroutine prints an explanation of how discrimination is used.

CALL HappyFace(4)

CALL PageHeader
PRINT #3, "What is Discrimination?"
PRINT #3, "Suppose a four-item test was given, with the following responses:"
PRINT #3,
PRINT #3, "                                     Question Number"
PRINT #3, "                                       1  2  3  4    Total"
PRINT #3, "                               Barney  1  0  1  0     2"
PRINT #3, "                            Frederick  1  1  1  1     4"
PRINT #3, "                                Joyce  0  0  0  1     1"
PRINT #3, "                                Tisha  1  1  1  0     3"
PRINT #3,
PRINT #3, "Question two looks like a good question because the high-scoring students"
PRINT #3, "Tisha and Frederick, got it right, and the low-scoring students missed it."
PRINT #3, "In other words, question two discriminates between high and low scoring"
PRINT #3, "students."
PRINT #3,
PRINT #3, "Discrimination can be represented graphically:"
PRINT #3,
PRINT #3, "            I "
PRINT #3, "         1 -l         *   *    <----The high-scoring students got it right"
PRINT #3, "Item #2     l "
PRINT #3, "Score       l "
PRINT #3, "         0 -l *   *        <----The low-scoring students missed it"
PRINT #3, "            l______________"
PRINT #3, "              1   2   3   4"
PRINT #3, "               Total Score"
PRINT #3,
PRINT #3, "A best-fitting line can be drawn to show the relation between total score"
PRINT #3, "and item score.  The spread of the data about this line is indicated by the"
PRINT #3, "correlation coefficient, r.  Actually, r-squared is a better indicator of a"
PRINT #3, "relation than is r.  This is explained by the "; CHR$(34); "variance"; CHR$(34); " interpretation of r:"
PRINT #3, "                                          S(x,y)"
PRINT #3, "                            r*r  =  1  -  ------"
PRINT #3, "                                           S(y)"
PRINT #3, "         S(y) is the spread (actually the variance squared) of the y data."
PRINT #3, "         S(x,y) is the spread of the y data about a best fitting line."
PRINT #3, "                              x"
PRINT #3, "                            .  \ S(x,y)"
PRINT #3, "                          .   , \"
PRINT #3, "                 l      .   ,   .x"
PRINT #3, "              1 -l    .*   *  .*      _____"
PRINT #3, "     Item #3     l  .   ,   .           l  "
PRINT #3, "     Score       l.   ,   .             l S(y) "
PRINT #3, "              0 -l *,   .             __l__  "
PRINT #3, "                 l______________"
PRINT #3, "                   1   2   3   4"
PRINT #3, "                    Total Score"
PRINT #3,
PRINT #3, "If S(x,y) is half of S(y), then r*r is 0.5.  If S(y) is one-fourth of"
PRINT #3, "S(x,y) then r*r is .75.  As you see, r squared is more directly related to"
PRINT #3, "the spread of the data about the best-fitting line than is r."
PRINT #3,
PRINT #3, "As you know, r is supposed to range from -1 to +1.  When r is +1, all the"
PRINT #3, "points will lie on a line.  However, as you can see, there is no way for "
PRINT #3, "all the points to lie on a line for this data.  This is because an item"
PRINT #3, "score can only be 0 or 1; it can't be, say, .5, so in fact r cannot reach +1."
PRINT #3, "The largest possible value that r can attain, r(max), is determined by the"
PRINT #3, "program.  Item two happens to have the largest possible r:  the item was"
PRINT #3, "answered correctly only by the highest-scoring half of the class."
PRINT #3,
PRINT #3, "I HAVE CHOSEN TO DEFINE DISCRIMINATION AS [r/r(max)] squared.  Dividing"
PRINT #3, "by r(max) gives discrimination a possible range of -1 to +1.  The sign"
PRINT #3, "is the same as that of r before squaring."

CALL HappyFace(4)

END SUB

FUNCTION DiscrimError!
'********************* Error Limits for a Correlation Coefficient ***********
' The following is used to test the null hypothesis that a correlation co-
' efficient is zero.  If r(observed) is less than r(null) then there is no
' significant difference between r(observed) and r = 0 at the 90% confidence
' level.  The equation is from "Statistics in Education & Psychology" by
' M. W. Tate, p. 281.
'                               t
'           r(null) = -----------------------
'                     squareroot(N - 2 + t*t)
' t = Student's T at 90% C.I.; the values are read in in the main module.
' DiscrimError just returns the value of r(null) at the 90% confidence level.
' N must be at least 3 or else program will end.

IF NumStudents < 3 THEN
    PRINT "Number of students must be 3 or greater to determine discrimination "
    PRINT "confidence limits.  Program quits."
    END
ELSEIF NumStudents > 30 THEN
    DegOfFreedom = 30
ELSE
    DegOfFreedom = NumStudents - 2
END IF
StudentsT! = T90(DegOfFreedom)
rnull! = StudentsT! / SQR(NumStudents - 2 + StudentsT! ^ 2)
DiscrimError! = rnull! * rnull! * DiscrimFactor
END FUNCTION

FUNCTION DiscrimMaxFactor!
'Discrimination is supposed to range from -1 to 1.  The point biserial
'correlation coefficient, however, does not reach one for most distributions.
'This function determines the maximum value discrimination could have.
'The value of the function is the inverse of that maximum, 1 / discrimMaximum.
'The correlation coefficient is:
'                     (Y1bar - Y0bar)squareroot(p*q)
'             r(pb) = ------------------------------
'                                  s
'     Y1bar = mean score on test of people who correctly answered a problem.
'     Y0bar = "     "     "   "  "   "      "  incorrectly "      "   "
'     p = proportion of people who answered the question correctly.
'     q = 1 - p
'     s = standard deviation of test score totals
'We need the value where the numerator is largest.
'The array StudentTotals(NumIndex(N)) contains totals in increasing order.
'Determine the numerator when just the highest-scoring student got an item
'correct.

IF NumStudents < 4 THEN
    DiscrimMaxFactor! = 1
    EXIT FUNCTION
END IF
FOR NumRight = 1 TO (NumStudents - 2)
    NumWrong = NumStudents - NumRight
    CorrectTotal = 0
    FOR M = (NumStudents - NumRight + 1) TO NumStudents
            CorrectTotal = CorrectTotal + StudentTotals(NumIndex(M))
    NEXT M
    InCorrectTotal = SumX - CorrectTotal
    CorrectMean! = CorrectTotal / NumRight
    InCorrectMean! = InCorrectTotal / NumWrong
    P! = NumRight / NumStudents
    q! = 1 - P!
    Numerator! = (CorrectMean! - InCorrectMean!) * SQR(P! * q!)
    IF Numerator! > LargestNumerator! THEN LargestNumerator! = Numerator!
NEXT NumRight
DiscrimMaxFactor! = StandardDev / LargestNumerator!

END FUNCTION

SUB F6
IF PrintWide THEN           'Changes output to normal
    LOCATE 4, 41
    COLOR 8
    PRINT CHR$(17)
    PrintWide = false
    IF NormalWidthGraphics THEN Dash = 196 ELSE Dash = 45
    LinesPerPage = LinesPerNormalPage
    PrintWidth = 80
ELSE                        'Changes output to wide
    LOCATE 4, 41
    COLOR 11  '
    PRINT CHR$(17)
    Dash = 45
    PrintWide = true
    LinesPerPage = LinesPerWidePage
    PrintWidth = ColumnsPerWidePage
END IF
END SUB

SUB F7
IF EditKey THEN
    LOCATE 5, 41
    COLOR 8
    PRINT CHR$(17)
    EditKey = false
    PALETTE 1, 56
ELSE
    LOCATE 5, 41
    COLOR 9
    PRINT CHR$(17)
    EditKey = true
    PALETTE 1, 63
END IF
END SUB

SUB F8
IF NOT ScoreFirstSheet THEN
    LOCATE 6, 41
    COLOR 8
    PRINT CHR$(17)
    ScoreFirstSheet = true
ELSE
    LOCATE 6, 41
    COLOR 9
    PRINT CHR$(17)
    ScoreFirstSheet = false
END IF
END SUB

SUB FKeys (N)
'Controls F Keys 1 - 4 and their display.  F1 = item analysis;
'F2 = Student responses; F3 = Personal scores; F4 = Discrimination text
'1 is added after initialization, so in subroutine INITIAL use:
'              Initialization:  0 = 1 (only), 1 = 2 (on), 2 = 0 (off)
FKeys1To4(N) = (FKeys1To4(N) + 1) MOD 3
    'Changes 0 to 1, 1 to 2, and 2 to 0
SELECT CASE N
    CASE 1
        row = 1
        column = 1
        only = 31
        IF FKeys1To4(1) = 1 AND (FKeys1To4(2) = 1 OR FKeys1To4(3) = 1 OR FKeys1To4(4) = 1) THEN FKeys1To4(1) = 2
    CASE 2
        row = 2
        column = 1
        only = 35
        IF FKeys1To4(2) = 1 AND (FKeys1To4(1) = 1 OR FKeys1To4(3) = 1 OR FKeys1To4(4) = 1) THEN FKeys1To4(2) = 2
    CASE 3
        row = 1
        column = 41
        only = 74
        IF FKeys1To4(3) = 1 AND (FKeys1To4(1) = 1 OR FKeys1To4(2) = 1 OR FKeys1To4(4) = 1) THEN FKeys1To4(3) = 2
    CASE 4
        row = 2
        column = 41
        only = 77
        IF FKeys1To4(4) = 1 AND (FKeys1To4(1) = 1 OR FKeys1To4(2) = 1 OR FKeys1To4(3) = 1) THEN FKeys1To4(4) = 2
END SELECT
IF FKeys1To4(N) = 0 THEN          'Don't print
    LOCATE row, column
    COLOR 8
    PRINT CHR$(17)
ELSEIF FKeys1To4(N) = 1 THEN      'Only print
    LOCATE row, only
    COLOR 10
    PRINT "ONLY";
    COLOR 10
    LOCATE row, column
    PRINT CHR$(17)
ELSE                              'Print
    LOCATE row, only
    PRINT "    ";
    COLOR 10
    LOCATE row, column
    PRINT CHR$(17)
END IF

END SUB

SUB GetFormat (FirstRecord$, SecondRecord$, AForm AS Format)
'Determine the format of the input or answer key file.  If not recognized,
'print a description of the file's format.
DO
    N = N + 1
    IF AForm.length1 = DataFormat(N).length1 AND (AForm.length2 = DataFormat(N).length2 OR AForm.length2 = 0) THEN
        FormatType = N
        FoundAFormat = true
    END IF
LOOP UNTIL FoundAFormat OR N > 3

IF NOT FoundAFormat THEN
    COLOR 7
    LOCATE 11, 1
    IF WhereAt = "GetResults--Input File" THEN
        PRINT SPC(25); "Unrecognized input file format."
        FileToOpen = 1
    ELSE
        PRINT SPC(25); "Unrecognized Answer Key Format"
        FileToOpen = 2
    END IF
    PRINT MID$(FirstRecord$, 1, 80)
    ScreenString$ = "1---5---10----5---20----5---30----5---40----5---50----5---60----5---70----5---80"
    PRINT ScreenString$
    PRINT SPC(27); " First record length: "; AForm.length1
    SEEK FileToOpen, AForm.length1
    FunnyLooking$ = CHR$(8)
    FOR N = 1 TO 5
        ch$ = INPUT$(1, FileToOpen)
        PRINT SPC(22); "ASCII value of character"; AForm.length1 + N - 1; "is"; ASC(ch$);
        IF ASC(ch$) > 31 THEN
            PRINT "("; ch$; ")"
        ELSE
            PRINT "("; FunnyLooking$; ")"
        END IF
    NEXT N
    PRINT SPC(14); "(ASCII values:  carriage return = 13; line feed = 10)"
    IF AForm.length2 > 0 THEN
        FOR M = 1 TO AForm.length2
            K = ASC(MID$(SecondRecord$, M, 1))
            IF (K = 13 OR K = 10 OR K = 9) THEN MID$(SecondRecord$, M, 1) = FunnyLooking$
        NEXT M
        PRINT MID$(SecondRecord$, 1, 80)
        PRINT ScreenString$
    ELSE
        PRINT
    END IF
    PRINT SPC(27); "Second record length: "; AForm.length2
    PRINT SPC(22); "Type ANALYZE /? for more information"
    END
END IF
AForm = DataFormat(FormatType)
'If the second record length was zero, this changes it to some positive number.
'This doesn't cause any problems, though, since .Length2 is not used in the
'calling subroutine.
END SUB

SUB GetResults
DIM tempResponse AS STRING, temp  AS STRING * 1, answerkey AS STRING
DIM Record AS STRING * 303, InForm AS Format, KeyForm AS Format

'   This program treats the answer key and student responses as Characters,
' rather than Integers.  It is more convenient in BASIC to input one character
' at a time, rather than one digit at a time, from a string such as "1543223".
' Total correct for a student is found by comparing response characters with
' answer key characters.  The answer key can contain embedded blanks;
' responses to such items are given in the printout, but not used in
' calculations of totals, etc.  The same applies to student responses to
' items not on the answer key.

'************************** Get Input filename ****************************
ON ERROR GOTO ErrorHandler
WhereAt = "GetResults--Input File"          'used for error handling.
CLS
COLOR 15
LOCATE 7, 1, 0                              'Set up screen
    PRINT "     Input File:"
LOCATE 10, 1
PRINT STRING$(80, 196)                      'prints a line across the screen
IF InFileName = "" THEN
    DO
        LOCATE 7, 19
        INPUT ; "", InFileName
    LOOP WHILE InFileName = ""
END IF
LOCATE 7, 19
PRINT UCASE$(InFileName);
OPEN InFileName FOR INPUT AS 1
InFileName = UCASE$(InFileName)     'Makes all caps for comparison.

'******************* Format of input file:  100 or 200 items? ***************
'The input file format may be new scanner, old scanner-100 items, or old
'scanner-200 items format.
'   OLD SCANNER:
'Determine if there are more than 100 items on the test.  The format of the
'input file varies:                   
'Under 101 items:     5 | 20 | 100  |  7  |   3    |  3     |   = 138
'                   junk|name|scores|total|subtotal|cr,lf,lf|
'
'Over  100 items:  | 20 | 125  |   3    |  75       |  7  |    3   |   3    |   =236
'                  |name|scores|cr,lf,lf|more scores|total|subtotal|cr,lf,lf|
'                           
'The last 13 characters are,e.g., "T00044  044cr,lf,lf".
'The last "lf" (linefeed) is omitted from the end of the input file.
'The extra "lf" is interpreted as the first character in the second record.
'
'These two formats are distinguished by the length of the first and second
'records.
'    NEW SCANNER:
'Record length is 303, with NAME(21) in positions 41-61 and
'responses(200) in positions 89-288
'However, at WVSC the record is setup with record length 221
'with NAME(21) in 1-21 and responses(200) in 22-221.

IF EOF(1) THEN
    LOCATE 15, 25
    COLOR 7
    PRINT "Input file is empty; goodbye."
    PALETTE
    END
END IF
LINE INPUT #1, FirstRecord$
InForm.length1 = LEN(FirstRecord$)
IF NOT EOF(1) THEN
    LINE INPUT #1, SecondRecord$
    InForm.length2 = LEN(SecondRecord$)
ELSE
    InForm.length2 = 0  'This avoids "Input past file end" for 1 record files.
END IF
'File pointer is now at start of third record.
CALL GetFormat(FirstRecord$, SecondRecord$, InForm)
NameOnKey = MID$(FirstRecord$, InForm.NameStart - InForm.Pad, InForm.NameLength)
IF InForm.Response2Length = 0 THEN
    SEEK #1, 1
    LINE INPUT #1, junk$
END IF
LOCATE 7, 19
PRINT InFileName;

'***************************** Get Output file name *********************
' The name "InFileName.OUT" is suggested.  If that was the input file name,
' then "InFileName.END is suggested.
' OutFileName contains the output file name, if it was given on the
' command line

IF OutFileName = "" OR OutFileName = InFileName THEN
    'No suitable output filename was given, so ask for one.
    'Construct a proposed output filename.
    DotPosition = INSTR(InFileName, ".")
    IF DotPosition > 0 THEN
        'Get the extension, and clip it off.
        Ending$ = RIGHT$(InFileName, LEN(InFileName) - DotPosition)
        OutFileName = LEFT$(InFileName, DotPosition - 1)
    ELSE
        OutFileName = InFileName
    END IF
    'Now add an appropriate extension.
    IF Ending$ <> "OUT" THEN
        OutFileName = OutFileName + ".OUT"
    ELSE
        OutFileName = OutFileName + ".END"
    END IF
END IF
LOCATE 8, 1
    PRINT "    Output File:"
LOCATE 8, 19
    PRINT OutFileName;
COLOR 7
ON ERROR GOTO CatchError    'A different error handler is needed to catch
                            '"file does not exist"
Exist = true
DO
    OPEN OutFileName FOR INPUT AS #3
    'If OutFileName does not exist, then CatchError changes Exist to false.
    CLOSE #3
    IF Exist THEN
        'File already exists.
        BEEP
        LOCATE 15, 1
        PRINT SPACE$(80);
        LOCATE 15, 1
        COLOR 15
        PRINT SPC(15); OutFileName; " already exists.  Overwrite [No]?  ";
        YesOrNo$ = ""
        DO
            YesOrNo$ = INKEY$
        LOOP WHILE YesOrNo$ = ""
        IF UCASE$(YesOrNo$) = "Y" THEN
            Safe = true
            LOCATE 8, 20 + LEN(OutFileName)
            PRINT "(overwrite)"
        ELSE
            LOCATE 15, 1
            PRINT SPACE$(80)
            DO
                LOCATE 8, 19
                PRINT SPACE$(80 - 19);
                LOCATE 8, 19
                INPUT ; "", OutFileName
                TryAgain = false
                IF UCASE$(OutFileName) = InFileName THEN
                    LOCATE 15, 1
                    PRINT SPACE$(80);
                    LOCATE 15, 15
                    COLOR 7
                    PRINT "Output file name must differ from input file name"
                    COLOR 15
                    TryAgain = true
                END IF
            LOOP UNTIL NOT TryAgain
            Safe = false
            'Loop and check the new file name.
        END IF
    ELSE
        'File doesn't already exist.
        Safe = true
    END IF
LOOP UNTIL Safe

'******************************** Set Up Screen *****************************
LOCATE 3, 41        'marker for F5-abort
    COLOR 8
    PRINT CHR$(17)
COLOR 15
LOCATE 8, 19
    PRINT UCASE$(OutFileName);
LOCATE 9, 1
    PRINT "Answer Key File:"
LOCATE 9, 19
IF KeyFileName = "" THEN
    PRINT InFileName;
ELSE
    PRINT KeyFileName;
END IF
LOCATE 1, 4
    PRINT "F1   Include Item Analysis"
LOCATE 2, 4
    PRINT "F2   Include Student Responses"
LOCATE 1, 44
    PRINT "F3   Include Personal Reports"
LOCATE 2, 44
    PRINT "F4   Include Discrimination Text"
LOCATE 3, 44
    PRINT "F5   Abort Now"
LOCATE 4, 44
    PRINT "F6   Wide Output"
LOCATE 5, 44
    PRINT "F7   Change Answer Key Filename"
LOCATE 6, 44
    PALETTE 1, 56
    COLOR 1
    PRINT "F8   First Input File Sheet is a Key"
EditKey = true
ScoreFirstSheet = true
CALL FKeys(1)
CALL FKeys(2)
CALL FKeys(3)
CALL FKeys(4)
CALL F6
CALL F7
CALL F8
LOCATE 15, 1
PRINT SPACE$(80);
LOCATE 15, 1, 0                             'turns off cursor
COLOR 7
PRINT SPC(25); "Set options, then press enter"
DO                                          'Set options by pressing F keys
    ch$ = INKEY$    'ch$ is two characters long when an F key is pressed.
                    'The first character is CHR$(0), the second is used below.
    SELECT CASE MID$(ch$, 2, 1)
        CASE CHR$(59)                   'F1
            CALL FKeys(1)
        CASE CHR$(60)                   'F2
            CALL FKeys(2)
        CASE CHR$(61)                   'F3
            CALL FKeys(3)
        CASE CHR$(62)                   'F4
            CALL FKeys(4)
        CASE CHR$(63)                   'F5
            LOCATE 3, 41
            COLOR 12
            PRINT CHR$(17)
            COLOR 7
            PALETTE
            END
        CASE CHR$(64)                   'F6
            CALL F6
        CASE CHR$(65)                   'F7
            CALL F7
        CASE CHR$(66)                   'F8
            CALL F8
    END SELECT
LOOP UNTIL ch$ = CHR$(13)
LOCATE 3, 41
PRINT SPACE$(18);
COLOR 15
LOCATE 15, 1                             'turns cursor back on
PRINT SPACE$(80);
IF FKeys1To4(4) = 1 THEN COLOR 7: EXIT SUB
IF EditKey THEN
    LOCATE 9, 19
    PRINT SPACE$(80 - 19)
    LOCATE 9, 19
    INPUT ; "", KeyFileName
    LOCATE 9, 19
    IF KeyFileName = "" THEN KeyFileName = InFileName
    KeyFileName = UCASE$(KeyFileName)
    PRINT KeyFileName;
END IF

'************************ Get & Read AnswerKey ******************************
' Answer Key is placed into answers(N).  Determine NumProblems.

ON ERROR GOTO ErrorHandler         'Used for error handling.
WhereAt = "GetResults--Answer Key"
IF KeyFileName <> "" THEN       'Even works when KeyFileName=InputFile
    OPEN KeyFileName FOR INPUT AS 2
    LINE INPUT #2, FirstRecordKey$
    LOCATE 15, 1
    PRINT SPACE$(80);
    LOCATE 15, 1
    IF NOT EOF(2) THEN
        LINE INPUT #2, SecondRecordKey$
    ELSE
        SecondRecordKey$ = ""
    END IF
    KeyForm.length1 = LEN(FirstRecordKey$)
    KeyForm.length2 = LEN(SecondRecordKey$)
    CALL GetFormat(FirstRecordKey$, SecondRecordKey$, KeyForm)
    CLOSE 2
    NameOnKey = MID$(FirstRecord$, KeyForm.NameStart - KeyForm.Pad, KeyForm.NameLength)
    FirstRecord$ = FirstRecordKey$
    SecondRecord$ = SecondRecordKey$
    IF ScoreFirstSheet THEN
        LOCATE 7, 19 + LEN(InFileName)
        PRINT " (First sheet will be scored)";
    END IF
ELSE            'No special answer key, so use first sheet in input file
    ScoreFirstSheet = false
    KeyForm.ResponseLength = InForm.ResponseLength
    KeyForm.ResponseStart = InForm.ResponseStart
    KeyForm.Response2Length = InForm.Response2Length
    KeyForm.Response2Start = InForm.Response2Start
    KeyForm.Pad = InForm.Pad
END IF
COLOR 7
VIEW PRINT 11 TO 24
FOR N = 1 TO KeyForm.ResponseLength
    temp = MID$(FirstRecord$, KeyForm.ResponseStart - KeyForm.Pad + N - 1, 1)
    Answers(N) = temp
    answerkey = answerkey + temp
NEXT N
IF KeyForm.Response2Length > 0 THEN
   FOR N = 1 TO KeyForm.Response2Length
        temp = MID$(SecondRecord$, KeyForm.Response2Start + N - 1, 1)
        Answers(125 + N) = temp
        answerkey = answerkey + temp
    NEXT N
END IF
ShortResponse$ = RTRIM$(answerkey)
NumProblems = LEN(ShortResponse$)       'NumProblems is number of problems,
                                        'including embedded blanks.

NullString$ = CHR$(0) + CHR$(0)
FOR N = 1 TO NumProblems
    SELECT CASE Answers(N)          'Distribution of scores in Answer Key
        CASE "1 "
            Ones = Ones + 1
        CASE "2 "
            Twos = Twos + 1
        CASE "3 "
            Threes = Threes + 1
        CASE "4 "
            Fours = Fours + 1
        CASE "5 "
            Fives = Fives + 1
        CASE "* "
            PRINT SPC(7); "Item"; N; "on answer key is *; all responses will be scored as correct."
            GuarantedRight = GuarantedRight + 1
            Answers(N) = "#  "
            'This simplifies comparisons latter.  Specifically, it prevents a
            'student's "* " from equaling an answer key "* ".
            'It is changed back to "* " in ANALYSIS for the printout.
        CASE "  ", NullString$
            PRINT SPC(7); "Item"; N; "on answer key is blank and will not be used for scoring."
            BlanksInKey = BlanksInKey + 1
        CASE ELSE
            PRINT "Unrecognized answer number"; N; "("; Answers(N); ") on key; program bombs."
            END
    END SELECT
NEXT N
ActualProblems = NumProblems - BlanksInKey

'**************************Read Score Sheets ********************************
' Student responses go into Names(M) and Response(M,N).  Determine NumStudents
' and MaxProblem, in case some responses are beyond last item on answer key.

M = 0
MaxProblem = NumProblems
IF ScoreFirstSheet THEN
    SEEK #1, 1
ELSE
    InForm.Pad = 0
END IF
IF InForm.Response2Length > 0 THEN ReadASecondRecord = true
DO WHILE NOT EOF(1)
    M = M + 1
    LINE INPUT #1, Record
   
        '********************* Get Names & Capitalize First Letters********
    Temp1$ = MID$(Record, InForm.NameStart - InForm.Pad, InForm.NameLength)
                                'Make just first letters capital in the name.
        'remove leading and trailing blanks
    Temp1$ = LCASE$(RTRIM$(LTRIM$(Temp1$)))
    startpoint = 1
    IF Temp1$ <> "" THEN 'This leaves a null string name alone.
            'capitalize the first letter
        MID$(Temp1$, 1, 1) = UCASE$(MID$(Temp1$, startpoint, 1))
    END IF
    DO
            'use blank to see if there is another word
        spot = INSTR(startpoint, Temp1$, " ")
        IF spot <> 0 THEN
                'if didn't exit, then there is another letter
                'capitalize the letter following a blank
            MID$(Temp1$, spot + 1, 1) = UCASE$(MID$(Temp1$, spot + 1))
                '(A capital blank is a blank, if blanks are together)
            startpoint = spot + 1
        END IF
    LOOP UNTIL spot = 0
    Names(M) = Temp1$

    '********************** Get Responses, Calculate Totals *****************
    tempResponse = MID$(Record, InForm.ResponseStart - InForm.Pad, InForm.ResponseLength)
    IF InForm.Pad THEN InForm.Pad = 0
    IF ReadASecondRecord THEN
        LINE INPUT #1, Record
        String2$ = MID$(Record, InForm.Response2Start, InForm.Response2Length)
        tempResponse = tempResponse + String2$
    END IF
            'MaxProblem is used to print responses beyond those on Answer Key.
    ShortResponse$ = RTRIM$(tempResponse)
    Length = LEN(ShortResponse$)
    IF Length > MaxProblem THEN MaxProblem = Length
    Total = GuarantedRight      'Free points to start with for everyone.
    FOR N = 1 TO Length
                                'Transfer responses to Response array.
        Response(M, N) = MID$(ShortResponse$, N, 1)
        Answer$ = Answers(N)
        IF Response(M, N) = Answer$ AND Answer$ <> "  " THEN
            Total = Total + 1
            Response(M, N) = "- "      'Response is stored as "- " if correct.
        END IF
    NEXT N
    StudentTotals(M) = Total
    SumX = SumX + Total
    SumXSquared& = SumXSquared& + Total * Total
LOOP
CLOSE #1
NumStudents = M
row = CSRLIN: column = POS(N)
VIEW PRINT
COLOR 15
LOCATE 4, 9
PRINT "  Number of sheets: "; NumStudents;
LOCATE 5, 9
PRINT "Number of problems: "; NumProblems;
COLOR 7
VIEW PRINT 11 TO 25
LOCATE row, column

Average = SumX / NumStudents
IF NumStudents > 1 THEN
    'Standard deviation is never used unless NumStudents is 2 or greater
    intermediate& = NumStudents * SumXSquared& - SumX * SumX
    StandardDev = SQR(intermediate& / NumStudents / (NumStudents - 1))
    OneOverStandardDev = 1 / StandardDev
ELSE
    StandardDev = 1
END IF

END SUB

SUB HappyFace (N)
'Makes yellow Happy Faces at beginning and end of subroutines.
'Calls toggle between empty and full faces.
STATIC row, column, Done
IF N > 4 THEN
    M = 52
    N = N - 2
ELSEIF N > 2 THEN           'N is the F key number; If N is 1 or 2, location
    M = 41              'is on left; 3 and 4 are on right.
    N = N - 2
ELSE
    M = 1
END IF
IF NOT Done THEN                    'First make empty happy face
    row = CSRLIN: column = POS(N)
    VIEW PRINT
    LOCATE N, M
    COLOR 14
    PRINT CHR$(1)
    Done = true
ELSE                                'Then make full happy face
    LOCATE N, M
    PRINT CHR$(2)
    VIEW PRINT 11 TO 25
    LOCATE row, column
    COLOR 7
    Done = false
END IF

END SUB

SUB Initial (Info() AS STRING)
'Reads the contents of the initialization file.  Asks to create a new file,
'\ANALYZE.INI, if no initialization file is found.

'Initialize variables
    LinesPerNormalPage = 66     '60 for HPIIP+ LaserJet; 66 for IBM Proprinter
    LinesPerWidePage = 80       '80 for green-bar computer paper
    ColumnsPerWidePage = 132
    RunKermit = true
    FKeys1To4(1) = 1
    FKeys1To4(2) = 1
    FKeys1To4(3) = 1
    FKeys1To4(4) = 1
    PrintWide = true       'F6 initialization changes to opposite
    NormalWidthGraphics = true
    Info(1) = "INFO:  The answer key can contain blanks, which are not scored, and asterisks,"
    Info(2) = "which cause all responses to be scored as correct.  (An item is marked with an "
    Info(3) = "asterisk by marking more than one response.)  If the answer key contains a"
    Info(4) = "mistake, it is not necessary to rescan the students' response sheets.  Just"
    Info(5) = "correct the key and rescan it."
    Command(1) = "cd\kermit"
    Command(2) = "kermit"
    DataFormat(1).length1 = 135
    DataFormat(1).NameStart = 7
    DataFormat(1).NameLength = 20
    DataFormat(1).ResponseStart = 27
    DataFormat(1).ResponseLength = 100
    DataFormat(1).Pad = 1
    DataFormat(1).length2 = 136
    DataFormat(1).Response2Start = 0
    DataFormat(1).Response2Length = 0
    DataFormat(2).length1 = 145
    DataFormat(2).NameStart = 2
    DataFormat(2).NameLength = 20
    DataFormat(2).ResponseStart = 22
    DataFormat(2).ResponseLength = 125
    DataFormat(2).Pad = 1
    DataFormat(2).length2 = 86
    DataFormat(2).Response2Start = 2
    DataFormat(2).Response2Length = 75
    DataFormat(3).length1 = 221
    DataFormat(3).NameStart = 1
    DataFormat(3).NameLength = 21
    DataFormat(3).ResponseStart = 22
    DataFormat(3).ResponseLength = 200
    DataFormat(3).Pad = 0
    DataFormat(3).length2 = 221
    DataFormat(3).Response2Start = 0
    DataFormat(3).Response2Length = 0
    DataFormat(4).length1 = 261
    DataFormat(4).NameStart = 41
    DataFormat(4).NameLength = 21
    DataFormat(4).ResponseStart = 62
    DataFormat(4).ResponseLength = 200
    DataFormat(4).Pad = 0
    DataFormat(4).length2 = 261
    DataFormat(4).Response2Start = 0
    DataFormat(4).Response2Length = 0
ON ERROR GOTO CatchError   'CatchError changes Exist to false if file not found.
Exist = true
IF InitFile = "" THEN InitFile = "\analyze.ini"
OPEN InitFile FOR INPUT AS 4
IF Exist THEN
    DO UNTIL EOF(4)
        'Evaluate a line at a time.  First look for an "=" sign, then take the
        'string from the begining of the line to "=" and call it Temp1$; it
        'will be the variable name.  Next look for a "'"; this indicates the
        'start of a comment.  Take the string between "=" and "'" and call it
        'Temp2$; it will be the value of the variable.
        LINE INPUT #4, Record$
        Position = INSTR(1, Record$, "=")
        IF Position > 2 THEN          'Temp1$ is before =; Temp2$ is after =
            comment = INSTR(1, Record$, "'")
            IF comment = 0 THEN comment = 150
            Temp1$ = RTRIM$(LTRIM$(MID$(Record$, 1, Position - 1)))
            Temp2$ = RTRIM$(LTRIM$(MID$(Record$, Position + 1, comment - Position - 1)))
        END IF
        IF Position OR Temp2$ = "" THEN
            SELECT CASE UCASE$(Temp1$)
                CASE "LINESPERNORMALPAGE"
                    temp = VAL(Temp2$)
                    IF temp < 201 AND temp > 24 THEN LinesPerPage = temp
                CASE "LINESPERWIDEPAGE"
                    temp = VAL(Temp2$)
                    IF temp < 201 AND temp > 24 THEN LinesPerWidePage = temp
                CASE "COLUMNSPERWIDEPAGE"
                    temp = VAL(Temp2$)
                    IF temp < 301 AND temp > 79 THEN
                        ColumnsPerWidePage = temp
                    ELSE
                        PRINT "ColumnsPerWidePage must be between 40 and 300; defaulting to 132."
                    END IF
                CASE "COMMANDLINESIFWIDEOUTPUT"
                    IF UCASE$(Temp2$) = "FALSE" THEN RunKermit = false
                CASE "F1DEFAULT"
                    SELECT CASE VAL(Temp2$)
                        CASE 0
                            FKeys1To4(1) = 2
                        CASE 1
                            FKeys1To4(1) = 1
                        CASE ELSE
                            FKeys1To4(1) = 0
                    END SELECT
                CASE "F2DEFAULT"
                    SELECT CASE VAL(Temp2$)
                        CASE 0
                            FKeys1To4(2) = 2
                        CASE 1
                            FKeys1To4(2) = 1
                        CASE ELSE
                            FKeys1To4(2) = 0
                    END SELECT
                CASE "F3DEFAULT"
                    SELECT CASE VAL(Temp2$)
                        CASE 0
                            FKeys1To4(3) = 2
                        CASE 1
                            FKeys1To4(3) = 1
                        CASE ELSE
                            FKeys1To4(3) = 0
                    END SELECT
                CASE "F4DEFAULT"
                    SELECT CASE VAL(Temp2$)
                        CASE 0
                            FKeys1To4(4) = 2
                        CASE 1
                            FKeys1To4(4) = 1
                        CASE ELSE
                            FKeys1To4(4) = 0
                    END SELECT
                CASE "F5DEFAULTPRINTWIDE"
                    IF UCASE$(Temp2$) = "TRUE" THEN PrintWide = false
                CASE "NOGRAPHICSWHENNORMALWIDTH"
                IF UCASE$(Temp2$) = "FALSE" THEN NormalWidthGraphics = true
                CASE "INFO1"
                    Info(1) = Temp2$
                CASE "INFO2"
                    Info(2) = Temp2$
                CASE "INFO3"
                    Info(3) = Temp2$
                CASE "INFO4"
                    Info(4) = Temp2$
                CASE "INFO5"
                    Info(5) = Temp2$
                CASE "COMMANDLINE1"
                    Command(1) = Temp2$
                CASE "COMMANDLINE2"
                    Command(2) = Temp2$
                CASE "FORMAT1LENGTH1"
                    DataFormat(1).length1 = VAL(Temp2$)
                CASE "FORMAT1NAMESTART"
                    DataFormat(1).NameStart = VAL(Temp2$)
                CASE "FORMAT1NAMELENGTH"
                    DataFormat(1).NameLength = VAL(Temp2$)
                CASE "FORMAT1RESPONSESTART"
                    DataFormat(1).ResponseStart = VAL(Temp2$)
                CASE "FORMAT1RESPONSELENGTH"
                    DataFormat(1).ResponseLength = VAL(Temp2$)
                CASE "FORMAT1SHORTFIRST"
                    DataFormat(1).Pad = VAL(Temp2$)
                CASE "FORMAT1LENGTH2"
                    DataFormat(1).length2 = VAL(Temp2$)
                CASE "FORMAT1RESPONSE2START"
                    DataFormat(1).Response2Start = VAL(Temp2$)
                CASE "FORMAT1RESPONSE2LENGTH"
                    DataFormat(1).Response2Length = VAL(Temp2$)
                CASE "FORMAT2LENGTH1"
                    DataFormat(2).length1 = VAL(Temp2$)
                CASE "FORMAT2NAMESTART"
                    DataFormat(2).NameStart = VAL(Temp2$)
                CASE "FORMAT2NAMELENGTH"
                    DataFormat(2).NameLength = VAL(Temp2$)
                CASE "FORMAT2RESPONSESTART"
                    DataFormat(2).ResponseStart = VAL(Temp2$)
                CASE "FORMAT2RESPONSELENGTH"
                    DataFormat(2).ResponseLength = VAL(Temp2$)
                CASE "FORMAT2SHORTFIRST"
                    DataFormat(2).Pad = VAL(Temp2$)
                CASE "FORMAT2LENGTH2"
                    DataFormat(2).length2 = VAL(Temp2$)
                CASE "FORMAT2RESPONSE2START"
                    DataFormat(2).Response2Start = VAL(Temp2$)
                CASE "FORMAT2RESPONSE2LENGTH"
                    DataFormat(2).Response2Length = VAL(Temp2$)
                CASE "FORMAT3LENGTH1"
                    DataFormat(3).length1 = VAL(Temp2$)
                CASE "FORMAT3NAMESTART"
                    DataFormat(3).NameStart = VAL(Temp2$)
                CASE "FORMAT3NAMELENGTH"
                    DataFormat(3).NameLength = VAL(Temp2$)
                CASE "FORMAT3RESPONSESTART"
                    DataFormat(3).ResponseStart = VAL(Temp2$)
                CASE "FORMAT3RESPONSELENGTH"
                    DataFormat(3).ResponseLength = VAL(Temp2$)
                CASE "FORMAT3SHORTFIRST"
                    DataFormat(3).Pad = VAL(Temp2$)
                CASE "FORMAT3LENGTH2"
                    DataFormat(3).length2 = VAL(Temp2$)
                CASE "FORMAT3RESPONSE2START"
                    DataFormat(3).Response2Start = VAL(Temp2$)
                CASE "FORMAT3RESPONSE2LENGTH"
                    DataFormat(3).Response2Length = VAL(Temp2$)
                CASE "FORMAT4LENGTH1"
                    DataFormat(4).length1 = VAL(Temp2$)
                CASE "FORMAT4NAMESTART"
                    DataFormat(4).NameStart = VAL(Temp2$)
                CASE "FORMAT4NAMELENGTH"
                    DataFormat(4).NameLength = VAL(Temp2$)
                CASE "FORMAT4RESPONSESTART"
                    DataFormat(4).ResponseStart = VAL(Temp2$)
                CASE "FORMAT4RESPONSELENGTH"
                    DataFormat(4).ResponseLength = VAL(Temp2$)
                CASE "FORMAT4SHORTFIRST"
                    DataFormat(4).Pad = VAL(Temp2$)
                CASE "FORMAT4LENGTH2"
                    DataFormat(4).length2 = VAL(Temp2$)
                CASE "FORMAT4RESPONSE2START"
                    DataFormat(4).Response2Start = VAL(Temp2$)
                CASE "FORMAT4RESPONSE2LENGTH"
                    DataFormat(4).Response2Length = VAL(Temp2$)
                CASE ELSE
                    PRINT "Unrecognized variable in .ini file:  "; Temp1$; " = "; Temp2$
                    PRINT "Press any key to continue"
                    DO
                        ch$ = INKEY$
                    LOOP WHILE ch$ = ""
            END SELECT
        END IF
    LOOP
    CLOSE 4
ELSE
    CLS
    PRINT "Initialization file not found; create a new one? (Y/N)";
    DO
        ch$ = INKEY$
    LOOP WHILE ch$ = ""
    IF UCASE$(ch$) = "Y" THEN
        OPEN "\analyze.ini" FOR OUTPUT AS 4
        PRINT #4, "F1Default = 1  ' 0 = no item analysis    1 = analysis     2 = analysis only"
        PRINT #4, "F2Default = 1  ' 0 = no personal reports 1 = make reports 2 = reports only"
        PRINT #4, "F3Default = 1  ' 0 = no responses        1 = responses    2 = responses only"
        PRINT #4, "F4Default = 1  ' 0 = no text             1 = text         2 = text only"
        PRINT #4, "F5DefaultPrintWide = false        ' if true then wide output is default"
        PRINT #4, "LinesPerNormalPage = 66           ' valid numbers are 25 to 200"
        PRINT #4, "NoGraphicsWhenNormalWidth = false ' true if can't print extended characters."
        PRINT #4, "LinesPerWidePage = 80             ' valid numbers are 25 to 200"
        PRINT #4, "ColumnsPerWidePage = 132          ' valid numbers are 80 to 300"
        PRINT #4, "CommandLinesIfWideOutput = true   ' If false, prints wide on default printer"
        PRINT #4, "CommandLine1 = cd\kermit"
        PRINT #4, "CommandLine2 = kermit"
        PRINT #4, "Info1 = "; Info(1)
        PRINT #4, "Info2 = "; Info(2)
        PRINT #4, "Info3 = "; Info(3)
        PRINT #4, "Info4 = "; Info(4)
        PRINT #4, "Info5 = "; Info(5)
        PRINT #4, "     ' Sentry 7001, under-a-hundred format"
        PRINT #4, "Format1Length1 = 135"
        PRINT #4, "Format1Length2 = 136"
        PRINT #4, "Format1NameStart = 7"
        PRINT #4, "Format1NameLength = 20"
        PRINT #4, "Format1ResponseStart = 27"
        PRINT #4, "Format1ResponseLength = 100"
        PRINT #4, "Format1ShortFirst = 1  ' set to 1 if each record ends with lf lf"
        PRINT #4, "' Double linefeed causes all records after first to have lf as first character."
        PRINT #4, "Format1Response2Start = 0 "
        PRINT #4, "Format1Response2Length = 0   ' if not 0, causes a second record to be read."
        PRINT #4, "     ' Sentry 7001, over-a-hundred format"
        PRINT #4, "Format2Length1 = 145"
        PRINT #4, "Format2Length2 = 86"
        PRINT #4, "Format2NameStart = 2"
        PRINT #4, "Format2NameLength = 20"
        PRINT #4, "Format2ResponseStart = 22"
        PRINT #4, "Format2ResponseLength = 125"
        PRINT #4, "Format2ShortFirst = 1  ' set to 1 if each record ends with lf lf"
        PRINT #4, "Format2Response2Start = 2 "
        PRINT #4, "Format2Response2Length = 75   ' if not 0, causes a second record to be read."
        PRINT #4, "     ' OPSCAN 5, their filename.sdf format (single delimiter format)"
        PRINT #4, "Format3Length1 = 221"
        PRINT #4, "Format3Length2 = 221"
        PRINT #4, "Format3NameStart = 1"
        PRINT #4, "Format3NameLength = 21"
        PRINT #4, "Format3ResponseStart = 22"
        PRINT #4, "Format3ResponseLength = 200"
        PRINT #4, "Format3ShortFirst = 0  ' set to 1 if each record ends with lf lf"
        PRINT #4, "Format3Response2Start = 0 "
        PRINT #4, "Format3Response2Length = 0   ' if not 0, causes a second record to be read."
        PRINT #4, "     ' OPSCAN 5, their filename.dat format"
        PRINT #4, "Format4Length1 = 261"
        PRINT #4, "Format4Length2 = 261"
        PRINT #4, "Format4NameStart = 41"
        PRINT #4, "Format4NameLength = 21"
        PRINT #4, "Format4ResponseStart = 62"
        PRINT #4, "Format4ResponseLength = 200"
        PRINT #4, "Format4ShortFirst = 0  ' set to 1 if each record ends with lf lf"
        PRINT #4, "Format4Response2Start = 0 "
        PRINT #4, "Format4Response2Length = 0   ' if not 0, causes a second record to be read."
        CLOSE 4
        PRINT "Initial parameters saved in ANALYZE.INI in root directory"
        PRINT "Press any key to continue"
        DO
        LOOP WHILE INKEY$ = ""
    END IF
END IF
END SUB

SUB ItemAnalysis (Info() AS STRING)
'************************** Print Item Analysis *****************************
' Limit is used to flag items frequently missed
' Distribution of discrimination is in NetD1 - NetD6.  The intermediate total
' is in NetDTotal!.
' Distribution of student responses by letter is in TotalA&, TotalB&, TotalC&,
' TotalD&, TotalE&, and TotalBlank& (These all have to be long integer).
CALL HappyFace(1)
RelStandDev! = (Average - StandardDev * 2.5) / ActualProblems
IF RelStandDev! < .3 THEN
    Limit = NumStudents * .3
ELSE
    Limit = RelStandDev! * NumStudents
END IF

' The function DiscrimError! returns the 90% confidence
' interval (0 +/- rIsZero) for r being zero.
IF NumStudents > 3 THEN rIsZero! = DiscrimError!
AnyDiscrimFlagged = false
    CALL PageHeader
PRINT #3, "                                ITEM ANALYSIS"
PRINT #3,
PRINT #3, "       Correct               Distribution        Answer      Discrimination"
'PRINT #3, "     ----------     -----------------------------  on -------------------------"
PRINT #3, "     "; STRING$(10, Dash); "     "; STRING$(29, Dash); "  on "; STRING$(25, Dash)
PRINT #3, "Item   %     #        A    B    C    D    E Blank Key NetD   A   B   C   D   E"
LineNum = LineNum + 4
IF PrintWide THEN
        CALL PageHeader
    PRINT #3,
END IF
FOR N = 1 TO NumProblems
    CALL PageHeader
    PRINT #3, USING "###"; N;
                                'Flag problems with few correct responses
    IF NumStudents > 4 AND Answers(N) <> "  " THEN
        IF Answers(N) <> "* " THEN
            IF ItemTotals(N) < Limit THEN
                PRINT #3, "*";
            ELSE
                PRINT #3, " ";
            END IF
          
            ' Flag misunderstood items and divide Discrimination values by sigma.
            ' Items are "misunderstood" if at least two items have positive
            ' discriminations.
            DiscrimCheck = false
            RightAnswer = VAL(Answers(N))
            FOR J = 1 TO 5
                Discrim! = Discrimination(N, J)
                IF Discrim! > rIsZero! AND J <> RightAnswer THEN
                    DiscrimCheck = true
                    AnyDiscrimFlagged = true
                ELSEIF Discrim! < -rIsZero! AND J = RightAnswer THEN
                    DiscrimCheck = true
                    AnyDiscrimFlagged = true
                END IF
            NEXT J
            ' Net Discrimination (NetD!) is discrimination of the correct answer.
            NetD! = Discrimination(N, RightAnswer)
            IF DiscrimCheck THEN
                PRINT #3, "#";
            ELSE
                PRINT #3, " ";
            END IF
        ELSE
            NetD! = 0
            PRINT #3, "  ";
        END IF
        SELECT CASE NetD!   'While here, calculate NetD distribution
            CASE IS < 0
                NetD1 = NetD1 + 1
            CASE IS < .2
                NetD2 = NetD2 + 1
            CASE IS < .4
                NetD3 = NetD3 + 1
            CASE IS < .6
                NetD4 = NetD4 + 1
            CASE IS < .8
                NetD5 = NetD5 + 1
            CASE ELSE
                NetD6 = NetD6 + 1
        END SELECT
    ELSE
        PRINT #3, "  ";
    END IF
       
    PRINT #3, USING "###.#  "; ItemTotals(N) / NumStudents * 100;
    PRINT #3, USING "###     "; ItemTotals(N);
    IF A(N) <> 0 THEN PRINT #3, USING "###  "; A(N);  ELSE PRINT #3, "  -  ";
    IF B(N) <> 0 THEN PRINT #3, USING "###  "; B(N);  ELSE PRINT #3, "  -  ";
    IF C(N) <> 0 THEN PRINT #3, USING "###  "; C(N);  ELSE PRINT #3, "  -  ";
    IF D(N) <> 0 THEN PRINT #3, USING "###  "; D(N);  ELSE PRINT #3, "  -  ";
    IF E(N) <> 0 THEN PRINT #3, USING "###  "; E(N);  ELSE PRINT #3, "  -  ";
    IF Blank(N) <> 0 THEN PRINT #3, USING "###   "; Blank(N);  ELSE PRINT #3, "      ";
    SELECT CASE Answers(N)
        CASE "1 "
            letter$ = "A"
        CASE "2 "
            letter$ = "B"
        CASE "3 "
            letter$ = "C"
        CASE "4 "
            letter$ = "D"
        CASE "5 "
            letter$ = "E"
        CASE "  "
            letter$ = "Blank"
        CASE "* "
            letter$ = "*"
        CASE ELSE
            letter$ = "boo-boo"
    END SELECT
    PRINT #3, USING "&"; letter$;

    IF NumStudents > 6 THEN
        IF Answers(N) <> "  " THEN
            'Print Discrimination in appropriate format
            IF NetD! < -.99 OR NetD! > .99 THEN
                PRINT #3, USING " ##  "; NetD!;
            ELSEIF NetD! = 0 THEN
                PRINT #3, "   0 ";
            ELSE
                IF NetD! < 0 THEN
                    PRINT #3, USING " +.##"; NetD!;
                ELSE         'No sign if positive
                    PRINT #3, USING "  .##"; NetD!;
                END IF
            END IF
        ELSE
            NetD! = 0
            PRINT #3, " ";
        END IF

        FOR J = 1 TO 5
            SELECT CASE J
            CASE 1
                L = A(N)
                PRINT #3, " ";
            CASE 2
                L = B(N)
            CASE 3
                L = C(N)
            CASE 4
                L = D(N)
            CASE 5
                L = E(N)
            END SELECT
            IF L <> 0 THEN
                Discrim! = Discrimination(N, J)
                IF Discrim! = -1 OR Discrim! = 1 THEN
                    PRINT #3, USING "  ##"; Discrim!;
                ELSEIF Discrim! = 0 THEN
                    PRINT #3, "   0";
                ELSE
                    IF Discrim! < 0 THEN
                        IF Discrim! < -.95 THEN
                            PRINT #3, USING " +#."; Discrim!;
                        ELSE
                            PRINT #3, USING " +.#"; Discrim!;
                        END IF
                    ELSE
                        IF Discrim! > .95 THEN
                            PRINT #3, USING "  #."; Discrim!;
                        ELSE
                            PRINT #3, USING "  .#"; Discrim!;
                        END IF
                    END IF
                END IF
            ELSE PRINT #3, "    ";
            END IF
        NEXT J
        NetDTotal! = NetDTotal! + NetD!
    END IF
    PRINT #3,
    IF PrintWide THEN
            CALL PageHeader
        PRINT #3,
    END IF

    TotalA& = TotalA& + A(N)
    TotalB& = TotalB& + B(N)
    TotalC& = TotalC& + C(N)
    TotalD& = TotalD& + D(N)
    TotalE& = TotalE& + E(N)
    TotalBlank& = TotalBlank& + Blank(N)
NEXT N
      
    CALL PageHeader
PRINT #3, "*The most difficult problems."
IF AnyDiscrimFlagged THEN
        CALL PageHeader
    PRINT #3, "#A wrong answer was chosen significantly more often by high-scoring students"
        CALL PageHeader
    PRINT #3, "than by low-scoring students."
END IF
'********************** Print Distribution of Answers on Answer Key *********
IF LineNum > (LinesPerPage - 18) THEN
    '17 or 18 lines needed for rest of Item Analysis.  Start on a new page if not
    'enough lines to finish.
    FOR N = 0 TO (LinesPerPage - LineNum)
        PRINT #3,
    NEXT N
    LineNum = LinesPerPage + 1
END IF
    CALL PageHeader                     'Start on a new page
PRINT #3,
    CALL PageHeader
PRINT #3, "                                     A's    B's    C's    D's    E's   Blank"
    CALL PageHeader
PRINT #3, "Distribution of Answers on Key:     ";
PRINT #3, USING "##.#%  "; Ones / NumProblems * 100; Twos / NumProblems * 100;
PRINT #3, USING "##.#%  "; Threes / NumProblems * 100; Fours / NumProblems * 100;

IF Fives = 0 THEN
    PRINT #3, "  -    ";
ELSE
PRINT #3, USING "##.#%  "; Fives / NumProblems * 100;
END IF
IF BlanksInKey = 0 THEN
    PRINT #3, "  -"
ELSE
    PRINT #3, USING "##.##%"; BlanksInKey / NumProblems * 100
END IF
GrandTotal& = TotalA& + TotalB& + TotalC& + TotalD& + TotalE& + TotalBlank&
    CALL PageHeader
PRINT #3, "Distribution of Student Responses:  ";
PRINT #3, USING "##.#%  "; TotalA& / GrandTotal& * 100; TotalB& / GrandTotal& * 100;
PRINT #3, USING "##.#%  "; TotalC& / GrandTotal& * 100; TotalD& / GrandTotal& * 100;

IF TotalE& = 0 THEN
    PRINT #3, "  -    ";
ELSE
    PRINT #3, USING "##.#%  "; TotalE& / GrandTotal& * 100;
END IF
IF TotalBlank& = 0 THEN
    PRINT #3, "  -"
ELSE
    PRINT #3, USING "##.##%  "; TotalBlank& / GrandTotal& * 100
END IF
IF BadResponses <> 0 THEN
        CALL PageHeader
    PRINT #3, "Student responses with more than one answer marked (indicated by "; CHR$(34); "?"; CHR$(34); "):  "; BadResponses
END IF
'******************** Print Reliability & Discrimination ********************
IF NumStudents > 6 THEN
        CALL PageHeader
    PRINT #3,
      
    'Confidence Interval from reliability is discussed in "Basic Statistical
    'Concepts", by A.E. Bartz(1981).
    ConfInterval95! = 1.96 * StandardDev * SQR(1 - reliability)
        CALL PageHeader
    PRINT #3, "95% Confidence interval for a student's "; CHR$(34); "true ability"; CHR$(34); ":  +/-";
    PRINT #3, USING "##"; ConfInterval95!;
    PRINT #3, USING " (or +/-##%) "; ConfInterval95! / ActualProblems * 100
        CALL PageHeader
    PRINT #3, USING "from the current score, based on Reliability (Kuder-Richardson Method):  #.##"; reliability
        CALL PageHeader
    PRINT #3,
    NetD1 = NetD1 / ActualProblems * 100
    NetD2 = NetD2 / ActualProblems * 100
    NetD3 = NetD3 / ActualProblems * 100
    NetD4 = NetD4 / ActualProblems * 100
    NetD5 = NetD5 / ActualProblems * 100
    NetD6 = NetD6 / ActualProblems * 100
        CALL PageHeader
    PRINT #3, SPC(28); "-1<0     0<.2   .2<.4   .4<.6   .6<.8   .8<1"
        CALL PageHeader
    PRINT #3, "      NetD Distribution:";
    PRINT #3, USING "     ##%"; NetD1; NetD2; NetD3; NetD4; NetD5; NetD6
        CALL PageHeader
    PRINT #3, "      Average Net Discrimination: ";
    PRINT #3, USING "##.##"; NetDTotal! / ActualProblems
        CALL PageHeader
    PRINT #3, USING "      90% Confidence interval for a discrimination of zero:  +.## "; -rIsZero!;
    PRINT #3, USING "to .##"; rIsZero!
        CALL PageHeader
    PRINT #3,
        CALL PageHeader
    PRINT #3, "Item discrimination, NetD, is the square of the correlation coefficient between"
        CALL PageHeader
    PRINT #3, "test scores and an item score.  It is scaled to range from -1 to +1.  A negative"
        CALL PageHeader
    PRINT #3, "discrimination means more low-scoring students chose a response than did high-"
        CALL PageHeader
    PRINT #3, "scoring students."
END IF
IF LinesPerPage - LineNum > 5 THEN      'Only prints if there is free space
        PageHeader
    PRINT #3,
    FOR K = 1 TO 5
        PageHeader
        PRINT #3, Info(K)
    NEXT K
END IF
IF LineNum > 3 THEN                             'Start at the top of a page
    FOR N = 0 TO (LinesPerPage - LineNum)       'by moving to near bottom
            CALL PageHeader
        PRINT #3,
    NEXT N
END IF
CALL HappyFace(1)
END SUB

SUB PageHeader
' This subroutine keeps track of what line on the page is being printed and
' gives each page a header consisting of a page number and the name on the
' answer key.
'****** To use:  Call PageHeader before each print statement. ***************
'
'The linenumber is kept updated.
'       Before calling:  linenumber is the line that will next be printed;
'        After calling:  linenumber is the linenumber after printing one line.
STATIC PageNum, TheString$, MadeStringYet
IF LineNum <= LinesPerPage THEN
   LineNum = LineNum + 1       'This line is all that is usually executed.
ELSEIF LineNum = 2 * LinesPerPage THEN
'This allows the first page to not have a header and still have the second
'pagenumber be two.  This is done by:
'                        LineNum=LinesPerPage*2
'                        Call PageHeader
'Note that in this case the Linenumber is not incremented.
    PageNum = 1
    LineNum = 0
ELSE
    LineNum = 3
    IF NOT MadeStringYet THEN         'initialize page heading string
        Some = 36 - LEN(InFileName)
        TheString$ = "  " + InFileName + "   " + NameOnKey + SPACE$(Some) + DATE$
        MadeStringYet = true
    END IF
    PageNum = PageNum + 1
    PRINT #3, USING "Page ###"; PageNum;
    PRINT #3, TheString$
END IF

END SUB

SUB PersonalPrint
DIM Lines(4) AS STRING, AnswerString(4) AS STRING, Max(0 TO 4)

'Prints a "Tab" that can be cut and given to students.  It looks like this:
'
'Baire   Karla           Score:  98 out of 159 (61.6%)
'                         5   10    5   20    5   30    5   40    5   50    5   60    5   70    5   80    5   90    5  100
'       Your answer:  4-5--34-35----3---5-1 --41-11-41--1-11-2-1--11------2-1---21----111------------1---23--------------5
'     Answer on key:  5133251351235443314122425245243212222211221122122211122112122111222211211112121224132534251425134321
'
'                         5  110    5  120    5  130    5  140    5  150    5
'       Your answer:  1-------133--1---1--4-5-----5-3-1---415-4-4-224-2-434112-1-
'     Answer on key:  53512411222212122223312312224322433132332311412313211231334
'
'
'Next Student            Score:  67 out of 159 (42.1%)

CALL HappyFace(3)

NumberOfProblems = MaxProblem
IF PrintWidth < 121 THEN        'Determine which of 2 formats to use.
    ProblemsPerLine = 60    'Must be a multiple of five
    OtherLines = 1
ELSE
    ProblemsPerLine = 100
    OtherLines = 2
END IF

'Decide what to do if extra lines would be printed because a student marked
'answers beyond the end of the answer key.
ExtraLines = 4 * (MaxProblem \ ProblemsPerLine - NumProblems \ ProblemsPerLine)
IF ExtraLines THEN
    BEEP
    PRINT "         NOTE:  A student has marked item"; MaxProblem; "which is not on the key."
    PRINT "         This will lengthen the score tabs of each student by"; ExtraLines; "lines."
    PRINT "             1)  That's OK; continue."
    PRINT "             2)  Limit the score tabs to problems on the answer key."
    PRINT "             3)  Don't make any score tabs."
    COLOR 15
    PRINT SPC(28); "What should be done [1]?  ";
    COLOR 7
    DO
    ch$ = INKEY$
    LOOP WHILE ch$ = ""
    IF ASC(ch$) = 13 THEN ch$ = "1"
    PRINT
    SELECT CASE ch$
        CASE "1"
            PRINT SPC(34); "Continuing"
        CASE "2"
            NumberOfProblems = NumProblems
            PRINT SPC(21); "Score tabs limited to problems on key"
        CASE ELSE
            PRINT SPC(27); "No score tabs will be made"
            EXIT SUB
    END SELECT
END IF

    'Figure out how many lines each score tab (plus a blank line) will take.
NumberOfSets = (NumberOfProblems - 1) \ ProblemsPerLine + 1
LinesInAllSets = OtherLines + 4 * NumberOfSets

'Prepare strings that will be the same for each score tab.  Set Max() values.

Line1$ = "    5   10    5   20    5   30    5   40    5   50    5   60"
Line2$ = "    5   70    5   80    5   90    5  100    5  110    5  120"
Line3$ = "    5  130    5  140    5  150    5  160    5  170    5  180"
Line4$ = "    5  190    5  200"
BigLine$ = Line1$ + Line2$ + Line3$ + Line4$

Max(0) = 0
FOR K = 1 TO NumberOfSets
    IF NumberOfProblems > ProblemsPerLine * K THEN
        Max(K) = ProblemsPerLine * K
    ELSE
        Max(K) = NumberOfProblems
    END IF
   
    Length = 5 * ((Max(K) - Max(K - 1)) \ 5)
    Lines(K) = SPACE$(20) + MID$(BigLine$, Max(K - 1) + 1, Length)
    Lines(K) = RTRIM$(Lines(K)) 'test

    AnswerString(K) = "    Answer on key:  "
    FOR M = Max(K - 1) + 1 TO Max(K)
        AnswerString(K) = AnswerString(K) + LEFT$(Answers(M), 1)
    NEXT M
NEXT K

                                    'Make the scores tabs.
FOR N = 1 TO NumStudents
    CALL PageHeader                 'Print Header if needed
    IF LineNum = 3 THEN             'If Header printed, add a blank line.
        PRINT #3,
        CALL PageHeader
    END IF
    Index = AlphaIndex(N)
    PRINT #3, USING "& "; Names(Index);
    PRINT #3, TAB(27); "Score: "; StudentTotals(Index); "out of"; ActualProblems;
    PRINT #3, USING "(##.#%)"; StudentTotals(Index) / ActualProblems * 100
    FOR K = 1 TO NumberOfSets
        PRINT #3, Lines(K)
        PRINT #3, SPC(6); "Your answer:  ";
        FOR M = Max(K - 1) + 1 TO Max(K)
            PRINT #3, LEFT$(Response(Index, M), 1);
        NEXT M
        PRINT #3,
        PRINT #3, AnswerString(K)
        PRINT #3,
    NEXT K
    IF PrintWide THEN PRINT #3,     'An extra blank line for green-bar paper
    LineNum = LineNum + LinesInAllSets - 1  '-1 since called pageheader once
    IF LineNum > (LinesPerPage - LinesInAllSets) THEN
        FOR L = 0 TO (LinesPerPage - LineNum)
            'LineNum = LineNum + 1
            PRINT #3,
        NEXT L
        LineNum = LinesPerPage + 1  'Sets PageHeader to make a new page.
    END IF
NEXT N
IF LineNum < LinesPerPage THEN
    FOR L = 0 TO (LinesPerPage - LineNum)
        PRINT #3,
    NEXT L
    LineNum = LinesPerPage + 1  'Sets PageHeader to make a new page.
END IF

CALL HappyFace(3)

END SUB

SUB PrintOut
DIM Percent(10)

HappyFace (5)
COLOR 15
'LOCATE 3, 49
LOCATE 3, 55
PRINT "Basic PrintOut";
COLOR 14

LineNum = LinesPerPage * 2
CALL PageHeader     'This starts pageheaders on page 2
'***************** Print Name, Score in Numeric & Alphabetical Order ********
' Distribution of scores is in Percent(1 to 10).
' SumOfDevSquared is intermediate result for calculating standard deviation.

PRINT #3, "Name on Answer Key:  "; NameOnKey; TAB(44); "Number of Sheets Graded: "; NumStudents
PRINT #3,
PRINT #3, "Arranged by Score                        Arranged Alphabetically"
PRINT #3, "                    CORRECT ANSWERS                          CORRECT ANSWERS"
PRINT #3, "Name                number  percent      Name                number  percent"
PRINT #3, STRING$(35, Dash); "      "; STRING$(35, Dash)
LineNum = 7     'That's the number after printing six lines.
        'numindex and alphaindex are the sorting arrays returned by QuickSort.
HighestScore = 0
LowestScore = NumProblems
FOR N = 1 TO NumStudents
    CALL PageHeader
    PRINT #3, USING "&"; Names(NumIndex(N));
    PRINT #3, USING "####"; StudentTotals(NumIndex(N));
        'Embedded blanks aren't used to calculate score
    PRINT #3, USING "   ###.#"; StudentTotals(NumIndex(N)) / ActualProblems * 100;
    PRINT #3, USING "        &"; Names(AlphaIndex(N));
    PRINT #3, USING "####"; StudentTotals(AlphaIndex(N));
    PRINT #3, USING "   ###.#"; StudentTotals(AlphaIndex(N)) / ActualProblems * 100
    RealNumber! = StudentTotals(N) / ActualProblems * 100
    SELECT CASE RealNumber!   'Get distribution of Totals
        CASE IS <= 10!
            Percent(1) = Percent(1) + 1
        CASE IS <= 20!
            Percent(2) = Percent(2) + 1
        CASE IS <= 30!
            Percent(3) = Percent(3) + 1
        CASE IS <= 40!
            Percent(4) = Percent(4) + 1
        CASE IS <= 50!
            Percent(5) = Percent(5) + 1
        CASE IS <= 60!
            Percent(6) = Percent(6) + 1
        CASE IS <= 70!
            Percent(7) = Percent(7) + 1
        CASE IS <= 80!
            Percent(8) = Percent(8) + 1
        CASE IS <= 90!
            Percent(9) = Percent(9) + 1
        CASE ELSE
            Percent(10) = Percent(10) + 1
    END SELECT
    IF StudentTotals(N) > HighestScore THEN HighestScore = StudentTotals(N)
    IF StudentTotals(N) < LowestScore THEN LowestScore = StudentTotals(N)
    IF PrintWide THEN
        IF N < NumStudents THEN
                CALL PageHeader
            PRINT #3,
        END IF
    END IF
NEXT N

'*********************** Print Average and Score Distribution **************
    CALL PageHeader
PRINT #3, STRING$(33, Dash)
    CALL PageHeader
PRINT #3, "           Average:  ";
PRINT #3, USING "###.# "; Average;
PRINT #3, USING "###.#%"; Average / ActualProblems * 100
    CALL PageHeader
PRINT #3, "     Highest Score:  ";
PRINT #3, USING "###   "; HighestScore;
PRINT #3, USING "###.#%"; HighestScore / ActualProblems * 100
    CALL PageHeader
PRINT #3, "      Lowest Score:  ";
PRINT #3, USING "###   "; LowestScore;
PRINT #3, USING "###.#%"; LowestScore / ActualProblems * 100
IF NumStudents > 4 THEN
    CALL PageHeader
    PRINT #3, "Standard Deviation:   ";
    PRINT #3, USING "##.# "; StandardDev;
    PRINT #3, USING "###.#%"; StandardDev / ActualProblems * 100
END IF
CALL PageHeader
PRINT #3, USING "Number of Problems:  ###"; ActualProblems
CALL PageHeader
PRINT #3,
                           
'******************** Print Graph of Distribution of Scores *****************
Maxinterval = 0
FOR N = 1 TO 10
        IF Percent(N) > Maxinterval THEN Maxinterval = Percent(N)
NEXT N
IF LineNum > (LinesPerPage - 11) THEN    '11 lines Needed for Distribution
    FOR N = 0 TO (LinesPerPage - LineNum)
        PRINT #3,
    NEXT N
    LineNum = LinesPerPage + 1
END IF
CALL PageHeader                     'Start on a new page
PRINT #3, "                    Relative Distribution of Scores"
FOR N = 10 TO 100 STEP 10
     PRINT #3, USING "###"; Percent(N \ 10);
     PRINT #3, USING "     ## - "; N - 10;
     PRINT #3, USING "###% "; N;
     PRINT #3, LEFT$("******************************************", Percent(N \ 10) / Maxinterval * 42)
NEXT N

LineNum = LineNum + 10
LinesToPrint = LinesPerPage - LineNum
FOR N = 0 TO LinesToPrint
    PRINT #3,
    LineNum = LineNum + 1
NEXT N
'Ready to print on first line of a page; PageHeader needs to be called next.
HappyFace (5)
END SUB

' ============================== QuickSort ===================================
'   QuickSort works by picking a random "pivot" element in SortArray, then
'   moving every element that is bigger to one side of the pivot, and every
'   element that is smaller to the other side.  QuickSort is then called
'   recursively with the two subdivisions created by the pivot.  Once the
'   number of elements in a subdivision reaches two, the recursive calls end
'   and the array is sorted.
' ============================================================================
'
'        array      pivot      swap     return                        done
'        54321 --> 54|321 --> 321|54    321|45                       12345
'                                 \    /      \                     /
'                                recursive     pivot    swap      /
'                                  call        3|21 --> 21|3   123
'                                   45                     \  /
'                                                          12
'
SUB QuickSort1 (Low, High)      'This is a numeric sort.
   IF Low < High THEN

      ' Only two elements in this subdivision; swap them if they are out of
      ' order, then end recursive calls:
      IF High - Low = 1 THEN
         IF StudentTotals(NumIndex(Low)) > StudentTotals(NumIndex(High)) THEN
            SWAP NumIndex(Low), NumIndex(High)
         END IF
      ELSE

         ' Pick a pivot element at random, then move it to the end:
         RandIndex = RandInt%(Low, High)
         SWAP NumIndex(High), NumIndex(RandIndex)
         partitionInt = StudentTotals(NumIndex(High))
         DO

            ' Move in from both sides towards the pivot element:
            I = Low: J = High
            DO WHILE (I < J) AND (StudentTotals(NumIndex(I)) <= partitionInt)
               I = I + 1
            LOOP
            DO WHILE (J > I) AND (StudentTotals(NumIndex(J)) >= partitionInt)
               J = J - 1
            LOOP

            ' If we haven't reached the pivot element, it means that two
            ' elements on either side are out of order, so swap them:
            IF I < J THEN
               SWAP NumIndex(I), NumIndex(J)
            END IF
         LOOP WHILE I < J

         ' Move the pivot element back to its proper place in the array:
         SWAP NumIndex(I), NumIndex(High)

         ' Recursively call the QuickSort procedure (pass the smaller
         ' subdivision first to use less stack space):
         IF (I - Low) < (High - I) THEN
            QuickSort1 Low, I - 1
            QuickSort1 I + 1, High
         ELSE
            QuickSort1 I + 1, High
            QuickSort1 Low, I - 1
         END IF
      END IF
   END IF
END SUB

' ============================== QuickSort ===================================
'   QuickSort works by picking a random "pivot" element in SortArray, then
'   moving every element that is bigger to one side of the pivot, and every
'   element that is smaller to the other side.  QuickSort is then called
'   recursively with the two subdivisions created by the pivot.  Once the
'   number of elements in a subdivision reaches two, the recursive calls end
'   and the array is sorted.
' ============================================================================
'
SUB QuickSort2 (Low, High)      'This is an alphabetical sort.
DIM partitionIntS AS STRING * 20
   IF Low < High THEN

      ' Only two elements in this subdivision; swap them if they are out of
      ' order, then end recursive calls:
      IF High - Low = 1 THEN
         IF Names(AlphaIndex(Low)) > Names(AlphaIndex(High)) THEN
            SWAP AlphaIndex(Low), AlphaIndex(High)
         END IF
      ELSE

         ' Pick a pivot element at random, then move it to the end:
         RandIndex = RandInt%(Low, High)
         SWAP AlphaIndex(High), AlphaIndex(RandIndex)
         partitionIntS = Names(AlphaIndex(High))
         DO

            ' Move in from both sides towards the pivot element:
            I = Low: J = High
            DO WHILE (I < J) AND (Names(AlphaIndex(I)) <= partitionIntS)
               I = I + 1
            LOOP
            DO WHILE (J > I) AND (Names(AlphaIndex(J)) >= partitionIntS)
               J = J - 1
            LOOP

            ' If we haven't reached the pivot element, it means that two
            ' elements on either side are out of order, so swap them:
            IF I < J THEN
               SWAP AlphaIndex(I), AlphaIndex(J)
            END IF
         LOOP WHILE I < J

         ' Move the pivot element back to its proper place in the array:
         SWAP AlphaIndex(I), AlphaIndex(High)

         ' Recursively call the QuickSort procedure (pass the smaller
         ' subdivision first to use less stack space):
         IF (I - Low) < (High - I) THEN
            QuickSort2 Low, I - 1
            QuickSort2 I + 1, High
         ELSE
            QuickSort2 I + 1, High
            QuickSort2 Low, I - 1
         END IF
      END IF
   END IF
END SUB

' =============================== RandInt% ===================================
'   Returns a random integer greater than or equal to the Lower parameter
'   and less than or equal to the Upper parameter.
' ============================================================================
'
FUNCTION RandInt% (lower, Upper) STATIC
   RandInt% = INT(RND * (Upper - lower + 1)) + lower
END FUNCTION

SUB ResponseControl
'************************* Print Name, Responses to Questions***************
' The subroutine RESPONSEPRINT prints a page of student responses.  Here we
' keep track of which questions and which students go on a page.

CALL HappyFace(2)

CALL PageHeader
PRINT #3, "                                        STUDENTS' RESPONSES"
PRINT #3, "                              Dash if Same Response as on Answer Key"
LineNum = LineNum + 1
endcount = 0
ProblemsPerLine = (PrintWidth - 24) \ 2
DO
    start = endcount + 1
    endcount = start + ProblemsPerLine
    IF MaxProblem < endcount THEN endcount = MaxProblem
    CALL ResponsePrint(start, endcount)
        'returns with LineNum = Next line to print.
    LinesRemaining = LinesPerPage - LineNum
    IF LinesRemaining >= 0 THEN
        IF LinesRemaining < 8 + NumStudents OR endcount >= MaxProblem THEN
            FOR N = 0 TO LinesRemaining
                PRINT #3,
                LineNum = LineNum + 1
            NEXT N
        ELSE
            CALL PageHeader
            PRINT #3,
            CALL PageHeader
            PRINT #3,
        END IF
    END IF
LOOP WHILE endcount < MaxProblem

CALL HappyFace(2)

END SUB

SUB ResponsePrint (start, endcount)

'This subroutine prints student responses for problems from "start" to "end"
'for all students.  It makes a heading each time it is called.
DIM responses AS STRING, FirstRow AS STRING, SecondRow AS STRING
DIM ThirdRow AS STRING
                                        'Assign problem-number characters
FOR I = start TO endcount
    FRow = I \ 100
    SRow = (I - FRow * 100) \ 10
    TRow = I MOD 10
    IF I < 100 THEN
        FirstRow = FirstRow + "  "
    ELSE
        FirstRow = FirstRow + STR$(FRow)
    END IF
    IF I < 10 THEN
        SecondRow = SecondRow + "  "
    ELSE
        SecondRow = SecondRow + STR$(SRow)
    END IF
    ThirdRow = ThirdRow + STR$(TRow)
NEXT I

CALL PageHeader
PRINT #3, "                     "; FirstRow
PRINT #3, "                     "; SecondRow
PRINT #3, "     Problem Number: "; ThirdRow
    'This maps 45 and 195 onto 45 and 205
character = (160 * Dash - 405) \ 151
PRINT #3, TAB(23); STRING$(2 * (endcount - start) + 1, character)

PRINT #3, "         Answer Key: ";
FOR M = start TO endcount
    PRINT #3, USING " !"; Answers(M);
NEXT M
PRINT #3,
PRINT #3,
LineNum = LineNum + 5

'***************************** Print Student Answers ***********************
FOR N = 1 TO NumStudents        'Print one line of responses per student
    Index = NumIndex(N)
    CALL PageHeader
    PRINT #3, Names(Index); " ";
    FOR M = start TO endcount - 1
        PRINT #3, Response(Index, M);
    NEXT M
    PRINT #3, MID$(Response(Index, endcount), 1, 1)  'Leaves off final space
NEXT N

END SUB

