/*
 *  ddli.c
 *  The Duniho and Duniho Life Pattern Indicator
 *  by Fergus Duniho
 *  Copyright (c) 1992-1994 Fergus Duniho
 */

#define VER "V3.41"
#define EMAIL "fdnh@troi.cc.rochester.edu"
#define NETMAIL "Fergus Duniho @ 1:2613/278 (The FileWorks BBS)"

#undef MSDOS

#define AMIGA 1
#define MSDOS 2
#define UNIX 3

#define OPSYS AMIGA

#if OPSYS == MSDOS
    #define prtdev "PRT:"
    #define FILE_NAME_MAX 32
    #define OUTMAX 3
    #define OUTSTR "Send output to (1) Screen, (2) File, or (3) Printer?"
#elif OPSYS == MSDOS
    #define prtdev "PRN"
    #define FILE_NAME_MAX 8
    #define OUTMAX 3
    #define OUTSTR "Send output to (1) Screen, (2) File, or (3) Printer?"
#elif OPSYS == UNIX
    #define prtdev ""
    #define FILE_NAME_MAX 32
    #define OUTMAX 2
    #define OUTSTR "Send output to (1) Screen or (2) File?"
#else
    #error OPERATING SYSTEM UNKNOWN
#endif

/*
 * If your compiler does not have the command "strdup",
 * which is common in C compilers but not part of ANSI
 * C, uncomment the next #include statement.
 */
/* #include "strdup.c" */

#include "fpdio.c"
#include "qst.c"
#include <time.h>

#define XN E ? "Extraverted" : "Introverted"
#define QFILE "ddli.qst"

int pow (int x, int y);
int typecmp (char *t1, char *t2);
void pause (int col);

int main (int argc, char **argv) {
    int i, col, size, A, pr[14], x, type,
        E, I, S, N, T, F, J, P, ES, EN, ET, EF, R;
    char line[256], nline[512], *name, *fname,
        LP[5], LPE[5], LPI[5],
        *PF[2] = {"Intuition", "Sensing"},
        *JF[2] = {"Thinking", "Feeling"},
        *text1 = "Your %s function is %s %s.";
    FILE *fptr;
    qst *Q;

#if OPSYS == MSDOS
    col = 75;
#else
    wrapwrite (stdout, 0, 0, 20, "How many columns does your screen have?", 0);
    col = fgetp(stdin);
#endif

    wrapwrite (stdout, 0, 0, col,
        "\n\"The Duniho and Duniho Life Pattern Indicator\"",
        VER, "\nBy Fergus Duniho. Copyright (c) 1992-1994",
        "Fergus Duniho.\n\nMost of the questions are drawn from",
        "and based on those in Terence Duniho's \"Preference",
        "Patterns Questionaire\" and his book _Wholeness Lies",
        "Within_. Fergus is responsible for the choice of questions.",
        "\n\nThis product is freeware. Send your raw scores and",
        "sundry comments to Fergus Duniho through the Internet or",
        "through the Fidonet.  Here are my Internet and Fidonet",
        "addresses:\n\n", EMAIL, "\n", NETMAIL, "\n", 0);

    pause (col);
    wrapwrite (stdout, 5, 0, col, "When you answer each question,",
        "there are some things you should bear in mind.\n\n", 0);

    wrapwrite (stdout, 2, 0, col, "1.   Base your answer on how you usually",
        "are, not just on how you were on a particular occasion.\n\n", 0);

    wrapwrite (stdout, 2, 0, col, "2.   Base your answer on how you actually",
        "are, even when that differs from how you would like to be.\n\n", 0);

    wrapwrite (stdout, 2, 0, col, "3.   Base your answer on how you have",
        "actually been in real situations, as opposed to how you might be",
        "in imaginary situations.\n\n", 0);

    wrapwrite (stdout, 2, 0, col, "4.   Finally, remember that this is not",
        "a test. Nobody has an answer key with the right answers in it.",
        "The right answers depend upon who you are. This program does not",
        "measure degrees of normality and abnormality. It merely measures",
        "differences that may exist between normal, psychologically,",
        "healthy individuals.\n\n", 0);

    size = HowMany(QFILE, '#');
    Q = new_qnode(0);
    Q->pv = (Q->nx = Q);
    Get_QList (QFILE, Q, size);
    if (argc > 1)
        read_scores (argv[1], Q);

    wrapwrite (stdout, 0, 0, col, "What is your name?", 0);
    name = clone_line(stdin, 80);
    wrapwrite (stdout, 0, 0, col, "Do you already know your psychological",
        "type? (y/n)", 0);
    if (yes()) {
        wrapwrite (stdout, 0, 0, col, "Please select your type from the",
            "list below:\n\n0 - INFP\t1 - INFJ\t2 - INTP\t3 - INTJ\n",
            "4 - ISFP\t5 - ISFJ\t6 - ISTP\t7 - ISTJ\n",
            "8 - ENFP\t9 - ENFJ\t10 - ENTP\t11 - ENTJ\n",
            "12 - ESFP\t13 - ESFJ\t14 - ESTP\t15 - ESTJ\n", 0);
        type = getp(0, 15);
    }
    else type = 16;

#ifdef DEBUG
    wrapwrite (stdout, 0, 0, col,
        "Enter an integer as a seed value for the random # generator", 0);
    srand (fgetp(stdin));
#else
    srand (clock());
#endif

    Q = RND_QList (Q, size);
    AskQuestions (Q, col);

    /* Initializes Preference Scores to Zero */
    for (i = 0; i < 14; i++)
        pr[i] = 0;

    /* Calculates Scores */
    for (Q = Q->nx; Q->num > 0; Q = Q->nx)
        pr[Q->ans] += Q->strength;

    wrapwrite (stdout, 0, 0, col, OUTSTR, 0);
    A = getp(1, OUTMAX);
    if (A == 1)
        fptr = stdout;
    else if (A == 2) {
        wrapwrite (stdout, 0, 0, col, "Please enter a file name.", 0);
        fname = clone_line(stdin, FILE_NAME_MAX);
        WrOpen (fptr, fname);
    }
#if OPSYS != UNIX
    else if (A == 3) {
        WrOpen (fptr, prtdev);
        col = 75;
    }
#endif

    wrapwrite (fptr, 0, 0, col, "Please bear in mind that the DDLI",
        "does not tell you what your type is.  It merely indicates what",
        "might be your type with some degree of probability.  Do not take",
        "your results on the DDLI as the final word on what your type is.",
        "With that said, here are your results:\n\n", 0);
    E = pr[1]; I = pr[2]; S = pr[3]; N = pr[4];
    T = pr[5]; F = pr[6]; J = pr[7]; P = pr[8];
    ES = pr[12]; EN = pr[13]; ET = pr[11]; EF = pr[10];
    sprintf (nline, "%s's scores on the main set of questions:\n"
                    "\nExtraversion (E): %3d    %3d :(I) Introversion"
                    "\nSensing      (S): %3d    %3d :(N) iNtuition"
                    "\nThinking     (T): %3d    %3d :(F) Feeling"
                    "\nJudging      (J): %3d    %3d :(P) Perceiving\n",
                    name, E, I, S, N, T, F, J, P);
    wrapwrite (fptr, 0, 0, col, nline, 0);

    /* Calculates possible life pattern based on primary scores. */
    LP[0] = (E > I) ? 'E' : (E < I) ? 'I' : 'X';
    LP[1] = (S > N) ? 'S' : (S < N) ? 'N' : 'X';
    LP[2] = (T > F) ? 'T' : (T < F) ? 'F' : 'X';
    LP[3] = (J > P) ? 'J' : (J < P) ? 'P' : 'X';
    LP[4] = 0;

    fprintf (fptr, "You scored as an %s.\n", LP);
    x = 0;
    for (i = 0; i < 4; i++)
        if (LP[i] == 'X')
            x++;
    if (x) {
        sprintf (line, "This is not a real type. You could be any of "
        "%d different types. Read the type descriptions to determine "
        "which you are.", pow(2,x));
        wrapwrite (fptr, 0, 0, col, line, 0);
    }
    else {
        E = (LP[0] == 'E'); R = ((LP[3] == 'J') == E);
        sprintf (line, "\nAssuming that you are an %s,\n", LP);
        wrapwrite (fptr, 0, 5, col, line, 0);
        sprintf (line, text1, "DOMINANT", XN, R ? JF[LP[2] == 'F'] : PF[LP[1] == 'S']);
        wrapwrite (fptr, 0, 5, col, line, 0);
        sprintf (line, text1, "AUXILIARY", !XN, R ? PF[LP[1] == 'S'] : JF[LP[2] == 'F']);
        wrapwrite (fptr, 0, 5, col, line, 0);
        sprintf (line, text1, "TERTIARY", XN, R ? PF[LP[1] == 'N'] : JF[LP[2] == 'T']);
        wrapwrite (fptr, 0, 5, col, line, 0);
        sprintf (line, text1, "INFERIOR", !XN, R ? JF[LP[2] == 'T'] : PF[LP[1] == 'N']);
        wrapwrite (fptr, 0, 5, col, line, 0);
    }
    if (A == 1) pause (col);
    wrapwrite (fptr, 0, 0, col, "Please bear in mind that the",
        "supplementary questions are experimental and may be highly",
        "unreliable.  If these scores conflict with your previous scores,",
        "it is probably because the questions are still not reliable",
        "enough.\n\n", 0);
    if (A == 1) pause (col);
    sprintf (nline, "\n%s's scores on the supplementary questions:\n\n"
    "Extraverted Thinking / Introverted Feeling   : %d\n"
    "Extraverted Feeling / Introverted Thinking   : %d\n\n"
    "Extraverted Intuition / Introverted Sensing  : %d\n"
    "Extraverted Sensing / Introverted Intuition  : %d\n\n"
    "Rationality (Dominant Judging Function)      : %d\n"
    "A-rationality (Dominant Perceiving Function) : %d\n\n",
        name, ET, EF, EN, ES, pr[9], pr[0]);
    wrapwrite (fptr, 0, 0, col, nline, 0);

    /* Calculates possible life patterns based on supplemental scores. */
    LPE[0] = 'E'; LPI[0] = 'I';
    if (pr[9] > pr[0]) {
        LPE[3] = 'J';
        LPI[3] = 'P';
    }
    else if (pr[9] < pr[0]) {
        LPE[3] = 'P';
        LPI[3] = 'J';
    }
    else {
        LPE[3] = 'X';
        LPI[3] = 'X';
    }
    if (LPE[3] == 'P') {
        if (EF > ET) {
            LPE[2] = 'T';
            LPI[2] = 'F';
        }
        else if (EF < ET) {
            LPE[2] = 'F';
            LPI[2] = 'T';
        }
        else {
            LPE[2] = 'X';
            LPI[2] = 'X';
        }
        if (ES < EN) {
            LPE[1] = 'N';
            LPI[1] = 'S';
        }
        else if (ES > EN) {
            LPE[1] = 'S';
            LPI[1] = 'N';
        }
        else {
            LPE[1] = 'X';
            LPI[1] = 'X';
        }
    }
    else if (LPE[3] == 'J') {
        if (EF < ET) {
            LPE[2] = 'T';
            LPI[2] = 'F';
        }
        else if (EF > ET) {
            LPE[2] = 'F';
            LPI[2] = 'T';
        }
        else {
            LPE[2] = 'X';
            LPI[2] = 'X';
        }
        if (ES > EN) {
            LPE[1] = 'N';
            LPI[1] = 'S';
        }
        else if (ES < EN) {
            LPE[1] = 'S';
            LPI[1] = 'N';
        }
        else {
            LPE[1] = 'X';
            LPI[1] = 'X';
        }
    }
    else {
        LPE[1] = 'X';
        LPE[2] = 'X';
        LPI[1] = 'X';
        LPI[2] = 'X';
    }
    LPE[4] = LPI[4] = 0;

    sprintf (line, "According to the supplementary scores, %s could be "
    "an %s or an %s.  These are opposite types, because the supplementary "
    "questions measure for preferences that opposite types share in common.  "
    "See the FAQ for an explanation.", name, LPE, LPI);
    if (typecmp(LP, LPE) || typecmp(LP, LPI))
        sprintf (nline, "%s These results are consistent with your score as an %s.", line, LP);
    else
        sprintf (nline, "%s These results conflict with the evaluation of %s as an %s.", line, name, LP);
    wrapwrite (fptr, 5, 0, col, nline, "\n\n", 0);
    if (fptr != stdout)
        fclose (fptr);
    if (A == 1) pause (col);
    wrapwrite (stdout, 5, 0, col,
        "Please note that the DDLI is fallible, and that you might not",
        "be what you scored as.  In order to make the DDLI more",
        "reliable, I want to collect the raw scores from people who know",
        "their type INDEPENDENTLY from what the DDLI has told them.",
        "With your permission, the DDLI will store your raw",
        "scores in a file.  If you ALREADY KNOW your type, or if you",
        "figure out what your type is, please send me your raw scores",
        "via e-mail.  Your raw scores will help me determine which",
        "questions to leave out and which to leave in.  Do you give the",
        "DDLI permission to store your raw scores in a file?", 0);
    if (yes()) {
        save_scores (Q, type, col);
        wrapwrite (stdout, 0, 0, col, "Thank you for saving a copy of your",
            "raw scores.  Please remember that it will be useful to me ONLY",
            "IF you know your type INDEPENDENTLY from what the DDLI has",
            "told you. Please note that this file is straight ASCII.",
            "It is not binary.  Do NOT uuencode it.  Do NOT MIME-encode",
            "it.  Do NOT BinHex it.  Do NOT compress it.  Just insert it",
            "into the body of an ordinary e-mail message.", 0);
    }

    return 0;
}

int pow (int x, int y) {
    if (y < 1)
        return 1;
    if (y == 1)
        return x;
    return x * pow(x, y-1);
}

int typecmp (char *t1, char *t2) {
    int i;

    for (i = 0; i < 4; i++)
        if ((t1[i] != t2[i]) && (t1[i] != 'X') && (t2[i] != 'X'))
            return 0;
    return 1;
}

void pause (int col) {
    wrapwrite (stdout, 0, 0, col, "Press <ENTER> to continue.\n", 0);
    nextline (stdin);
}

