/*
**
** Prototype list for DOORUTIL.H
**
*/

#include "\doors\structs.h"
#include "\doors\bbscfg.h"

/*
** make acctp a new variable type - an array of structures
** same for userp
*/

typedef struct acct_rec acctp[];
typedef struct user_rec userp[];

struct msg3
{
    int type;                   /* will always be 7 */
    int line;                   /* the line number for this task (0-5) */
    int inq;                    /* the queue to read incoming data from */
    int outq;                   /* the queue to send outgoing data to */
    acctp far *acctptr;         /* a pointer to an array of structures */
    userp far *userptr;
    int numlines;               /* how many lines are configured */
    struct cfg_rec far *cfgptr; /* pointer to BBSCFG record */
};

struct msg1
{
    int type;
    int count;
    char text[1000];
};

struct msg4
{
    int type;
    int oba;    /* how many bytes available in output buffer */
    int count;  /* how many bytes currently in output buffer */
};

/*
** Thsi structure is used for broadcast to multiple lines
*/

struct msg5
{
    int type;
    char far *text;
    int far *flag;
    int sendto[33];
    int tcbnum;
};

/*
** cbr is a structure used when making database calls to Falken.
** Doors have the ability to manipulate Falkens databases, but
** must call Falken to do it.  This structure is set up for the
** database call, and then the address of this structure is passed
** to Falken in the mdbs structure below.
*/

#define MAXKEY 32

typedef struct                  /* entry structure in index        */
{
    unsigned long recptr;       /* points to data record           */
    int reclen;                 /* Record length                    */
    char key[MAXKEY];           /* start of record key             */
}   ENTRY;


struct call_bt_rec
{
    int bt_function;
    int bt_file_id;             /* an index into the IX_DESC array */
    void far *data_addr;
    int far *length;
    ENTRY far *data_key;
    int keynumber;              /* must be 0 */
    int rtnvalue;               /* to be loaded with the return value */
};

struct mdbs_rec
{
    int mdbs_type;
    struct call_bt_rec far *cbraddr;
    int tcbnum;
    int far *doneflag;
};

extern int  a_exit(int  code);
extern int  isinstalled(void);
extern int  init(void);
extern void  logoff(void);
extern void  update(void);
extern void  setbinarymode(void);
extern void  settextmode(void);
extern void  clear_input_buffer(void);
extern void  clear_output_buffer(void);
extern void  get_port(int  port);
extern void  return_port(int  port);
extern int  get_oba(void);
extern int  get_in_cnt(void);
extern int  bbslog(char  *fs);
extern int  qprintf(char  *fs,...);
extern int  qputs(char  *fs);
extern int  send(char  *fs);
extern int  broadcast(char  *fs,int  *linenums);
extern int  qgets(char  *s,int  len);
extern int  tqgets(char  *s,int  len,int  timeout);
extern void  waitforempty(void);
extern void disable_sends(void);
extern void enable_sends(void);
extern int  getserialnum(char  *s);
extern int  getversion(char  *s);
extern int start_a_door(char *cmd, int pri);
extern void wait_for_door(int tcbnum);
extern int load_a_door(char *cmd, int pri);

extern int btrv(int fcode, int fd, void *datbuf, int *size,
                    ENTRY * key, int keynum);

#define ACCT_FILE  0
#define DLOAD_FILE 1
#define BIOS_FILE  2
#define MSG_FILE   3
#define EMAIL_FILE 4

#ifndef EOF
#define EOF (-1)
#endif

#ifndef ERROR
#define ERROR   (-1)
#endif

#ifndef OK
#define OK  1
#endif

#define FOUND       2
#define NOTFOUND    3

/*
    beginning of index and end of index status codes
*/

#define BOI (-2)                /* beginning of index */
#define EOI (-3)                /* end of index */


/*
** The following values are legal for fcode
*/

#define b_open 0                /* open an existing database file */
#define b_close 1               /* close a database file */
#define b_insert 2              /* insert a record into the database */
#define b_update 3              /* update (modify) an existing record */
#define b_delete 4              /* delete a record */
#define b_getequ 5              /* get the record whose key exactly equals
                                 * 'key' */
#define b_getnext 6             /* get next record, sequentially */
#define b_getprev 7             /* get previous record */
#define b_getgt 8               /* get record whose key > 'key' */
#define b_getge 9               /* get record whose key >= 'key' */
#define b_getlt 10              /* get record whose key < 'key' */
#define b_getle 11              /* get record whose key <= 'key' */
#define b_getlow 12             /* return first record in database */
#define b_gethi 13              /* return last record in database */
#define b_getpos 14             /* UNUSED */
#define b_getdirect 15          /* return this exact record - key and offset */
#define b_getdata 16            /* special case - only read data file at this
                                 * offset! */
#define b_append  17            /* only write to the data file - return
                                 * offset in key */
#define b_create    21          /* create a new index file */

