/*
** Interface routines for calling the Fossil driver.
** See fsubs.doc for details.  This file can be compiled
** by ant stabdard DOS C or C++ compiler, in any memory model.
**
** The only restriction is that the compiler library must support
** an int86() and int86x() type call, with the REGS and SREGS
** structures defined.  This covers all the major players, including
** Microsoft, Borland, Mix, and Watcom.
*/

#include <dos.h>

union REGS ir;
struct SREGS sr;

int f_recv(int line, char *buf, int max)
{
    char far *ptr;

    ptr=buf;    /* for mixed models - force a FAR pointer */

    sr.es=FP_SEG(ptr);
    ir.x.di=FP_OFF(ptr);
    ir.x.cx=max;
    ir.x.dx=line;
    ir.h.ah=0x18;
    int86x(0x14,&ir,&ir,&sr);
    return ir.x.ax;
}

int f_send(int line, char *buf, int count)
{
    char far *ptr;

    ptr=buf;    /* for mixed models - force a FAR pointer */

    sr.es=FP_SEG(ptr);
    ir.x.di=FP_OFF(ptr);
    ir.x.cx=count;
    ir.x.dx=line;
    ir.h.ah=0x19;
    int86x(0x14,&ir,&ir,&sr);
    return ir.x.ax;
}

int f_getinfo(int line, char *buf, int count)
{
    char far *ptr;

    ptr=buf;    /* for mixed models - force a FAR pointer */

    sr.es=FP_SEG(ptr);
    ir.x.di=FP_OFF(ptr);
    ir.x.cx=count;
    ir.x.dx=line;
    ir.h.ah=0x1b;
    int86x(0x14,&ir,&ir,&sr);
    return ir.x.ax;
}

f_status(int line)
{
    ir.x.dx=line;
    ir.h.ah=3;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_setbaud(int line, int parms)
{
    ir.x.dx=line;
    ir.x.ax=parms;
    ir.h.ah=0;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_initialize(int line)
{
    ir.x.dx=line;
    ir.h.ah=4;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_dtr(int line, int on_off)
{
    ir.x.dx=line;
    ir.x.ax=on_off;
    ir.h.ah=6;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_flushin(int line)
{
    ir.x.dx=line;
    ir.h.ah=0xa;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_flushout(int line)
{
    ir.x.dx=line;
    ir.h.ah=9;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_getfc(int line)
{
    ir.x.dx=line;
    ir.h.ah=0x48;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_flowctrl(int line, int fc)
{
    ir.x.dx=line;
    ir.x.ax=fc;
    ir.h.ah=0xf;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_purgeout(int line)    /* wait until output buffer is empty */
{
    while(!(f_status(line)&0x4000)) relinq();
}

f_deinit(int line)
{
    ir.x.dx=line;
    ir.h.ah=0x5;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_writechar(int line, char ch)
{
    ir.x.dx=line;
    ir.h.al=ch;
    ir.h.ah=0xb;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_readchar(int line)
{
    ir.x.dx=line;
    ir.h.ah=2;
    int86(0x14,&ir,&ir);
    ir.h.ah=0;
    return ir.x.ax;
}

f_setbufsize(int line, int inbufsize, int outbufsize)
{
    ir.x.dx=line;
    ir.x.bx=inbufsize;
    ir.x.cx=outbufsize;
    ir.h.ah=0x43;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_getmaxbuf()
{
    ir.h.ah=2;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_insertchar(int line, char ch)
{
    ir.x.dx=line;
    ir.h.al=ch;
    ir.h.ah=0xb;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_getoba(int line)
{
    ir.x.dx=line;
    ir.h.ah=0x4b;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

f_getibw(int line)
{
    ir.x.dx=line;
    ir.h.ah=0x4c;
    int86(0x14,&ir,&ir);
    return ir.x.ax;
}

