#include "hgraph.h"

/*  Subroutine MANDEL()   */


#define sqr(x) (x*x)
#define MAX_ITERATIONS 100
#define MAX_SIZE       4
#define MAX_ROW        347
#define MAX_COL        719

#define MAX_COLORS 2

void mandel (pmax, pmin, qmax, qmin)
double pmax, pmin, qmax,  qmin;
{
  int color, row, col;
  double p, q, modulus, deltap, deltaq, Xcur, Xlast, Ycur, Ylast;

  deltap = (pmax - pmin) / (MAX_COL - 1);
  deltaq = (qmax - qmin) / (MAX_ROW - 1);
  for (col = 0; col <= MAX_COL; col++)
     for (row = 0; row <= MAX_ROW; row++) {
        p = pmin + col * deltap;
        q = qmin + row * deltaq;
        Xlast = Ylast = modulus = 0.0;
        color = 0;
        while ( (modulus < MAX_SIZE) && (color < MAX_ITERATIONS) ) {
           Xcur = sqr (Xlast) - sqr (Ylast) + p;
           Ycur = 2 * Xlast * Ylast + q;
           color++;
           Xlast = Xcur;
           Ylast = Ycur;
           modulus = sqr (Xcur) + sqr (Ycur);
        }  /* while */
        hpixel((color % MAX_COLORS),col,row);
     }  /* for */
}  /* mandel */
