/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: demo.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for the demo program's main class.
*
* $Id: demo.hpp 1.2 1994/03/09 11:29:32 kjb release $
*
****************************************************************************/

#ifndef	__DEMO_HPP
#define	__DEMO_HPP

#ifndef	__MVISION_HPP
#include "mvision.hpp"
#endif

#ifndef	__TPROGRAM_HPP
#include "tprogram.hpp"
#endif

#ifndef	__TMENU_HPP
#include "tmenubar.hpp"
#endif

/*------------------------------ Constants --------------------------------*/

// Application command codes

const ushort

	cmNextDemo			= 1000,			// Move onto next demo
	cmPrevDemo			= 1001,			// Move back to prev demo
	cmAutoDemo			= 1002,			// Toggle automatic operation
	cmSetExplanation	= 1003,			// Set the explanation window text
	cmSetDemoTitle		= 1004,			// Set the demo title text

// Menu command codes

	cmAbout				= 100,			// Bring up the about box
	cmVideoMode			= 101,			// Change the current video mode
	cmLineDemo			= 102,
	cmEllipseDemo		= 103,
	cmArcDemo			= 104,
	cmPolygonDemo		= 105,
	cmRectangleDemo		= 106,
	cmColorDemo			= 107,
	cmMarkerDemo		= 108,
	cmPatternDemo		= 109,
	cmFloodFillDemo		= 110,
	cmAnimationDemo		= 111,
	cmEmptyDemo			= 112;			// No demo to display

/*---------------------------- Global Variables ---------------------------*/

extern int forcedriver;
extern int snowlevel;

/*-------------------------- Class definitions ----------------------------*/

class Demo : public TProgram {
protected:

			// Method to change the video mode
			void changeVideoMode();

public:
			// Constructor
			Demo();

			// Virtual destructor
	virtual	~Demo();

			// Virtual to handle an event
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Methods to create the menubar, status line and desktop etc
	static	TMenuBar *initMenuBar(const TRect& bounds);
	static	TDeskTop *initDeskTop(const TRect& bounds);
	static	void initVideoMode(int& driver,int& mode);
	};

#endif	// __DEMO_HPP
