/****************************************************************************
*
*				Visual - A 3D Scientific Visualisation Program
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: demoarea.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the class DemoArea, a class for
*				performing the demos in a double buffered window.
*
* $Id: demoarea.hpp 1.2 1994/03/09 11:29:32 kjb release $
*
****************************************************************************/

#ifndef	__DEMOAREA_HPP
#define	__DEMOAREA_HPP

#ifndef	__TRENDERA_HPP
#include "trendera.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The DemoArea class is a class used to represent an area for peforming
// the double buffered demonstrations.
//---------------------------------------------------------------------------

class DemoArea : public TRenderArea {
protected:
	short	cntDemo;					// Current demonstration

			// Method to run each of the specific demonstrations
			void displayStatusInfo();
			void lineDemo();
			void ellipseDemo();
			void arcDemo();
			void polygonDemo();
			void rectangleDemo();
			void fontDemo();
			void colorDemo();
			void markerDemo();
			void patternDemo();
			void floodFillDemo();
			void animationDemo();

			// Method to set the demonstration title name
			void setDemoTitle(char *title);

			// Method to set the information window text
			void setInfoText(char *text);

public:
			// Constructor
			DemoArea(const TRect& bounds);

			// Method handle interaction with the rendering
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);

			// Method to render the scene
	virtual	void render();
	};

#endif	// __RENDERA_HPP
