/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: demowind.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Member functions for the class DemoWindow, a class
*				performing each of the graphics library demos in the
*				current window.
*
* $Id: demowind.cpp 1.2 1994/03/09 11:29:32 kjb release $
*
****************************************************************************/

#include "demo.hpp"

#pragma	hdrstop

#include "demowind.hpp"
#include "demoarea.hpp"

/*----------------------------- Implementation ----------------------------*/

DemoWindow::DemoWindow(const TRect& bounds)
	: TDialog(bounds,NULL,wfFramed),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		DemoWindow::DemoWindow
* Parameters:	bounds		- Bounding box for the window
*
* Description:	Constructor for the DemoWindow class. The window is used
*				to render each of the demos currently being executed.
*
****************************************************************************/
{
	options &= ~(ofSelectable | ofFirstClick);

	TRect r(inner);
	r.offset(-bounds.left(),-bounds.top());
	insert(new DemoArea(r));
}

void DemoWindow::drawBackground(const TRect&)
/****************************************************************************
*
* Function:		DemoWindow::drawBackground
*
* Description:	Draws the background for the window. Since the window is
*				completely covered by the rendering area, we do not
*				draw the window background.
*
****************************************************************************/
{
}
