/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: explwind.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Member functions for the class ExplanationWindow, a class
*				providing information about the current demo in progress.
*
* $Id: explwind.cpp 1.2 1994/03/09 11:29:38 kjb release $
*
****************************************************************************/

#include "demo.hpp"

#pragma	hdrstop

#include "explwind.hpp"

/*----------------------------- Implementation ----------------------------*/

ExplanationWindow::ExplanationWindow(const TRect& bounds)
	: TDialog(bounds,NULL,wfFramed),
	  TWindowInit(TWindow::initFrame,TWindow::initTitleBar)
/****************************************************************************
*
* Function:		ExplanationWindow::ExplanationWindow
* Parameters:	bounds		- Bounding box for the window
*
* Description:	Constructor for the ExplanationWindow class. The window will
*				be placed at the bottom of the bounding box passed to
*				this routine.
*
****************************************************************************/
{
	options &= ~(ofSelectable | ofFirstClick);

	fontManager.useFont(fmSystemFont);

	// Adjust the bounds for the entire window

	TRect	r(innerBounds());
	int		borderH = r.left() - bounds.left() + 1;
	int		borderV = r.top() - bounds.top() + 1;

	r.inset(1,1);
	r.top() = r.bottom() - MGL_textHeight() * 3;
	r.inset(-borderH,-borderV);
	setBounds(r);

	getExtent(r);
	r.inset(borderH,borderV);

	explanation = new TMultiLineText(r,"");
	insert(explanation);
}

void ExplanationWindow::handleEvent(TEvent& event,phaseType)
/****************************************************************************
*
* Function:		ExplanationWindow::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the ExplanationWindow class. Here
*				we handle events that change the text in the window.
*
****************************************************************************/
{
	if (event.what == evBroadcast) {
		if (event.message.command == cmSetExplanation) {
			explanation->setText((const char *)event.message.infoPtr);
			clearEvent(event);
			}
		}
}
