/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: explwind.hpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the class ExplanationWindow, a class for
*				displaying the explanation information about the current
*				demo at the bottom of the display. It also contains the
*				speed buttons to move forwards or backwards through the
*				demos.
*
* $Id: explwind.hpp 1.2 1994/03/09 11:29:32 kjb release $
*
****************************************************************************/

#ifndef	__EXPLWIND_HPP
#define	__EXPLWIND_HPP

#ifndef	__TDIALOG_HPP
#include "tdialog.hpp"
#endif

#ifndef	__TSTTEXT_HPP
#include "tsttext.hpp"
#endif

/*-------------------------- Class definitions ----------------------------*/

//---------------------------------------------------------------------------
// The ExplanationWindow class is a special TDialog class used to display
// information about the current demo, and to handle the speed buttons.
//---------------------------------------------------------------------------

class ExplanationWindow : public TDialog {
protected:
	TMultiLineText	*explanation;	// Text for the explanation

public:
			// Constructor
			ExplanationWindow(const TRect& bounds);

			// Method handle events
	virtual	void handleEvent(TEvent& event,phaseType phase = phFocused);
	};

#endif	// __EXPLWIND_HPP
