/****************************************************************************
*
*					Demo - Demonstration Program for the
*						MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: main.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Main program code for the demo program. This _must_ not be
*				compiled with anything but normal 8086 instructions, since
*				it must be able to detect an incorrect processor
*				configuration!
*
* $Id: main.cpp 1.2 1994/03/09 11:29:38 kjb release $
*
****************************************************************************/

#include "demo.hpp"

#pragma	hdrstop

#include <ctype.h>
#include "sysinfo.h"
#include "getopt.h"

/*------------------------------ Implementation ---------------------------*/

#include <alloc.h>

void badHeap(void)
{
	MGL_exit();
	cerr << "Heap corrupted\n";
	exit(1);
}

void checkHeap(void)
{
	if (heapcheck() == _HEAPCORRUPT)
		badHeap();
}

#pragma option -1-				// Compile _only_ for 8086 operation!!

void checkHardware(void)
/****************************************************************************
*
* Function:		checkHardware
*
* Description:	Checks the hardware for compatibility, bombing out if
*				it is incompatible. This module should not be compiled
*				with any 286 or better instructions!
*
****************************************************************************/
{
	// Check to see that the processor is approriate!!

	cpu_type cpu = SYS_cpu();
	if (cpu < cpu_386) {
		cerr << "This machine has an '";
		switch (cpu) {
			case cpu_86:	cerr << "8086";		break;
			case cpu_286:
			case cpu_286p:	cerr << "80286";	break;
			default:
				cerr << "Misidentified CPU - report this!\n";
				break;
			}
		cerr << "' microprocessor, but this program requires\n"
			 << "an i386 or better to operate.\n";
		exit(EXIT_FAILURE);
		}

#ifndef	FIXED_POINT

	fpu_type fpu = SYS_fpu();
	if (fpu == fpu_none) {
		cerr << "This program requires a floating point co-processor (287,387,487)\n";
		cerr << "to operate effectively. Without a floating point co-processor you\n";
		cerr << "must use the fixed point version of the program.\n\n";
		exit(EXIT_FAILURE);
		}

#endif
}

void help(void)
/****************************************************************************
*
* Function:		help
*
* Description:	Provide usage information about the program.
*
****************************************************************************/
{
	cerr << "Usage: demo [-ega|vga|vesa] [-hfbsp]\n\n";
	cerr << "-ega    Use the standard EGA device drivers\n";
	cerr << "-vga    Use the standard VGA device drivers\n";
	cerr << "-vesa   Use the standard VESA VBE device drivers. By default the system will\n";
	cerr << "        try to use the accelerated drivers.\n";
	cerr << "-f      Turn off special SuperVGA performance enhancements.\n";
	cerr << "-b      Program the palette via the BIOS (XGA and Non VGA style SuperVGA's).\n";
	cerr << "-s      Use slower palette routines for VLB compatability.\n";
	cerr << "-p<arg> Set the palette snow level factor (defaults to 100).\n";
	cerr << "-h      Provide this usage information.\n\n";
	cerr << "If you have a VESA VLB Local Bus based video card, the palette may not be\n";
	cerr << "programmed correctly. In this case, try using the -s option to slow down the\n";
	cerr << "palette programming routines, or the -b option to use the BIOS. You will need\n";
	cerr << "to use the -b option if the video card is an XGA with the VESA VBE TSR\n";
	cerr << "installed.\n\n";
	cerr << "The -p option is used to set the number of palette entries programmed per\n";
	cerr << "vertical retrace. You can speed up the palette programming by increasing this\n";
	cerr << "value, but you may experience snow during palette rotations and fades. Decrease\n";
	cerr << "the value if you experience snow during palette programming.\n\n";
	exit(1);
}

int main(int argc,char *argv[])
{
	int		option;
	char	*argument;

	checkHardware();

	// Parse command line options

	do {
		option = getopt(argc,argv,"Ee:Vv:FfBbSsPp:Hh",&argument);
		if (option > 0) option = tolower(option);
		switch(option) {
			case 'e':
				forcedriver = grEGA;
				break;
			case 'v':
				if (tolower(argument[0]) == 'g')
					forcedriver = grVGA;
				else if (tolower(argument[0]) == 'e')
					forcedriver = grSVGA;
				else help();
				break;
			case 'f':
				MGL_slowSuperVGA(true);
				break;
			case 'b':
				MGL_useBIOSPalette(true);
				break;
			case 's':
				MGL_slowPalette(true);
				break;
			case 'p':
				snowlevel = atoi(argument);
				break;
			case PARAMETER:
			case INVALID:
			case 'h':
				help();
			}
		} while (option != ALLDONE);

	// Keep re-starting the application while we recieve the cmRestart
	// command code. This allows the application to change video modes
	// on the fly.

	ushort endState = cmRestart;
	while (endState == cmRestart) {
		checkHeap();
		Demo *demo = new Demo;
		endState = demo->run();
		delete demo;
		checkHeap();
		}
	return 0;
}
