/****************************************************************************
*
*						MegaGraph Graphics Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: ffilltst.c $
* Version:      $Revision: 1.2 $
*
* Language:		ANSI C
* Environment:	IBM PC (MS DOS)
*
* Description:	Program to test the flood filling routines.
*
* $Id: ffilltst.c 1.2 1994/03/10 09:25:52 kjb release $
*
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include "mgraph.h"
#include "ztimer.h"

/* Routines in main.c */

void four_dots(void);
void init_graphics(char *testname,int argc,char *argv[]);
void exit_graphics(void);
void ReportTime(ulong count);

/* Function prototypes for the code in 'ffill.c' */

void MGL_interiorFill(int x,int y);
void MGL_boundaryFill(int x,int y,color_t bdr);

/* We need a rather large stack to fill high resolution displays! */

extern unsigned _stklen = 30*1024;

#define MaxPts		6		/* Maximum # of pts in polygon	*/
#define	NUM			3

typedef	struct {
	point	poly[MaxPts];
	int		color;
	} entry;

entry	table[NUM];

void main(int argc,char *argv[])
{
	color_t	maxcolor,backcolor;
	int		maxx,maxy;
	int 	i,j;
	ulong	count1,count2,count3,count4;

	init_graphics("Floodfill test",argc,argv);

	maxcolor = MGL_maxColor();
	maxx = MGL_maxx();
	maxy = MGL_maxy();

	srand(200);

	/* Draw a set of polygons */

	for (j = 0; j < NUM; j++) {
		table[j].color = random(maxcolor);		/* Keep random in sync	*/
		table[j].color = (j == 0) ? BLUE : (j == 1) ? RED : YELLOW;

		for (i = 0; i < MaxPts; i++) {
			table[j].poly[i].x = random(maxx);
			table[j].poly[i].y = random(maxy);
			}
		}

	backcolor = MGL_getBackColor();
	MGL_setBackColor(MGL_realColor(BLACK));
	MGL_clearDevice();
	MGL_setBackColor(backcolor);
	for (j = 0; j < NUM; j++) {
		MGL_setColor(MGL_realColor(table[j].color));
		MGL_fillPolygon(MaxPts,table[j].poly,0,0);
		}

	MGL_setColor(MGL_realColor(RED));
	MGL_lineCoord(0,0,10,20);

	getch();
	MGL_setColor(MGL_realColor(GREEN));
	LZTimerOn();
	MGL_boundaryFill(10,10,MGL_realColor(RED));
	LZTimerOff();
	count1 = LZTimerCount();

	getch();

	backcolor = MGL_getBackColor();
	MGL_setBackColor(MGL_realColor(BLACK));
	MGL_clearDevice();
	MGL_setBackColor(backcolor);
	for (j = 0; j < NUM; j++) {
		MGL_setColor(MGL_realColor(table[j].color));
		MGL_fillPolygon(MaxPts,table[j].poly,0,0);
		}
	MGL_setColor(MGL_realColor(WHITE));
	MGL_rectCoord(0,0,maxx+1,maxy+1);

	MGL_setColor(MGL_realColor(RED));
	MGL_lineCoord(0,0,10,20);

	getch();
	MGL_setColor(MGL_realColor(GREEN));
	LZTimerOn();
	MGL_boundaryFill(10,10,MGL_realColor(RED));
	LZTimerOff();
	count2 = LZTimerCount();

	getch();

	backcolor = MGL_getBackColor();
	MGL_setBackColor(MGL_realColor(BLACK));
	MGL_clearDevice();
	MGL_setBackColor(backcolor);
	for (j = 0; j < NUM; j++) {
		MGL_setColor(MGL_realColor(table[j].color));
		MGL_fillPolygon(MaxPts,table[j].poly,0,0);
		}

	MGL_setColor(MGL_realColor(RED));
	MGL_lineCoord(0,0,10,20);

	getch();
	MGL_setColor(MGL_realColor(GREEN));
	LZTimerOn();
	MGL_interiorFill(10,10);
	LZTimerOff();
	count3 = LZTimerCount();

	getch();

	backcolor = MGL_getBackColor();
	MGL_setBackColor(MGL_realColor(BLACK));
	MGL_clearDevice();
	MGL_setBackColor(backcolor);
	for (j = 0; j < NUM; j++) {
		MGL_setColor(MGL_realColor(table[j].color));
		MGL_fillPolygon(MaxPts,table[j].poly,0,0);
		}
	MGL_setColor(MGL_realColor(WHITE));
	MGL_rectCoord(0,0,maxx+1,maxy+1);

	MGL_setColor(MGL_realColor(RED));
	MGL_lineCoord(0,0,10,20);

	getch();
	MGL_setColor(MGL_realColor(GREEN));
	LZTimerOn();
	MGL_interiorFill(10,10);
	LZTimerOff();
	count4 = LZTimerCount();

	exit_graphics();
	ReportTime(count1);
	ReportTime(count2);
	ReportTime(count3);
	ReportTime(count4);
}
