/****************************************************************************
*
*							  The MegaToolbox
*
*                   Copyright (C) 1994 SciTech Software
*							All rights reserved.
*
* Filename:		$RCSfile: event.h $
* Version:		$Revision: 1.3 $
*
* Language:		ANSI C
* Environment:  IBM PC Real mode and 16/32 bit Protected Mode
*
* Description:	Header file for the event queue module. The event library
*				depends upon routines in the mouse library for correct
*				operation.
*
* $Id: event.h 1.3 1994/03/06 07:50:12 kjb release $
*
****************************************************************************/

#ifndef	__EVENT_H
#define	__EVENT_H

#ifndef	__DEBUG_H
#include "debug.h"
#endif

#ifndef	__MOUSE_H
#include "mouse.h"
#endif

/*-------------------------- Macro Definitions ----------------------------*/

/* Event message masks for keyDown events */

#define	ASCIIMASK	0x00FF		/* Ascii code of key pressed			*/
#define	SCANMASK	0xFF00		/* Scan code of key pressed				*/

#define	EVT_asciiCode(m)	( (uchar) (m & ASCIIMASK) )
#define	EVT_scanCode(m)		( (uchar) ( (m & SCANMASK) >> 8 ) )

/* Event message masks for mouse events */

#define	LEFTBMASK	0x0001		/* Left button is bit 0					*/
#define	RIGHTBMASK	0x0004		/* Right button is bit 1				*/
#define	BOTHBMASK	0x0005		/* Both left and right together			*/
#define	MIDDLEMASK	0x0010		/* Middle button is bit 4				*/
#define	LEFTMBMASK	0x0011		/* Left and middle buttons together		*/
#define	RIGHTMBMASK	0x0014		/* Right and middle buttons together	*/
#define	ALLBMASK	0x0015		/* All buttons pressed					*/

/* Modifier masks */

#define	LEFTBUT		0x0001		/* Set if left button was down			*/
#define	RIGHTBUT	0x0002		/* Set if right button was down			*/
#define	MIDDLEBUT	0x0004		/* Set if middle button was down		*/
#define	RIGHTSHIFT	0x0008		/* Set if right shift down				*/
#define	LEFTSHIFT	0x0010		/* Set if left shift down				*/
#define	CTRLSTATE	0x0020		/* Set if ctrl key down					*/
#define	ALTSTATE	0x0040		/* Set if alt key down					*/
#define	LEFTCTRL	0x0080		/* Set if left ctrl key down			*/
#define	LEFTALT		0x0100		/* Set if left alt key down				*/
#define	SHIFTKEY	(LEFTSHIFT | RIGHTSHIFT)	/* Any shift key		*/

typedef	struct {
	uint		what;			/* Event code							*/
	long		when;			/* Clock ticks since midnight			*/
	int			where_x;		/* Mouse location						*/
	int			where_y;
	long		message;		/* Event specific message				*/
	int			modifiers;		/* Modifier flags						*/
	int			next;   		/* Next event in queue					*/
	int			prev;			/* Previous event in queue				*/
	} event;

/* Event codes */

#define	NULLEVT		0x0000		/* A null event							*/
#define	KEYDOWN		0x0001		/* Key down event						*/
#define	KEYREPEAT	0x0002		/* Key repeat event						*/
#define	KEYUP		0x0004		/* Key up event							*/
#define	MOUSEDOWN	0x0008		/* Mouse down event						*/
#define	MOUSEUP		0x0010		/* Mouse up event						*/
#define	MOUSEMOVE	0x0020		/* Mouse movement event					*/
#define	TIMERTICK	0x0040		/* Timer tick event						*/
#define	USEREVT		0x0080		/* First user event						*/

/* Event code masks */

#define	KEYEVT		(KEYDOWN | KEYREPEAT | KEYUP)
#define	MOUSEEVT	(MOUSEDOWN | MOUSEUP | MOUSEMOVE)
#define	MOUSECLICK	(MOUSEDOWN | MOUSEUP)
#define	EVERYEVT	0xFFFF

/*-------------------------- Function Prototypes --------------------------*/

#ifdef	__cplusplus
extern "C" {			/* Use "C" linkage when in C++ mode	*/
#endif

void	PUBAPI EVT_init(void);
void	PUBAPI EVT_suspend(void);
void	PUBAPI EVT_resume(void);
bool	PUBAPI EVT_post(int what,long message,ms_status *stat,int modifiers);
void	PUBAPI EVT_flush(int mask);
void 	PUBAPI EVT_halt(event *evt,int mask);
void	PUBAPI EVT_delay(event *evt,int mask,uint time);
bool 	PUBAPI EVT_getNext(event *evt,int mask);
bool	PUBAPI EVT_peekNext(event *evt,int mask);
bool 	PUBAPI EVT_mouseMove(bool set);
int		PUBAPI EVT_setTimerTick(int ticks);

#ifdef	__cplusplus
}						/* End of "C" linkage for C++	*/
#endif

#endif  /* __EVENT_H */
