/****************************************************************************
*
*                             The MegaToolbox
*
*                   Copyright (C) 1993 SciTech Software
*                           All rights reserved.
*
* Filename:     $RCSfile: sysinfo.h $
* Version:      $Revision: 1.3 $
*
* Language:     ANSI C
* Environment:	IBM PC Real mode and 16/32 bit Protected Mode
*
* Description:  Header file for system information gathering module.
*
* $Id: sysinfo.h 1.3 1994/03/06 07:39:18 kjb release $
*
****************************************************************************/

#ifndef __SYSINFO_H
#define __SYSINFO_H

#ifndef __DEBUG_H
#include "debug.h"
#endif

/*--------------------- Macros and type definitions -----------------------*/

typedef enum    {cpu_86,cpu_186,cpu_286,cpu_286p,
				 cpu_386,cpu_386p,cpu_486,cpu_486p,
				 cpu_586,cpu_586p} cpu_type;

typedef enum    {fpu_none,fpu_87,fpu_287,fpu_387,fpu_487,fpu_587} fpu_type;

typedef enum    {PC_class,PCXT_class,PCAT_class,PS2_class,OS2_class} class_type;

typedef enum    {no_adapter,MDA_adapter,HGC_adapter,CGA_adapter,EGA_adapter,
				 MCGA_adapter,VGA_adapter,SVGA_adapter,IBM8514_adapter,
				 XGA_adapter} adapter_type;

typedef enum    {no_display,MDA_display,CGA_display,EGA_display,
                 PS2mono_display,PS2color_display} display_type;

typedef struct {
	short	adapter1;       /* Active adapter       */
	short	adapter2;       /* Inactive adapter     */
	short	display1;
	short	display2;
	short   videoram1;
	short   videoram2;
    } subsys_type;

#define LINES_43    0x4000          /* Enables 43 line mode */
#define LINES_50    0x8000          /* Enables 50 line mode */

/*------------------------- Function Prototypes ---------------------------*/

#ifdef  __cplusplus
extern "C" {            /* Use "C" linkage when in C++ mode */
#endif

cpu_type    PUBAPI SYS_cpu(void);
fpu_type    PUBAPI SYS_fpu(void);
class_type  PUBAPI SYS_biosClass(void);
bool        PUBAPI SYS_extKeyboard(void);
void        PUBAPI SYS_getSubSys(subsys_type *subSystem);
int         PUBAPI SYS_screenLines(void);
int         PUBAPI SYS_screenWidth(void);
int         PUBAPI SYS_getVideoMode(void);
void        PUBAPI SYS_setVideoMode(int mode);
bool        PUBAPI SYS_set43lines(void);
bool        PUBAPI SYS_set50lines(void);
bool        PUBAPI SYS_set25lines(void);
bool        PUBAPI SYS_modeMono(void);
bool        PUBAPI SYS_modeColor(void);

#ifdef  __cplusplus
}                       /* End of "C" linkage for C++   */
#endif

#endif  /* __SYSINFO_H */
