/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: isvesa.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:  Test program to check the ability to allocate real mode
*				memory and to call real mode interrupt handlers such as
*				the VESA VBE BIOS from protected mode. Compile and link
*				with the appropriate command line for your DOS extender.
*
*				Functions tested:	PMODE_allocRealSeg()
*									PMODE_freeRealSeg()
*									PMODE_int86x()
*
* $Id: isvesa.c 1.1 1994/03/10 09:05:43 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mem.h>
#include "pmode.h"

/* SuperVGA information block */

typedef struct {
	char    VESASignature[4];       /* 'VESA' 4 byte signature          */
	short   VESAVersion;            /* VBE version number               */
	long	OEMStringPtr;           /* Far pointer to OEM string        */
	long    Capabilities;           /* Capabilities of video card       */
	long	VideoModePtr;           /* Far pointer to supported modes   */
	short   TotalMemory;            /* Number of 64kb memory blocks     */
	char    reserved[236];          /* Pad to 256 byte block size       */
	} VgaInfoBlock;

void main(void)
{
	RMREGS			regs;
	RMSREGS			sregs;
	VgaInfoBlock	*vgaInfo;
	unsigned long	vgaInfo_segid;
	unsigned		vgaInfo_segment;
	unsigned		vgaInfo_offset;

	printf("Program running in ");
	switch (_PMODE_modeType) {
		case PMODE_realMode:
			printf("real mode.\n\n");
			break;
		case PMODE_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PMODE_386:
			printf("32 bit protected mode.\n\n");
			break;
        }

	/* Allocate a 256 byte block of real memory for communicating with
	 * the VESA BIOS.
	 */

	vgaInfo = PMODE_allocRealSeg(256, &vgaInfo_segid, &vgaInfo_segment,
		&vgaInfo_offset);
	if (vgaInfo == NULL) {
		fprintf(stderr, "Unable to allocate real mode memory!\n");
		exit(1);
		}

	/* Call the VESA VBE to see if it is out there */

	regs.x.ax = 0x4F00;
	regs.x.di = vgaInfo_offset;
	sregs.es = vgaInfo_segment;
	PMODE_int86x(0x10, &regs, &regs, &sregs);
	if (regs.x.ax == 0x004F && strncmp(vgaInfo->VESASignature,"VESA",4) == 0) {
		printf("VESA VBE version %d.%d BIOS detected\n",
			vgaInfo->VESAVersion >> 8, vgaInfo->VESAVersion & 0xF);
		}
	else printf("VESA VBE not found\n");

	PMODE_freeRealSeg(vgaInfo_segid);
}
