
' Copyright (c) 1991-1995, John David Rohner.  All rights reserved.
'
' This file is to be "$INCLUDED" with all Basic modules.
'

' $DYNAMIC
'
' All variables integer unless defined otherwise.
'
DEFINT A-Z

'
' Some "don't let sysop change" strings.
'
CONST PID       = "JDR_BBS r.10"
CONST CopyRight = "Copyright (c) 1991-1995 by John Rohner.  All rights reserved."
CONST Title1    = "Juggernaut, Dendro-Recombinant Bulletin Board System (JDR_BBS)  release .10"
CONST Title2    = "Copyright (C) John David Rohner 1991-1995.  All rights reserved."
CONST Release   = 10
CONST ProgramIs = "Juggernaut r.10 (+1) [unregistered]"
CONST Status    = "[unregistered]"

CONST UpSC    = 18432
CONST DownSC  = 20480
CONST LeftSC  = 19200
CONST RightSC = 19712

CONST UserRL    = 384
CONST UserIDXRL = 34
CONST MsgRL     = 136
CONST MsgIDXRL  = 12
CONST FileRL    = 128
CONST FileIDXRL = 26
CONST SumLogRL  = 146


'
' Create the data structures.
'

'
' UserRecord is the record structure of the USERS file.  In the program the
' current users' information is stored in USER. in just such a record.
' Other user data is read in with the AnyUser. variable.
'
TYPE UserRecord                    'Len = 384
  UserName      AS STRING * 30     'Mixed case.
  Password      AS STRING * 15     'Uppercase only.
  CityState     AS STRING * 30     'Mixed case
  SysopNote   AS LONG
  UserNote    AS LONG
  BirthDate     AS INTEGER         'Birthdate of user.
                                   'Date stored in integer form.
  SecLevel      AS INTEGER         '-32,767 to 32,767 security level.
  FirstCall     AS INTEGER         'First date user called.
                                   'Date stored in integer form.
  Attr          AS INTEGER         '16 bits: see useredit.ans
  Toggles       AS INTEGER         '16 bits:
                                   '1 True if should beep after transfers.
                                   '2 True if show Enter Msg line numbers.
                                   '3 True if show Read Msg total lines.
                                   '4 True if should "turbo" out the msgs.
                                   '5 True if user is a male.
                                   '6 True if password assist is on.
                                   '7 True if want to see L&D/Point values.
                                   'rest are used. this needs updating.
  Protocol      AS STRING * 1      'User's procotol default.
  Votes         AS STRING * 100    '=100 Voting questions (Byte answers).
  SubsStart     AS INTEGER         'Subscription start date.
                                   'Date stored in integer form.
  Style         AS STRING * 3
  ElapsedMinsC  AS INTEGER
  ElapsedMins   AS INTEGER         'elapsed non-DL/UL mins of calls today.
  LastCallerNum AS LONG
  LastDateOn    AS INTEGER         'Last time user called.
                                   'Date stored in integer form.
  PswdChange    AS STRING * 1      'Counter towards user change password order.
                                   '0 = off, 1 to 255 ascii value.
  AlterDate     AS INTEGER         'The last date in which they exercised
                                   'their Life & Death options.
                                   'Date stored in integer form.
  Toggles2      AS INTEGER         '16 bits:
  PRStuff       AS STRING * 8      'Peer Review information.
  Connect       AS STRING * 1      'Last baud user connected at.
  NewFilesPtr   AS LONG            '0 to 2,100,000,000
                                   'What the "NewFilesPtr" number was at the last
                                   'time they called, any stuff with
                                   'numbers higher is new to them.
  HighestPtr    AS LONG            '0 to 2,100,000,000 Highest HileFilePtr they
                                   'know about.  NewFilesPtr is call
                                   'dependant--it's updated after they log out,
                                   'this isn't--this is a security measure.
  PagedSysop    AS INTEGER         '0 to 32,767 Number of times they've tried to
                                   'page the sysop.
  Logons        AS INTEGER         '0 to 32,767 Number of logons.
  Attempts      AS STRING * 1      '0 to 255 Number of bad password attempts
                                   'since their last call.
  MinCredits    AS INTEGER         '-32,767 to 32,767
                                   'Number of minutes to add to their daily
                                   'that their security level gets.
  MinMegs       AS INTEGER         '-32,767 to 32,767
                                   'This number is multiplied by 1 megabyte
                                   'and then added to their "number of
                                   'bytes can download" to determine what
                                   'their download bytes limit is.
  MsgsPosted    AS INTEGER         '0 to 32,767 Total number of public messages
                                   '(excluding NetMail) they've posted.
  EMsgsPosted   AS INTEGER         '0 to 32,767 Total number of private
                                   '(excluding feedback and NetMail) messages
                                   'they've posted.
  FMsgsPosted   AS INTEGER         '0 to 32,767 Total number of feedback
                                   'messages they've posted.
  NetMailSent   AS INTEGER         '0 to 32,767 Total number of NetMail letters
                                   'they've sent.
  NetMailRcvd   AS INTEGER         '0 to 32,767 Total number of NetMail letters
                                   'they've received.
  Elapsed       AS INTEGER         '0 to 32,767 Length of previous call(s).
                                   'Never exceeds maximum daily limit for
                                   'whatever security level.
                                   'Download minutes.
  Dnlds         AS INTEGER         '0 to 32,767 Total files downloaded.
  DLBytes       AS LONG            '0 to 2,100,000,000 Total bytes downloaded.
  MinsDLing     AS LONG            '0 to 2,100,000,000 Total number of minutes
                                   'downloading.
  BadDLs        AS INTEGER         '0 to 32,767 Total number of bad DL's.
  Uplds         AS INTEGER         '0 to 32,767 Total files uploaded.
  ULBytes       AS LONG            '-'ve to 2,100,000,000 Total bytes uploaded.
  MinsULing     AS LONG            '0 to 2,100,000,000 Total number of minutes
                                   'uploading.
  BadULs        AS INTEGER         '0 to 32,767 Total number of bad UL's.
  Doors         AS INTEGER         '0 to 32,767 Number of accesses to doors.
  SubsEnd       AS INTEGER         'Date subscription ends.
  HighNotePtr AS LONG
  TotalMonies AS LONG              'total money they've sent.
  LastMonies  AS LONG               'last amount they sent
  Attr2       AS INTEGER
  BytesUToday AS LONG         'use date of last call to determine if current
                              'call means to zero this field.
  BytesUWeek  AS LONG          'this will have to be a weekly event.
                              'problem if user on another node when this 
                              'executes.
  MsgsRcvd    AS INTEGER      'Number of normal messages TO: and read.
  EMsgsRcvd   AS INTEGER      'Number of private messages TO: and read.
  SLSubsEnds  AS INTEGER
  ScreenSize  AS STRING * 1
  MsgRC       AS STRING * 10         'ansi code for reading messages.
  Language    AS STRING * 1
  RealName    AS STRING * 30         'mixed case
  HomePhone     AS STRING * 17
  BBSPhone      AS STRING * 17
END TYPE



'
' UsersNameInfo is the type used in an internal array which contains all
' the user names, and their record number in USERS file--it's an array index.
' The array is UsersName().
'
TYPE UsersNameInfo               'Len = 34
  NameUC  AS STRING * 30         'User name, uppercased.
  UserLoc AS LONG                'Location of user record in USERS (0..n).
END TYPE

'
' MessageRecord is the record structure used for each messages header in
' the MESSAGES file.  In the program, the message data is stored in the
' Message. variable with this same record.
'
TYPE MessageRecord               'Len = 136
  Attr          AS INTEGER       '16 bits:
                                 '1 True if a deleted message.
                                 '2 True if Msg body is compressed.
                                 '3 True if this is a reply.
                                 'x True if NetMail
                                 'x True if shouldn't ever NetMail out.
                                 '5 True if shouldn't ever Auto delete.
                                 'x True if should never delete at all.
                                 '8 True if redirected from sysop.
                                 '9 True if redirected from AI.
                                 '10 True if redirected to sysop.
                                 '11 True if redirected to AI.
                                 '12 True if there are file attaches.
                                 '13 True if message will be completed later.
                                 '14 True if any file attaches are free.
                                 '16 True if want's RR (temporary until NetMail)
                                 'Rest are for the future.
  MsgNum        AS LONG          '1 to 2,100,000,000 message number.
                                 'Each message base has it's own message
                                 'counter.
  MsgFrom       AS STRING * 30   'Name of sender.  Mixed case.
  MsgTo         AS STRING * 30   'Name of receiver or "ALL".  Mixed case.
  MsgDateSent   AS INTEGER       'Date message was sent.
                                 'Date stored in integer form.
  MsgTimeSent   AS INTEGER       'Time stored in integer form.
                                 'HHMM and +/-'ve depending on am/pm.
  MsgDateRcvd   AS INTEGER       'Date message was received.  0 if not
                                 'received or sent to "ALL".
                                 'Date stored in integer form.
  MsgTimeRcvd   AS INTEGER       'Time stored in integer form.
                                 'HHMM and +/-'ve depending on am/pm.
  NumOfBytes    AS INTEGER       'Doesn't exceed 8192, message length.
  NumberReplies AS STRING * 1    'This message has been replied to x times.
                                 'This is not the number of active replies.
  TimesRead     AS INTEGER       'Number of times this message has been read.
  LastDateRead  AS INTEGER       'last date anybody read the message.
  MsgSubject    AS STRING * 33   'Compressed text--message subject.
  MsgBase       AS INTEGER       '0 - 32,767 Message bases.
  x             AS INTEGER       'not used
  Attr2         AS INTEGER       'not used, save for future attr2
  SourceAddr    AS STRING * 6          'NetMail source address.
  DestAddr      AS STRING * 6          'NetMail destination address.
  MsgLoc        AS LONG
END TYPE


'
' MessageInfo is the structure used the in the message indexes.
'
TYPE MessageInfo                 'Len = 12
  MsgLoc    AS LONG                'Location (bytes) of start of message in
                                   'the MESSAGES file.
  MsgNum    AS LONG                'The message's number.
  MsgToUC   AS INTEGER             'Numeric form of receiver's name.
  MsgFromUC AS INTEGER             'Numeric form of sender's name.
END TYPE

'
' FileListRecord is the data stucture used in the FILELIST file.  The data
' file containing the information for the various potential downloads.
'
TYPE FileListRecord              'Len = 128
  RFArea     AS INTEGER          '0 to 32,767 File areas.
  NewFilesPtr  AS LONG             'The number each file is given, needs
                                 'not be unique, but represents to the
                                 'system and users when something is new.
                                 'Similar in concept to just checking
                                 'for new file dates since last call.
  LDCount    AS INTEGER          'Chr$(0-28), Chr$(100-199),  A symbolic
                                 'counter and guide about how long a file
                                 'will be on-line (in days), also offers
                                 'opportunity for users to "knock down" or
                                 '"raise up" the "life" of the file.
                                 '100-199 represents 00-99 file points value.
  FName      AS STRING * 12      'The file name.  Including "."
                                 'deliminator--left justified.
  DescLoc    AS LONG
  DescSize   AS INTEGER
  GIFw       AS INTEGER
  GIFh       AS INTEGER
  GIFc       AS INTEGER
  future2    AS STRING * 39      '
  FSize      AS LONG             'The file's size.
  UserName   AS STRING * 30      'Mixed case.  Name of uploader.
  Percentage AS INTEGER          'Percentage rate to credit uploader.
  Password   AS INTEGER          'Two byte (checksum) password.
  Downloaded AS INTEGER          'Number of times downloaded.
  LastDLed   AS INTEGER          'Last date it was downloaded.
  DateULed   AS INTEGER          'Date it was uploaded.
  Attr       AS INTEGER          '16 bits:
                                 '1 True if deleted.
                                 '2 If free.
                                 '3 If not validated yet.
                                 'x If preferred compressed (BBS compressed).
                                 'x If virus checked.
                                 '6 If invisible.
                                 '7 If incomplete.
                                 '8 If a user created extract file.
                                 '9 If free only if callers is 9600+ baud.
                                 'x If downloading counts as an upload.
                                 'rest for the future
  Group      AS INTEGER          'User must be in this group to access.
  GFArea     AS INTEGER          '0 to 32,767 File areas.
  RealDate   AS INTEGER          'Files date on the disk.
  Future     AS STRING * 5
END TYPE

'
' FileNameInfo is the record for the FILES.IDX file.
'
TYPE FileNameInfo                'Len = 26
  FName AS STRING * 12           'File name, including "." deliminator.
                                 'Left justified.
  FLoc  AS LONG                  'Location in FILELIST of this file's data.
  FSize AS LONG                  'Size of file in bytes.
  Attr  AS INTEGER               '16 bits:
                                 '1 True if deleted.
                                 '2 If free.
                                 '3 If not validated yet.
                                 'x If preferred compressed (BBS compressed).
                                 'x If virus checked.
                                 '6 If invisible.
                                 '7 If incomplete.
                                 '8 If a user created extract file.
                                 'x If downloading counts as an upload.
                                 'rest for the future
  RFArea AS INTEGER              'Real file area/location of file.
  GFArea AS INTEGER              'Ghost file area/pretend.
END TYPE

'
' FileInfo is what "FindF" uses.  See the "FindF" routine for more info.
' In the program, this data can be found in the FFile. variable.
'
TYPE FileInfo                    'Len = 18
  FName AS STRING * 12           'File name.
  FSize AS LONG                  'File Size in bytes.
  FDate AS INTEGER               'File date.
END TYPE




TYPE LevelRecord           'Len = 28
  SecLevel      AS INTEGER
  ShowLevel     AS INTEGER
  PCRatio       AS INTEGER
  BRatio        AS INTEGER
  FRatio        AS INTEGER
  DLMinsPerDay  AS INTEGER
  MinsPerCall   AS INTEGER
  MinsPerDay    AS INTEGER
  StartTime     AS INTEGER
  EndTime       AS INTEGER
  VoteWeight    AS INTEGER
  MinBaud       AS LONG
  MinPassLen    AS INTEGER
END TYPE
                         


TYPE SettingsRecord              'Len = 1043
  AutoValAfDLx    AS INTEGER
  MaxLinesInMsg   AS INTEGER     'Maximum lines allowed in a message.
  MaxWidthOfMsg   AS INTEGER     'Maximum chars per msg line.
  NewsWidth       AS INTEGER
  MaxUsers        AS INTEGER     'Maximum number of users to keep active.
  MinPKTSqSize    AS LONG
  LDDelSL         AS INTEGER
  ExchBytes       AS LONG
  ExchMins        AS INTEGER
  SLAfSubsEnds    AS INTEGER
  CanVoteSL       AS INTEGER
  MaxPAttempts    AS INTEGER
  MaxLAttempts    AS INTEGER
  TakeOffBytes    AS INTEGER     '200 -> 200%
  CreditAfDLXLim  AS INTEGER
  LoggingTog1     AS INTEGER
  BufferSize      AS INTEGER     'buffer is made in 4096 increments.
  MinSpace        AS LONG
  MinULSpace      AS LONG
  LDDelSpace      AS LONG
  TargetSpace     AS LONG
  BeSureSpace     AS LONG
  LogoTimeOut     AS INTEGER
  AIHelpSpace     AS LONG
  ResetConnect    AS INTEGER
  ResetNoConnect  AS INTEGER
  CommPort        AS INTEGER
  SLEachOther     AS INTEGER
  TimeOut         AS INTEGER
  AINewUserMsg    AS STRING * 3
  Node            AS INTEGER
  CBVLDSL         AS INTEGER
  StatsSize       AS INTEGER
  RambleAddSL     AS INTEGER
  WorstSL         AS INTEGER
  WorstLogons     AS INTEGER
  LogLeader       AS STRING * 5
  MaxIDLines      AS INTEGER
  ChatWords       AS INTEGER
  NewFilesPtr       AS LONG
  Sysop           AS STRING * 30      'Mixed case.
  MassMail        AS INTEGER
  PPRSL           AS INTEGER
  SysopOnlyUL     AS INTEGER
  BiSL            AS INTEGER       'DROPPED
  MaxRambles      AS INTEGER
  MaxPosts        AS INTEGER
  ModemBaud       AS LONG
  PRMsgStart      AS STRING * 3
  PRMsgPassed     AS STRING * 3
  PRMsgFailed     AS STRING * 3
  PRMinSL         AS INTEGER
  PRMaxSL         AS INTEGER
  DrDrives        AS STRING * 5
  StartTime       AS STRING * 8
  LastCallersSize AS STRING * 1
  BiDayBaud       AS INTEGER           'DROPPED
  DefaultLang     AS STRING * 5
  x               AS STRING * 3
  CreditAfDLDLim  AS INTEGER
  Key1            AS STRING * 20
  Key2            AS STRING * 20
  Key3            AS STRING * 20
  PRCount         AS INTEGER
  FirstCommand    AS STRING * 4
  Toggles0        AS INTEGER
  Toggles7        AS INTEGER
  PostRingSL      AS INTEGER
  GIPID           AS STRING * 8
  G640x480x256    AS INTEGER
  G800x600x256    AS INTEGER
  DLMsgsMax       AS INTEGER
  MaxMsgsToPKT    AS INTEGER
  MenuSysThres    AS STRING * 1
  SumLogDays      AS INTEGER
  CallerNumber    AS LONG
  ModemInit       AS STRING * 30
  ModemAnswer     AS STRING * 15
  NewUserPswd     AS STRING * 15
  ProtDLPctgOvR   AS INTEGER
  ProtDLPDaysOvR  AS INTEGER
  GivePctgBEaDL   AS INTEGER
  GivePctgMEaDL   AS INTEGER
  Toggles1        AS INTEGER
  Toggles2        AS INTEGER
  Toggles3        AS INTEGER
  Toggles4        AS INTEGER
  Toggles5        AS INTEGER
  Toggles6        AS INTEGER
  ReviewLen       AS INTEGER
  LoggingTog2     AS INTEGER
  DebugTog        AS INTEGER
  DescH           AS INTEGER
  DescHwDIZ       AS INTEGER
  ModemOffHook    AS STRING * 30
  MinSLLevelX     AS INTEGER
  WFCHelpBlk      AS INTEGER
  TakeOffMins     AS INTEGER     '200 -> 200%
  MaxDLMsgsSize   AS LONG
  ShuttlePswd     AS STRING * 30
  MaxGMode        AS INTEGER
  Morning         AS INTEGER
  Afternoon       AS INTEGER
  Evening         AS INTEGER
  MinDescLength   AS INTEGER
  Toggles8        AS INTEGER
  Toggles9        AS INTEGER
  CreditAfDLx     AS INTEGER
  StartDate       AS INTEGER
  FPWorthInBytes  AS LONG
  Phone           AS STRING * 20
  FC4Msg          AS LONG
  RumorsLoc       AS LONG
  Future          AS STRING * 20        'for still more stuff.
  HourlyDate      AS INTEGER
  HourlyData      AS STRING * 192
  Colors1         AS STRING * 15
  Colors2         AS STRING * 15
  Colors3         AS STRING * 15
  Colors4         AS STRING * 15
  Colors5         AS STRING * 15
  Colors6         AS STRING * 15
  Colors7         AS STRING * 15
  Colors8         AS STRING * 15
  Colors9         AS STRING * 15
  Colors10        AS STRING * 15
  Colors11        AS STRING * 15
  Colors12        AS STRING * 15
  Colors13        AS STRING * 15
  AllIs           AS STRING * 30
  DefaultMsgRC    AS STRING * 10
  PswdOverWrite   AS STRING * 15
  BBSLocation     AS STRING * 30
  BBSName         AS STRING * 30
  WFCWPChar       AS STRING * 1
  WFCWPFore       AS STRING * 1
  WFCWPBack       AS STRING * 1
  WFCCLHCoor      AS STRING * 1
  WFCCLVCoor      AS STRING * 1
  WFCCLPText      AS STRING * 10
  WFCCLSText      AS STRING * 10
  WFCCLWidth      AS STRING * 1
  WFCCLHeight     AS STRING * 1

END TYPE


TYPE MessageBaseRecord     'Len = 108
  PostSL     AS INTEGER
  ReadSL     AS INTEGER
  ScanSL     AS INTEGER
  StartTime  AS INTEGER
  EndTime    AS INTEGER
  BufferSize AS INTEGER
  NextNumber AS LONG
  SubType    AS INTEGER                   '16 bits:
                                          '1 true if all messages are from ANON.
                                          '2 true if PRIvate (else PUBlic).
                                          '3 true if NET mail.
                                          '4 true if LOCKed.
                                          '5 true if only sysop can DEL msgs.
                                          '6 true if all messages go to ALL.
                                          '7 true if show "hidden" net info.
                                          'x true if net password protected.
                                          '9 true if an EchoMail area.
                                          'x whether toggled ON or OFF.
                                          'rest for the future
  MsgOp      AS STRING * 30
  Title      AS STRING * 60
END TYPE





TYPE MsgAreaIRecord     'Len = 
  ScanSL     AS INTEGER
  NextNumber AS LONG
  SubType    AS INTEGER
  SLen       AS INTEGER
  BufferSize AS INTEGER
END TYPE


TYPE FileAreaRecord           'Len = 410
  MinDLSL    AS INTEGER
  MaxDLSL    AS INTEGER
  MinULSL    AS INTEGER
  MaxULSL    AS INTEGER
  MinScanSL  AS INTEGER
  MaxScanSL  AS INTEGER
  StartTime  AS INTEGER
  EndTime    AS INTEGER
  BufferSize AS INTEGER
  Attr       AS INTEGER                 'x whether toggled ON or OFF.
  MaxMBSize  AS INTEGER
  Template   AS INTEGER
  NewFilesPtr  AS LONG
  FileOp     AS STRING * 30
  Path       AS STRING * 64
  Title      AS STRING * 72
  AlsoPath1  AS STRING * 36
  AlsoPath2  AS STRING * 36
  AlsoPath3  AS STRING * 36
  AlsoPath4  AS STRING * 36
  AlsoPath5  AS STRING * 36
  AlsoPath6  AS STRING * 36
END TYPE



TYPE FileAreaIRecord           'Len = 24
  MinDLSL    AS INTEGER
  MaxDLSL    AS INTEGER
  MinScanSL  AS INTEGER
  MaxScanSL  AS INTEGER
  Attr       AS INTEGER                 'x whether toggled ON or OFF.
  NewFilesPtr  AS LONG
  FileOp     AS INTEGER
  StartTime  AS INTEGER
  EndTime    AS INTEGER
  MaxMBSize  AS INTEGER
END TYPE


TYPE SummaryRec                    'Len = 146
  UserName       AS STRING * 30     'Mixed case.
  Location       AS STRING * 30     'Mixed case.
  BaudRate       AS STRING * 20
  CallerNum      AS LONG
  LastCallerNum  AS LONG
  DateOn         AS INTEGER
  TimeOn         AS INTEGER
  NodeOn         AS INTEGER
  TotalMinsUsed  AS INTEGER
  PagedSysop     AS INTEGER         'Number of times they've tried to page sysop.
  MsgsPosted     AS INTEGER         'Number of public messages posted.
  MsgsRcvd       AS INTEGER
  EMsgsPosted    AS INTEGER         'Number of private messages posted.
  EMsgsRcvd      AS INTEGER
  FMsgsPosted    AS INTEGER         'Number of feedback messages posted.
  NetMailSent    AS INTEGER         'Number of NetMail letters sent.
  NetMailRcvd    AS INTEGER         'Number of NetMail letters received.
  Dnlds          AS INTEGER         'Files downloaded.
  DLBytes        AS LONG            'Bytes downloaded.
  MinsDLing      AS INTEGER         'Number of minutes downloading.
  BadDLs         AS INTEGER         'Number of bad DL's.
  Uplds          AS INTEGER         'Files uploaded.
  ULBytes        AS LONG            'Bytes uploaded.
  MinsULing      AS INTEGER         'Number of minutes uploading.
  BadULs         AS INTEGER         'Number of bad UL's.
  Doors          AS INTEGER         'Number of accesses to doors.
  RamblesMade    AS INTEGER
  RamblesAdded   AS INTEGER  'fixed
  SL             AS INTEGER  'new
  MsgsReadOnLine AS INTEGER  'new
  MsgsUploaded   AS INTEGER  'new
  MsgsDownloaded AS INTEGER  'new
END TYPE



TYPE LZHHeaderType
  HeaderLength AS STRING * 2
  Method       AS STRING * 5
  StoredSize   AS LONG
  OriginalSize AS LONG
  FileTime     AS INTEGER
  FileDate     AS INTEGER
  Filler1      AS STRING * 2
  NameLength   AS STRING * 1
END TYPE

TYPE ZIPHeaderType
  TestString   AS STRING * 4          '= "PK"Chr$(3)Chr$(4)
  Version      AS INTEGER
  General      AS INTEGER
  Method       AS INTEGER
  FileTime     AS INTEGER
  FileDate     AS INTEGER
  CRC32        AS LONG
  StoredSize   AS LONG
  OriginalSize AS LONG
  NameLength   AS INTEGER
  HeaderLength AS INTEGER
END TYPE

TYPE ARJHeaderType
  Filler1      AS STRING * 2
  HeaderLength AS INTEGER
  Filler3      AS STRING * 5
  Method       AS STRING * 1
  EntryType    AS STRING * 4
  FileDate     AS INTEGER
  StoredSize   AS LONG
  OriginalSize AS LONG
  CRC32        AS LONG
  Filler2      AS STRING * 6
END TYPE


TYPE RamblingRecord         'Len = 77
  AccessSL    AS INTEGER
  NewFilesPtr   AS LONG
  LastDate    AS INTEGER
  Count       AS INTEGER
  Number      AS STRING * 3
  RambleOp    AS STRING * 30
  Title       AS STRING * 34
END TYPE


TYPE QWKType
  Status     AS STRING * 1
  MsgNum     AS STRING * 7
  DateSent   AS STRING * 8
  TimeSent   AS STRING * 5
  MsgTo      AS STRING * 25
  MsgFrom    AS STRING * 25
  MsgSubject AS STRING * 25
  Filler1    AS STRING * 12
  MsgNum2    AS STRING * 8
  NumRecs    AS STRING * 6
  Status2    AS STRING * 1
  IDXNum     AS INTEGER
  Filler2    AS STRING * 3
END TYPE


TYPE FidoPktMessage
  MsgType   AS INTEGER       '= 2
  OrigNode  AS INTEGER
  DestNode  AS INTEGER
  OrigNet   AS INTEGER
  DestNet   AS INTEGER
  Attr      AS INTEGER
  Cost      AS INTEGER
END TYPE


TYPE FidoPktHeader
  OrigNode  AS INTEGER
  DestNode  AS INTEGER
  Year      AS INTEGER
  Month     AS INTEGER
  Day       AS INTEGER
  Hour      AS INTEGER
  Minute    AS INTEGER
  Seconds   AS INTEGER
  Baud      AS INTEGER
  PktType   AS INTEGER      '= 2
  OrigNet   AS INTEGER
  DestNet   AS INTEGER
  ProdCode  AS STRING * 1
  Serial    AS STRING * 1
  Password  AS STRING * 8   'Chr$(0) terminated.
  OrigZone  AS INTEGER
  DestZone  AS INTEGER
  Filler1   AS STRING * 20  'all zero's
END TYPE





TYPE DoorRecord         'len = 244
  StartTime AS INTEGER              'Access allowed start time.
  EndTime   AS INTEGER              'Access allowed end time.
  MaxTime   AS INTEGER             'Absolute maximum time allowed in the
                                   'door, if Download Minutes is less than
                                   'this, then DL minutes is used instead.
  LogType   AS STRING * 1          '"0" to "9" type of logging to do
  MinSpace  AS LONG                '
  UserName  AS STRING * 30         'Door-op--get's 255 SL when exit to door.
  Path      AS STRING * 64
  Execute   AS STRING * 67           'Actual execution line
  Note      AS STRING * 66
  ExitType  AS INTEGER
  MinSL     AS INTEGER
  MaxSL     AS INTEGER
END TYPE


TYPE NodeIndexRecord
  Addr     AS STRING * 6
  NodeList AS STRING * 1
  Location AS LONG
END TYPE

TYPE MenuCmdRecord
  HotKey        AS STRING * 1
  Attributes    AS INTEGER
  MinSL         AS INTEGER
  MaxSL         AS INTEGER
  Cmd           AS STRING * 4
  SpecialFX     AS INTEGER
  row           AS INTEGER
  column        AS INTEGER
  TextToDisplay AS STRING * 40
END TYPE




TYPE TXTFileRecord                'len = 72
  Attr        AS INTEGER        '1 if force-read
  FileName    AS STRING * 12
  FileDate    AS INTEGER
  Description AS STRING * 52
  DLSizeK     AS INTEGER        'not for files, but for total in subareas.
  ViewSizeK   AS INTEGER        'not for files, but for total in subareas.
END TYPE

TYPE GaugeRecord
  StepSize    AS LONG
  NextStepNum AS LONG
  NextStep    AS INTEGER
END TYPE



'
' $INCLUDE: 'JDRBBS.DEF'
'



'
' Make many variables global.
'
COMMON SHARED _
  C0$, C1$, C7$, C8$, C13$, C32$, C41$, Null$, C1310$, _
  TGot$, TT$, ProtocolDn$, ProtocolUp$, _
  SqString$, UserMsgInfo$, BatchToDL$, MenuSet$, SpecialFX$, _
  BasesSize, DirsSize, LevelsSize, LESpecial, BaseIndex, TGot, TT, TT&, _
  UserSL, CommPort, ConnectCPS, FileIndex, GlobalStuff$(), _
  Work(), o$(), Chars$(), Colors$(), _
  FileNames() AS STRING * 40, Paths$(), Handle(), _
  Blocks&(), Lines$(), Short$(), UGInUse, DialSuccess, _
  GHoriz, GVert, GDepth, GInUse, GColor, GObjects$(), GDir$, GPattern, _
  GPatShift, MinTimer, GlobalBits, _
  FileAreaI() AS FileAreaIRecord, _
  Levels() AS LevelRecord, _
  UserIDX AS UsersNameInfo, FileIDX AS FileNameInfo, _
  Door AS DoorRecord, User AS UserRecord, AnyUser AS UserRecord, _
  Gauge AS GaugeRecord, _
  FFile AS FileInfo, FFile2 AS FileInfo, _
  FileList AS FileListRecord, Message AS MessageRecord, _
  Settings AS SettingsRecord, _
  LZHInfo AS LZHHeaderType, ZIPInfo AS ZIPHeaderType, _
  ARJInfo AS ARJHeaderType, Ramble as RamblingRecord, _
  SumLog AS SummaryRec, SumRec AS SummaryRec, QWKRec AS QWKType, _
  FidoMsg AS FidoPktMessage, FidoPkt AS FidoPktHeader, _
  NodeIndex AS NodeIndexRecord, TXTFileInfo AS TXTFileRecord, _
  MenuCmd AS MenuCmdRecord, MsgIDX as MessageInfo, _
  MsgArea AS MessageBaseRecord, FileArea AS FileAreaRecord, _
  MsgAreaI() AS MsgAreaIRecord




