# compress and output PostScript as assembly language data.
outfile != FILENAME {
	outfn = outfile = FILENAME;
	gsub(/.[^.]*$/, ".inc", outfn);
}
{
	gsub(/%.*$/,"");		# strip comments
	gsub(/[\t ]+/, " ");		# fold multiple whitespace into single.
	gsub(/^ +/, "");		# strip leading whitespace
	if ($0 != "") {			# don't print blank lines.
		printf("db '%s '\n", $0) >outfn;
	}
}

END {
	print "db CR,LF\n" >outfn;
}