	TITLE	Video, etc. Data for Modular Sequencer
	NAME	MBV
	.SALL
;==============================================================
; MusicBox Modular Sequencer, Version 2
; Video screen data
;--------------------------------------------------------------
; author: John Dunn
; date:   03/07/86
; update: 03/20/88
;--------------------------------------------------------------
; COPYRIGHT (C) 1986 John Dunn, All Rights Reserved 
; Entered into the Public Domain, March 20, 1988
;
; Use and copying of this software and preparation of derivative works
; based upon this software are permitted.  Any distribution of this
; software or derivative works must comply with all applicable United
; States export control laws.
; 
; This software is made available AS IS, and the author makes no warranty 
; about the software, its performance, or its conformity to any specification.
; 
; Any person obtaining a copy of this software is requested to send their
; name and address address to:
;
;       John Dunn, Senior Research Fellow
;       Time Arts Inc.
;       3436 Mendocino Ave.
;       Santa Rosa, CA 95401
;
;==============================================================
	include	order.asm
;--------------------------------------------------------------
        include equates.asm
;--------------------------------------------------------------
_TEXT   SEGMENT
        ASSUME DS:DGROUP, CS:_TEXT
        include extrn.asm
        extrn work:near
_TEXT   ENDS
;--------------------------------------------------------------
_DATA   SEGMENT
        ASSUME DS:DGROUP, CS:_TEXT
;--------------------------------------------------------------
; video data for modules
; Data format:
;       word0:  number of lines in the module
;       word1:  absolute offset of source module on master screen
;       word2,3,4:  att/char of the 3 characters in the line
;       word5,6,7:  next line, etc
;       entire list ends with -1
;
        even
        public  _modtxt
_modtxt equ     $
        public  $beta          ; real time clock
$beta   dw      (?beta-$beta)/6,        0000
        dw      rde+004h,whi+0e1h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0'
        dw      yel+'&' ,blu+'0' ,blu+'0'
?beta   equ     $
        public  $secs          ; real time clock
$secs   dw      (?secs-$secs)/6,        0000
        dw      yel+03ah,whi+092h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'0' ,yel+'0' ,yel+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+'m' ,blu+'0' ,blu+'0'
?secs   equ     $
        public  $lambda        ; real time clock
$lambda dw      (?lambda-$lambda)/6,        0000
        dw      rde+004h,whi+0e2h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0'
        dw      yel+'&' ,blu+'0' ,blu+'0'
?lambda equ     $
        public  $mclk           ; loop-driven clock
$mclk   dw      (?mclk-$mclk)/6,        0000
        dw      rde+004h,whi+0b3h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+'o' ,blu+'0' ,blu+'0'
?mclk   equ     $
        public  $mclock        ; mesure clock
$mclock dw      (?mclock-$mclock)/6,        0000
        dw      rde+004h,whi+0bah,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+09bh,blu+'0' ,blu+'0'
?mclock equ     $
        public  $muclk        ; real time clock
$muclk  dw      (?muclk-$muclk)/6,        0000
        dw      rde+004h,whi+0e6h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+09bh,blu+'0' ,blu+'0'
?muclk equ     $
        public  $gamma        ; real time clock
$gamma  dw      (?gamma-$gamma)/6,        0000
        dw      rde+004h,whi+0e7h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+09bh,blu+'0' ,blu+'0'
        dw      yel+'o' ,blu+'0' ,blu+'0'
?gamma equ     $
        public  $clock          ; note clock
$clock  dw      (?clock-$clock)/6,      0000
        dw      rde+004h,whi+00dh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+015h,blu+'0' ,blu+'1'
        dw      yel+00dh,blu+'0' ,blu+'3'
        dw      yel+'s' ,blu+'0' ,blu+'0'
        dw      yel+'o' ,blu+'0' ,blu+'0'
        dw      yel+'v' ,blu+'0' ,blu+'1'
?clock  equ     $
        public  $klock          ; note clock
$klock  dw      (?klock-$klock)/6,      0000
        dw      rde+004h,whi+00eh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+015h,blu+'0' ,blu+'1'
        dw      yel+00dh,blu+'0' ,blu+'3'
        dw      yel+'s' ,blu+'0' ,blu+'0'
        dw      yel+'o' ,blu+'0' ,blu+'0'
        dw      yel+'v' ,blu+'0' ,blu+'1'
?klock  equ     $
        public  $alpha          ; master control
$alpha  dw      (?alpha-$alpha)/6,      0000
        dw      rde+004h,whi+0e0h,whi+'$'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+'@' ,blu+'0' ,blu+'0'
        dw      yel+0e8h,blu+'0' ,blu+'0'
        dw      yel+0eah,blu+'0' ,blu+'1'
        dw      yel+'|' ,blu+'0' ,blu+'4'
        dw      yel+00dh,blu+'0' ,blu+'3'
        dw      yel+004h,blu+'7' ,blu+'8'
        dw      yel+'?' ,blu+'0' ,blu+'0'
        dw      yel+'s' ,blu+'0' ,blu+'0'
        dw      yel+0edh,blu+'0' ,blu+'0'
        dw      yel+0feh,yel+'1' ,yel+'0' 
?alpha  equ     $
        public  $wseq           ; staged sequencer
$wseq   dw      (?wseq-$wseq)/6,        0000
        dw      yel+03ah,whi+'w' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+040h,blu+'0' ,blu+'0' 
        dw      0c30h   ,blu+'0' ,blu+'0' ,yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' ,yel+'3' ,blu+'0' ,blu+'0' 
        dw      yel+'4' ,blu+'0' ,blu+'0' ,yel+'5' ,blu+'0' ,blu+'0' 
        dw      yel+'6' ,blu+'0' ,blu+'0' ,yel+'7' ,blu+'0' ,blu+'0' 
        dw      yel+'8' ,blu+'0' ,blu+'0' ,yel+'9' ,blu+'0' ,blu+'0' 
        dw      yel+'A' ,blu+'0' ,blu+'0' ,yel+'B' ,blu+'0' ,blu+'0' 
        dw      yel+'C' ,blu+'0' ,blu+'0' ,yel+'D' ,blu+'0' ,blu+'0' 
        dw      yel+'E' ,blu+'0' ,blu+'0' ,yel+'F' ,blu+'0' ,blu+'0' 
?wseq   equ     $
        public  $xseq           ; staged sequencer
$xseq   dw      (?xseq-$xseq)/6,        0000
        dw      yel+03ah,whi+'x' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      0c30h   ,blu+'0' ,blu+'0' ,yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' ,yel+'3' ,blu+'0' ,blu+'0' 
        dw      yel+'4' ,blu+'0' ,blu+'0' ,yel+'5' ,blu+'0' ,blu+'0' 
        dw      yel+'6' ,blu+'0' ,blu+'0' ,yel+'7' ,blu+'0' ,blu+'0' 
?xseq   equ     $
        public  $yseq           ; staged sequencer
$yseq   dw      (?yseq-$yseq)/6,        0000
        dw      yel+03ah,whi+'y' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      0c30h   ,blu+'0' ,blu+'0' ,yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' ,yel+'3' ,blu+'0' ,blu+'0' 
?yseq   equ     $
        public  $zseq           ; staged sequencer
$zseq   dw      (?zseq-$zseq)/6,        0000
        dw      yel+03ah,whi+'z' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+040h,blu+'0' ,blu+'0' 
        dw      0c30h   ,blu+'0' ,blu+'0' ,yel+'1' ,blu+'0' ,blu+'0' 
?zseq   equ     $
        public  $useq           ; switch seq
$useq   dw      (?useq-$useq)/6,        0000
        dw      yel+03ah,whi+'u' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
?useq   equ     $
        public  $vseq           ; switch seq
$vseq   dw      (?vseq-$vseq)/6,        0000
        dw      yel+03ah,whi+'v' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?vseq   equ     $
        public  $euseq          ; shift sequencer
$euseq  dw      (?euseq-$euseq)/6,      0000
        dw      mag+0f9h,whi+090h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0'
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
        dw      yel+0eah,blu+'0' ,blu+'1'
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?euseq  equ     $
        public  $puseq          ; address sequencer
$puseq  dw      (?puseq-$puseq)/6,      0000
        dw      yel+03ah,whi+'P' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+014h,blu+'0' ,blu+'0' 
        dw      yel+0eah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+026h,blu+'F' ,blu+'F' 
?puseq  equ     $
        public  $quseq          ; address sequencer
$quseq  dw      (?quseq-$quseq)/6,      0000
        dw      yel+03ah,whi+'Q' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?quseq  equ     $
        public  $ruseq          ; address sequencer
$ruseq  dw      (?ruseq-$ruseq)/6,      0000
        dw      yel+03ah,whi+'R' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?ruseq  equ     $
        public  $suseq          ; address sequencer
$suseq  dw      (?suseq-$suseq)/6,      0000
        dw      yel+03ah,whi+'S' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?suseq  equ     $
        public  $tuseq          ; address sequencer
$tuseq  dw      (?tuseq-$tuseq)/6,      0000
        dw      yel+03ah,whi+'T' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?tuseq  equ     $
        public  $pseq          ; step sequencer
$pseq   dw      (?pseq-$pseq)/6,        0000
        dw      mag+0f9h,whi+'p' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+0eah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+026h,blu+'F' ,blu+'F' 
?pseq  equ     $
        public  $qseq          ; step sequencer
$qseq   dw      (?qseq-$qseq)/6,        0000
        dw      mag+0f9h,whi+'q' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+012h,blu+'0' ,blu+'0' 
?qseq  equ     $
        public  $rseq          ; step sequencer
$rseq   dw      (?rseq-$rseq)/6,        0000
        dw      mag+0f9h,whi+'r' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+012h,blu+'0' ,blu+'0' 
?rseq   equ     $
        public  $sseq          ; step sequencer
$sseq   dw      (?sseq-$sseq)/6,        0000
        dw      mag+0f9h,whi+'s' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+012h,blu+'0' ,blu+'0' 
?sseq  equ     $
        public  $tseq          ; step sequencer
$tseq   dw      (?tseq-$tseq)/6,        0000
        dw      mag+0f9h,whi+'t' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+040h,blu+'0' ,blu+'0' ,yel+012h,blu+'0' ,blu+'0' 
?tseq  equ     $
        public  $domute         ; master control
$domute dw      (?domute-$domute)/6,      0000
        dw      yel+03ah,whi+0e8h,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'0' ,blu+'0' ,blu+'0'
        dw      yel+'8' ,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0'
        dw      yel+'&' ,blu+'0' ,blu+'0'
?domute equ     $
        public  $gatel          ; show byte to leds 0-7
$gatel  dw      (?gatel-$gatel)/6,      0000
        dw      yel+03ah,whi+';' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      rde+004h,yel+02dh,yel+'0' ,rde+004h,yel+02dh,yel+'1' 
        dw      rde+004h,yel+02dh,yel+'2' ,rde+004h,yel+02dh,yel+'3' 
        dw      rde+004h,yel+02dh,yel+'4' ,rde+004h,yel+02dh,yel+'5' 
        dw      rde+004h,yel+02dh,yel+'6' ,rde+004h,yel+02dh,yel+'7' 
?gatel  equ     $
        public  $gout          ; do byte to leds 0-7
$gout   dw      (?gout-$gout)/6,      0000
        dw      yel+03ah,whi+0feh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'0' ,blu+'0' ,blu+'0' ,yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' ,yel+'3' ,blu+'0' ,blu+'0' 
        dw      yel+'4' ,blu+'0' ,blu+'0' ,yel+'5' ,blu+'0' ,blu+'0' 
        dw      yel+'6' ,blu+'0' ,blu+'0' ,yel+'7' ,blu+'0' ,blu+'0' 
?gout   equ     $
        public  $iclock          ; interference clock
$iclock dw      (?iclock-$iclock)/6,    0000
        dw      rde+004h,whi+003h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
?iclock equ     $
        public  $kclock          ; interference clock
$kclock dw      (?kclock-$kclock)/6,    0000
        dw      rde+004h,whi+09bh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0' 
?kclock equ     $
        public  $icount          ; addresser/counter
$icount dw      (?icount-$icount)/6,    0000
        dw      yel+03ah,whi+'I' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
?icount equ     $
        public  $ocount          ; addresser/counter
$ocount dw      (?ocount-$ocount)/6,    0000
        dw      yel+03ah,whi+'O' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' 
?ocount equ     $
        public  $jcount          ; addresser/counter
$jcount dw      (?jcount-$jcount)/6,    0000
        dw      yel+03ah,whi+'J' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
?jcount equ     $
        public  $kcount          ; addresser/counter
$kcount dw      (?kcount-$kcount)/6,    0000
        dw      yel+03ah,whi+'K' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' ,yel+023h,blu+'0' ,blu+'0' 
?kcount equ     $
        public  $lcount          ; addresser/counter
$lcount dw      (?lcount-$lcount)/6,    0000
        dw      yel+03ah,whi+'L' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' ,yel+019h,blu+'0' ,blu+'0' 
?lcount equ     $
        public  $mcount          ; addresser/counter
$mcount dw      (?mcount-$mcount)/6,    0000
        dw      yel+03ah,whi+'M' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' ,yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' ,yel+019h,blu+'0' ,blu+'0' 
?mcount equ     $
        public  $ncount          ; addresser/counter
$ncount dw      (?ncount-$ncount)/6,    0000
        dw      yel+03ah,whi+'N' ,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0'
        dw      yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+040h,blu+'0' ,blu+'0'
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
?ncount equ     $
        public  $randp          ; raw random generator
$randp  dw      (?randp-$randp)/6,      0000
        dw      rde+004h,whi+0adh,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0'
?randp  equ     $
        public  $nrand          ; raw random generator
$nrand  dw      (?nrand-$nrand)/6,      0000
        dw      rde+004h,whi+0c1h,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+09bh,blu+'0' ,blu+'0'
        dw      yel+'o' ,blu+'0' ,blu+'0'
        dw      yel+'%' ,blu+'0' ,blu+'0'
?nrand  equ     $
         public  $trand          ; rand tone row 0-11
$trand  dw      (?trand-$trand)/6,        0000
        dw      yel+03ah,whi+0ech,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' ,yel+'!' ,blu+'0' ,blu+'0' 
?trand  equ     $
        public  $rand          ; random generator
$rand   dw      (?rand-$rand)/6,        0000
        dw      yel+03ah,whi+03fh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+015h,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?rand   equ     $
        public  $rrand          ; raw random generator
$rrand  dw      (?rrand-$rrand)/6,      0000
        dw      yel+03ah,whi+0a8h,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+015h,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' 
?rrand  equ     $
        public  $variz          ; rand tone row 0-11
$variz  dw      (?variz-$variz)/6,        0000
        dw      yel+03ah,whi+'i' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0'
        dw      yel+018h,blu+'0' ,blu+'0' 
?variz  equ     $
        public  $variy          ; rand tone row 0-11
$variy  dw      (?variy-$variy)/6,        0000
        dw      yel+03ah,whi+'j' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0'
        dw      yel+018h,blu+'0' ,blu+'0' 
?variy  equ     $
        public  $variv          ; rand tone row 0-11
$variv  dw      (?variv-$variv)/6,        0000
        dw      yel+03ah,whi+'k' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+018h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?variv  equ     $
        public  $varix          ; rand tone row 0-11
$varix  dw      (?varix-$varix)/6,        0000
        dw      yel+03ah,whi+'l' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+0f1h,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?varix  equ     $
        public  $sandh          ; saple and hold
$sandh  dw      (?sandh-$sandh)/6,      0000
        dw      yel+03ah,whi+015h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0'
        dw      yel+'=' ,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
?sandh  equ     $
        public  $andl           ; and logic
$andl   dw      (?andl-$andl)/6,        0000
        dw      yel+03ah,whi+'&' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' ,yel+'x' ,blu+'0' ,blu+'0' 
?andl   equ     $
        public  $orl            ; or logic
$orl    dw      (?orl-$orl)/6,          0000
        dw      yel+03ah,whi+'|' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?orl    equ     $
        public  $notl           ; not logic
$notl   dw      (?notl-$notl)/6,        0000
        dw      yel+03ah,whi+0edh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+0edh,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' 
 ?notl   equ     $
        public  $delay          ; delay
$delay  dw      (?delay-$delay)/6,      0000
        dw      yel+03ah,whi+0D0h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+09bh,blu+'0' ,blu+'0' ,yel+'+' ,blu+'0' ,blu+'0'
?delay  equ     $
        public  $slope          ; slope detector
$slope  dw      (?slope-$slope)/6,      0000
        dw      rde+004h,whi+05ch,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?slope  equ     $
        public  $twopwr          ; twopwr/offset
$twopwr dw      (?twopwr-$twopwr)/6,    0000
        dw      yel+03ah,whi+05eh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+05eh,blu+'0' ,blu+'0' 
?twopwr  equ     $
        public  $scale          ; scale/offset
$scale  dw      (?scale-$scale)/6,      0000
        dw      yel+03ah,whi+025h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+025h,blu+'0' ,blu+'0' ,yel+02bh,blu+'0' ,blu+'0' 
?scale  equ     $
        public  $sumit          ; scaled sum of 4 inputs 
$sumit  dw      (?sumit-$sumit)/6,      0000
        dw      yel+03ah,whi+0e4h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+025h,blu+'0' ,blu+'0' ,yel+02bh,blu+'0' ,blu+'0' 
?sumit  equ     $
        public  $mixit          ; scaled sum of 4 inputs 
$mixit  dw      (?mixit-$mixit)/6,      0000
        dw      yel+03ah,whi+0eeh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+025h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+025h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+025h,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
?mixit  equ     $
        public  $limit          ; limiter
$limit  dw      (?limit-$limit)/6,      0000
        dw      yel+03ah,whi+017h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' ,yel+019h,blu+'0' ,blu+'0' 
?limit  equ     $
        public  $apprx          ; rand + scale + offsets
$apprx  dw      (?apprx-$apprx)/6,      0000
        dw      yel+03ah,whi+0F7h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' ,yel+019h,blu+'0' ,blu+'0' 
?apprx  equ     $
        public  $delta          ; size of change
$delta  dw      (?delta-$delta)/6,      0000
        dw      yel+03ah,whi+07Fh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0'
?delta  equ     $
        public  $cmak             ; chord generator
$cmak   dw      (?cmak-$cmak)/6,         0000
        dw      yel+03ah,whi+013h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+0a2h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+01dh,blu+'0' ,blu+'0' 
        dw      yel+09fh,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
?cmak   equ     $
        public  $cgen             ; chord generator
$cgen   dw      (?cgen-$cgen)/6,         0000
        dw      yel+03ah,whi+'!' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
        dw      yel+0a2h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+01dh,blu+'0' ,blu+'0' 
        dw      yel+09fh,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
?cgen   equ     $
        public  $cplay            ; chord play
$cplay  dw      (?cplay-$cplay)/6,       0000
        dw      yel+03ah,whi+080h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+01dh,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?cplay  equ     $
        public  $cplai            ; chord play
$cplai  dw      (?cplai-$cplai)/6,       0000
        dw      yel+03ah,whi+087h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+01dh,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?cplai  equ     $
        public  $cstor            ; chord store
$cstor  dw      (?cstor-$cstor)/6,       0000
        dw      yel+03ah,whi+'@' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+0a2h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
?cstor  equ     $
        public  $sort             ; sort
$sort   dw      (?sort-$sort)/6,         0000
        dw      yel+03ah,whi+01dh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
?sort   equ     $
        public  $bassd            ; dithered bass
$bassd  dw      (?bassd-$bassd)/6,         0000
        dw      yel+03ah,whi+':' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'#' ,blu+'0' ,blu+'0' 
        dw      yel+0f1h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'-' ,blu+'0' ,blu+'0' 
?bassd  equ     $
        public  $deltat            ; delta test
$deltat dw      (?deltat-$deltat)/6,       0000
        dw      rde+004h,whi+0a6h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' 
        dw      yel+07fh,blu+'0' ,blu+'0' 
        dw      yel+093h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?deltat equ     $
        public  $mul12            ; * 12
$mul12  dw      (?mul12-$mul12)/6,       0000
        dw      yel+03ah,whi+0f8h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?mul12  equ     $
        public  $div12            ; div 12
$div12  dw      (?div12-$div12)/6,       0000
        dw      yel+03ah,whi+0f6h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?div12  equ     $
        public  $mod12            ; mod 12
$mod12  dw      (?mod12-$mod12)/6,       0000
        dw      yel+03ah,whi+0a2h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?mod12  equ     $
        public  $fold            ; fold octave
$fold   dw      (?fold-$fold)/6,       0000
        dw      yel+03ah,whi+0f4h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+093h,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?fold   equ     $
        public  $dither           ; dither
$dither dw      (?dither-$dither)/6,        0000
        dw      yel+03ah,whi+006h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?dither equ     $
        public  $dithzr           ; dithzr
$dithzr dw      (?dithzr-$dithzr)/6,        0000
        dw      yel+03ah,whi+005h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?dithzr equ     $
        public  $ddithr           ; dither
$ddithr dw      (?ddithr-$ddithr)/6,        0000
        dw      rde+004h,whi+004h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'=' ,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
?ddithr equ     $
        public  $odds           ; dither
$odds   dw      (?odds-$odds)/6,        0000
        dw      yel+03ah,whi+0ach,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
?odds equ     $
        public  $oddz           ; dither
$oddz   dw      (?oddz-$oddz)/6,        0000
        dw      yel+03ah,whi+084h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
?oddz equ     $
        public  $ratio          ; dither
$ratio  dw      (?ratio-$ratio)/6,    0000
        dw      yel+03ah,whi+08fh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
?ratio equ     $
        public  $ratiz          ; dither
$ratiz  dw      (?ratiz-$ratiz)/6,    0000
        dw      yel+03ah,whi+08eh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
?ratiz equ     $
        public  $filter         ; size of change
$filter dw      (?filter-$filter)/6,    0000
        dw      yel+03ah,whi+09Fh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+09fh,blu+'0' ,blu+'0' 
        dw      yel+02bh,blu+'0' ,blu+'0' 
?filter equ     $
        public  $fflop          ; flip flop
$fflop  dw      (?fflop-$fflop)/6,      0000
        dw      rde+004h,whi+0e9h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+073h,blu+'0' ,blu+'0' 
        dw      yel+072h,blu+'0' ,blu+'0' 
?fflop equ     $
        public  $union          ; time union
$union  dw      (?union-$union)/6,      0000
        dw      rde+004h,whi+0efh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'t' ,blu+'0' ,blu+'0' 
        dw      yel+'s' ,blu+'0' ,blu+'0' 
?union equ     $
        public  $passt          ; pass thru
$passt  dw      (?passt-$passt)/6,      0000
        dw      yel+03ah,whi+0d6h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0abh,blu+'0' ,blu+'0' 
        dw      yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' 
?passt equ     $
        public  $passq          ; pass thru
$passq  dw      (?passq-$passq)/6,      0000
        dw      yel+03ah,whi+0b7h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0abh,blu+'0' ,blu+'0' 
        dw      yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?passq equ     $
        public  $rangep         ; bounds check
$rangep dw      (?rangep-$rangep)/6,    0000
        dw      rde+004h,whi+0cah,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+018h,blu+'0' ,blu+'0' ,yel+019h,blu+'0' ,blu+'0' 
?rangep equ     $
        public  $quant          ; quantize
$quant  dw      (?quant-$quant)/6,        0000
        dw      yel+03ah,whi+0fch,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+0f6h,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'e' ,blu+'0' ,blu+'0' 
        dw      yel+'f' ,blu+'0' ,blu+'0' 
        dw      yel+'g' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
?quant  equ     $
        public  $lastv         ; last change
$lastv dw      (?lastv-$lastv)/6,        0000
        dw      yel+03ah,whi+00ch,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'e' ,blu+'0' ,blu+'0' 
        dw      yel+'f' ,blu+'0' ,blu+'0' 
        dw      yel+'g' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
?lastv equ     $
        public  $xcall          ; external call
$xcall  dw      (?xcall-$xcall)/6,        0000
        dw      yel+03ah,whi+08ah,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+08aH,blu+'0' ,blu+'0' 
        dw      yel+'A' ,blu+'0' ,blu+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'B' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'C' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'D' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
?xcall  equ     $
        public  $rcall          ; get registers
$rcall  dw      (?rcall-$rcall)/6,        0000
        dw      yel+03ah,whi+088h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'r' ,blu+'0' ,blu+'0' 
?rcall  equ     $
        public  $tstmob           ; test midi out buffer
$tstmob dw      (?tstmob-$tstmob)/6,        0000
        dw      rde+004h,whi+0f9h,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
?tstmob equ     $
        public  $xmidii           ; get midi input
$xmidii dw      (?xmidii-$xmidii)/6,        0000
        dw      yel+03ah,whi+01ah,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+0eah,blu+'0' ,blu+'0' 
?xmidii equ     $
        public  $mpuins           ; mpu input status
$mpuins dw      (?mpuins-$mpuins)/6,        0000
        dw      rde+004h,whi+0abh,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0'
        dw      yel+'&' ,blu+'0' ,blu+'3'
?mpuins equ     $
        public  $xkbd           ; get keyboard input
$xkbd   dw      (?xkbd-$xkbd)/6,        0000
        dw      yel+03ah,whi+0fbh,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' 
?xkbd   equ     $
         public  $poke          ; byte write
$poke   dw      (?poke-$poke)/6,        0000
        dw      yel+03ah,whi+07bh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'$' ,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
?poke   equ     $
        public  $peek          ; byte read
$peek   dw      (?peek-$peek)/6,        0000
        dw      yel+03ah,whi+07dh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'$' ,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
?peek   equ     $
        public  $outpb          ; byte output  
$outpb  dw      (?outpb-$outpb)/6,        0000
        dw      yel+03ah,whi+095h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'P' ,blu+'0' ,blu+'0' 
        dw      yel+'p' ,blu+'0' ,blu+'0' 
?outpb  equ     $
        public  $inptb          ; byte input  
$inptb  dw      (?inptb-$inptb)/6,        0000
        dw      yel+03ah,whi+08dh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'P' ,blu+'0' ,blu+'0' 
        dw      yel+'p' ,blu+'0' ,blu+'0' 
?inptb  equ     $
        public  $emeter         ; indicator meter
$emeter dw      (?emeter-$emeter)/6,        0000
        dw      yel+03ah,whi+096h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'l' ,blu+'0' ,blu+'0' 
        dw      yel+'r' ,blu+'0' ,blu+'0' 
        dw      yel+'*' ,blu+'0' ,blu+'0' 
        dw      yel+0f9h,rde+'8' ,rde+'8'
        dw      yel+0f9h,yel+'7' ,yel+'7'
        dw      yel+0f9h,yel+'6' ,yel+'6'
        dw      yel+0f9h,yel+'5' ,yel+'5'
        dw      yel+0f9h,yel+'4' ,yel+'4'
        dw      yel+0f9h,yel+'3' ,yel+'3'
        dw      yel+0f9h,yel+'2' ,yel+'2'
        dw      yel+0f9h,yel+'1' ,yel+'1'
?emeter equ     $
        public  $imeter         ; indicator meter
$imeter dw      (?imeter-$imeter)/6,        0000
        dw      yel+03ah,whi+097h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'l' ,blu+'0' ,blu+'0' 
        dw      yel+'r' ,blu+'0' ,blu+'0' 
        dw      yel+'%' ,blu+'0' ,blu+'0' 
        dw      yel+0f9h,rde+'8' ,rde+'8'
        dw      yel+0f9h,yel+'7' ,yel+'7'
        dw      yel+0f9h,yel+'6' ,yel+'6'
        dw      yel+0f9h,yel+'5' ,yel+'5'
        dw      yel+0f9h,yel+'4' ,yel+'4'
        dw      yel+0f9h,yel+'3' ,yel+'3'
        dw      yel+0f9h,yel+'2' ,yel+'2'
        dw      yel+0f9h,yel+'1' ,yel+'1'
?imeter equ     $
        public  $higher         ; latch highest input
$higher dw      (?higher-$higher)/6,    0000
        dw      yel+03ah,whi+01eh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?higher equ     $
        public  $lower          ; latch lowest input
$lower  dw      (?lower-$lower)/6,      0000
        dw      yel+03ah,whi+01fh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?lower  equ     $
        public  $maxf           ; latch highest input
$maxf   dw      (?maxf-$maxf)/6,        0000
        dw      yel+03ah,whi+018h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?maxf   equ     $
        public  $minf           ; latch lowest input
$minf   dw      (?minf-$minf)/6,        0000
        dw      yel+03ah,whi+019h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?minf   equ     $
        public  $rshift         ; right shift
$rshift dw      (?rshift-$rshift)/6,    0000
        dw      yel+03ah,whi+0AFh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+0AFh,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0'
?rshift equ     $
        public  $lshift         ; left shift
$lshift dw      (?lshift-$lshift)/6,    0000
        dw      yel+03ah,whi+0AEh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+0AEh,blu+'0' ,blu+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0'
?lshift equ     $
        public  $times          ; multiply & divide
$times  dw      (?times-$times)/6,      0000
        dw      yel+03ah,whi+'*' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'*' ,blu+'0' ,blu+'0' 
        dw      yel+'*' ,blu+'0' ,blu+'0' 
        dw      yel+0f6h,blu+'0' ,blu+'0' 
?times  equ     $
        public  $stopo          ; sync interface
$stopo  dw      (?stopo-$stopo)/6,      0000
        dw      rde+004h,whi+09dh,whi+'$'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'S' ,blu+'0' ,blu+'0'
        dw      yel+'G' ,blu+'0' ,blu+'0'
        dw      yel+'C' ,blu+'0' ,blu+'0'
        dw      yel+'R' ,blu+'0' ,blu+'0'
        dw      yel+'T' ,blu+'0' ,blu+'0'
        dw      yel+'!' ,blu+'0' ,blu+'0'
?stopo  equ     $
        public  $modulo          ; divide
$modulo dw      (?modulo-$modulo)/6,      0000
        dw      yel+03ah,whi+'/' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+'/' ,blu+'0' ,blu+'0' 
?modulo equ     $
        public  $plus           ; add
$plus   dw      (?plus-$plus)/6,        0000
        dw      yel+03ah,whi+'+' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?plus   equ     $
        public  $plusm           ; add, subtract
$plusm  dw      (?plusm-$plusm)/6,      0000
        dw      yel+03ah,whi+0f1h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'-' ,blu+'0' ,blu+'0' 
?plusm  equ     $
        public  $plusn           ; add, subtract
$plusn  dw      (?plusn-$plusn)/6,      0000
        dw      yel+03ah,whi+'-' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
        dw      yel+'-' ,blu+'0' ,blu+'0' 
?plusn  equ     $
        public  $change          ; true if change
$change dw      (?change-$change)/6,    0000
        dw      rde+004h,whi+00bh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?change equ     $
        public  $equal          ; true if equal
$equal  dw      (?equal-$equal)/6,      0000
        dw      rde+004h,whi+03dh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?equal  equ     $
        public  $nequal          ; true if nequal
$nequal dw      (?nequal-$nequal)/6,    0000
        dw      rde+004h,whi+0A7h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?nequal  equ     $
        public  $great          ; true if greater
$great  dw      (?great-$great)/6,      0000
        dw      rde+004h,whi+03eh,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+061h,blu+'0' ,blu+'0' ,yel+062h,blu+'0' ,blu+'0' 
?great  equ     $
        public  $lessp          ; true if less
$lessp  dw      (?lessp-$lessp)/6,      0000
        dw      rde+004h,whi+03ch,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+061h,blu+'0' ,blu+'0' ,yel+062h,blu+'0' ,blu+'0' 
?lessp  equ     $
        public  $bitsp          ; true if mask bit nz
$bitsp  dw      (?bitsp-$bitsp)/6,      0000
        dw      rde+004h,whi+0c2h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+01dh,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?bitsp  equ     $
        public  $bitsq          ; true if mask bit nz
$bitsq  dw      (?bitsq-$bitsq)/6,      0000
        dw      rde+004h,whi+0d1h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' ,yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?bitsq  equ     $
        public  $maskl          ; AND mask
$maskl  dw      (?maskl-$maskl)/6,        0000
        dw      yel+03ah,whi+0a9h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' ,yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+0AEh,blu+'0' ,blu+'0' 
?maskl  equ     $
        public  $maskr          ; AND mask
$maskr  dw      (?maskr-$maskr)/6,        0000
        dw      yel+03ah,whi+0aah,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' ,yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+0AFh,blu+'0' ,blu+'0' 
?maskr  equ     $
        public  $mask           ; AND mask
$mask   dw      (?mask-$mask)/6,        0000
        dw      yel+03ah,whi+091h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'&' ,blu+'0' ,blu+'0' ,yel+'&' ,blu+'0' ,blu+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0' 
?mask   equ     $
        public  $truep          ; true if zero
$truep  dw      (?truep-$truep)/6,      0000
        dw      rde+004h,whi+022h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?truep  equ     $
        public  $zerop          ; true if zero
$zerop  dw      (?zerop-$zerop)/6,      0000
        dw      rde+004h,whi+007h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?zerop  equ     $
         public  $minusp          ; true if minus
$minusp dw      (?minusp-$minusp)/6,    0000
        dw      rde+004h,whi+0a4h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?minusp  equ     $
        public  $asciz          ; asciz readout
$asciz  dw      (?asciz-$asciz)/6,    0000
        dw      yel+03ah,whi+086h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+' ' ,yel+' ' ,yel+' ' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?asciz equ     $
        public  $ascis          ; ascis readout
$ascis  dw      (?ascis-$ascis)/6,    0000
        dw      yel+03ah,whi+083h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+' ' ,yel+' ' ,yel+' ' 
        dw      yel+'@' ,blu+'0' ,blu+'0' 
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+012h,blu+'0' ,blu+'0' 
?ascis equ     $
        public  $ascii          ; ascii readout
$ascii  dw      (?ascii-$ascii)/6,    0000
        dw      yel+03ah,whi+0a0h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+' ' ,yel+' ' ,yel+' ' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?ascii equ     $
        public  $decin          ; deciaml readout
$decin  dw      (?decin-$decin)/6,    0000
        dw      yel+03ah,whi+001h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'0' ,yel+'0' ,yel+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?decin equ     $
        public  $decim          ; deciaml readout
$decim  dw      (?decim-$decim)/6,    0000
        dw      yel+03ah,whi+'.' ,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'0' ,yel+'0' ,yel+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?decim equ     $
        public  $noter          ; deciaml readout
$noter  dw      (?noter-$noter)/6,    0000
        dw      yel+03ah,whi+0d5h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'0' ,yel+'0' ,yel+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?noter equ     $
        public  $negate           ; negate
$negate dw      (?negate-$negate)/6,    0000
        dw      yel+03ah,whi+0A5h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?negate  equ     $
        public  $value          ; numerical value
$value  dw      (?value-$value)/6,      0000
        dw      yel+03ah,whi+023h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' ,yel+01ah,blu+'0' ,blu+'0' 
?value  equ     $
        public  $pusha          ; on/off pushbutton
$pusha  dw      (?pusha-$pusha)/6,      0000
        dw      rde+004h,whi+0e3h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+009h,mag+0b0h,mag+0b0h
?pusha  equ     $
        public  $pushb          ; oneshot pushbutton
$pushb  dw      (?pushb-$pushb)/6,      0000
        dw      rde+004h,whi+009h,whi+'0' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' ,yel+009h,mag+0b0h,mag+0b0h
?pushb  equ     $
        public  $pushc          ; inc/dec pushbutton
$pushc  dw      (?pushc-$pushc)/6,      0000
        dw      yel+03ah,whi+012h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'#' ,mag+'0' ,mag+'0' 
        dw      yel+009h,mag+01eh,mag+01fh
?pushc  equ     $
        public  $ltimer          ; loop timer
$ltimer dw      (?ltimer-$ltimer)/6,    0000
        dw      rde+004h,whi+0d9h,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
?ltimer equ     $
        public  $ctimer          ; clock timer
$ctimer dw      (?ctimer-$ctimer)/6,    0000
        dw      rde+004h,whi+0beh,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
?ctimer equ     $
        public  $atimer          ; abs timer
$atimer dw      (?atimer-$atimer)/6,    0000
        dw      rde+004h,whi+0bch,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
?atimer equ     $
        public  $stimer          ; sec timer
$stimer dw      (?stimer-$stimer)/6,    0000
        dw      rde+004h,whi+0bdh,whi+'0'
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+03dh,cyn+'0' ,cyn+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'d' ,blu+'0' ,blu+'0' 
        dw      yel+'h' ,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
?stimer equ     $
        public  $slew           ; slew value over time
$slew   dw      (?slew-$slew )/6,       0000
        dw      yel+03ah,whi+0e5h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'r' ,blu+'0' ,blu+'0' 
?slew   equ     $
        public  $xslew          ; xslew value over time
$xslew  dw      (?xslew-$xslew )/6,       0000
        dw      yel+03ah,whi+0ebh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'a' ,blu+'0' ,blu+'0' 
        dw      yel+'b' ,blu+'0' ,blu+'0' 
        dw      yel+'t' ,blu+'0' ,blu+'0' 
?xslew  equ     $
        public  $mapo          ; midi control mapping
$mapo   dw      (?mapo-$mapo)/6,      0000
        dw      yel+03ah,whi+094h,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'V' ,mag+'0' ,mag+'0' 
        dw      yel+'M' ,mag+'0' ,mag+'0' 
        dw      yel+'A' ,mag+'0' ,mag+'0' 
        dw      yel+'B' ,mag+'0' ,mag+'0' 
        dw      yel+'C' ,mag+'0' ,mag+'0' 
        dw      yel+'D' ,mag+'0' ,mag+'0' 
        dw      yel+'1' ,mag+'0' ,mag+'0' 
        dw      yel+'2' ,mag+'0' ,mag+'0' 
?mapo   equ     $
        public  $mapp          ; midi control mapping
$mapp   dw      (?mapp-$mapp)/6,      0000
        dw      yel+03ah,whi+081h,whi+'$' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'V' ,mag+'0' ,mag+'0' 
        dw      yel+'M' ,mag+'0' ,mag+'0' 
        dw      yel+'A' ,mag+'0' ,mag+'0' 
        dw      yel+'B' ,mag+'0' ,mag+'0' 
        dw      yel+'C' ,mag+'0' ,mag+'0' 
        dw      yel+'D' ,mag+'0' ,mag+'0' 
        dw      yel+'1' ,mag+'0' ,mag+'0' 
        dw      yel+'2' ,mag+'0' ,mag+'0' 
?mapp   equ     $
        public  $sxget          ; midi sys excl get
$sxget  dw      (?sxget-$sxget)/6,      0000
        dw      yel+03ah,whi+010h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0'
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
?sxget  equ     $
        public  $sxput          ; midi sys excl send
$sxput  dw      (?sxput-$sxput)/6,      0000
        dw      yel+03ah,whi+011h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'@' ,blu+'0' ,blu+'0'
        dw      yel+014h,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+0afh,blu+'0' ,blu+'0' 
?sxput  equ     $
        public  $addswa         ; prog switch out
$addswa dw      (?addswa-$addswa)/6,    0000
        dw      yel+03ah,whi+0f0h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+0f0h,blu+'0' ,blu+'0'
        dw      yel+'0' ,blu+'0' ,blu+'0'
        dw      yel+'1' ,blu+'0' ,blu+'0'
        dw      yel+'2' ,blu+'0' ,blu+'0'
        dw      yel+'3' ,blu+'0' ,blu+'0'
        dw      yel+'4' ,blu+'0' ,blu+'0'
        dw      yel+'5' ,blu+'0' ,blu+'0'
        dw      yel+'6' ,blu+'0' ,blu+'0'
        dw      yel+'7' ,blu+'0' ,blu+'0'
?addswa equ     $
        public  $psouta         ; prog switch out
$psouta dw      (?psouta-$psouta)/6,    0000
        dw      yel+03ah,whi+'a' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0a9h,blu+'0' ,blu+'0'
?psouta equ     $
        public  $psoutb         ; prog switch out
$psoutb dw      (?psoutb-$psoutb)/6,    0000
        dw      yel+03ah,whi+'b' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0aah,blu+'0' ,blu+'0'
?psoutb equ     $
        public  $psoutc         ; prog switch out
$psoutc dw      (?psoutc-$psoutc)/6,    0000
        dw      yel+03ah,whi+'c' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0a9h,blu+'0' ,blu+'0'
?psoutc equ     $
        public  $psoutd         ; prog switch out
$psoutd dw      (?psoutd-$psoutd)/6,    0000
        dw      yel+03ah,whi+'d' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0aah,blu+'0' ,blu+'0'
?psoutd equ     $
        public  $psoute         ; prog switch out
$psoute dw      (?psoute-$psoute)/6,    0000
        dw      yel+03ah,whi+'e' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0a9h,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0'
?psoute equ     $
        public  $psoutf         ; prog switch out
$psoutf dw      (?psoutf-$psoutf)/6,    0000
        dw      yel+03ah,whi+'f' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+'+' ,blu+'0' ,blu+'0'
        dw      yel+0a9h,blu+'0' ,blu+'0'
        dw      yel+0afh,blu+'0' ,blu+'0'
?psoutf equ     $
        public  $pcouta         ; prog control out
$pcouta dw      (?pcouta-$pcouta)/6,    0000
        dw      mag+0f9h,whi+'A' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcouta equ     $
        public  $pcoutb         ; prog control out
$pcoutb dw      (?pcoutb-$pcoutb)/6,    0000
        dw      mag+0f9h,whi+'B' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutb equ     $
        public  $pcoutc         ; prog control out
$pcoutc dw      (?pcoutc-$pcoutc)/6,    0000
        dw      mag+0f9h,whi+'C' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutc equ     $
        public  $pcoutd         ; prog control out
$pcoutd dw      (?pcoutd-$pcoutd)/6,    0000
        dw      mag+0f9h,whi+'D' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutd equ     $
        public  $pcoute         ; prog control out
$pcoute dw      (?pcoute-$pcoute)/6,    0000
        dw      mag+0f9h,whi+'E' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoute equ     $
        public  $pcoutf         ; prog control out
$pcoutf dw      (?pcoutf-$pcoutf)/6,    0000
        dw      mag+0f9h,whi+'F' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutf equ     $
        public  $pcoutg         ; prog control out
$pcoutg dw      (?pcoutg-$pcoutg)/6,    0000
        dw      mag+0f9h,whi+'G' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutg equ     $
        public  $pcouth         ; prog control out
$pcouth dw      (?pcouth-$pcouth)/6,    0000
        dw      mag+0f9h,whi+'H' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcouth equ     $
        public  $pcoutx         ; prog control out
$pcoutx dw      (?pcoutx-$pcoutx)/6,    0000
        dw      mag+0f9h,whi+'X' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutx equ     $
        public  $pcouty         ; prog control out
$pcouty dw      (?pcouty-$pcouty)/6,    0000
        dw      mag+0f9h,whi+'Y' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcouty equ     $
        public  $pcoutz         ; prog control out
$pcoutz dw      (?pcoutz-$pcoutz)/6,    0000
        dw      mag+0f9h,whi+'Z' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
?pcoutz equ     $
        public  $progo          ; midi program change
$progo  dw      (?progo-$progo)/6,      0000
        dw      yel+03ah,whi+0eah,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'@' ,mag+'0' ,mag+'0' 
        dw      yel+088h,mag+'0' ,mag+'0' 
        dw      yel+'U' ,mag+'#' ,mag+'#'
        dw      yel+013h,mag+'#' ,mag+'#'
        dw      yel+'R' ,mag+'#' ,mag+'#'
        dw      yel+'S' ,mag+'#' ,mag+'#'
        dw      yel+'|' ,mag+'0' ,mag+'0' 
        dw      yel+'X' ,mag+'0' ,mag+'0' 
        dw      yel+'Y' ,mag+'0' ,mag+'0' 
        dw      yel+'Z' ,mag+'0' ,mag+'0' 
        dw      yel+'A' ,mag+'0' ,mag+'0' 
        dw      yel+'B' ,mag+'0' ,mag+'0' 
        dw      yel+'C' ,mag+'0' ,mag+'0' 
        dw      yel+'D' ,mag+'0' ,mag+'0' 
        dw      yel+'E' ,mag+'0' ,mag+'0' 
        dw      yel+'e' ,mag+'0' ,mag+'0' 
        dw      yel+'F' ,mag+'0' ,mag+'0' 
        dw      yel+'f' ,mag+'0' ,mag+'0' 
        dw      yel+'G' ,mag+'0' ,mag+'0' 
        dw      yel+'g' ,mag+'0' ,mag+'0' 
        dw      yel+'H' ,mag+'0' ,mag+'0' 
        dw      yel+'h' ,mag+'0' ,mag+'0' 
?progo  equ     $
        public  $noteo          ; midi note output
$noteo  dw      (?noteo-$noteo)/6,      0000
        dw      rde+007h,whi+'1' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0e8h,blu+'0' ,blu+'0' 
        dw      yel+'&', blu+'F' ,blu+'F' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'v', blu+'0' ,blu+'0' 
        dw      yel+'r', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' ,yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' ,yel+'b', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' ,yel+'c', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' ,yel+'d', blu+'0' ,blu+'0' 
?noteo  equ     $
        public  $noteo1          ; midi note output
$noteo1 dw      (?noteo1-$noteo1)/6,      0000
        dw      rde+007h,whi+'2' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0e8h,blu+'0' ,blu+'0' 
        dw      yel+'&', blu+'F' ,blu+'F' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'v', blu+'0' ,blu+'0' 
        dw      yel+'r', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' ,yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' ,yel+'b', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' ,yel+'c', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' ,yel+'d', blu+'0' ,blu+'0' 
?noteo1 equ     $
        public  $noteo2          ; midi note output
$noteo2 dw      (?noteo2-$noteo2)/6,      0000
        dw      rde+007h,whi+'3' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0e8h,blu+'0' ,blu+'0' 
        dw      yel+'&', blu+'F' ,blu+'F' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'v', blu+'0' ,blu+'0' 
        dw      yel+'r', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' ,yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' ,yel+'b', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' ,yel+'c', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' ,yel+'d', blu+'0' ,blu+'0' 
?noteo2 equ     $
        public  $noteo3          ; midi note output
$noteo3 dw      (?noteo3-$noteo3)/6,      0000
        dw      rde+007h,whi+'4' ,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0e8h,blu+'0' ,blu+'0' 
        dw      yel+'&', blu+'F' ,blu+'F' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'t', blu+'0' ,blu+'0' 
        dw      yel+'v', blu+'0' ,blu+'0' 
        dw      yel+'r', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' ,yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' ,yel+'b', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' ,yel+'c', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' ,yel+'d', blu+'0' ,blu+'0' 
?noteo3 equ     $
        public  $chano          ; midi channel output
$chano  dw      (?chano-$chano)/6,      0000
        dw      rde+007h,whi+09ah,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'1' 
        dw      yel+09eh,blu+'0' ,blu+'0' 
        dw      yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'b', blu+'8' ,blu+'0' 
        dw      yel+'V', blu+'7' ,blu+'F' 
        dw      yel+'M', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' 
        dw      yel+'1', blu+'0' ,blu+'0' 
        dw      yel+'2', blu+'0' ,blu+'0' 
?chano  equ     $
        public  $chanl          ; midi channel output
$chanl  dw      (?chanl-$chanl)/6,      0000
        dw      rde+007h,whi+099h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'c', blu+'0' ,blu+'0' 
        dw      yel+0fbh,blu+'0' ,blu+'1' 
        dw      yel+09eh,blu+'0' ,blu+'0' 
        dw      yel+'a', blu+'0' ,blu+'0' 
        dw      yel+'b', blu+'8' ,blu+'0' 
        dw      yel+'V', blu+'7' ,blu+'F' 
        dw      yel+'M', blu+'0' ,blu+'0' 
        dw      yel+'A', blu+'0' ,blu+'0' 
        dw      yel+'B', blu+'0' ,blu+'0' 
        dw      yel+'C', blu+'0' ,blu+'0' 
        dw      yel+'D', blu+'0' ,blu+'0' 
        dw      yel+'1', blu+'0' ,blu+'0' 
        dw      yel+'2', blu+'0' ,blu+'0' 
?chanl  equ     $
        public  $sysxo          ; midi sysex output
$sysxo  dw      (?sysxo-$sysxo)/6,      0000
        dw      yel+03ah,whi+014h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'1' ,blu+'0' ,blu+'0' 
        dw      yel+'2' ,blu+'0' ,blu+'0' 
        dw      yel+'3' ,blu+'0' ,blu+'0' 
        dw      yel+'4' ,blu+'0' ,blu+'0' 
        dw      yel+'5' ,blu+'0' ,blu+'0' 
        dw      yel+'6' ,blu+'0' ,blu+'0' 
        dw      yel+'7' ,blu+'0' ,blu+'0' 
        dw      yel+'8' ,blu+'0' ,blu+'0' 
?sysxo  equ     $
        public  $ctrlo          ; midi ctrl output
$ctrlo  dw      (?ctrlo-$ctrlo)/6,      0000
        dw      yel+03ah,whi+098h,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+'#' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?ctrlo  equ     $
        public  $patcho         ; midi program change
$patcho dw      (?patcho-$patcho)/6,      0000
        dw      yel+03ah,whi+09eh,whi+'0' 
        dw      yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+01bh,cyn+'0' ,cyn+'0' 
        dw      yel+'c' ,blu+'0' ,blu+'0' 
        dw      yel+0aah,blu+'0' ,blu+'0' 
        dw      yel+'!' ,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?patcho equ    $
        public  $bopo          ; pc timer note output
$bopo   dw      (?bopo-$bopo)/6,        0000
        dw      yel+':' ,whi+00fh,whi+'$' ,yel+0f9h,gry+'0' ,gry+'0' 
        dw      yel+003h,blu+'0' ,blu+'0' 
        dw      yel+01ah,blu+'0' ,blu+'0' 
?bopo   equ     $
        public  ?modtxt
;--------------------------------------------------------------
; end of module text
        dw      -1
?modtxt equ     $
;--------------------------------------------------------------
; this last+1 module text is a buffer used to move a copy
; of an existing module.  It must be 25 lines to accommodate
; the maximum size module.
;
        public  $dummy          ; 25 line dummy for module text buffer
$dummy  dw      (?dummy-$dummy)/6,8
        dw      75 dup(?)
?dummy  equ     $
;--------------------------------------------------------------
; this last+2 is the menu text -- it only looks like a module
;
        public  $menu           ; page #'s and menu
$menu   dw      (?menu-$menu)/6,0H
        dw      blu+010h,yel+020h,yel+'0' 
        dw      blu+010h,yel+020h,yel+'1' 
        dw      blu+010h,yel+020h,yel+'2' 
        dw      blu+010h,yel+020h,yel+'3' 
        dw      blu+010h,yel+020h,yel+034h
        dw      blu+010h,yel+020h,yel+035h
        dw      blu+010h,yel+020h,yel+036h
        dw      blu+010h,yel+020h,yel+037h
        dw      grn+'E',grn+'S',grn+'C' ; ESC
        dw      rde+'D',rde+'E',rde+'L' ; DEL
        dw      yel+'S',yel+'E',yel+'T' ; SET
        dw      cyn+'H',cyn+'L',cyn+'T' ; HLT
        dw      grn+'O',grn+'F',grn+'F' ; OFF
        dw      gry+'0',gry+'0',gry+'0' ; 000
        dw      gry+'0',gry+'0',gry+'0' ; 000
        dw      blu+'0',blu+'0',blu+'0' ; 000
        dw      blu+'0',blu+'0',blu+'0' ; 000
        dw      yel+'0',blu+':',yel+'1' ; 0:1
        dw      yel+'2',blu+':',yel+'3' ; 2:3
        dw      yel+'4',blu+':',yel+'5' ; 4:5
        dw      yel+'6',blu+':',yel+'7' ; 6:7
        dw      yel+'8',blu+':',yel+'9' ; 8:9
        dw      yel+'A',blu+':',yel+'B' ; A:B
        dw      yel+'C',blu+':',yel+'D' ; C:D
        dw      yel+'E',blu+':',yel+'F' ; E:F
?menu   equ     $
;--------------------------------------------------------------
; The following table includes an entery for each defined
; module.  The format is:
;       word0:  module execution address
;       word1:  module text address
;       word2:  variables space (words) for each active module 
;       word3:  address of variable list for module 0
;        |
;       word18: address of variable list for module 15
;               -- set to -1 if it's a system module
;       word19: bits set if a module has been deleted, used to reincarnate
;       word20: execution address for magenta user input (optional)
;
        even
        public  _modsrc
_modsrc  equ     $
        public @dummy
@dummy  equ     $
@beta   dw      offset _text:_beta,     offset dgroup:$beta
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@secs   dw      offset _text:_secs,     offset dgroup:$secs
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lambda dw      offset _text:_lambda,   offset dgroup:$lambda
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@muclk  dw      offset _text:_muclk,    offset dgroup:$muclk
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@gamma  dw      offset _text:_gamma,    offset dgroup:$gamma
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mclock dw      offset _text:_mclock,   offset dgroup:$mclock
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mclk   dw      offset _text:_mclk,     offset dgroup:$mclk
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@clock  dw      offset _text:_clock,    offset dgroup:$clock
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@klock  dw      offset _text:_klock,    offset dgroup:$klock
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@alpha  dw      offset _text:_alpha,    offset dgroup:$alpha
        dw      12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
@xkbd   dw      offset _text:_xkbd ,    offset dgroup:$xkbd 
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
@tstmob dw      offset _text:_tstmob,   offset dgroup:$tstmob
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
@mpuins dw      offset _text:_mpuins,   offset dgroup:$mpuins
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
@xmidii dw      offset _text:_xmidii,   offset dgroup:$xmidii
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@domute dw      offset _text:_domute,   offset dgroup:$domute
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ltimer dw      offset _text:_ltimer,   offset dgroup:$ltimer
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ctimer dw      offset _text:_ctimer,   offset dgroup:$ctimer
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@atimer dw      offset _text:_atimer,   offset dgroup:$atimer
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@stimer dw      offset _text:_stimer,   offset dgroup:$stimer
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@wseq   dw      offset _text:_wseq,     offset dgroup:$wseq
        dw      17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@xseq   dw      offset _text:_xseq,     offset dgroup:$xseq
        dw      09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@yseq   dw      offset _text:_yseq,     offset dgroup:$yseq
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@zseq   dw      offset _text:_zseq,     offset dgroup:$zseq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@useq   dw      offset _text:_useq,     offset dgroup:$useq
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@vseq   dw      offset _text:_vseq,     offset dgroup:$vseq
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
@euseq  dw      offset _text:_euseq,   offset dgroup:$euseq
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:ueuseq
@puseq  dw      offset _text:_puseq,    offset dgroup:$puseq
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@quseq  dw      offset _text:_quseq,    offset dgroup:$quseq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ruseq  dw      offset _text:_ruseq,    offset dgroup:$ruseq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@suseq  dw      offset _text:_suseq,    offset dgroup:$suseq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@tuseq  dw      offset _text:_tuseq,    offset dgroup:$tuseq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@pseq   dw      offset _text:_pseq,     offset dgroup:$pseq
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
        dw      offset _text:upseq
@qseq   dw      offset _text:_qseq,     offset dgroup:$qseq
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
        dw      offset _text:uqseq
@rseq   dw      offset _text:_rseq,     offset dgroup:$rseq
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
        dw      offset _text:uqseq
@sseq   dw      offset _text:_sseq,     offset dgroup:$sseq
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
        dw      offset _text:uqseq
@tseq   dw      offset _text:_tseq,     offset dgroup:$tseq
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0      
        dw      offset _text:uqseq
@gatel  dw      offset _text:_gatel,    offset dgroup:$gatel
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@gout   dw      offset _text:_gout,     offset dgroup:$gout 
        dw      09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@iclock dw      offset _text:_iclock,   offset dgroup:$iclock
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@kclock dw      offset _text:_kclock,   offset dgroup:$kclock
        dw      10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ocount dw      offset _text:_ocount,   offset dgroup:$ocount
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@icount dw      offset _text:_icount,   offset dgroup:$icount
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@jcount dw      offset _text:_jcount,   offset dgroup:$jcount
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@kcount dw      offset _text:_kcount,   offset dgroup:$kcount
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lcount dw      offset _text:_lcount,   offset dgroup:$lcount
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mcount dw      offset _text:_mcount,   offset dgroup:$mcount
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ncount dw      offset _text:_ncount,   offset dgroup:$ncount
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@variy  dw      offset _text:_variy,    offset dgroup:$variy
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@variz  dw      offset _text:_variz,    offset dgroup:$variz
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@variv  dw      offset _text:_variv,    offset dgroup:$variv
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@varix  dw      offset _text:_varix,    offset dgroup:$varix
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@trand  dw      offset _text:_trand,    offset dgroup:$trand
        dw      09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@nrand  dw      offset _text:_nrand,    offset dgroup:$nrand
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@randp  dw      offset _text:_randp,    offset dgroup:$randp
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@rrand  dw      offset _text:_rrand,    offset dgroup:$rrand
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@twopwr dw      offset _text:_twopwr,   offset dgroup:$twopwr
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@rand   dw      offset _text:_rand,     offset dgroup:$rand
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@andl   dw      offset _text:_andl,     offset dgroup:$andl
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@orl    dw      offset _text:_orl,      offset dgroup:$orl
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@notl   dw      offset _text:_notl,     offset dgroup:$notl
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@delay  dw      offset _text:_delay,    offset dgroup:$delay
        dw      131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@slope  dw      offset _text:_slope,    offset dgroup:$slope
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@sandh  dw      offset _text:_sandh,    offset dgroup:$sandh
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@value  dw      offset _text:_value,    offset dgroup:$value
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@scale  dw      offset _text:_scale,    offset dgroup:$scale
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@sumit  dw      offset _text:_sumit,    offset dgroup:$sumit
        dw      07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mixit  dw      offset _text:_mixit,    offset dgroup:$mixit
        dw      07,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@limit  dw      offset _text:_limit,    offset dgroup:$limit
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@apprx  dw      offset _text:_apprx,    offset dgroup:$apprx
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@delta  dw      offset _text:_delta,    offset dgroup:$delta
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@cmak   dw      offset _text:_cmak,     offset dgroup:$cmak 
        dw      10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@cgen   dw      offset _text:_cgen,     offset dgroup:$cgen 
        dw      10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@cplay  dw      offset _text:_cplay,    offset dgroup:$cplay
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@cplai  dw      offset _text:_cplai,    offset dgroup:$cplai
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@cstor  dw      offset _text:_cstor,    offset dgroup:$cstor
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@sort   dw      offset _text:_sort,     offset dgroup:$sort 
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@bassd  dw      offset _text:_bassd,    offset dgroup:$bassd
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@deltat dw      offset _text:_deltat,   offset dgroup:$deltat
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mul12  dw      offset _text:_mul12,    offset dgroup:$mul12
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@div12  dw      offset _text:_div12,    offset dgroup:$div12
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mod12  dw      offset _text:_mod12,    offset dgroup:$mod12
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@fold   dw      offset _text:_fold,     offset dgroup:$fold
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@dither dw      offset _text:_dither,   offset dgroup:$dither
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@dithzr dw      offset _text:_dithzr,   offset dgroup:$dithzr
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ddithr dw      offset _text:_ddithr,   offset dgroup:$ddithr
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@odds   dw      offset _text:_odds,     offset dgroup:$odds
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@oddz   dw      offset _text:_oddz,     offset dgroup:$oddz
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ratio  dw      offset _text:_ratio,    offset dgroup:$ratio
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ratiz  dw      offset _text:_ratiz,    offset dgroup:$ratiz
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@filter dw      offset _text:_filter,   offset dgroup:$filter
        dw      12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@fflop  dw      offset _text:_fflop,    offset dgroup:$fflop
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@union  dw      offset _text:_union,    offset dgroup:$union
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@rangep dw      offset _text:_rangep,   offset dgroup:$rangep
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@quant  dw      offset _text:_quant,    offset dgroup:$quant
        dw      10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lastv  dw      offset _text:_lastv,   offset dgroup:$lastv
        dw      11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@xcall  dw      offset _text:_xcall,    offset dgroup:$xcall
        dw      11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@rcall  dw      offset _text:_rcall,    offset dgroup:$rcall
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@poke   dw      offset _text:_poke,     offset dgroup:$poke
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@peek   dw      offset _text:_peek,     offset dgroup:$peek
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@outpb  dw      offset _text:_outpb,    offset dgroup:$outpb
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@inptb  dw      offset _text:_inptb,    offset dgroup:$inptb
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@imeter dw      offset _text:_imeter,   offset dgroup:$imeter
        dw      3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@emeter dw      offset _text:_emeter,   offset dgroup:$emeter
        dw      3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@higher dw      offset _text:_higher,   offset dgroup:$higher
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lower  dw      offset _text:_lower,    offset dgroup:$lower
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@rshift dw      offset _text:_rshift,   offset dgroup:$rshift
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lshift dw      offset _text:_lshift,   offset dgroup:$lshift
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@modulo dw      offset _text:_modulo,   offset dgroup:$modulo
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@times  dw      offset _text:_times,    offset dgroup:$times
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@plus   dw      offset _text:_plus,     offset dgroup:$plus
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@plusm  dw      offset _text:_plusm,    offset dgroup:$plusm
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@plusn  dw      offset _text:_plusn,    offset dgroup:$plusn
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@maxf   dw      offset _text:_maxf,     offset dgroup:$maxf
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@minf   dw      offset _text:_minf,     offset dgroup:$minf
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@passt  dw      offset _text:_passt,    offset dgroup:$passt
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@passq  dw      offset _text:_passq,    offset dgroup:$passq
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@equal  dw      offset _text:_equal,    offset dgroup:$equal
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@nequal dw      offset _text:_nequal,   offset dgroup:$nequal
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@great  dw      offset _text:_great,    offset dgroup:$great
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@lessp  dw      offset _text:_lessp,    offset dgroup:$lessp
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@bitsp  dw      offset _text:_bitsp,    offset dgroup:$bitsp
        dw      02,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@bitsq  dw      offset _text:_bitsq,    offset dgroup:$bitsq
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@maskl  dw      offset _text:_maskl,    offset dgroup:$maskl
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@maskr  dw      offset _text:_maskr,    offset dgroup:$maskr
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@mask   dw      offset _text:_mask,     offset dgroup:$mask
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@truep  dw      offset _text:_truep,    offset dgroup:$truep
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@zerop  dw      offset _text:_zerop,    offset dgroup:$zerop
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@minusp dw      offset _text:_minusp,   offset dgroup:$minusp
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@negate dw      offset _text:_negate,   offset dgroup:$negate
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@change dw      offset _text:_change,   offset dgroup:$change
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ascii  dw      offset _text:_ascii,    offset dgroup:$ascii
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@asciz  dw      offset _text:_asciz,    offset dgroup:$asciz
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ascis  dw      offset _text:_ascis,    offset dgroup:$ascis
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@decin  dw      offset _text:_decin,    offset dgroup:$decin
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@decim  dw      offset _text:_decim,    offset dgroup:$decim
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@noter  dw      offset _text:_noter,    offset dgroup:$noter
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@sxput  dw      offset _text:_sxput,     offset dgroup:$sxput
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@sxget  dw      offset _text:_sxget,     offset dgroup:$sxget
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@slew   dw      offset _text:_slew,      offset dgroup:$slew
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@xslew  dw      offset _text:_xslew,     offset dgroup:$xslew
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@stopo  dw      offset _text:_stopo,     offset dgroup:$stopo
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
@mapo   dw      offset _text:_mapo,   offset dgroup:$mapo
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
        dw      offset _text:umapo
@mapp   dw      offset _text:_mapp,   offset dgroup:$mapp
        dw      08,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0
        dw      offset _text:umapp
@noteo  dw      offset _text:_noteo,  offset dgroup:$noteo
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@noteo1 dw      offset _text:_noteo1,  offset dgroup:$noteo1
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@noteo2 dw      offset _text:_noteo2,  offset dgroup:$noteo2
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@noteo3 dw      offset _text:_noteo3,  offset dgroup:$noteo3
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@chano  dw      offset _text:_chano,  offset dgroup:$chano
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@chanl  dw      offset _text:_chanl,  offset dgroup:$chanl
        dw      18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@progo  dw      offset _text:_progo,  offset dgroup:$progo
        dw      52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:uprogo
@sysxo  dw      offset _text:_sysxo,  offset dgroup:$sysxo
        dw      09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@ctrlo  dw      offset _text:_ctrlo,  offset dgroup:$ctrlo
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@patcho dw      offset _text:_patcho,  offset dgroup:$patcho
        dw      04,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@bopo   dw      offset _text:_bopo,   offset dgroup:$bopo
        dw      03,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0       
@pusha  dw      offset _text:_pusha,  offset dgroup:$pusha
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upusha
@pushb  dw      offset _text:_pushb,  offset dgroup:$pushb
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upushb
@pushc  dw      offset _text:_pushc,  offset dgroup:$pushc
        dw      01,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upushc
@addswa dw      offset _text:_addswa, offset dgroup:$addswa
        dw      09,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psouta dw      offset _text:_psouta, offset dgroup:$psouta
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psoutb dw      offset _text:_psoutb, offset dgroup:$psoutb
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psoutc dw      offset _text:_psoutc, offset dgroup:$psoutc
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psoutd dw      offset _text:_psoutd, offset dgroup:$psoutd
        dw      05,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psoute dw      offset _text:_psoute, offset dgroup:$psoute
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@psoutf dw      offset _text:_psoutf, offset dgroup:$psoutf
        dw      06,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
@pcouta dw      offset _text:_pcouta, offset dgroup:$pcouta
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutb dw      offset _text:_pcoutb, offset dgroup:$pcoutb
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutc dw      offset _text:_pcoutc, offset dgroup:$pcoutc
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutd dw      offset _text:_pcoutd, offset dgroup:$pcoutd
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoute dw      offset _text:_pcoute, offset dgroup:$pcoute
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutf dw      offset _text:_pcoutf, offset dgroup:$pcoutf
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutg dw      offset _text:_pcoutg, offset dgroup:$pcoutg
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcouth dw      offset _text:_pcouth, offset dgroup:$pcouth
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutx dw      offset _text:_pcoutx, offset dgroup:$pcoutx
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcouty dw      offset _text:_pcouty, offset dgroup:$pcouty
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
@pcoutz dw      offset _text:_pcoutz, offset dgroup:$pcoutz
        dw      00,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        dw      offset _text:upcout
;--------------------------------------------------------------
; the following is a 256 word address table, one address,
; in order, for each character in the ibm-pc character set
; these addresses point to the MODSRC table, which includes
; an entery for each module, plus a dummy for all the unused
; characters.  The purpose of this table is to allow identification
; of the module code and data, given only the module name character.
;
        even
        public  _chrtbl
_chrtbl equ     $
        dw      offset dgroup:@dummy,  offset dgroup:@decin
        dw      offset dgroup:@dummy,  offset dgroup:@iclock   ; 00 - 03

        dw      offset dgroup:@ddithr, offset dgroup:@dithzr
        dw      offset dgroup:@dither, offset dgroup:@zerop    ; 04 - 07

        dw      offset dgroup:@dummy,  offset dgroup:@pushb
        dw      offset dgroup:@dummy,  offset dgroup:@change   ; 08 - 0B

        dw      offset dgroup:@lastv,  offset dgroup:@clock
        dw      offset dgroup:@klock,  offset dgroup:@bopo     ; 0C - 0F

        dw      offset dgroup:@sxget,  offset dgroup:@sxput
        dw      offset dgroup:@pushc,  offset dgroup:@cmak     ; 10 - 13

        dw      offset dgroup:@sysxo,  offset dgroup:@sandh
        dw      offset dgroup:@dummy,  offset dgroup:@limit    ; 14 - 17

        dw      offset dgroup:@maxf,   offset dgroup:@minf 
        dw      offset dgroup:@xmidii, offset dgroup:@dummy    ; 18 - 1B

        dw      offset dgroup:@dummy,  offset dgroup:@sort
        dw      offset dgroup:@higher, offset dgroup:@lower    ; 1C - 1F

        dw      offset dgroup:@dummy,  offset dgroup:@cgen
        dw      offset dgroup:@truep,  offset dgroup:@value    ; 20 - 23

        dw      offset dgroup:@dummy,  offset dgroup:@scale
        dw      offset dgroup:@andl,   offset dgroup:@dummy    ; 24 - 27

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@times,  offset dgroup:@plus     ; 28 - 2B

        dw      offset dgroup:@dummy,  offset dgroup:@plusn
        dw      offset dgroup:@decim,  offset dgroup:@modulo   ; 2C - 2F

        dw      offset dgroup:@dummy,  offset dgroup:@noteo
        dw      offset dgroup:@noteo1, offset dgroup:@noteo2   ; 30 - 33

        dw      offset dgroup:@noteo3, offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; 34 - 37

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@bassd,  offset dgroup:@gatel    ; 38 - 3B

        dw      offset dgroup:@lessp,  offset dgroup:@equal
        dw      offset dgroup:@great,  offset dgroup:@rand     ; 3C - 3F

        dw      offset dgroup:@cstor,  offset dgroup:@pcouta
        dw      offset dgroup:@pcoutb, offset dgroup:@pcoutc   ; 40 - 43

        dw      offset dgroup:@pcoutd, offset dgroup:@pcoute
        dw      offset dgroup:@pcoutf, offset dgroup:@pcoutg   ; 44 - 47

        dw      offset dgroup:@pcouth, offset dgroup:@icount
        dw      offset dgroup:@jcount, offset dgroup:@kcount   ; 48 - 4B

        dw      offset dgroup:@lcount, offset dgroup:@mcount
        dw      offset dgroup:@ncount, offset dgroup:@ocount   ; 4C - 4F

        dw      offset dgroup:@puseq,  offset dgroup:@quseq
        dw      offset dgroup:@ruseq,  offset dgroup:@suseq    ; 50 - 53

        dw      offset dgroup:@tuseq,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; 54 - 57

        dw      offset dgroup:@pcoutx, offset dgroup:@pcouty
        dw      offset dgroup:@pcoutz, offset dgroup:@dummy    ; 58 - 5B

        dw      offset dgroup:@slope,  offset dgroup:@dummy
        dw      offset dgroup:@twopwr, offset dgroup:@dummy    ; 5C - 5F

        dw      offset dgroup:@dummy,  offset dgroup:@psouta 
        dw      offset dgroup:@psoutb, offset dgroup:@psoutc   ; 60 - 63

        dw      offset dgroup:@psoutd, offset dgroup:@psoute
        dw      offset dgroup:@psoutf, offset dgroup:@dummy    ; 64 - 67

        dw      offset dgroup:@dummy,  offset dgroup:@variz 
        dw      offset dgroup:@variy,  offset dgroup:@variv    ; 68 - 6B

        dw      offset dgroup:@varix,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; 6C - 6F

        dw      offset dgroup:@pseq,   offset dgroup:@qseq 
        dw      offset dgroup:@rseq,   offset dgroup:@sseq     ; 70 - 73

        dw      offset dgroup:@tseq,   offset dgroup:@useq  
        dw      offset dgroup:@vseq,   offset dgroup:@wseq     ; 74 - 77

        dw      offset dgroup:@xseq,   offset dgroup:@yseq 
        dw      offset dgroup:@zseq,   offset dgroup:@poke     ; 78 - 7B

        dw      offset dgroup:@orl,    offset dgroup:@peek
        dw      offset dgroup:@dummy,  offset dgroup:@delta    ; 7C - 7F

        dw      offset dgroup:@cplay,  offset dgroup:@mapp
        dw      offset dgroup:@dummy,  offset dgroup:@ascis    ; 80 - 83

        dw      offset dgroup:@oddz,   offset dgroup:@dummy
        dw      offset dgroup:@asciz,  offset dgroup:@cplai    ; 84 - 87

        dw      offset dgroup:@rcall,  offset dgroup:@dummy
        dw      offset dgroup:@xcall,  offset dgroup:@dummy    ; 88 - 8B

        dw      offset dgroup:@dummy,  offset dgroup:@inptb
        dw      offset dgroup:@ratiz,  offset dgroup:@ratio    ; 8C - 8F

        dw      offset dgroup:@euseq,  offset dgroup:@mask
        dw      offset dgroup:@secs,   offset dgroup:@dummy    ; 90 - 93

        dw      offset dgroup:@mapo,   offset dgroup:@outpb
        dw      offset dgroup:@emeter, offset dgroup:@imeter   ; 94 - 97

        dw      offset dgroup:@ctrlo,  offset dgroup:@chanl
        dw      offset dgroup:@chano,  offset dgroup:@kclock   ; 98 - 9B

        dw      offset dgroup:@dummy,  offset dgroup:@stopo
        dw      offset dgroup:@patcho, offset dgroup:@filter   ; 9C - 9F

        dw      offset dgroup:@ascii,  offset dgroup:@dummy
        dw      offset dgroup:@mod12,  offset dgroup:@dummy    ; A0 - A3

        dw      offset dgroup:@minusp, offset dgroup:@negate
        dw      offset dgroup:@deltat, offset dgroup:@nequal   ; A4 - A7

        dw      offset dgroup:@rrand,  offset dgroup:@maskl
        dw      offset dgroup:@maskr,  offset dgroup:@mpuins   ; A8 - AB

        dw      offset dgroup:@odds,   offset dgroup:@randp
        dw      offset dgroup:@lshift, offset dgroup:@rshift   ; AC - AF

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@mclk     ; B0 - B3

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@passq    ; B4 - B7

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@mclock, offset dgroup:@dummy    ; B8 - BB

        dw      offset dgroup:@atimer, offset dgroup:@stimer
        dw      offset dgroup:@ctimer, offset dgroup:@dummy    ; BC - BF

        dw      offset dgroup:@dummy,  offset dgroup:@nrand
        dw      offset dgroup:@bitsp,  offset dgroup:@dummy    ; C0 - C3

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; C4 - C7

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@rangep, offset dgroup:@dummy    ; C8 - CB

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; CC - CF

        dw      offset dgroup:@delay,  offset dgroup:@bitsq
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; D0 - D3

        dw      offset dgroup:@dummy,  offset dgroup:@noter
        dw      offset dgroup:@passt,  offset dgroup:@dummy    ; D4 - D7

        dw      offset dgroup:@dummy,  offset dgroup:@ltimer
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; D8 - DB

        dw      offset dgroup:@dummy,  offset dgroup:@dummy
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; DC - DF

        dw      offset dgroup:@alpha,  offset dgroup:@beta  
        dw      offset dgroup:@lambda, offset dgroup:@pusha    ; E0 - E3

        dw      offset dgroup:@sumit,  offset dgroup:@slew
        dw      offset dgroup:@muclk,  offset dgroup:@gamma    ; E4 - E7

        dw      offset dgroup:@domute, offset dgroup:@fflop
        dw      offset dgroup:@progo,  offset dgroup:@xslew    ; E8 - EB

        dw      offset dgroup:@trand,  offset dgroup:@notl
        dw      offset dgroup:@mixit,  offset dgroup:@union    ; EC - EF

        dw      offset dgroup:@addswa, offset dgroup:@plusm 
        dw      offset dgroup:@dummy,  offset dgroup:@dummy    ; F0 - F3

        dw      offset dgroup:@fold,   offset dgroup:@dummy
        dw      offset dgroup:@div12,  offset dgroup:@apprx    ; F4 - F7

        dw      offset dgroup:@mul12,  offset dgroup:@tstmob
        dw      offset dgroup:@dummy,  offset dgroup:@xkbd     ; F8 - FB

        dw      offset dgroup:@quant,  offset dgroup:@dummy
        dw      offset dgroup:@gout,   offset dgroup:@dummy    ; FC - FF
;--------------------------------------------------------------
; Module Execution Table
; The following table has space for 1024 modules.  As modules
; are made active, they are appended to the end of the table,
; and the address of WORK is appended to the end+1.
; Data format:
;       word0:  execution address of module
;       word1:  address of module's variables
;         |
;       wordn:  execution address of last module in list
;       wordn+1 address of last module's variables
;       wordn+2 execution address of work
;
        even
        public  _exetbl
_exetbl dw      work,0
        dw      2048 dup(?)
        dw      work
;--------------------------------------------------------------
; The following table is 256 words, the first=0, the 2nd =1, etc.
; Its purpos in life is to allow variables to be numeric constants.
; That is, variable pointers can point to the address of the number
; to be set to a number, rather than to a module output variable.
;
        public  @zero
@zero   dw      000h,001h,002h,003h,004h,005h,006h,007h
        dw      008h,009h,00ah,00bh,00ch,00dh,00eh,00fh
        dw      010h,011h,012h,013h,014h,015h,016h,017h
        dw      018h,019h,01ah,01bh,01ch,01dh,01eh,01fh
        dw      020h,021h,022h,023h,024h,025h,026h,027h
        dw      028h,029h,02ah,02bh,02ch,02dh,02eh,02fh
        dw      030h,031h,032h,033h,034h,035h,036h,037h
        dw      038h,039h,03ah,03bh,03ch,03dh,03eh,03fh
        dw      040h,041h,042h,043h,044h,045h,046h,047h
        dw      048h,049h,04ah,04bh,04ch,04dh,04eh,04fh
        dw      050h,051h,052h,053h,054h,055h,056h,057h
        dw      058h,059h,05ah,05bh,05ch,05dh,05eh,05fh
        dw      060h,061h,062h,063h,064h,065h,066h,067h
        dw      068h,069h,06ah,06bh,06ch,06dh,06eh,06fh
        dw      070h,071h,072h,073h,074h,075h,076h,077h
        dw      078h,079h,07ah,07bh,07ch,07dh,07eh,07fh
        dw      080h,081h,082h,083h,084h,085h,086h,087h
        dw      088h,089h,08ah,08bh,08ch,08dh,08eh,08fh
        dw      090h,091h,092h,093h,094h,095h,096h,097h
        dw      098h,099h,09ah,09bh,09ch,09dh,09eh,09fh
        dw      0a0h,0a1h,0a2h,0a3h,0a4h,0a5h,0a6h,0a7h
        dw      0a8h,0a9h,0aah,0abh,0ach,0adh,0aeh,0afh
        dw      0b0h,0b1h,0b2h,0b3h,0b4h,0b5h,0b6h,0b7h
        dw      0b8h,0b9h,0bah,0bbh,0bch,0bdh,0beh,0bfh
        dw      0c0h,0c1h,0c2h,0c3h,0c4h,0c5h,0c6h,0c7h
        dw      0c8h,0c9h,0cah,0cbh,0cch,0cdh,0ceh,0cfh
        dw      0d0h,0d1h,0d2h,0d3h,0d4h,0d5h,0d6h,0d7h
        dw      0d8h,0d9h,0dah,0dbh,0dch,0ddh,0deh,0dfh
        dw      0e0h,0e1h,0e2h,0e3h,0e4h,0e5h,0e6h,0e7h
        dw      0e8h,0e9h,0eah,0ebh,0ech,0edh,0eeh,0efh
        dw      0f0h,0f1h,0f2h,0f3h,0f4h,0f5h,0f6h,0f7h
        dw      0f8h,0f9h,0fah,0fbh,0fch,0fdh,0feh,0ffh
;--------------------------------------------------------------
; Module Variable Table 
; The following table has space for approximately 512 modules.
; As modules are made active, they are appended to the end of the table.
; Data format:
;       word0:  modsrc addr
;       word1:  priority
;       word2:  vpage seg
;       word3:  vpage addr
;       word4:  output value
;       word5:  input #1 pointer (to other output values)
;       word6:  input #2 pointer
;       word7:  etc.  - one entery for each input
;
        even
        public  vartbl
vartbl  db      varsiz dup(0)
;--------------------------------------------------------------
; place to put screen 0 data
; must use debug for this, or compile with debug = false to ignore
; to do it, ren mb.exe to mb.foo, then debug mb.foo
; find the data area with: S0 C000 "screen" 
; load in the screen: NMB.SCR then L(address)
; write out the file: RCX (give file bytes in original CX)
;                     NMB.FOO then W
; exit debug and rename MB.FOO to MB.EXE
;
        public  modscr
        even
modscr  db      "screen"
        dw      2048  dup(0103h)
;--------------------------------------------------------------
_DATA   ENDS
        END

